<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬只种类管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
			
 			//回显犬只毛色信息
 			var dogColor = '${fns:unescapeHtml(dogType.dogColor)}';
			var dogColorArray = dogColor.split(",");
			$.each(dogColorArray, function(i,val) {
				$("#dogColor").find("option[value='"+val+"']").attr("selected",true);
		    });
			$("#dogColor").trigger("change");
			
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/dogtype/dogType/">犬只种类列表</a></li>
		<li class="active"><a href="${ctx}/dogtype/dogType/view?id=${dogType.id}">犬只种类查看</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="dogType"  class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">犬种类代码：</label>
			<div class="controls">
				<form:input path="dogBreedCode" readonly="true" htmlEscape="false" maxlength="64" class="input-xlarge "/>
				<font color="#FF0000">* </font>
			</div>
		</div>
		<div class="control-group">
            <label class="control-label">犬种：</label>
            <div class="controls">
                <form:input path="dogBreed" readonly="true" htmlEscape="false" maxlength="255" class="input-xlarge "/>
            </div>
        </div>
		<div class="control-group" style="float: left">
			<label class="control-label">犬种类英文名称：</label>
			<div class="controls">
				<form:input path="breedEnName" readonly="true" htmlEscape="false" maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬种类英文别名：</label>
			<div class="controls">
				<form:input path="breedEnAlias" readonly="true" htmlEscape="false" maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">犬种类中文名称：</label>
			<div class="controls">
				<form:input path="breedCnName"  readonly="true" htmlEscape="false" maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬种类中文别名：</label>
			<div class="controls">
				<form:input path="breedCnAlias" readonly="true"  htmlEscape="false" maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">国别：</label>
			<div class="controls">
				<form:input path="countries" readonly="true" htmlEscape="false" maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">CACIB：</label>
			<div class="controls">
				<form:input path="cacib" readonly="true" htmlEscape="false" maxlength="1" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">标准时间：</label>
			<div class="controls">
				<form:input path="standardTime" readonly="true" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬种分类：</label>
			<div class="controls">
				<form:select path="breedClass" class="input-xlarge" style="width:284px;" disabled="true">
					<form:option value="" label="请选择"/>
					<form:options items="${fns:getDictList('dog_breed_class')}" itemLabel="label" itemValue="value"  htmlEscape="false"/>
				</form:select>
			</div>
		</div>		
		<div class="control-group">
			<label class="control-label">组：</label>
			<div class="controls">
				<form:input path="typeGroup" readonly="true" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">节：</label>
			<div class="controls">
				<form:input path="node" readonly="true" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">位：</label>
			<div class="controls">
				<form:input path="figures" readonly="true" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬种类照片：</label>
			<div class="controls">
				<form:input path="dogBreedPhoto" readonly="true" htmlEscape="false" maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">当前最大序号：</label>
			<div class="controls">
				<form:input path="nowMaxNumber" readonly="true" htmlEscape="false" maxlength="11" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group"  style="float: left">
			<label class="control-label">犬种简称：</label>
			<div class="controls">
				<form:input path="shortName" readonly="true" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">是否热门标识：</label>
			<div class="controls">
                <form:select path="hot" class="input-xlarge " onclick="changeState()" disabled="true">
                    <form:options items="${fns:getDictList('hot')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
                <font color="#FF0000">注：此两项为APP端功能 </font>
            </div>
		</div>
		<div class="control-group">
			<label class="control-label">毛色：</label>
			<div class="controls">
                <form:select id="dogColor" path="dogColor" class="input-xxlarge" multiple="true" disabled="true">
                	<form:options items="${dogColorMarkList}" itemLabel="dogColorMarkCn" itemValue="dogColorMarkCode" htmlEscape="false"/>
                </form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">出生纸一窝最大犬数：</label>
			<div class="controls">
				<form:input path="batchMaxNum" readonly="true" htmlEscape="false" type="number" min="1" maxlength="2" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" readonly="true" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>