<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>犬只精子变更管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {
            //$("#name").focus();
            $("#inputForm").validate({
                submitHandler: function (form) {
                    loading('正在提交，请稍等...');
                    form.submit();
                },
                errorContainer: "#messageBox",
                errorPlacement: function (error, element) {
                    $("#messageBox").text("输入有误，请先更正。");
                    if (element.is(":checkbox") || element.is(":radio") || element.parent().is(".input-append")) {
                        error.appendTo(element.parent().parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });
        });
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li><a href="${ctx}/dog/dogSemenChange/">犬只精子变更列表</a></li>
    <li class="active"><a href="${ctx}/dog/dogSemenChange/form?id=${dogSemenChange.id}">犬只精子变更<shiro:hasPermission
            name="dog:dogSemenChange:edit">${not empty dogSemenChange.id?'修改':'添加'}</shiro:hasPermission>
        <shiro:lacksPermission
                name="dog:dogSemenChange:edit">查看</shiro:lacksPermission></a></li>
</ul>
<br/>
<form:form class="form-horizontal">
    <div class="control-group">
        <label class="control-label">血统证书号：</label>
        <div class="controls">
                ${fns:escapeHtml(dogSemenChange.pedigreeCertified)}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">犬只芯片：</label>
        <div class="controls">
                ${fns:escapeHtml(dogSemenChange.dogChip)}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">犬种号：</label>
        <div class="controls">
                ${fns:escapeHtml(dogSemenChange.dogBreed)}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">犬名：</label>
        <div class="controls">
                ${fns:escapeHtml(dogSemenChange.dogName)}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">精子原主人：</label>
        <div class="controls">
                ${fns:escapeHtml(dogSemenChange.originMemberCode)}(${fns:escapeHtml(dogSemenChange.originMemberName)})
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">精子新主人：</label>
        <div class="controls">
                ${fns:escapeHtml(dogSemenChange.newMemberCode)}(${fns:escapeHtml(dogSemenChange.newMemberName)})
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">变更精子信息：</label>
        <div class="controls">
                ${dogSemenListCount}管
            <table class="table table-striped table-bordered table-condensed">
                <thead>
                <tr>
                    <th>原精子编号</th>
                    <th>CKU精子编号</th>
                </tr>
                </thead>
                <tbody>
                <c:forEach items="${dogSemenList}" var="dogSemen">
                <tr>
                    <td>
                            ${fns:escapeHtml(dogSemen.originalSemenCode) }
                    </td>
                    <td>
                            ${fns:escapeHtml(dogSemen.semenCode) }
                    </td>
                <tr>
                    </c:forEach>
                </tbody>
            </table>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">审核状态：</label>
        <div class="controls">
                ${fns:getDictLabel(dogSemenChange.reviewState, 'review_state', '')}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">审核时间：</label>
        <div class="controls">
            <fmt:formatDate value="${dogSemenChange.reviewTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">审核的意见：</label>
        <div class="controls">
                ${fns:escapeHtml(dogSemenChange.reviewRemarks) }
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">协会审核状态：</label>
        <div class="controls">
                ${fns:getDictLabel(dogSemenChange.ckuReviewState, 'review_state', '')}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">协会审核时间：</label>
        <div class="controls">
            <fmt:formatDate value="${dogSemenChange.ckuReviewTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">协会审核的意见：</label>
        <div class="controls">
                ${fns:escapeHtml(dogSemenChange.ckuReviewRemarks) }
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">备注信息：</label>
        <div class="controls">
                ${fns:escapeHtml(dogSemenChange.remarks) }
        </div>
    </div>
    <div class="form-actions">
        <input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
    </div>
</form:form>
</body>
</html>