<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
    <title>冠军登录信息管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function() {
            
        });
    </script>
</head>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
	<thead>
	<tr>
		<th>出生纸编号</th>
		<th>国外血统证书编号</th>
		<th>犬展鉴定编号</th>
		<th>血统证书编号</th>
		<th>犬主</th>
		<th>申请日期</th>
		<th>订单状态</th>
		<th>撤销状态</th>
		<th>DNA血样编号</th>
		<shiro:hasPermission name="dogbloodsave:dogBloodSave:edit"><th>操作</th></shiro:hasPermission>
	</tr>
	</thead>
	<tbody>
	<c:forEach items="${list}" var="dogBloodSave">
		<tr>
			<td>
					${dogBloodSave.birthCode}
			</td>
			<td>
					${dogBloodSave.overseasPedigreeCertified}
			</td>
			<td>
					${dogBloodSave.showAppraisalCode}
			</td>
			<td>
					${dogBloodSave.pedigreeCertified}
			</td>
			<td>
					${dogBloodSave.name}
			</td>
			<td>
				<fmt:formatDate value="${dogBloodSave.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
			</td>
			<td style="color:${dogBloodSave.paymentState=='2'?'#090':'#F00'}">
					${fns:getDictLabel(dogBloodSave.paymentState, 'user_payment_state', '')}
			</td>
			<td>
				<c:if test="${dogBloodSave.isCanceled=='1'}">
					已撤销
				</c:if>
			</td>
			<td>
				<c:choose>
					<c:when test="${not empty dogBloodSave.bloodSampleCode}">
						<a onclick="editForm('${dogBloodSave.id}')">${fns:escapeHtml(dogBloodSave.bloodSampleCode)}</a>
					</c:when>
					<c:when test="${empty dogBloodSave.bloodSampleCode&&dogBloodSave.paymentState=='2' && !dogBloodSave.businessRefundState}">
						<a style="color:#F00" onclick="editForm('${dogBloodSave.id}')">录入</a>
					</c:when>
				</c:choose>
			</td>
			<shiro:hasPermission name="dogbloodsave:dogBloodSave:delete">
				<td>
				<c:if test="${!dogBloodSave.businessRefundState}">
				      <a href="${ctx}/dogbloodsave/dogBloodSave/delete?id=${dogBloodSave.id}" onclick="return confirmx('确认要删除该DNA血样留存吗？', this.href)">删除</a>
				</c:if>
				</td>
			</shiro:hasPermission>
		</tr>
	</c:forEach>
	</tbody>
</table>
</body>
</html>