<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬只鉴定管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});

		function check(dogBreedCode, id){
			var reviewState = $("#reviewState option:selected").val();
			if(reviewState!='1'){
				$.jBox.alert("只有鉴定通过后才能生成血统证书号！","提示");
			}else{
				util.createPedigreeCertifiedCode(dogBreedCode,id);
			}
        }

		function getDogColorMarkByDogBreed(){


			var dogBreedCode = $("#dogBreed").val();

		    $.post('${ctx}/dogcolormark/dogColorMark/getByDogBreed', {
		    	dogBreedCode: dogBreedCode
		    }, function(data) {
		    	$('#dogFurColor').empty();
		    	
		    	$.each(data, function(i,val) {
		    		$('#dogFurColor').append("<option value ='"+val.dogColorMarkCode+"'>"+val.dogColorMarkCn+"</option>");
			    });
		    });	
		}

	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/dogappraisal/dogAppraisal/${dogAppraisal.dogBreed=='230'?'list?dogBreed=230':''}">犬只鉴定列表</a></li>
		<li class="active"><a href="${ctx}/dogappraisal/dogAppraisal/form?id=${dogAppraisal.id}">犬只鉴定<shiro:hasPermission name="dogappraisal:dogAppraisal:edit">${not empty dogAppraisal.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="dogappraisal:dogAppraisal:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="dogAppraisal" action="${ctx}/dogappraisal/dogAppraisal/edit" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>	
		<div class="control-group">
			<label class="control-label">犬种：</label>
			<div class="controls">
 				<form:select path="dogBreed" disabled="true"  class="input-xlarge required" onchange="getDogColorMarkByDogBreed()">
					<form:options items="${dogTypeList}" itemLabel="breedEnName" itemValue="dogBreedCode" htmlEscape="false"/>
				</form:select>
			</div>
		</div>	
		<div class="control-group">
			<label class="control-label">犬名：</label>
			<div class="controls">
 					<form:input path="dogName" disabled="true" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">毛色：</label>
			<div class="controls">
			    <form:select id="dogFurColor" path="dogFurColor" class="input-xlarge required">
			    	<form:options items="${dogColorMarkList}" itemLabel="dogColorMarkCn" itemValue="dogColorMarkCode" htmlEscape="false"/>
			    </form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">鉴定类型：</label>
			<div class="controls">
				<form:radiobuttons path="identifyType" disabled="true" items="${fns:getDictList('dog_appraisal_type')}" itemLabel="label" itemValue="value" htmlEscape="false" class="required"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬只出生日期：</label>
			<div class="controls">
				<input name="birthday" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
						value="<fmt:formatDate value="${dogAppraisal.birthday}" pattern="yyyy-MM-dd"/>"
						onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
				<form:radiobuttons path="dogGender" items="${fns:getDictList('dog_gender')}" itemLabel="label" itemValue="value" htmlEscape="false" class="required"/>
			</div>
		</div>
		<c:if test="${not empty dogAppraisal.mainShowId or not empty dogAppraisal.hospitalId}">
			<div class="control-group">
				<label class="control-label">是否提取DNA：</label>
				<div class="controls">
					<c:if test="${dogAppraisal.isFinishOrder==0}"><font color="red">否</font></c:if>
					<c:if test="${dogAppraisal.isFinishOrder==1}"><font color="green">是</font></c:if>
				</div>
			</div>
		</c:if>
		<div class="control-group">
			<label class="control-label">犬主：</label>
			<div class="controls">
				<form:input path="dogOwnerName" disabled="true" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				<form:input path="dogOwnerCode" disabled="true" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
			</div>
		</div>
		<c:if test="${dogAppraisal.identifyType=='0'}">
			<div class="control-group">
				<label class="control-label">鉴定人：</label>
				<div class="controls">
					<form:input path="identifier" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">鉴定地点：</label>
				<div class="controls">
					<form:input path="identifySite" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">鉴定时间：</label>
				<div class="controls">
					<input name="identifyDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
						value="<fmt:formatDate value="${dogAppraisal.identifyDate}" pattern="yyyy-MM-dd"/>"
						onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
				</div>
			</div>
		</c:if>
		<div class="control-group">
			<label class="control-label">犬只芯片号：</label>
			<div class="controls">
				<form:input path="dogChip" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">血统证书号：</label>
			<div class="controls">
				<form:hidden id="pedigreeCertified" path="pedigreeCertified" />
			
				<input  disabled="true" htmlEscape="false" maxlength="64" class="input-xlarge "
				  value="${fns:desensitize(dogAppraisal.pedigreeCertified,1)}" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">宠爱证书号：</label>
			<div class="controls">
				<form:hidden id="chongaiCertificateCode" path="chongaiCertificateCode" />
				<input disabled="true" htmlEscape="false" maxlength="50" class="input-xlarge "
 				value="${fns:desensitize(dogAppraisal.chongaiCertificateCode,1)}" />
			</div>
		</div>
		<c:if test="${dogAppraisal.identifyType=='1'}">
		<div class="control-group">
			<label class="control-label">鉴定结果：</label>
			<div class="controls">
				<sys:singleImgUpload module="dogAppraisal" imgId="${dogAppraisal.dogDnaImage }" fileSizeLimit="1024*1024*1" fileSingleSizeLimit="1024*1024*1" successCallback="uploadSuccess"/>
				<form:input id="dogDnaImage" path="dogDnaImage" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
				<!-- 文件上传成功的回调方法 -->
				<script type="text/javascript">
					function uploadSuccess(file,response){
						$("#dogDnaImage").val(response.id);
					}
				</script>
			</div>
		</div>
		</c:if>
		<div class="control-group">
			<label class="control-label">鉴定结果：</label>
			<div class="controls">
				<form:select id="reviewState" path="reviewState" class="input-medium">
					<form:options items="${fns:getDictList('dog_appraisal_review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审核意见：</label>
			<div class="controls">
				<form:textarea path="reviewRemarks" htmlEscape="false" rows="3" maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="dogappraisal:dogAppraisal:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>