<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>第二繁殖人管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {

		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>配种证明编号</th>
				<th>繁殖人</th>
				<th>第二繁殖人</th>
				<th>提交时间</th>
				<th>缴费状态</th>
				<shiro:hasPermission name="dog:dogSecondBreeder:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${list}" var="dogSecondBreeder">
			<tr>
				<td>
					${dogSecondBreeder.breedCertifiedCode}
				</td>
				<td>
					${dogSecondBreeder.breeder}
				</td>
				<td>
					${dogSecondBreeder.secondBreeder}
				</td>
				<td>
					<fmt:formatDate value="${dogSecondBreeder.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					${fns:getDictLabel(dogSecondBreeder.paymentState, 'user_payment_state', '')}
				</td>

				<shiro:hasPermission name="dog:dogSecondBreeder:edit"><td>
					<a href="${ctx}/dog/dogSecondBreeder/delete?id=${dogSecondBreeder.id}" onclick="return confirmx('确认要删除该第二繁殖人吗？', this.href)">删除</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>