/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.thinkgem.jeesite.modules.sys.service;

import com.cku.core.RESTResponse;
import com.thinkgem.jeesite.common.service.TreeService;
import com.thinkgem.jeesite.modules.sys.dao.AreaDao;
import com.thinkgem.jeesite.modules.sys.entity.Area;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 区域Service
 *
 * @author ThinkGem
 * @version 2014-05-16
 */
@Service
@Transactional(readOnly = true)
public class AreaService extends TreeService<AreaDao, Area> {

    public List<Area> findAll() {
        return UserUtils.getAreaList();
    }

    @Transactional(readOnly = false)
    public void save(Area area) {
        super.save(area);
        UserUtils.removeCache(UserUtils.CACHE_AREA_LIST);
    }

    @Transactional(readOnly = false)
    public void delete(Area area) {
        super.delete(area);
        UserUtils.removeCache(UserUtils.CACHE_AREA_LIST);
    }

    /**
     * @description: 获取所有省份
     * @author: laiguanglong
     * @date: 2017/5/9 16:29
     */
    public List<Area> getProvince() {
        return UserUtils.getProvince();
    }

    public RESTResponse getProvinceList(HttpServletRequest request) {
        List<Area> list = getProvince();
        list = list.stream().filter(a->{
            return !a.getName().equals("国外");
        }).collect(Collectors.toList());
        List<Map<String ,Object>> resultList = list.stream().map(a->{
            Map<String ,Object> map =new HashMap<String ,Object>();
            map.put("name",a.getName());
            map.put("value",a.getName());
            return map;
        }).collect(Collectors.toList());
        Map<String ,Object> map1 =new HashMap<String ,Object>();
        map1.put("name","全部");
        map1.put("value","");
        Map<String ,Object> map2 =new HashMap<String ,Object>();
        map2.put("name","全国");
        map2.put("value","");
        resultList.add(map1);
        resultList.add(map2);
        return new RESTResponse("data", resultList);
    }
}