package com.cku.restful.v2.show.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.oa.show.service.ShowScoreRankingService;
import com.cku.restful.v1.sys.web.BaseRestController;


@Controller
@RequestMapping(value = "/api/v2/open/showScoreRanking")
public class OpenShowController extends BaseRestController {
	
	@Autowired
	private ShowScoreRankingService showScoreRankingService;
	
	
	/**
	 * 临时使用：需处理2020年、2021年所有榜单的数据，把不符合此规则的狗从排行榜中撤掉，其余犬只上移排位。
	 * @param request
	 * @param response
	 * @throws Exception
	 */
	@RequestMapping(value = "/clearShowScoreRanking", method = RequestMethod.GET)
	@ResponseBody
	public void clearShowScoreRanking(HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		showScoreRankingService.clearShowScoreRanking("2020");
		
		showScoreRankingService.clearShowScoreRanking("2021");
	
	}
	

//	@Autowired
//	private ShowScoreRankingDao showscoreRankingDao;
//	@Autowired
//	private DogGenerationService dogGenerationService;
//	@Autowired
//	public DogService dogService;
//	@Autowired
//	private RestDogService restDogService;
	
//	@RequestMapping(value = "/getDogGeneration", method = RequestMethod.GET)
//	@ResponseBody
//	public void getDogGeneration(HttpServletRequest request, HttpServletResponse response) throws Exception {
//		List<String > list = showscoreRankingDao.findAllPedigreeCertified();
//		for(String pedigreeCertified:list) {
//			try {
//				Dog dog = dogService.getByPedigreeCertifiedCode(pedigreeCertified);
//				int i = restDogService.getDogGeneration(dog.getFdogPedigreeCertified(),dog.getMdogPedigreeCertified());
//				DogGeneration dogGeneration = new  DogGeneration();
//				dogGeneration.setPedigreeCertifiedCode(pedigreeCertified);
//				dogGeneration.setDogGeneration(i+"");
//				dogGeneration.preInsert();
//				dogGeneration.setIsNewRecord(true);
//				dogGenerationService.save(dogGeneration);	
//			}catch (Exception e) {
//				e.printStackTrace();
//				System.out.println("========================"+pedigreeCertified+"========================");
//			}
//		}
//	
//	}
	
}