package com.cku.restful.v1.sys.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.restful.v1.sys.model.RestArea;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.modules.sys.entity.Area;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

@Controller
@RequestMapping(value = "/api/v1/area")
public class RestAreaController extends BaseRestController {

	@RequestMapping(value = "/getProvince", method = RequestMethod.GET)
	@ResponseBody
	public void getProvince(HttpServletResponse response) throws IOException {
		List<Area> result = UserUtils.getProvince();
		List<RestArea> list = new ArrayList<RestArea>();
		for (Area area : result) {
			RestArea vo = new RestArea();
			BeanUtil.copyProperties(vo, area, "yyyy-MM-dd");
			list.add(vo);
		}
		Long totalCount = (long) list.size();
		ServletUtils.writeResponse(response, new RESTResponse("list",
				new PageBeanResult<RestArea>(list, totalCount)));
	}

	@RequestMapping(value = "/getCity", method = RequestMethod.GET)
	@ResponseBody
	public void getCity(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		String provinceName = request.getParameter("provinceName");
		if (StringUtils.isBlank(provinceName)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
					"provinceName省名称为空");
		}
		List<Area> result = UserUtils.getCityByProvince(provinceName);
		List<RestArea> list = new ArrayList<RestArea>();
		for (Area area : result) {
			RestArea vo = new RestArea();
			BeanUtil.copyProperties(vo, area, "yyyy-MM-dd");
			list.add(vo);
		}
		Long totalCount = (long) list.size();
		ServletUtils.writeResponse(response, new RESTResponse("list",
				new PageBeanResult<RestArea>(list, totalCount)));
	}
}