package com.cku.restful.v1.sys.service;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.cku.oa.handler.entity.HandlerRegister;
import com.cku.oa.handler.service.HandlerRegisterService;
import com.cku.restful.v1.handler.service.RestHandlerRegisterService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.cku.core.RESTResponse;
import com.cku.oa.dog.entity.DogAppraisal;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogChip;
import com.cku.oa.dog.entity.DogDnaArchive;
import com.cku.oa.dog.entity.DogDnaParentsCompare;
import com.cku.oa.dog.entity.DogNewborn;
import com.cku.oa.dog.entity.DogPedigreeCertifiedChange;
import com.cku.oa.dog.service.DogAppraisalService;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.dog.service.DogChipService;
import com.cku.oa.dog.service.DogDnaArchiveService;
import com.cku.oa.dog.service.DogDnaParentsCompareService;
import com.cku.oa.dog.service.DogNewbornService;
import com.cku.oa.dog.service.DogOwnerChangeService;
import com.cku.oa.dog.service.DogPedigreeCertifiedChangeService;
import com.cku.oa.dog.service.DogPedigreeCertifiedExportService;
import com.cku.oa.dog.service.DogPedigreeCertifiedRedoService;
import com.cku.oa.dog.service.DogVideoAppraisalService;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.groomer.dao.GroomerRegisterDao;
import com.cku.oa.groomer.entity.GroomerRegister;
import com.cku.oa.kennel.service.KennelRenameService;
import com.cku.oa.show.entity.MainShows;
import com.cku.oa.show.entity.ShowApply;
import com.cku.oa.show.service.ChampionLoginService;
import com.cku.oa.show.service.MainShowsService;
import com.cku.oa.show.service.ShowApplyService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.restful.v1.dog.service.RestDogBirthCertificateService;
import com.cku.restful.v1.dog.service.RestDogChipService;
import com.cku.restful.v1.dog.service.RestDogNewbornService;
import com.cku.restful.v1.dog.service.RestDogOwnerChangeService;
import com.cku.restful.v1.dog.service.RestDogPedigreeCertifiedChangeService;
import com.cku.restful.v1.dog.service.RestDogPedigreeCertifiedExportService;
import com.cku.restful.v1.dog.service.RestDogPedigreeCertifiedRedoService;
import com.cku.restful.v1.groomer.service.RestGroomerShowService;
import com.cku.restful.v1.kennel.service.RestKennelRenameService;
import com.cku.restful.v1.show.service.RestChampionLoginService;
import com.cku.restful.v1.sys.model.RestRefundAble;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import edu.emory.mathcs.backport.java.util.Arrays;
import io.netty.util.internal.StringUtil;
import net.sf.json.JSONObject;

/**
 * Created by lyyz on 2019/8/21.
 */
@Service
@Transactional(readOnly = true)
public class RefundService {
	@Autowired
	PaymentOrderService paymentOrderService;
	@Autowired
	private RestDogNewbornService restDogNewbornService;
	@Autowired
	private RestDogBirthCertificateService restDogBirthCertificateService;
	@Autowired
	private RestDogChipService restDogChipService;
	@Autowired
	private RestDogPedigreeCertifiedRedoService restDogPedigreeCertifiedRedoService;
	@Autowired
	private RestDogPedigreeCertifiedChangeService restDogPedigreeCertifiedChangeService;
	@Autowired
	private RestDogPedigreeCertifiedExportService restDogPedigreeCertifiedExportService;
	@Autowired
	private RestDogOwnerChangeService restDogOwnerChangeService;
	@Autowired
	private RestChampionLoginService restChampionLoginService;
	@Autowired
	private RestKennelRenameService restKennelRenameService;
	@Autowired
	private RestGroomerShowService restGroomerShowService;
	@Autowired
	private ShowApplyService showApplyService;
	@Autowired
	private DogPedigreeCertifiedChangeService dogPedigreeCertifiedChangeService;
	@Autowired
	private MainShowsService mainShowsService;
	@Autowired
	private GroomerRegisterDao groomerRegisterDao;
	@Autowired
	private DogChipService dogChipService;
	@Autowired
	private DogBirthCertificateService dogBirthCertificateService;
	@Autowired
	private DogNewbornService dogNewbornService;
	@Autowired
	private DogPedigreeCertifiedRedoService dogPedigreeCertifiedRedoService;
	@Autowired
	private DogPedigreeCertifiedExportService dogPedigreeCertifiedExportService;
	@Autowired
	private DogOwnerChangeService dogOwnerChangeService;
	@Autowired
	private ChampionLoginService championLoginService;
	@Autowired
	private KennelRenameService kennelRenameService;
	@Autowired
	private DogVideoAppraisalService dogVideoAppraisalService;
	@Autowired
	private DogDnaParentsCompareService dogDnaParentsCompareService;
	@Autowired
	private DogAppraisalService dogAppraisalService;
	@Autowired
	private DogDnaArchiveService dogDnaArchiveService;
	@Autowired
	private RestHandlerRegisterService restHandlerRegisterService;
	@Autowired
	private HandlerRegisterService handlerRegisterService;

	/**
	 * 根据业务条件 获取业务数据
	 *
	 * @return
	 */
	public RESTResponse getBusinessList(String businessId, Map<String, List<PaymentOrderDetail>> collect) {
		JSONObject jo = new JSONObject();
		switch (businessId) {
		// 配种证明费用 业务id号100 业务表"dog_newborn"
		case "1000":
			return restDogNewbornService.getRefundList(String.valueOf(getBusinessIds(collect, "dog_newborn")));
		// 新生犬登记卡 业务表dog_birth_certificate
		case "1002":
			return restDogBirthCertificateService.getRefundList(
					String.valueOf(getBusinessIds(collect, "dog_birth_certificate")),
					collect.entrySet().iterator().next().getValue().get(0).getOrderCode());
		// 新生犬血统证书 业务表dog_chip
		case "1004":
			return restDogChipService.getRefundList(String.valueOf(getBusinessIds(collect, "dog_chip")),
					collect.entrySet().iterator().next().getValue().get(0).getOrderCode());
		// 证书补做
		case "1006":
			return restDogPedigreeCertifiedRedoService
					.getRefundList(String.valueOf(getBusinessIds(collect, "dog_pedigree_certified_redo")));
		// 国外血统证书换发
		case "1007":
			return restDogPedigreeCertifiedChangeService
					.getRefundList(String.valueOf(getBusinessIds(collect, "dog_pedigree_certified_change")));
		// 出口证书业务
		case "1008":
			return restDogPedigreeCertifiedExportService
					.getRefundList(String.valueOf(getBusinessIds(collect, "dog_pedigree_certified_export")));
		// 犬主变更
		case "1009":
			return restDogOwnerChangeService.getRefundList(String.valueOf(getBusinessIds(collect, "dog_owner_change")));
		// 冠军登录
		case "1025":
			return restChampionLoginService
					.getRefundList(String.valueOf(getBusinessIds(collect, "show_champion_login")));
		// 美容师资格认证考试
		case "1046":
			return restGroomerShowService.getRefundList(String.valueOf(getBusinessIds(collect, "groomer_register")));
		// 年度犬舍
		case "1022":
			// 犬舍名称变更
		case "1098":
			return restKennelRenameService.getRefundList(String.valueOf(getBusinessIds(collect, "kennel_rename")));
		// 犬只参赛费
		// 北京
		case "1027":
			// 杭州
		case "1036":
			// 长春
		case "1030":
			// 重庆
		case "1039":
			// 长沙
		case "1033":
			// 郑州
		case "1042":
			// 南方区
		case "1070":
			// 北方区
		case "1073":
		case "1099":
			return showApplyService.getRefundList(String.valueOf(getBusinessIds(collect, "show_apply")));
		case "1082":
			// 视频鉴定、
			return dogVideoAppraisalService.getRefundList(collect);
		case "1010":
			// 繁殖鉴定
//			return dogAppraisalService.getRefundList(collect);
			return dogAppraisalService.getRefundList(String.valueOf(getBusinessIds(collect, "dog_appraisal")));
		case "1204":
			// 金质证书
			return dogDnaParentsCompareService.getRefundList(
					String.valueOf(getBusinessIds(collect, "dog_dna_parents_compare")),
					collect.entrySet().iterator().next().getValue().get(0).getOrderCode());
		case "1210":
			//训练师活动报名
			return restHandlerRegisterService.getRefundList(String.valueOf(getBusinessIds(collect, "handler_register")));
		default:
		}
		return new RESTResponse("data", jo);
	}

	private List<String> refundableReviewStateCodes = Arrays.asList(new String[] { "0", "2" });
	// 视频鉴定状态不一致
	private List<String> refundableReviewVideoStateCodes = Arrays.asList(new String[] { "0", "5" });

	public RestRefundAble getRefundable(String chargeGroupId, String businessIds, String refundStateCode,
			String orderCode) {
		// 1、reviewStateCode 业务单据审核状态
		// 0:待审核1:通过2:未通过3:已注销
		// 2、refundStateCode 退款审核状态字段
		// 1:退款审核中2:退款失败3:已退款
		// 统一根据
		// 业务审核单据为 未通过 或 待审核状态时 && 退款状态为初始状态时 可退款
		RestRefundAble refundable = new RestRefundAble();
		refundable.setFlag(Boolean.TRUE);

		if (!StringUtil.isNullOrEmpty(refundStateCode)) {
			refundable.setFlag(Boolean.FALSE);
			refundable.setMsg("已申请退款的单据,无法再次申请退款操作");
		}

		// 如果使用了需要均摊的优惠券，就不能退款 在申请时控制
		// List<SysCoupon> coupons = sysCouponDao.getCouponXNList(orderCode);
		// if (coupons.size() > 0) {
		// refundable.setFlag(Boolean.FALSE);
		// refundable.setMsg("使用代金券订单，禁止在线退款操作，退款时提示：该订单如需退款，请致电客服：400-6607000申请退款。");
		// }
		// if(!"2".equals(paymentOrder.getPaymentState())) {
		// return new RESTResponse(-1, "未付款的订单不能申请退款");
		// }

		// 以下为特殊业务场景的特殊判断
		switch (chargeGroupId) {
		// 配种证明费用 业务id号1000 业务表"dog_newborn"
		// 使配种来源：使用冷冻精子不能进行退款操作：有精子编号
		case "1000":
			DogNewborn dogNewborn = dogNewbornService.get(businessIds);
			if (!StringUtils.isBlank(dogNewborn.getSemenCode())) {
				refundable.setFlag(Boolean.FALSE);
				refundable.setMsg("配种方式为冷冻精子，无法进行退款操作");
			} else if (!refundableReviewStateCodes.contains(dogNewborn.getReviewState())) {
				refundable.setFlag(Boolean.FALSE);
				refundable.setMsg("已审核或已注销的单据,无法进行退款操作");
			}
			break;
		// 新生犬登记卡 业务表dog_birth_certificate
		// 同一个配种证明下整退，同一窝审核状态不一致不能进行退款操作
		case "1002":
			List<DogBirthCertificate> dogBirths = dogBirthCertificateService
					.findByFmdogBreedCertifiedCodeAndRunningNumber(businessIds, orderCode);
			Map<String, List<DogBirthCertificate>> dogBirthMap = dogBirths.stream()
					.collect(Collectors.groupingBy(DogBirthCertificate::getReviewState));
			if (dogBirthMap.size() != 1) {
				refundable.setFlag(Boolean.FALSE);
				refundable.setMsg("同一窝审核状态不一致,无法进行退款操作");
			} else if (dogBirths.stream().filter(i -> !refundableReviewStateCodes.contains(i.getReviewState()))
					.count() > 0) {
				refundable.setFlag(Boolean.FALSE);
				refundable.setMsg("已审核或已注销的单据,无法进行退款操作");
			}
			break;
		// 新生犬血统证书 业务表dog_chip
		// 血样未采集且未撤销：可以进行退款申请
		case "1004":
			Member member = UserUtils.getLoginMember();
			DogChip example = new DogChip();
			example.setPaymentMemberCode(member.getMemberCode());
			example.setRunningNumber(orderCode);
			example.setId("'" + businessIds + "'");
			List<DogChip> dogChipList = dogChipService.findList(example);
			if (CollectionUtils.isEmpty(dogChipList)) {
				example.setId(null);
				example.setRunningNumber(orderCode);
				example.setFmdogBreedCertifiedCode("'" + businessIds + "'");
				dogChipList = dogChipService.findList(example);
			}
			if (!CollectionUtils.isEmpty(dogChipList)) {
				for (DogChip po : dogChipList) {
					if (!dogChipService.dogChipCanRefund(po)) {
						refundable.setFlag(Boolean.FALSE);
						refundable.setMsg("业务状态异常，不支持退款操作");
						break;
					}
				}
			}
			// DNA位点分析，已绑定采样包不能退款
			DogDnaArchive dogDnaArchive = dogDnaArchiveService.getByRunningNumber(orderCode);
			if (dogDnaArchive != null && StringUtils.isNotBlank(dogDnaArchive.getSamplingCode())) {
				refundable.setFlag(Boolean.FALSE);
				refundable.setMsg("位点分析已绑定采样包，不支持退款操作");
				break;
			}
			break;
		// 国外血统证书换发
		// 犬只芯片校验未通过，未支付芯片费退款
		case "1007":
			DogPedigreeCertifiedChange changePo = dogPedigreeCertifiedChangeService.get(businessIds);

			if (!dogPedigreeCertifiedChangeService.isCanRefund(changePo)) {
				refundable.setFlag(Boolean.FALSE);
				refundable.setMsg("该单据不满足退款条件，无法进行退款操作");
			} else if (!refundableReviewStateCodes.contains(changePo.getReviewState())) {
				refundable.setFlag(Boolean.FALSE);
				refundable.setMsg("已审核或已注销的单据,无法进行退款操作");
			}
			break;
		// 美容师资格认证
		case "1046":
			GroomerRegister groomerRegister = groomerRegisterDao.get(businessIds);
			if (new Date().after(groomerRegister.getGroomerShow().getRegisterEndTime())) {
				refundable.setFlag(Boolean.FALSE);
				refundable.setMsg("活动报名时间已截止,无法进行退款操作");
			}
			break;
		// 犬只参赛费
		// 北京
		case "1027":
			// 杭州
		case "1036":
			// 长春
		case "1030":
			// 重庆
		case "1039":
			// 长沙
		case "1033":
			// 郑州
		case "1042":
			//添加赛事业务id
		case "1070":
		case "1073":
		case "1099":
			String[] businessIdsArr = businessIds.split("#");
			ShowApply showApply = showApplyService.get(businessIdsArr[0]);
			MainShows mainShows = mainShowsService.get(showApply.getMainShowId());
			if (new Date().after(mainShows.getStartTime())) {
				refundable.setFlag(Boolean.FALSE);
				refundable.setMsg("赛事已经开始,无法退款");
			} // 赛前退费，犬展活动区域请假，均为线下退费，限制不能线上再次申请退款
			else if ("1".equals(showApply.getRefundFlag()) || "1".equals(showApply.getAbsenceFlag())) {
				refundable.setFlag(Boolean.FALSE);
				refundable.setMsg("赛前退费或犬展活动区域请假的,无法退款");
			}
			break;
		// 证书补做
		case "1006":
			if (!"0".equals(dogPedigreeCertifiedRedoService.get(businessIds).getReviewState())
					&& !"3".equals(dogPedigreeCertifiedRedoService.get(businessIds).getReviewState())) {
				refundable.setFlag(Boolean.FALSE);
				refundable.setMsg("已审核或已注销的单据,无法进行退款操作");
			}
			break;
		// 出口证书业务
		case "1008":
			if (!refundableReviewStateCodes
					.contains(dogPedigreeCertifiedExportService.get(businessIds).getReviewState())) {
				refundable.setFlag(Boolean.FALSE);
				refundable.setMsg("已审核或已注销的单据,无法进行退款操作");
			}
			break;
		// 犬主变更
		case "1009":
			if (!refundableReviewStateCodes.contains(dogOwnerChangeService.get(businessIds).getReviewState())) {
				refundable.setFlag(Boolean.FALSE);
				refundable.setMsg("已审核或已注销的单据,无法进行退款操作");
			}
			break;
		// 冠军登录
		case "1025":
			if (!refundableReviewStateCodes.contains(championLoginService.get(businessIds).getReviewState())) {
				refundable.setFlag(Boolean.FALSE);
				refundable.setMsg("已审核或已注销的单据,无法进行退款操作");
			}
			break;
		// 年度犬舍
		case "1022":
			// 犬舍名称变更
		case "1098":
			if (!refundableReviewStateCodes.contains(kennelRenameService.get(businessIds).getReviewState())) {
				refundable.setFlag(Boolean.FALSE);
				refundable.setMsg("已审核或已注销的单据,无法进行退款操作");
			}
			break;
		// 视频鉴定
		case "1082":
			if (!refundableReviewVideoStateCodes.contains(dogVideoAppraisalService.get(businessIds).getReviewState())) {
				refundable.setFlag(Boolean.FALSE);
				refundable.setMsg("已审核或已注销的单据,无法进行退款操作");
			}
			break;
		// 繁殖鉴定 需 如已获得线上鉴定通过的犬只报名繁殖鉴定的鉴定信息审核状态为待审核、未通过状态订单
		case "1010":
			DogAppraisal d = dogAppraisalService.get(businessIds);
//			//查询繁殖鉴定
//			DogVideoAppraisal dogVideoAppraisal = new DogVideoAppraisal();
//			dogVideoAppraisal.setDelFlag("0");
//			dogVideoAppraisal.setChipNo(d.getDogChip());
//			DogVideoAppraisal byDogVideoAppraisal = dogVideoAppraisalDao.findByDogVideoAppraisal(dogVideoAppraisal);
//			if(byDogVideoAppraisal==null && byDogVideoAppraisal.getChipNo()==null&&byDogVideoAppraisal.getReviewState().equals("1")){
//				refundable.setFlag(Boolean.FALSE);
//				refundable.setMsg("申请繁殖鉴定退款需完成线上鉴定业务");
//				break;
//			}
			if (!refundableReviewVideoStateCodes.contains(dogAppraisalService.get(businessIds).getReviewState())) {
				refundable.setFlag(Boolean.FALSE);
				refundable.setMsg("已审核或已注销的单据,无法进行退款操作");
			}
			break;

		case "1204":
			// 金质证书 亲子比对状态为“待审核”时，且未生成证书时可申请退款；
			DogDnaParentsCompare dnaParentsCompare = dogDnaParentsCompareService.get(businessIds);
			if ((StringUtils.isNotEmpty(dnaParentsCompare.getReviewState())
					&& !"0".equals(dnaParentsCompare.getReviewState()))) {
				refundable.setFlag(Boolean.FALSE);
				refundable.setMsg("金质证书不为待审核,不支持退款操作");
				break;
			}

			if ("1".equals(dnaParentsCompare.getIsCanceled())) {
				refundable.setFlag(Boolean.FALSE);
				refundable.setMsg("金质证书业务已撤销,不支持退款操作");
				break;
			}

			if (new Integer(2).equals(dnaParentsCompare.getApplySource())
					&& StringUtils.isNotEmpty(dnaParentsCompare.getPedigreeCertified())) {
				refundable.setFlag(Boolean.FALSE);
				refundable.setMsg("金质证书已生成证书号,不支持退款操作,如有疑问,请联系客服处理,致电400-660-7000");
				break;
			}

			// （需要考虑父母DNA存档状态，例如已有DNA位点数据则不允许申请退费）
			List<DogDnaArchive> dnaArchiveList = dogDnaArchiveService.findListByOrderCode(orderCode);
			if (dnaArchiveList.stream().anyMatch(da -> "1".equals(da.getProcessState())  ||  StringUtils.isNotEmpty(da.getDnaCode()))) {
				refundable.setFlag(Boolean.FALSE);
				refundable.setMsg("该订单下DNA位点申请已有位点数据不支持退款");
				break;
			}
			break;
			// 训练师资格认证
		case "1210":
			HandlerRegister handlerRegister = handlerRegisterService.get(businessIds);
			if (new Date().after(handlerRegister.getHandlerShow().getRegisterEndTime())) {
				refundable.setFlag(Boolean.FALSE);
				refundable.setMsg("活动报名时间已截止,无法进行退款操作");
			}
			if ("3".equals(handlerRegister.getReviewState())) {
				refundable.setFlag(Boolean.FALSE);
				refundable.setMsg("审核状态目前为已注销,无法进行退款操作");
			}
			break;
		default:
		}

		return refundable;
	}

	/**
	 * 根据数据库提供订单详情信息 拼接配种证明序号
	 *
	 * @param collect
	 * @return
	 */
	private StringBuffer getBusinessIds(Map<String, List<PaymentOrderDetail>> collect, String table) {
		StringBuffer sb = new StringBuffer();
		collect.entrySet().forEach(i -> {
			i.getValue().stream()
					.filter(j -> StringUtils.isNotEmpty(j.getBusinessTable()) && j.getBusinessTable().equals(table)
							&& StringUtils.isNotEmpty(j.getBusinessIds()))
					.collect(Collectors.groupingByConcurrent(PaymentOrderDetail::getBusinessIds)).keySet()
					.forEach(j -> {
						if (j.contains("#"))
							if ("show_apply".equals(table)) {
								sb.append("'" + j.substring(0, j.indexOf("#")) + "',");
							} else {
								sb.append("'" + j.substring(j.lastIndexOf("#") + 1) + "',");
							}
						else
							sb.append("'" + j + "'").append(",");
					});
		});
		if (sb.length() > 0) {
			sb.deleteCharAt(sb.length() - 1);
		}
		return sb;
	}

	/**
	 * 根据业务条件 获取业务数据
	 *
	 * @return
	 */
	public RESTResponse getBusinessList(String ids, String table) {
		JSONObject jo = new JSONObject();
		switch (table) {
		// 配种证明费用
		case "dog_newborn":
			return restDogNewbornService.getRefundList(ids);
		// 新生幼犬CKU血统证书费
		case "dog_chip":
			break;
		// 登记服务费(纯种犬DNA样本)
		case "dog_blood_save":
			break;
		// 新生犬登记卡
		case "dog_birth_certificate":
			break;
		default:

		}
		return new RESTResponse("data", jo);
	}
}
