/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.show.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.oa.sys.service.SMSRemindService;
import com.cku.restful.v1.show.service.RestShowApplyService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

/**
 * 赛事报名表Controller
 *
 * @author lgl
 * @version 2016-07-15
 */
@Controller
@RequestMapping(value = "/api/v1/show")
public class RestShowApplyController extends BaseRestController {

	@Autowired
	private RestShowApplyService restShowApplyService;
	
	@Autowired
	private SMSRemindService smsRemindService;

	@ApiOperation(value = "赛事鉴定-赛事列表", tags = "赛事鉴定-zxy")
	@ApiImplicitParams({ @ApiImplicitParam(name = "pageNo", value = "分页"),
			@ApiImplicitParam(name = "pageSize", value = "分页"),
			@ApiImplicitParam(name = "token", paramType = "query", value = "token"),
			@ApiImplicitParam(name = "showLocation", value = "赛事地点") })
	@ApiResponses({ @ApiResponse(code = 0, message = "{\n" + "    \"rc\": 0,\n" + "    \"msg\": \"OK\",\n"
			+ "    \"list\": [\n" + "        {\n" + "            \"branchShowDetail\": \"\",\n"
			+ "            \"showCancel\": \"\",\n" + "            \"dogNumMax\": \"180\",\n"
			+ "            \"venuesId\": \"\",\n" + "            \"referee\": \"\",\n"
			+ "            \"showCode\": \"\",\n" + "            \"closingTime\": \"2020-07-21 00:00:00\",\n"
			+ "            \"showLocation\": \"长春-7月25日-7月26日\",\n" + "            \"isTop\": \"1\",\n"
			+ "            \"mainShowName\": \"6场CAC\",\n" + "            \"organizer\": \"8\",\n"
			+ "            \"orgnizeType\": \"0\",\n" + "            \"attention\": \"\",\n"
			+ "            \"startTime\": \"2020-07-25\",\n" + "            \"endTime\": \"2020-07-26\",\n"
			+ "            \"id\": \"bc98852896a5432196f7f75693aa85d8\",\n" + "            \"register\": \"1\"\n"
			+ "        }\n" + "    ],\n" + "    \"total\": 1\n" + "}") })
	@RequestMapping(value = "/dogappraisalMain", method = RequestMethod.GET)
	@ResponseBody
	public void getDogappraisalMain(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restShowApplyService.getDogappraisalMain(request);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/main", method = RequestMethod.GET)
	@ResponseBody
	public void getMain(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restShowApplyService.getMain(request);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/child", method = RequestMethod.GET)
	@ResponseBody
	public void getChild(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restShowApplyService.getChild(request);
		ServletUtils.writeResponse(response, result);
	}


	@RequestMapping(value = "/apply", method = RequestMethod.POST)
	@ResponseBody
	public void post(@RequestBody String json, HttpServletResponse response) throws Exception {
		RESTResponse result = restShowApplyService.post(json);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/apply/getPrice", method = RequestMethod.GET)
	@ResponseBody
	public void getPrice(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restShowApplyService.getPrice(request);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/showApplyCheck", method = RequestMethod.GET)
	@ResponseBody
	public void showApplyCheck(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restShowApplyService.showApplyCheck(request);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/pedigreeCertifiedCodeCheck", method = RequestMethod.GET)
	@ResponseBody
	public void pedigreeCertifiedCodeCheck(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restShowApplyService.pedigreeCertifiedCodeCheck(request);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/handlerCheck", method = RequestMethod.GET)
	public void handlerCheck(HttpServletRequest request, HttpServletResponse response) throws IOException {
		ServletUtils.writeResponse(response, restShowApplyService.handlerCheck(request));
	}

	@RequestMapping(value = "/getApplyHistory", method = RequestMethod.GET)
	public void getApplyHistory(HttpServletRequest request, HttpServletResponse response) throws IOException {
		ServletUtils.writeResponse(response, restShowApplyService.getApplyHistory(request));
	}

	/**
	 * @description: APP专用，获取价格
	 * @author: laiguanglong
	 * @date: 2017/7/27 10:21
	 */
	@RequestMapping(value = "/apply/appGetPrice", method = RequestMethod.GET)
	@ResponseBody
	public void appGetPrice(HttpServletRequest request, HttpServletResponse response) throws Exception {
		RESTResponse result = restShowApplyService.appGetPrice(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * @description: APP专用，贴纸申请业务校验
	 * @author: laiguanglong
	 * @date: 2017/7/27 10:21
	 */
	@RequestMapping(value = "/apply/stickerCheck", method = RequestMethod.GET)
	@ResponseBody
	public void stickerCheck(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restShowApplyService.stickerCheck(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * @description: 根据当前登录人、血统证书号、狗id、子赛事 获取可用的优惠劵
	 * @author: zhangxiang
	 * @date: 2019/2/13 14:29
	 */
	@RequestMapping(value = "/apply/getCoupon", method = RequestMethod.GET)
	@ResponseBody
	public void getCoupon(HttpServletRequest request, HttpServletResponse response) throws IOException {
		// 获取参数
		String showCodes = request.getParameter("showCodes");
		String pedigreeCertified = request.getParameter("pedigreeCertified");
		String ageGroupJson = request.getParameter("ageGroupJson");
		ServletUtils.writeResponse(response,
				new RESTResponse("data", restShowApplyService.getCoupon(showCodes, pedigreeCertified, ageGroupJson)));
	}

	/**
	 * 是否弹出犬主人组弹框
	 * 
	 * @param request
	 * @param response
	 * @throws IOException
	 */

	@RequestMapping(value = "/isAskQzrz", method = RequestMethod.GET)
	public void isAskQzrz(HttpServletRequest request, HttpServletResponse response) throws IOException {
		ServletUtils.writeResponse(response, restShowApplyService.isAskQzrz(request));
	}
	
	/**
	 * 发送授权短信 
	 */
	@RequestMapping(value="/sms" , method=RequestMethod.GET)
	@ResponseBody
	public void getSmsCode(HttpServletRequest request,HttpServletResponse response) throws IOException{
		smsRemindService.sendShowSMSCode(request);
		ServletUtils.writeResponse(response, new RESTResponse());
	}
	
	/**
	 * 验证授权短信 
	 */
	@RequestMapping(value="/checkSms" , method=RequestMethod.GET)
	@ResponseBody
	public void checkSms(HttpServletRequest request,HttpServletResponse response) throws IOException{
		restShowApplyService.checkSms(request);
		ServletUtils.writeResponse(response, new RESTResponse());
	}

	
	/**
	 * 验证是否参加过该赛事
	 */
	@RequestMapping(value="/repeatShowApply" , method=RequestMethod.GET)
	@ResponseBody
	public void repeatShowApply(HttpServletRequest request,HttpServletResponse response) throws IOException{
		restShowApplyService.repeatShowApply(request);
		ServletUtils.writeResponse(response, new RESTResponse());
	}
}