package com.cku.restful.v1.shop.web;

import java.io.IOException;

import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.shop.service.RestShopCartsService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

/**
 * 商城购物车临时Controller
 * 
 * @author lyy
 * @version 2016-08-23
 */
@Controller
@RequestMapping(value = "/api/v1/shop")
public class RestShopCartsController extends BaseRestController {

	@Autowired
	private RestShopCartsService restShopCartsService;

	@RequestMapping(value = "/shopCarts", method = RequestMethod.GET)
	@ResponseBody
	public void getList(HttpServletResponse response) throws IOException {
		RESTResponse result = restShopCartsService.getList();
		ServletUtils.writeResponse(response, result);
	}
	@RequestMapping(value = "/shopCarts/subtractGoods/{id}", method = RequestMethod.GET)
	@ResponseBody
	public void subtractGoods(@PathVariable("id") String id,HttpServletResponse response) throws IOException {
		RESTResponse result = restShopCartsService.subtractGoods(id);
		ServletUtils.writeResponse(response, result);
	}
	@RequestMapping(value = "/shopCarts/addGoods/{id}", method = RequestMethod.GET)
	@ResponseBody
	public void addGoods(@PathVariable("id") String id,HttpServletResponse response) throws IOException {
		RESTResponse result = restShopCartsService.addGoods(id);
		ServletUtils.writeResponse(response, result);
	}
	@RequestMapping(value = "/shopCarts", method = RequestMethod.POST)
	@ResponseBody
	public void post(@RequestBody String json, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restShopCartsService.post(json);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/shopCarts/{id}", method = RequestMethod.DELETE)
	@ResponseBody
	public void delete(@PathVariable("id") String id,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restShopCartsService.delete(id);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/shopCarts", method = RequestMethod.PUT)
	@ResponseBody
	public void put(@RequestBody String json, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restShopCartsService.put(json);
		ServletUtils.writeResponse(response, result);
	}

}