package com.cku.restful.v1.open;

import java.util.Objects;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.restful.v1.dog.model.PetClass;
import com.cku.restful.v1.dog.service.RestDogService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.common.security.Cryptos;

@Controller
@RequestMapping(value = "/api/v1/open/myDog")
public class OpenRestMyDogController extends BaseRestController {
	@Autowired
	private RestDogService restDogService;

	@RequestMapping(value = "/getDogFamily", method = RequestMethod.GET)
	public void getDogFamily(HttpServletRequest request, HttpServletResponse response) throws Exception {
		ServletUtils.writeResponse(response, restDogService.getDogFamily(request));
	}

	@RequestMapping(value = "/getDogFamilyByPedigreeCertifiedCode", method = RequestMethod.GET)
	public void getDogFamilyByPedigreeCertifiedCode(HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		String pedigreeCertifiedCode = request.getParameter("pedigreeCertifiedCode");
		if (StringUtils.isBlank(pedigreeCertifiedCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pedigreeCertifiedCode参数必传");
		}
		ServletUtils.writeResponse(response, restDogService.getDogFamilyByPedigreeCertifiedCode(pedigreeCertifiedCode,
				request.getParameter("token")));
	}

	@RequestMapping(value = "/getDogFamilyByPedigreeCertifiedCodeAES", method = RequestMethod.GET)
	public void getDogFamilyByPedigreeCertifiedCodeAES(HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		String pedigreeCertifiedCode = request.getParameter("pedigreeCertifiedCode");
		if (StringUtils.isBlank(pedigreeCertifiedCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pedigreeCertifiedCode参数必传");
		}
		pedigreeCertifiedCode = Cryptos.aesDecrypt(pedigreeCertifiedCode);
		ServletUtils.writeResponse(response, restDogService.getDogFamilyByPedigreeCertifiedCode(pedigreeCertifiedCode,
				request.getParameter("token")));
	}

	@RequestMapping(value = "/getCompatriots", method = RequestMethod.GET)
	public void getCompatriots(HttpServletRequest request, HttpServletResponse response) throws Exception {
		ServletUtils.writeResponse(response, restDogService.getCompatriots(request));
	}

	@RequestMapping(value = "/getChildren", method = RequestMethod.GET)
	public void getChildren(HttpServletRequest request, HttpServletResponse response) throws Exception {
		ServletUtils.writeResponse(response, restDogService.getChildren(request));
	}

	@RequestMapping(value = "/getShowResults", method = RequestMethod.GET)
	public void getShowResults(HttpServletRequest request, HttpServletResponse response) throws Exception {
		ServletUtils.writeResponse(response, restDogService.getShowResults(request));
	}

	@RequestMapping(value = "/getInfo", method = RequestMethod.GET)
	public void getInfo(HttpServletRequest request, HttpServletResponse response) throws Exception {
		ServletUtils.writeResponse(response, restDogService.getInfo(request));
	}

	@RequestMapping(value = "/getLevel", method = RequestMethod.GET)
	public void getLevel(HttpServletRequest request, HttpServletResponse response) throws Exception {
		String identificationFlag = request.getParameter("identificationFlag");
		if (StringUtils.isBlank(identificationFlag)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "参数为空");
		}
		PetClass petClass = restDogService.getDogClassInfo(identificationFlag);
		if (Objects.isNull(petClass) || StringUtils.isBlank(petClass.getIdentificationFlag())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "查询不到该宠物的等级信息！");
		}
		ServletUtils.writeResponse(response, new RESTResponse("data", petClass));
	}
}