package com.cku.restful.v1.dog.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.DigestUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.restful.v1.dog.service.RestDogChipService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.common.utils.StringUtils;

import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

/**
 * 证书补做Controller
 *
 * @author lgl
 * @version 2016-08-11
 */
@Controller
@RequestMapping(value = "/api/v1/dog")
public class RestDogChipController extends BaseRestController {

	@Autowired
	private RestDogChipService restDogChipService;

	@RequestMapping(value = "/newdogchip/{id}", method = RequestMethod.GET)
	@ResponseBody
	public void getDogNewborn(@PathVariable("id") String id, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogChipService.get(id);
		ServletUtils.writeResponse(response, result);
	}

	@ApiOperation(value = "血统证书-列表", tags = { "血统证书-zxy" })
	@ApiImplicitParams({ @ApiImplicitParam(name = "pageNo", value = "分页"),
			@ApiImplicitParam(name = "pageSize", value = "分页"),
			@ApiImplicitParam(name = "token", paramType = "query", value = "token") })
	@ApiResponses({ @ApiResponse(code = 0, message = "{    \n" + "	\"rc\": 0,\n" + "	    \"msg\": \"OK\",\n"
			+ "	    \"list\": [        {            \n" + "		\"dogEnName\": \"犬只英文名\",\n"
			+ "		            \"identificationFlag\": \"芯片号\",\n" + "		            \"isCanceled\": \"\",\n"
			+ "		            \"snCode\": \"识别码\",\n" + "		            \"hasChip\": true,\n"
			+ "		            \"processState\": \"撤销\",\n" + "		            \"canEdit\": true,\n"
			+ "		            \"breeder\": \"刘载春\",\n" + "		            \"reviewStateCode\": \"\",\n"
			+ "		            \"newMemner\": null,\n" + "		            \"hospitalCode\": \"\",\n"
			+ "		            \"reviewRemarks\": \"\",\n" + "		            \"businessState\": \"待支付\",\n"
			+ "		            \"dogBirthday\": \"2020-04-22\",\n" + "		            \"dnaSaveWay\": \"0\",\n"
			+ "		            \"id\": \"d40e6c23fb96486faccd1f2ad9bb7ee5\",\n"
			+ "		            \"createDate\": \"2020-04-27\",\n" + "		\"paymentState\": \"2\",\n"
			+ "		\"runningNumber\": \"2004271435143330@2268\",\n" + "		 \"tempUserName\": \"张三\",\n"
			+ "		\"callName\": \"啊海\",\n" + "		            \"pedigreeCertified\": \"\",\n"
			+ "		            \"colorFlag\": \"BBM-黑罩酒红\",\n" + "		            \"ecertFlag\": \"0\",\n"
			+ "		            \"canCanceled\": true,\n" + "		            \"newDogOwnerCode\": \"\",\n"
			+ "		            \"hospitalName\": \"\",\n" + "		            \"isAll\": \"0\",\n"
			+ "		            \"newMemberFlag\": \"\",\n" + "		            \"birthCode\": \"000858014\",\n"
			+ "		            \"stickerFlag\": \"\",\n" + "		            \"fmdogBreedCertifiedCode\": \"\",\n"
			+ "		            \"isDnaParentsCompare\": \"0\",\n" + "		            \"dogGender\": \"公\",\n"
			+ "		            \"dogBreed\": \"下司犬\",\n" + "		            \"reviewState\": \"待审核\",\n"
			+ "		            \"certificateType\": \"\"        \n" + "	}    ],\n" + "	    \"total\": 19\n"
			+ "}") })
	@RequestMapping(value = "/newdogchip", method = RequestMethod.GET)
	@ResponseBody
	public void getList(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogChipService.getList(request);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/newdogchip/{id}", method = RequestMethod.DELETE)
	@ResponseBody
	public void delete(@PathVariable("id") String id, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogChipService.delete(id);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @Description：新生犬登记申请撤销操作
	 * @author: zhuoHeng
	 * @version: 2016年10月25日 上午12:05:32
	 */
	@RequestMapping(value = "/newdogchip/canceled/{id}", method = RequestMethod.PUT)
	@ResponseBody
	public void canceled(@PathVariable("id") String id, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogChipService.canceled(id);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @Description：新生犬登记申请撤销操作（宠爱王国使用） @author: zhuoHeng
	 * @version: 2016年10月25日 上午12:05:32
	 */
	@RequestMapping(value = "/newdogchip/appCanceled", method = RequestMethod.PUT)
	@ResponseBody
	public void canceled(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String id = request.getParameter("id");
		RESTResponse result = restDogChipService.canceled(id);
		ServletUtils.writeResponse(response, result);
	}

	@ApiOperation(value = "血统证书-提交表单", tags = { "血统证书-zxy" })
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", paramType = "query", value = "token") })
	@ApiResponses({ @ApiResponse(code = 0, message = "{\n" + "    \"rc\":0,\n" + "    \"msg\":\"OK\",\n"
			+ "    \"data\":\"4bb236aa5935427ea9ce992d1903027c\"\n" + "}\n" + "") })
	@RequestMapping(value = "/newdogchip", method = RequestMethod.POST)
	@ResponseBody
	public void postDogNewborn(@ApiParam(name = "json", value = "{{\n" + "	\"birthCode\": \"000858014\",\n"
			+ "	    \"haddleWay\": 0,\n" + "	    \"dnaSaveWay\": 0,\n"
			+ "	    \"token\": \"eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOiJ7XCJ1c2VySWRcIjpcIjc5MTQwXCIsXCJsb2dpblR5cGVcIjpcIm5ld2FwcFwiLFwibmFtZVwiOlwiXCIsXCJtb2JpbGVcIjpcIjE1NjY1NTU2NjY2XCIsXCJja3VVc2VySWRcIjpcIjMyOVwiLFwiY2FhY1VzZXJJZFwiOlwiXCIsXCJjc3ZVc2VySWRcIjpcIlwifSIsImlzcyI6ImRldmVsb3AiLCJleHAiOjE1OTA0NzI4MDEsImlhdCI6MTU4Nzg4MDgwMX0.hIc7vUkoUCN104pGoA5sFGXhxtpzgAu_iQA3lGl33Fs\",\n"
			+ "	    \"hospitalCode\": \"a61cf0c2cbb44bc893a5f6c90109836c\",\n" + "	    \"isDnaParentsCompare\": 0,\n"
			+ "	    \"newDogOwnerCode\": \"2268\",\n" + "	    \"callName\": \"啊海\",\n"
			+ "	    \"stickerFlag\": 0,\n" + "	    \"identificationFlag\": \"202004221234788\",\n"
			+ "	\"ecertFlag\": \"0\",\n" + "	\"newMemberFlag\": \"1\",\n" + "	    \"newMember\": {        \n"
			+ "		\"name\": \"xxx\",\n" + "		        \"mobile\": \"15611111111\",\n"
			+ "		        \"cardNo\": \"123123123123123123\",\n" + "		        \"province\": \"北京市\",\n"
			+ "		        \"city\": \"北京市\",\n" + "		        \"street\": \"xxxxxxxx\",\n"
			+ "		\"area\": \"区\"    \n" + "	}\n" + "}}") @RequestBody String json, HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restDogChipService.post(json, request);
		ServletUtils.writeResponse(response, result);
	}

	@ApiOperation(value = "血统证书-获取价格", tags = { "血统证书-zxy" })
	@ApiImplicitParams({ @ApiImplicitParam(name = "birthCode", value = "登记卡编号"),
			@ApiImplicitParam(name = "dnaSaveWay", value = "0/1 0:血样留存 1:DNA位点分析"),
			@ApiImplicitParam(name = "isDnaParentsCompare", value = "0/1 0:为选择双亲比对 1:选择双亲比对"),
			@ApiImplicitParam(name = "newMember", value = "0/1 0:未改变犬主 1:改变犬主"),
			@ApiImplicitParam(name = "memberCode", value = "犬主会员号"),
			@ApiImplicitParam(name = "token", paramType = "query", value = "token") })
	@ApiResponses({ @ApiResponse(code = 0, message = "{\n" + "    \"rc\":0,\n" + "    \"msg\":\"OK\",\n"
			+ "    \"data\":{\n" + "        \"price\":\"1100.00\"\n" + "    }\n" + "}\n" + "") })
	@RequestMapping(value = "/newdogchip/getPrice", method = RequestMethod.GET)
	@ResponseBody
	public void getPrice(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogChipService.getPrice(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @Description：订单详细中业务数据查询
	 * @author: zhuoHeng
	 * @version: 2017年1月3日 上午9:36:25
	 */
	@RequestMapping(value = "/newdogchip/orderDetail", method = RequestMethod.GET)
	@ResponseBody
	public void orderDetail(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String id = request.getParameter("id");
		RESTResponse result = restDogChipService.orderDetail(id);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/newdogchip/checkBirthCode", method = RequestMethod.GET)
	@ResponseBody
	public void checkBirthCode(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogChipService.checkBirthCode(request);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/newdogchip/checkNewDogOwner", method = RequestMethod.GET)
	@ResponseBody
	public void checkNewDogOwner(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogChipService.checkNewDogOwner(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * @description: 新生犬登记申请修改操作
	 * @author: laiguanglong
	 * @date: 2017/5/23 16:59
	 */
	@RequestMapping(value = "/newdogchip", method = RequestMethod.PUT)
	@ResponseBody
	public void put(@RequestBody String json, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogChipService.put(json);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 校验呼名
	 *
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "/newdogchip/checkCallName", method = RequestMethod.GET)
	@ResponseBody
	public void checkCallName(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogChipService.checkCallName(request);
		ServletUtils.writeResponse(response, result);
	}

	@ApiOperation(value = "根据登记卡查询鼻纹信息", tags = { "新生犬登记卡-zxy" })
	@ApiImplicitParams({ @ApiImplicitParam(name = "birthCode", value = "登记卡编号"),
			@ApiImplicitParam(name = "token", paramType = "query", value = "token") })
	@ApiResponses({ @ApiResponse(code = 0, message = "{\n" + "	\"rc\": 0,\n" + "	\"msg\": \"OK\",\n"
			+ "	\"data\": {\n" + "		\"dogNose\": false\n" + "	}\n" + "}") })
	@RequestMapping(value = "/newdogchip/checkNose", method = RequestMethod.GET)
	@ResponseBody
	public void checkNose(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogChipService.checkNose(request);
		ServletUtils.writeResponse(response, result);
	}

	@ApiOperation(value = "血统证书-电子证书查看", tags = { "血统证书-zxy" })
	@ApiImplicitParams({ @ApiImplicitParam(name = "id", value = "证书id"),
			@ApiImplicitParam(name = "token", paramType = "query", value = "token") })
	@ApiResponses({ @ApiResponse(code = 0, message = "{    \n" + "	\"rc\": 0,\n" + "	    \"msg\": \"OK\",\n"
			+ "	    \"data\": {        \n" + "		\"color\": \"白色\", // 毛色中文\n"
			+ "		        \"dogGenderDesc\": \"male\", // 性别英文\n" + "		        \"breeder\": \"李鹏\", // 繁育人\n"
			+ "		        \"dogGrade\": \"\", // 等级\n"
			+ "		        \"identification\": \"156100009538457\", // 身份鉴别号码\n"
			+ "		        \"dogBirthday\": \"\", // 出生日期\n" + "		        \"dogBreedDesc\": \"卷毛比熊犬\", // 犬种中文\n"
			+ "		        \"kennleName\": \"阿罗哈犬舍\", // 犬舍中文 \n" + "		        \"colorDesc\": \"WH\", // 毛色英文\n"
			+ "		        \"createDate\": \"2020-4-28\", // 签发日起\n"
			+ "		        \"pedigreeCertified\": \"CKU-215494663/20\", // 血统证书号\n"
			+ "		        \"kennelEnName\": \"A Luo Ha's Kennel\", // 注册名称\n"
			+ "		\"paperDogName\": \"A Luo Ha  One\",\n" + "		        \"dogMemberName\": \"李鹏\", // 犬主名称\n"
			+ "		        \"dogGender\": \"公\", // 性别中文\n" + "		        \"callName\": \"\", // 呼名称\n"
			+ "		        \"dogBreed\": \"Bichon Frise\", // 犬种英文\n" + "		\"breederEn\": \"xxx\" //繁殖人英文\n"
			+ "		\"dogMemberNameEn\": \"xcxx\" //  犬主英文\n" + "		        \n" + "		\"dog1\": {   \n"
			+ "			\"showLevel\": \"\", // 头衔 1\n"
			+ "			 \"dogName\": \"GCHS CH MON AMI'S REAL GOOD TIME\", // 犬英文名称 2\n"
			+ "			            \"pedigreeCertified\": \"CKU-215464901/19\", // 血统证书 3\n"
			+ "			            \"color\": \"WH\", // 毛色 4\n"
			+ "			            \"createDate\": \"2010-8-8\" // 日期 5\n" + "			        \n" + "		}    \n"
			+ "	}\n" + "}") })
	@RequestMapping(value = "/newdogchip/view", method = RequestMethod.GET)
	@ResponseBody
	// 公众号-血统证书-更新电子证书版本
	public void view(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogChipService.viewCertificate(request);
		ServletUtils.writeResponse(response, result);
	}

	// 增加纸质版登记卡申请功能
	@RequestMapping(value = "/newdogchip/ecertFlag/{id}", method = RequestMethod.GET)
	@ResponseBody
	public void updateEcertFlag(HttpServletRequest request, HttpServletResponse response, @PathVariable("id") String id)
			throws IOException {
		RESTResponse result = restDogChipService.updateEcertFlag(id);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/duplicate/birthCode", method = RequestMethod.GET)
	@ResponseBody
	public void getDuplicateRecordByBirthCertificateLevelCode(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restDogChipService.getDuplicateRecordByBirthCertificateLevelCode(request);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/duplicate/birthCode/{birthCertificateLevelCode}", method = RequestMethod.DELETE)
	@ResponseBody
	public void deleteDuplicateRecordByBirthCertificateLevelCode(HttpServletRequest request,
			HttpServletResponse response, @PathVariable("birthCertificateLevelCode") String birthCertificateLevelCode)
			throws IOException {
		String secretkey = request.getParameter("secretkey");
		RESTResponse result = new RESTResponse(ZAErrorCode.ZA_ERROR, "不允许操作");
		if (!StringUtils.isBlank(secretkey)) {
			String sign = DigestUtils.md5DigestAsHex("secretkey".getBytes()).toLowerCase();
			if (sign.equals(secretkey)) {
				result = restDogChipService.deleteDuplicateRecordByBirthCertificateLevelCode(birthCertificateLevelCode,
						request);
			}
		}
		ServletUtils.writeResponse(response, result);
	}

}