package com.cku.restful.v1.dog.vo.request;

import com.cku.core.BasePageRequest;
import com.drew.lang.annotations.NotNull;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

/**
 * @author yuanshuai
 * @date 2023/6/8 15:27
 */
@Data
@ApiModel
@Builder
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class GoldCertifiedPageRequest extends BasePageRequest {

    private static final long serialVersionUID = -3254110956282262508L;

    @ApiModelProperty("申请来源（1:血统证书升级2:登记卡申请）")
    @NotNull
    private Integer applySource;

    @ApiModelProperty("血统证书号")
    private String pedigreeCertified;

    @ApiModelProperty("出生纸编号")
    private String birthCode;
}
