package com.cku.restful.v1.dog.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogBloodSaveDao;
import com.cku.oa.dog.dao.DogDnaArchiveDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogBloodSave;
import com.cku.oa.dog.entity.DogDnaArchive;
import com.cku.oa.dog.entity.DogPedigreeCertifiedExport;
import com.cku.oa.dog.service.DogDnaArchiveService;
import com.cku.oa.dog.service.DogPedigreeCertifiedExportService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.finance.dao.PaymentChargingItemDao;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.service.OrgService;
import com.cku.restful.v1.dog.model.RestDogPedigreeCertifiedExport;
import com.cku.restful.v1.dog.model.SysCountry;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import net.sf.json.JSONObject;

/**
 * 出口证书申请Service
 *
 * @author lgl
 * @version 2016-08-19
 */
@Service
@Transactional(readOnly = true)
public class RestDogPedigreeCertifiedExportService {

	private static final String PAYMENTCHARGINGITEM_SHORTNAME_ALL = "dog_pedigree_certified_export@All";
	private static final String PAYMENTCHARGINGITEM_SHORTNAME_ZANGAO = "dog_pedigree_certified_export@Zangao";

	@Autowired
	private DogPedigreeCertifiedExportService dogPedigreeCertifiedExportService;
	@Autowired
	private DogService dogService;
	@Autowired
	private PaymentChargingItemDao paymentChargingItemDao;
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	@Autowired
	private PaymentCartService paymentCartService;
	@Autowired
	public LoginServerService loginServerService;

	@Autowired
	private DogDnaArchiveDao dogDnaArchiveDao;
	@Autowired
	private DogBloodSaveDao dogBloodSaveDao;
	@Autowired
	private RestDogDloodDnaService restDogDloodDnaService;
	@Autowired
	public OrgService orgService;

	/**
	 * 申请退款数据
	 *
	 * @param ids
	 * @return
	 */
	public RESTResponse getRefundList(String ids) {
		Member member = UserUtils.getLoginMember();
		DogPedigreeCertifiedExport example = new DogPedigreeCertifiedExport();
		example.setPaymentMemberCode(member.getMemberCode());
		example.setDelFlag("0");
		example.setId(ids);
		List<DogPedigreeCertifiedExport> dogChipList = dogPedigreeCertifiedExportService.findList(example);
		List<RestDogPedigreeCertifiedExport> list = new ArrayList<RestDogPedigreeCertifiedExport>();
		for (DogPedigreeCertifiedExport dogChip : dogChipList) {
			RestDogPedigreeCertifiedExport vo = new RestDogPedigreeCertifiedExport();
			BeanUtil.copyProperties(vo, dogChip, "yyyy-MM-dd");
			vo.setReviewStateCode(vo.getReviewState());
			vo.setReviewState(DictUtils.getDictLabel(vo.getReviewState(), "review_state", ""));

			dogPedigreeCertifiedExportService.getCountry(vo.getExportCountry());

			list.add(vo);
		}
		return new RESTResponse("data", list);
	}

	public RESTResponse getList(HttpServletRequest request) {
		Member member = UserUtils.getLoginMember();
		// 获取参数
		String pedigreeCertified = request.getParameter("pedigreeCertified");
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		// 参数校验
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}

		DogPedigreeCertifiedExport example = new DogPedigreeCertifiedExport();
		// 设置分页参数
		Page<DogPedigreeCertifiedExport> page = new Page<DogPedigreeCertifiedExport>();
		page.setPageNo(pageNoInt);
		page.setPageSize(pageSizeInt);
		// 设置查询条件
		example.setPaymentMemberCode(member.getMemberCode());
		example.setDelFlag("0");
		example.setPage(page);
		if (StringUtils.isNotBlank(pedigreeCertified)) {
			example.setPedigreeCertified(pedigreeCertified);
		}
		// 根据当前登录是否杜高会员来判断个人狗列表是杜高犬还是CKU犬
		if (StringUtils.isBlank(example.getDogBreed())) {
			// 根据当前登录端查询犬种
			example.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
		} else {
			example.getSqlMap().put("dogBreedMap", " ='" + example.getDogBreed() + "'");
		}
		// 查询并组装返回对象
		Page<DogPedigreeCertifiedExport> result = dogPedigreeCertifiedExportService.findPage(page, example);
		List<DogPedigreeCertifiedExport> dogPedigreeCertifiedExportList = result.getList();
		List<RestDogPedigreeCertifiedExport> list = new ArrayList<RestDogPedigreeCertifiedExport>();
		for (DogPedigreeCertifiedExport dogChip : dogPedigreeCertifiedExportList) {
			RestDogPedigreeCertifiedExport vo = new RestDogPedigreeCertifiedExport();
			BeanUtil.copyProperties(vo, dogChip, "yyyy-MM-dd");
			vo.setState(dogChip.getReviewState());
			vo.setReviewState(DictUtils.getDictLabel(vo.getReviewState(), "review_state", ""));
			// 是否可编辑
			vo.setEditFlag(dogChip.getCreateDate().after(DateUtils.parseDate("2023-03-01")));
			if (StringUtils.isNotEmpty(vo.getExportCountry())) {
				SysCountry country = dogPedigreeCertifiedExportService.getCountry(vo.getExportCountry());
				if(country!=null) {
					vo.setExportCountryCn(country.getCountryCn());
				}
			}
			vo.setBirthdate(DateUtils.formatDate(dogChip.getBirthdate()));
			vo.setColorFlag(dogChip.getColorFlag());
			vo.setNameEn(dogChip.getNameEn());
			vo.setDogBreedName(dogChip.getBreedCnName());
			vo.setGender(dogChip.getGender().equals("1") ? "公" : "母");
			if(vo.getDogDnaArchiveFlag() != null && vo.getDogDnaArchiveFlag()) {
				DogDnaArchive dogDnaArchive = dogDnaArchiveDao.getByPedigreeCertifiedCode(vo.getPedigreeCertified());
				if(!Objects.isNull(dogDnaArchive)) {
					vo.setApplyChannel(String.valueOf(dogDnaArchive.getApplyChannel())  );
					vo.setHospitalCode(dogDnaArchive.getOrgId());
					Org org = orgService.get(dogDnaArchive.getOrgId());
					if(!Objects.isNull(org)) {
						vo.setHospitalName(org.getName());
						vo.setHospitalProvince(org.getProvince());
					}
				}
			}
			list.add(vo);
		}
		long count = result.getCount();
		return new RESTResponse("list", new PageBeanResult<RestDogPedigreeCertifiedExport>(list, count));
	}

	@Transactional(readOnly = false)
	public RESTResponse post(String json) {
		// 获取参数
		DogPedigreeCertifiedExport vo = BeanUtil.toBean(json, DogPedigreeCertifiedExport.class);
		// 参数校验
		validateParameter(vo);
		// 构造持久对象
		DogPedigreeCertifiedExport po = buildPo(vo);
		// 业务校验
		dogPedigreeCertifiedExportService.validateBusiness(po);
		// 写入业务表
		dogPedigreeCertifiedExportService.save(po);
		// 写入购物车
		String businessOrderCode = IdGen.uuid();
		PaymentCart paymentCart = buildPaymentCart(po, businessOrderCode);
		paymentCartService.addToCart(paymentCart, "1008");
		
		StringBuilder cartIds = new StringBuilder();
		cartIds.append(paymentCart.getId());

		if (vo.getDogDnaArchiveFlag() != null && vo.getDogDnaArchiveFlag()) {
			String dnaCartId = buildDnaPaymentCart(po, businessOrderCode);
			cartIds.append(",").append(dnaCartId);
		}
		return new RESTResponse("data", cartIds.toString());
	}

	/**
	 * @description: 参数校验
	 * @author: laiguanglong
	 * @date: 2016年9月8日 下午5:35:32
	 */
	private void validateParameter(DogPedigreeCertifiedExport vo) {
		if (StringUtils.isBlank(vo.getDogId())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬id为空");
		}
		if (StringUtils.isBlank(vo.getExportCountry())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "出口国家为空");
		}
		if (StringUtils.isBlank(vo.getExporter())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "接收人为空");
		}
		if (StringUtils.isBlank(vo.getExportDestination())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "出口目的地为空");
		}

	}

	/**
	 * @description: 构造持久对象
	 * @author: laiguanglong
	 * @date: 2016年9月13日 下午6:09:17
	 */
	private DogPedigreeCertifiedExport buildPo(DogPedigreeCertifiedExport vo) {
		DogPedigreeCertifiedExport po = new DogPedigreeCertifiedExport();
		Dog dog = dogService.get(vo.getDogId());
		if (dog == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该血统证书号有误");
		}
		po.setDogId(dog.getId());
		po.setPedigreeCertified(dog.getPedigreeCertifiedCode());
		po.setExportCountry(vo.getExportCountry().toUpperCase());
		po.setExportDestination(vo.getExportDestination().toUpperCase());
		po.setExporter(vo.getExporter().toUpperCase());
		po.setPaymentMemberCode(UserUtils.getLoginMember().getMemberCode());
		String shortName = PAYMENTCHARGINGITEM_SHORTNAME_ALL;
		if ("230".equals(dog.getDogBreed())) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_ZANGAO;
		}
		PaymentChargingItem paymentChargingItem = paymentChargingItemDao.getByShortName(shortName);
		po.setPrice(paymentChargingItem.getPrice());
		po.setReviewState("0");
		po.setPaymentState("1");
		po.setProcessState("0");
		po.setDogDnaArchiveFlag(vo.getDogDnaArchiveFlag());
		po.setVodUrl(vo.getVodUrl());
		po.setApplyChannel(vo.getApplyChannel());//办理渠道   0	机构办理   1	自检
		if( "0".equals(po.getApplyChannel() )) {
			po.setHospitalCode(vo.getHospitalCode());
		}
		return po;
	}

	private String buildDnaPaymentCart(DogPedigreeCertifiedExport po, String businessOrderCode) {
		DogDnaArchive dogDnaArchive = dogDnaArchiveDao.getByPedigreeCertifiedCode(po.getPedigreeCertified());
		if (dogDnaArchive != null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
					"已有位点分析" + ("1".equals(dogDnaArchive.getPaymentState()) ? "未付款" : ""));
		}
		if(!( "1".equals(po.getApplyChannel()) || "0".equals(po.getApplyChannel() ))) {
			//办理渠道   0	机构办理   1	自检
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "applyChannel为空");
		}
		String hospitalCode = po.getHospitalCode();
		if ("0".equals(po.getApplyChannel()) && StringUtils.isEmpty(hospitalCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "hospitalCode为空");
		}
		StringBuilder cartIds = new StringBuilder();

		DogBloodSave DogBloodSave = dogBloodSaveDao.getByPedigreeCertifiedCode(po.getPedigreeCertified());
		if (DogBloodSave == null) {
			String bloodSaveCartId = restDogDloodDnaService.bloodSave(null, "", "", "", po.getPedigreeCertified(), "1",
					IdGen.uuid(), hospitalCode);
			cartIds.append(bloodSaveCartId).append(",");
		}
		String dnaArchiveCartId = restDogDloodDnaService.dnaArchive("", "", po.getDogId(), po.getPedigreeCertified(),
				IdGen.uuid(), hospitalCode,po.getApplyChannel());
		cartIds.append(dnaArchiveCartId);
		return cartIds.toString();
	}

	private PaymentCart buildPaymentCart(DogPedigreeCertifiedExport po, String businessOrderCode) {
		PaymentCart paymentCart = new PaymentCart();
		String shortName = PAYMENTCHARGINGITEM_SHORTNAME_ALL;
		Dog dog = dogService.getByPedigreeCertifiedCode(po.getPedigreeCertified());
		if ("230".equals(dog.getDogBreed())) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_ZANGAO;
		}
		PaymentChargingItem paymentChargingItem = paymentChargingItemService.getByShortName(shortName);
		paymentCart.setChargingItemId(paymentChargingItem.getId());
		paymentCart.setChargingItemName(paymentChargingItem.getName());
		paymentCart.setNum("1");
		paymentCart.setPrice(paymentChargingItem.getPrice());
		paymentCart.setTotalPrice(paymentChargingItem.getPrice());
		paymentCart.setBusinessTable("dog_pedigree_certified_export");
		paymentCart.setBusinessIds(po.getId());
		paymentCart.setBusinessOrderCode(businessOrderCode);
		return paymentCartService.addBusinessManage(paymentCart, "1008");
	}

	public RESTResponse getPrice(HttpServletRequest request) {
		// 获取参数
		String dogId = request.getParameter("dogId");
		String dogDnaArchiveFlag = request.getParameter("dogDnaArchiveFlag");
		Boolean dnaFlag = false;
		if (StringUtils.isNotEmpty(dogDnaArchiveFlag)) {
			dnaFlag = Boolean.valueOf(dogDnaArchiveFlag).booleanValue();
		}
		if (StringUtils.isBlank(dogId)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬id为空");
		}
		Dog dog = dogService.get(dogId);
		if (dog == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬id有误");
		}
		// 验证4代犬是否禁止出口
		dogService.dogChangeBan(dog);

		// 获取价格
		String shortName = PAYMENTCHARGINGITEM_SHORTNAME_ALL;
		if ("230".equals(dog.getDogBreed())) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_ZANGAO;
		}

		PaymentChargingItem paymentChargingItem = paymentChargingItemService.getByShortName(shortName);
		String price = paymentChargingItem.getPrice();
		// 是否申请位点分析
		if (dnaFlag) {
			DogDnaArchive dogDnaArchive = dogDnaArchiveDao.getByPedigreeCertifiedCode(dog.getPedigreeCertifiedCode());
			if (dogDnaArchive == null  || "1".equals(dogDnaArchive.getPaymentState()) ) {
				//点位分析需要换收费项
				List<PaymentChargingItem> items = paymentChargingItemService.findListByIds(DogDnaArchiveService.DNA_ARCHIVE_FEE);
				Double dogDnaArchivePrice = items.stream().mapToDouble(a -> Double.valueOf(a.getPrice())).sum();
				
				price = new BigDecimal(price).add(new BigDecimal(dogDnaArchivePrice)).toString();
			}
		}

		JSONObject jo = new JSONObject();
		jo.put("price", price);
		return new RESTResponse("data", jo);
	}

	public RESTResponse countryList(HttpServletRequest request) {
		List<SysCountry> countryList = dogPedigreeCertifiedExportService.getCountryList();
		JSONObject jo = new JSONObject();
		jo.put("countryList", countryList);
		return new RESTResponse("data", jo);
	}

	@Transactional
	public RESTResponse editvod(String json) {
		JSONObject obj = JSONObject.fromObject(json);
		String id = obj.getString("id");
		String vodUrl = obj.getString("vodUrl");
		DogPedigreeCertifiedExport dogPedigreeCertifiedExport = dogPedigreeCertifiedExportService.get(id);
		
		if(StringUtils.isEmpty(dogPedigreeCertifiedExport.getVodUrl())) {
			dogPedigreeCertifiedExport.setReviewState("0");

		}else {
			if (!dogPedigreeCertifiedExport.getVodUrl().equals(vodUrl)) {
				dogPedigreeCertifiedExport.setReviewState("0");
			}
		}
		dogPedigreeCertifiedExport.setVodUrl(vodUrl);
		dogPedigreeCertifiedExportService.save(dogPedigreeCertifiedExport);
		return new RESTResponse("data", "OK");
	}
	
	

	@Transactional(readOnly = false)
	public RESTResponse validateBusiness(HttpServletRequest request) {
		// 获取参数
		String dogId = request.getParameter("dogId");
		// 构造持久对象
		DogPedigreeCertifiedExport po = new DogPedigreeCertifiedExport();
		po.setDogId(dogId);
		// 业务校验
		dogPedigreeCertifiedExportService.validateBusiness(po);
		return new RESTResponse("data", true);
	}

}