/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.breeder.service;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.cku.core.PageBeanResult;
import com.cku.core.PageResultDto;
import com.cku.core.RESTResponse;
import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogBirthCertificateDao;
import com.cku.oa.dog.dao.DogChipDao;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogChip;
import com.cku.oa.dog.service.DogColorMarkService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.finance.dao.PaymentOrderDao;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.sys.coupon.entity.SysCoupon;
import com.cku.oa.sys.coupon.service.SysCouponService;
import com.cku.oa.sys.coupon.vo.CouponGroupVO;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberActivity20201212Discount;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.ConstantUtils;
import com.cku.oa.sys.util.DateUtils;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.restful.v1.breeder.dto.RestDogChipApplyCouponDto;
import com.cku.restful.v1.breeder.dto.RestDogChipApplyOptimalCouponsDto;
import com.cku.restful.v1.dog.model.RestDogChipPriceDto;
import com.cku.restful.v1.dog.model.RestDogChipPriceResultDto;
import com.cku.restful.v1.dog.service.RestDogChipService;
import com.cku.restful.v1.finance.service.RestOrderService;
import com.cku.restful.v1.sys.model.RestCouponGroup;
import com.cku.restful.v1.sys.service.RestMemberService;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import edu.emory.mathcs.backport.java.util.Arrays;
import net.sf.json.JSONObject;

/**
 * 新生犬登记Service
 *
 * @author zhuoHeng
 * @version 2016-08-04
 */
@Service
@Transactional(readOnly = true)
public class BreederDogChipService {

	@Autowired
	private RestDogChipService restDogChipService;
	@Autowired
	private RestOrderService restOrderService;
	@Autowired
	private PaymentOrderDao paymentOrderDao;
	@Autowired
	private PaymentOrderDetailDao paymentOrderDetailDao;
	@Autowired
	private DogChipDao dogChipDao;
	@Autowired
	private DogBirthCertificateDao dogBirthCertificateDao;
	@Autowired
	private DogColorMarkService dogColorMarkService;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private SysCouponService sysCouponService;
	@Autowired
	private MemberService memberService;
	@Autowired
	private RestMemberService restMemberService;
	@Autowired
	private MemberActivity20201212Discount memberActivity20201212Discount;

	@Transactional(readOnly = false)
	public RESTResponse post(String json, HttpServletRequest request) {
		RESTResponse response = restDogChipService.post(json, request);
		String[] cardIds = response.getData().getString("data").split(",");
		RESTResponse re = restOrderService.cartToOrder(cardIds);
		if (re != null && re.getData() != null && re.getData().get("data") != null) {
			JSONObject jo = JSONObject.fromObject(re.getData().get("data"));
			if (jo.get("id") != null && StringUtils.isNotBlank(jo.get("id").toString())) {
				// 修改活动记录
				memberActivity20201212Discount.buildDogChip20201212Discount2(jo.get("id").toString());
			}
		}
		return re;
	}

	@Transactional(readOnly = false)
	public PageResultDto<RestCouponGroup> getCoupons(RestDogChipApplyCouponDto request,
			HttpServletRequest httpRequest) {
		// TODO@zhangjuwu 优惠券包业务
		Member member = UserUtils.getLoginMember();
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.getByBirthCerRegCode(request.getBirthCode());
		if (Objects.isNull(dogBirthCertificate)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请输入正确的出生纸编号");
		}
		// 根据犬只ID判断是否符合用券条件
		if (!DateUtils.isInOneYearOld(dogBirthCertificate.getDogBirthday())) {
			return PageResultDto.success(null, 0L);
		}
		// 判断申请人是否是犬只的主人或繁殖人
		if (!member.getMemberCode().equals(request.getMemberCode())
				&& !member.getMemberCode().equals(dogBirthCertificate.getBreederMemberCode())) {
			return PageResultDto.success(null, 0L);
		}
		Page<CouponGroupVO> result = sysCouponService
				.findGroupPage(new Page<SysCoupon>(request.getPageNo(), request.getPageSize()),
						SysCoupon.builder().state("0").memberCode(member.getMemberCode())
								.targetList(Arrays.asList(new String[] { ConstantUtils.COUPON_TARGET_DOGCHIPAPPLY }))
								.build());
		// 结果处理
		List<RestCouponGroup> resultList = new ArrayList<RestCouponGroup>();
		if (!CollectionUtils.isEmpty(result.getList())) {
			RestDogChipPriceResultDto priceResult = restDogChipService.getPriceWithCoupon(
					RestDogChipPriceDto.builder().birthCode(request.getBirthCode()).dnaSaveWay(request.getDnaSaveWay())
							.ecertFlag(request.getEcertFlag()).isDnaParentsCompare(request.getIsDnaParentsCompare())
							.memberCode(request.getMemberCode()).newMember(request.getNewMember()).build());
			// 计算优惠券可抵扣金额
			Double canDeductPrice = priceResult.getItems().stream()
					.filter(cart -> ConstantUtils.DOGCHIPAPPLY_DEDUCT_ITEM.contains(cart.getId()))
					.mapToDouble(a -> Double.parseDouble(a.getPrice())).sum();
			for (CouponGroupVO vo : result.getList()) {
				RestCouponGroup cg = new RestCouponGroup();
				cg.setGroupId(vo.getGroupId());
				cg.setCouponName(vo.getCouponName());
				cg.setCouponType(vo.getCouponType());
				cg.setCouponTypeDesc(vo.getCouponTypeDesc());
				cg.setCouponNum(vo.getCouponNum());
				cg.setFacePrice(vo.getFacePrice());
				cg.setTarget(vo.getTarget());
				cg.setExplains("");
				cg.setUseNum(BigInteger.ONE.intValue());
				if (vo.getFacePrice().doubleValue() > (Objects.isNull(canDeductPrice) ? 0d : canDeductPrice)) {
					cg.setState("1");
				}
				resultList.add(cg);
			}
			List<RestCouponGroup> tmpList = resultList.stream().filter(cg -> "1".equals(cg.getState()))
					.collect(Collectors.toList());
			resultList.removeAll(tmpList);
			resultList.addAll(tmpList);
		}

		return PageResultDto.success(resultList, result.getCount());
	}

	@Transactional(readOnly = false)
	public ResultDto<RestCouponGroup> getOptimalCoupons(RestDogChipApplyOptimalCouponsDto request) throws Exception {
		Member member = UserUtils.getLoginMember();
		if (StringUtils.isNotBlank(request.getBirthCode()) && StringUtils.isNotBlank(request.getMemberCode())) {
			// 获取出生纸
			DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao
					.getByBirthCerRegCode(request.getBirthCode());
			// 如果选择优惠券，则校验犬只年龄12月及以上，办理人必须为银卡会员以上,办理人必须为犬主或繁殖人,否则推荐券为空
			if (Objects.isNull(dogBirthCertificate)) {
				return ResultDto.SUCCESSFUL();
			}

			if (!DateUtils.isInOneYearOld(dogBirthCertificate.getDogBirthday())) {
				return ResultDto.SUCCESSFUL();
			}
			
			if (!member.getMemberCode().equals(request.getMemberCode())
					&& !member.getMemberCode().equals(dogBirthCertificate.getBreederMemberCode())) {
				return ResultDto.SUCCESSFUL();
			}
		}

		RestDogChipPriceResultDto priceResult = restDogChipService.getPriceWithCoupon(
				RestDogChipPriceDto.builder().birthCode(request.getBirthCode()).dnaSaveWay(request.getDnaSaveWay())
						.ecertFlag(request.getEcertFlag()).isDnaParentsCompare(request.getIsDnaParentsCompare())
						.memberCode(request.getMemberCode()).newMember(request.getNewMember()).build());
		// 计算优惠券可抵扣金额
		Double canDeductPrice = priceResult.getItems().stream()
				.filter(cart -> ConstantUtils.DOGCHIPAPPLY_DEDUCT_ITEM.contains(cart.getId()))
				.mapToDouble(a -> Double.parseDouble(a.getPrice())).sum();

		List<CouponGroupVO> list = sysCouponService.findGroupList(
				SysCoupon.builder().state("0").memberCode(member.getMemberCode()).facePrice(canDeductPrice.toString())
						.targetList(Arrays.asList(new String[] { ConstantUtils.COUPON_TARGET_DOGCHIPAPPLY })).build());

		if (!CollectionUtils.isEmpty(list)) {
			CouponGroupVO vo = list.get(0);
			RestCouponGroup cg = new RestCouponGroup();
			cg.setGroupId(vo.getGroupId());
			cg.setCouponName(vo.getCouponName());
			cg.setCouponType(vo.getCouponType());
			cg.setCouponTypeDesc(vo.getCouponTypeDesc());
			cg.setCouponNum(vo.getCouponNum());
			cg.setFacePrice(vo.getFacePrice());
			cg.setTarget(vo.getTarget());
			cg.setExplains("");
			cg.setUseNum(BigInteger.ONE.intValue());
			return ResultDto.success(cg);
		}
		return ResultDto.SUCCESSFUL();
	}

	public RESTResponse orderOther(String id) {
		String memberCode = UserUtils.getLoginMember().getMemberCode();
		PaymentOrder paymentOrder = paymentOrderDao.get(id);
		if (paymentOrder == null || !paymentOrder.getMemberCode().equals(memberCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "订单号有误");
		}
		List<PaymentOrderDetail> paymentOrderDetailList = paymentOrderDetailDao
				.getOrderByRunningNum(paymentOrder.getOrderCode(), memberCode);
		String chipId = "";
		boolean memberFlag = false;
		boolean payFlag = false;
		for (PaymentOrderDetail paymentOrderDetail : paymentOrderDetailList) {
			if ("dog_chip".equals(paymentOrderDetail.getBusinessTable())) {
				chipId = paymentOrderDetail.getBusinessIds();
			}
			// 有缴会员费的信息
			if ("sys_member".equals(paymentOrderDetail.getBusinessTable())) {
				payFlag = true;
			}

		}

		if (StringUtils.isBlank(chipId)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "订单有误");
		}
		JSONObject jo = new JSONObject();
		DogChip dogChip = dogChipDao.get(chipId);
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.getByBirthCerRegCode(dogChip.getBirthCode());

		if (!dogBirthCertificate.getBreederMemberCode().equals(dogBirthCertificate.getTempMemberCode())) {
			memberFlag = true;
		}

		Member newMember = memberService.getByMemberCode(dogBirthCertificate.getTempMemberCode());
		jo.put("memberName", newMember.getName());
		jo.put("memberCode", newMember.getMemberCode());
		jo.put("memberMobile", newMember.getMobile());
		jo.put("memberType", UserUtils.getMemberTypeDesc(newMember) + UserUtils.getMemberCardTypeDesc(newMember));

		jo.put("newMemnerFlag", memberFlag);
		jo.put("payFlag", payFlag);

		return new RESTResponse("data", jo);
		// if (memberFlag) { // 有会员缴费信息
		// Member newMember =
		// memberService.getByMemberCode(dogBirthCertificate.getTempMemberCode());
		// jo.put("memberName", newMember.getName());
		// jo.put("memberCode", newMember.getMemberCode());
		// jo.put("memberMobile", newMember.getMobile());
		// jo.put("memberType", getTypeDesc(newMember));
		// jo.put("newMemnerFlag", true);
		// return new RESTResponse("data",jo);
		// } else {
		// jo.put("newMemnerFlag", false);
		// return new RESTResponse("data",jo);
		// }
	}

	public RESTResponse order(String id) {
		String memberCode = UserUtils.getLoginMember().getMemberCode();
		PaymentOrder paymentOrder = paymentOrderDao.get(id);
		if (paymentOrder == null || !paymentOrder.getMemberCode().equals(memberCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "订单号有误");
		}
//		String productNum = "1";
		Double productPrice = Double.parseDouble(paymentOrder.getTotalPrice());
		String dogChipId = null;

		// 新生幼犬标记位
		boolean newDogFlag = true;
		List<PaymentOrderDetail> paymentOrderDetailList = paymentOrderDetailDao
				.getOrderByRunningNum(paymentOrder.getOrderCode(), memberCode);
		for (PaymentOrderDetail paymentOrderDetail : paymentOrderDetailList) {
			if ("dog_chip".equals(paymentOrderDetail.getBusinessTable())) {
				dogChipId = paymentOrderDetail.getBusinessIds();
			}
			if ("249".equals(paymentOrderDetail.getChargingItemId())) {
				newDogFlag = false;
			}
		}
		if (StringUtils.isBlank(dogChipId)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "订单有误");
		}
//		DogChip dogChip = dogChipDao.get(dogChipId);
//		DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.getByBirthCerRegCode(dogChip.getBirthCode());
//		// 新出生纸标记位
//		boolean isNewDogBirthCertificate = dogBirthCertificate.getCreateDate()
//				.getTime() >= DogBirthCertificateService.newBusinessTimeMillis;
//		// 双亲比对标记位
//		boolean dnaParentsCompareFlag = "1".equals(dogChip.getIsDnaParentsCompare());
//		// 位点分析标记位
//		boolean dnaArchiveFlag = "1".equals(dogChip.getDnaSaveWay());
		// 组装返回对象
		JSONObject jo = new JSONObject();
		jo.put("orderCode", paymentOrder.getOrderCode());
		jo.put("totalPrice", paymentOrder.getTotalPrice());

		List<JSONObject> other = new ArrayList<>();
		List<PaymentOrderDetail> couponList = paymentOrderDetailList.stream()
				.filter(d -> "sys_coupon".equals(d.getBusinessTable())).collect(Collectors.toList());
		Double couponPrice = 0d;
		if (!CollectionUtils.isEmpty(couponList)) {
			JSONObject otherChild = new JSONObject();
			otherChild.put("name", "血统证书抵扣费用");
			otherChild.put("num", "1");
			couponPrice = couponList.stream().mapToDouble(a -> Double.parseDouble(a.getTotalPrice())).sum();
			otherChild.put("price", String.format("%.2f", couponPrice));
			other.add(otherChild);
		}

		List<PaymentOrderDetail> memberList = paymentOrderDetailList.stream()
				.filter(d -> ("sys_member".equals(d.getBusinessTable()) || "kennel".equals(d.getBusinessTable())))
				.collect(Collectors.toList());
		Double memberPrice = 0d;
		if (!CollectionUtils.isEmpty(memberList)) {
			JSONObject otherChild = new JSONObject();
			otherChild.put("name", "会员缴费");
			otherChild.put("num", "1");
			memberPrice = memberList.stream().mapToDouble(a -> Double.parseDouble(a.getTotalPrice())).sum();
			otherChild.put("price", String.format("%.2f", memberPrice));
			other.add(otherChild);
		}

		// 判断产品类型
//		jo.put("productName",getProductName(isNewDogBirthCertificate, newDogFlag, dnaParentsCompareFlag, dnaArchiveFlag));
		JSONObject otherChild = new JSONObject();
		otherChild.put("name", "血统证书业务费用");
		otherChild.put("num", "1");
		otherChild.put("price", String.format("%.2f", productPrice - couponPrice - memberPrice));
		other.add(0, otherChild);
		jo.put("other", other);

		return new RESTResponse("data", jo);
	}

	private String getProductName(boolean isNewDogBirthCertificate, boolean newDogFlag, boolean dnaParentsCompareFlag,
			boolean dnaArchiveFlag) {
		String productName = "";
		if (isNewDogBirthCertificate) {
			// 新出生纸
			if (newDogFlag) {
				// 新生幼犬
				if (dnaParentsCompareFlag) {
					// 双亲比对
					productName = "DNA纯血统犬证书办理";
				} else {
					// 无双亲比对
					if (dnaArchiveFlag) {
						// 位点分析
						productName = "纯血犬血统证书办理(含位点分析)";
					} else {
						// 无位点分析
						productName = "纯血犬血统证书办理";
					}
				}
			} else {
				// 超龄犬
				if (dnaParentsCompareFlag) {
					// 双亲比对
					productName = "DNA纯血统证书办理(超龄犬)";
				} else {
					// 无双亲比对
					productName = "纯血犬血统证书办理(超龄犬)";
				}
			}
		} else {
			// 旧出生纸
			if (newDogFlag) {
				// 新生幼犬
				if (dnaParentsCompareFlag) {
					// 双亲比对
					productName = "DNA纯血统犬证书办理(含芯片)";
				} else {
					// 无双亲比对
					if (dnaArchiveFlag) {
						// 位点分析
						productName = "纯血犬血统证书办理(含位点分析含芯片)";
					} else {
						// 无位点分析
						productName = "纯血犬血统证书办理(含芯片)";
					}
				}
			} else {
				// 超龄犬
				if (dnaParentsCompareFlag) {
					// 双亲比对
					productName = "DNA纯血统证书办理(超龄犬含芯片)";
				} else {
					// 无双亲比对
					productName = "纯血犬血统证书办理(超龄犬含芯片)";
				}
			}
		}
		return productName;
	}

	public RESTResponse getCanApplyDogBirthCertificateList(HttpServletRequest request) {
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		// 参数校验
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}
		String memberCode = UserUtils.getLoginMember().getMemberCode();
		// 四星五星犬舍免激活
		List<DogBirthCertificate> dogBirthCertificateList = dogBirthCertificateDao
				.getCanApplyDogBirthCertificateList(memberCode, (pageNoInt - 1) * pageSizeInt, pageSizeInt);
		List<JSONObject> list = Lists.newArrayList();
		for (DogBirthCertificate dogBirthCertificate : dogBirthCertificateList) {
			JSONObject jo = new JSONObject();
			jo.put("birthCerRegCode", getString(dogBirthCertificate.getBirthCerRegCode()));
			jo.put("dogBirthday", DateUtils.dateToStr(dogBirthCertificate.getDogBirthday()));
			jo.put("identificationFlag", getString(dogBirthCertificate.getIdentificationFlag()));
			jo.put("colorFlag", getString(dogColorMarkService.getDogColorMarkCn(dogBirthCertificate.getColorFlag())));
			jo.put("dogBreed", getString(dogTypeService.getBreedCnName(dogBirthCertificate.getDogBreed())));
			jo.put("dogGender", DictUtils.getDictLabel(dogBirthCertificate.getDogGender(), "dog_gender", ""));
			jo.put("dogEnName", getString(dogBirthCertificate.getDogEnName()));
			jo.put("fmdogBreedCertifiedCode", getString(dogBirthCertificate.getFmdogBreedCertifiedCode()));
			jo.put("snCode", getString(dogBirthCertificate.getSnCode()));
			list.add(jo);
		}
		return new RESTResponse("list",
				new PageBeanResult<>(list, dogBirthCertificateDao.getCanApplyDogBirthCertificateCount(memberCode)));
	}

	private String getString(String str) {
		return str == null ? "" : str;
	}

	public RESTResponse checkMember(HttpServletRequest request) {
		String memberCode = request.getParameter("memberCode");
		if (StringUtils.isBlank(memberCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "memberCode不能为空");
		}
		Member member = memberService.getByMemberCode(memberCode);
		if (member == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员号码有误，请输入正确会员号，新犬主如非cku会员，请选择非cku会员");
		}

		if (!MemberUtil.isActiveMember(member)) {
			String price = restMemberService.getRenewPrice(member.getMemberCode());
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "因新犬主为无效CKU会员，无法办理犬主变更业务，如继续办理，需为其缴纳会员费" + price + "元。");
		}
		return new RESTResponse();
	}

}