package com.cku.partner.open.club.web;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.cku.core.PageResultDto;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogNose;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.service.DogNoseService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.partner.open.club.service.AppHospitalService;
import com.cku.restful.v1.breeder.service.RestBreederService;
import com.cku.restful.v1.dog.model.RestDogBirthCertificate;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.modules.sys.entity.User;

/**
 * user chaixueteng 2016年10月12日
 */
@Controller
@RequestMapping(value = "/partner/open")
public class AppHospitalController extends BaseRestController {
	@Autowired
	private AppHospitalService appHospitalService;

	@Autowired
	private DogNoseService dogNoseService;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private RestBreederService restBreederService;

	/**
	 * @Description: APP 合作机构-新生犬登记 - 以采集的鼻纹列表
	 * @author: zhangxiang
	 * @date: 2020/7/9 17:56
	 */

	@RequestMapping(value = "findDogNoseList")
	@ResponseBody
	public PageResultDto<RestDogBirthCertificate> findDogNoseList(HttpServletRequest request,
			HttpServletResponse response) {
		JSONObject params = new JSONObject();
		DogNose dogNose = new DogNose();
		User user = appHospitalService.loginUser();
		DogBirthCertificate dogBirthCertificate = new DogBirthCertificate();
		// dogBirthCertificate.setAddUser(user.getLoginName());
		dogNose.setDogBirthCertificate(dogBirthCertificate);
		dogNose.setCreateBy(user);
		Page<DogNose> page = dogNoseService.findListApp(new Page<DogNose>(request, response), dogNose);
		List<DogNose> lists = page.getList();
		List<RestDogBirthCertificate> restDogBirthCertificates = new ArrayList<>();
		for (DogNose l : lists) {
			RestDogBirthCertificate dogBirthCertificate1 = new RestDogBirthCertificate();
			dogBirthCertificate1.setBirthCerRegCode(l.getDogBirthCertificate().getBirthCerRegCode());
			dogBirthCertificate1.setDogEnName(l.getDogBirthCertificate().getDogEnName());
			DogType dogType = dogTypeService.getByDogBreedCode(l.getDogBirthCertificate().getDogBreed());
			if (dogType != null) {
				dogBirthCertificate1.setBreeder(dogType.getBreedCnName());
			}
			if (l.getDogBirthCertificate().getDogBirthday() != null) {
				dogBirthCertificate1.setDogBirthday(
						new SimpleDateFormat("yyyy-MM-dd").format(l.getDogBirthCertificate().getDogBirthday()));
			}
			dogBirthCertificate1.setDogGender(l.getDogBirthCertificate().getDogGender());
			dogBirthCertificate1.setCreateDate(new SimpleDateFormat("yyyy-MM-dd").format(l.getCreateDate()));
			restDogBirthCertificates.add(dogBirthCertificate1);
		}

		long count = page.getCount();
		// return new RESTResponse("list", new
		// PageBeanResult<RestDogBirthCertificate>(restDogBirthCertificates, count));
		return PageResultDto.success(restDogBirthCertificates, count);

	}

	/**
	 * @Description: APP 合作机构-新生犬登记 - 鼻纹申请
	 * @author: zhangxiang
	 * @date: 2020/7/9 17:56
	 */
	@RequestMapping(value = "searchByDogNose")
	@ResponseBody
	public RESTResponse searchByDogNose(HttpServletRequest request, HttpServletResponse response) {

		// 这里获取member，如果token失效，会抛出-30，用户信息验证失败的异常
		User user = appHospitalService.loginUser();
		String birthCode = request.getParameter("birthCode");
		String snCode = request.getParameter("snCode");
		if (org.apache.commons.lang3.StringUtils.isBlank(birthCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登记卡编号/芯片号为空");
		}
		if (org.apache.commons.lang3.StringUtils.isBlank(snCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "授权码为空");
		}
		return new RESTResponse(appHospitalService.searchByDogNose(birthCode, snCode));
	}

	/**
	 * @Description: 我的犬只列表-添加鼻纹
	 * @author: zhangxiang
	 * @date: 2020/7/23 14:39
	 */
	@RequestMapping(value = "/addDogNose", method = RequestMethod.PUT)
	public void addDogNose(@RequestBody String json, HttpServletResponse response) throws IOException {
		ServletUtils.writeResponse(response, appHospitalService.addDogNose(json));
	}

	// @RequestMapping(value = "/addDogNoseByDogId", method = RequestMethod.PUT)
	// public void addDogNoseByDogId(@RequestBody String json, HttpServletResponse
	// response) throws IOException {
	// ServletUtils.writeResponse(response, restBreederService.addDogNose(json));
	// }

	@RequestMapping(value = "/birthcertificate/addDogNose", method = RequestMethod.PUT)
	@ResponseBody
	public void birthAddDogNose(@RequestBody String json, HttpServletResponse response) throws Exception {
		ServletUtils.writeResponse(response, appHospitalService.addDogNoseByBirth(json));
	}
}
