package com.cku.partner.club.web;

import com.cku.oa.dog.entity.DogAppraisal;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.service.DogAppraisalService;
import com.cku.oa.dog.service.DogColorMarkService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.show.entity.MainShows;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.service.OrgService;
import com.cku.partner.club.service.ClubDogAppraisalService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.Dict;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping(value = "/partner/dog/appraisal")
public class ClubDogAppraisalController extends BaseController {

    @Autowired
    private DogTypeService dogTypeService;
    @Autowired
    private DogColorMarkService dogColorMarkService;
    @Autowired
    private DogAppraisalService dogAppraisalService;
    @Autowired
    private ClubDogAppraisalService clubDogAppraisalService;
    @Autowired
    private OrgService orgService;
    @Autowired
    private PaymentOrderService paymentOrderService;
    @Autowired
    private PaymentOrderDetailDao paymentOrderDetailDao;

    @RequestMapping(value = {"list", ""})
    public String list(DogAppraisal dogAppraisal, HttpServletRequest request, HttpServletResponse response, Model model) {
        Org org = (Org) UserUtils.getSession().getAttribute("org");
        dogAppraisal.setPaymentMemberCode(org.getMemberCode());
        dogAppraisal.setCreateBy(org.getUser());
        Page<DogAppraisal> page = clubDogAppraisalService.findPage(new Page<DogAppraisal>(request, response), dogAppraisal);
        //标记isFinishOrder字段
        for (DogAppraisal po : page.getList()) {
            po.setIsFinishOrder(dogAppraisalService.getIsFinishOrder(po));
            po.setBusinessState(dogAppraisalService.getBusinessState(po));
        }
        model.addAttribute("page", page);
        model.addAttribute("dogTypeList", dogTypeService.findAllList());
        return "partner/dogAppraisal/dogAppraisalList";
    }

    @RequestMapping(value = "form")
    public String form(DogAppraisal dogAppraisal, Model model) {
        dogAppraisal = clubDogAppraisalService.get(dogAppraisal);
        model.addAttribute("dogAppraisal", dogAppraisal);
        return "partner/dogAppraisal/dogAppraisalForm";
    }

    @RequestMapping(value = "addForm")
    public String addForm(DogAppraisal dogAppraisal, Model model) {
        Org org = (Org) UserUtils.getSession().getAttribute("org");
        dogAppraisal.setChipInject("0");
        List<Dict> reviewList = Lists.newArrayList();
        reviewList.add(new Dict("","请选择"));
        reviewList.add(new Dict("0","不通过"));
        reviewList.add(new Dict("1","通过"));
        model.addAttribute("reviewList", reviewList);
        model.addAttribute("org", org);
        model.addAttribute("dogAppraisal", dogAppraisal);
        List<DogType> dogTypeList;
        if ("singleTypeClub".equals(org.getOrgType())) {
            dogTypeList = dogTypeService.findSingOrgDogTypeList(org.getId());
        } else {
            dogTypeList = dogTypeService.findFormalAndNBList();
        }
        model.addAttribute("dogTypeList", dogTypeList);
        model.addAttribute("dogColorMarkList", dogColorMarkService.findAllList());
        return "partner/dogAppraisal/dogAppraisalAddForm";
    }

    @RequestMapping(value = "add")
    public String add(DogAppraisal dogAppraisal, Model model, RedirectAttributes redirectAttributes) {
        if (!beanValidator(model, dogAppraisal)) {
            return addForm(dogAppraisal, model);
        }
        try {
            clubDogAppraisalService.add(dogAppraisal);
            addMessage(redirectAttributes, "录入犬只鉴定成功");
        } catch (Exception e) {
            addMessage(redirectAttributes, "录入犬只鉴定失败：" + e.getMessage());
        }
        return repage();
    }

    @RequestMapping(value = "payment")
    public String payment(DogAppraisal dogAppraisal, Model model, RedirectAttributes redirectAttributes) {
        dogAppraisal = clubDogAppraisalService.get(dogAppraisal);
        List<PaymentOrderDetail> detailList;
        if (StringUtils.isBlank(dogAppraisal.getRunningNumber())) {
            detailList = clubDogAppraisalService.buildOrder(dogAppraisal);
        } else {
            detailList = paymentOrderDetailDao.getOrderByRunningNum(dogAppraisal.getRunningNumber(), dogAppraisal.getDogOwnerCode());
        }
        PaymentOrder order = paymentOrderService.getByOrderCode(detailList.get(0).getOrderCode());
        model.addAttribute("orderId", order.getId());
        model.addAttribute("order", detailList);
        Org org = (Org) UserUtils.getSession().getAttribute("org");
        //重新查找  session域固定不变 所以需要重新查询 余额
        model.addAttribute("org", orgService.get(org.getId()));
        //跳转页面
        model.addAttribute("repage", repage());
        return "partner/sys/paymentPage";
    }

    @RequestMapping(value = "editForm")
    public String editForm(DogAppraisal dogAppraisal, Model model) {
        dogAppraisal = clubDogAppraisalService.get(dogAppraisal);
        model.addAttribute("dogAppraisal", dogAppraisal);
        model.addAttribute("dogTypeList", dogTypeService.findAllList());
        model.addAttribute("dogColorMarkList", dogColorMarkService.getByDogBreedCode(dogAppraisal.getDogBreed()));
        return "partner/dogAppraisal/dogAppraisalEditForm";
    }

    @RequestMapping(value = "edit")
    public String edit(DogAppraisal dogAppraisal, Model model, RedirectAttributes redirectAttributes) {
        if (!beanValidator(model, dogAppraisal)) {
            return editForm(dogAppraisal, model);
        }
        try {
            clubDogAppraisalService.edit(dogAppraisal);
            addMessage(redirectAttributes, "编辑犬只鉴定成功");
        } catch (Exception e) {
            addMessage(redirectAttributes, "编辑犬只鉴定失败：" + e.getMessage());
        }
        return repage();
    }

    @RequestMapping(value = "delete")
    public String delete(DogAppraisal dogAppraisal, RedirectAttributes redirectAttributes) {
        dogAppraisal = clubDogAppraisalService.get(dogAppraisal);
        try {
            dogAppraisalService.delete(dogAppraisal);
            addMessage(redirectAttributes, "删除犬只鉴定成功");
        } catch (Exception e) {
            addMessage(redirectAttributes, "删除犬只鉴定失败：" + e.getMessage());
        }
        return repage();
    }

    @RequestMapping(value = "resolve")
    public String resolve(DogAppraisal dogAppraisal, RedirectAttributes redirectAttributes) {
        addMessage(redirectAttributes, "处理犬只鉴定成功");
        try {
            dogAppraisalService.resolve(dogAppraisal);
        } catch (Exception e) {
            logger.warn("处理犬只鉴定失败：", e);
            addMessage(redirectAttributes, "处理犬只鉴定失败：" + e.getMessage());
        }
        return repage();
    }

    @RequestMapping(value = "print")
    public String print(DogAppraisal print, Model model) {
        return clubDogAppraisalService.print(print, model);
    }

    @RequestMapping(value = "resetPrint")
    public String resetPrint(DogAppraisal dogAppraisal, RedirectAttributes redirectAttributes) {
        dogAppraisalService.resetPrint(dogAppraisal);
        addMessage(redirectAttributes, "重置犬只鉴定打印成功");
        return repage();
    }

    @RequestMapping(value = "printDna")
    public String printDna(DogAppraisal dogAppraisal, Model model) {
        return clubDogAppraisalService.printDna(dogAppraisal, model);
    }

    @RequestMapping(value = "resetPrintDna")
    public String resetPrintDna(DogAppraisal dogAppraisal, RedirectAttributes redirectAttributes) {
        dogAppraisalService.resetPrintDna(dogAppraisal);
        addMessage(redirectAttributes, "重置犬只DNA鉴定打印成功");
        return repage();
    }

    /**
     * @Description： 跳转到列表页
     * @author: yuanshuai
     * @date: 2018/9/27 15:23
     */
    private String repage() {
        return "redirect:/partner/dog/appraisal/list?repage";
    }
}