package com.cku.partner.club.service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.clubdog.entity.ClubDog;
import com.cku.oa.clubdog.service.ClubDogService;
import com.cku.oa.dog.dao.DogAppraisalDao;
import com.cku.oa.dog.dao.DogBirthCertificateDao;
import com.cku.oa.dog.dao.DogChipChangeDao;
import com.cku.oa.dog.dao.DogPedigreeCertifiedChangeDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogActivation;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogBloodSave;
import com.cku.oa.dog.entity.DogChip;
import com.cku.oa.dog.entity.DogChipChange;
import com.cku.oa.dog.entity.DogColorMark;
import com.cku.oa.dog.entity.DogDnaArchive;
import com.cku.oa.dog.entity.DogDnaParentsCompare;
import com.cku.oa.dog.entity.DogNewborn;
import com.cku.oa.dog.entity.DogNose;
import com.cku.oa.dog.entity.DogPedigreeCertifiedChange;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.enums.DnaParentsCompareApplySourceEnum;
import com.cku.oa.dog.service.DogActivationService;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.dog.service.DogBloodSaveService;
import com.cku.oa.dog.service.DogChipChangeService;
import com.cku.oa.dog.service.DogChipService;
import com.cku.oa.dog.service.DogColorMarkService;
import com.cku.oa.dog.service.DogDnaArchiveService;
import com.cku.oa.dog.service.DogDnaParentsCompareService;
import com.cku.oa.dog.service.DogNewbornService;
import com.cku.oa.dog.service.DogNoseService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.finance.dao.PaymentOrderDao;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.kennel.dao.KennelDao;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.kennel.service.KennelService;
import com.cku.oa.sampling.enums.SamplingDogSourceTypeEnum;
import com.cku.oa.sys.badword.service.DemandSensitiveWordService;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.coupon.dao.SysCouponDao;
import com.cku.oa.sys.coupon.entity.SysCoupon;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.LoginServer;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.entity.OrgChip;
import com.cku.oa.sys.entity.user.KennelType;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.entity.user.MemberCardTypeEnum;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.service.OrgChipService;
import com.cku.oa.sys.service.OrgDogTypeLimitService;
import com.cku.oa.sys.service.OrgService;
import com.cku.oa.sys.service.RemindService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.oa.sys.util.PinYinUtil;
import com.cku.oa.sys.util.ValidateUtil;
import com.cku.restful.v1.dog.service.RestDogBirthCertificateService;
import com.cku.restful.v1.dog.service.RestDogChipService;
import com.cku.restful.v1.finance.service.RestOrderService;
import com.thinkgem.jeesite.common.utils.Collections3;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.modules.sys.dao.UserDao;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * user chaixueteng 2016年10月10日
 */
@Service
@Transactional(readOnly = true)
public class ClubMemberService {
	private static final String DOG_CHIP_FEE = "dog_chip_change@chipFee";
	@Autowired
	public MemberService memberService;
	@Autowired
	public DogDnaArchiveService dogDnaArchiveService;
	@Autowired
	public DogBloodSaveService dogBloodSaveService;
	@Autowired
	public DogChipChangeDao dogChipChangeDao;
	@Autowired
	public MemberDao memberDao;
	@Autowired
	public KennelService kennelService;
	@Autowired
	private UserDao userDao;
	@Autowired
	public RemindService remindService;
	@Autowired
	public KennelDao kennelDao;
	@Autowired
	private DogChipService dogChipService;
	@Autowired
	private DogNewbornService dogNewbornService;
	@Autowired
	private DogService dogService;
	@Autowired
	private DogChipChangeService dogChipChangeService;
	@Autowired
	private OrgChipService orgChipService;
	@Autowired
	private DogBirthCertificateService dogBirthCertificateService;
	@Autowired
	public DogAppraisalDao dogAppraisalDao;
	@Autowired
	public DogBirthCertificateDao dogBirthCertificateDao;
	@Autowired
	private DogPedigreeCertifiedChangeDao dogPedigreeCertifiedChangeDao;
	@Autowired
	private RestDogChipService restDogChipService;
	@Autowired
	private RestDogBirthCertificateService restDogBirthCertificateService;
	@Autowired
	private PaymentOrderDao paymentOrderDao;
	@Autowired
	private PaymentOrderDetailDao paymentOrderDetailDao;
	@Autowired
	private ClubDogService clubDogService;
	@Autowired
	private LoginServerService loginServerService;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private RestOrderService restOrderService;
	@Autowired
	private DogColorMarkService dogColorMarkService;
	@Autowired
	private ClubDogActivitionService clubDogActivitionService;
	@Autowired
	private DogActivationService dogActivationService;
	@Autowired
	private SysCouponDao sysCouponDao;
	@Autowired
	private OrgService orgService;
	@Autowired
	private PaymentService paymentService;
	@Autowired
	public OrgDogTypeLimitService orgDogTypeLimitService;
	@Autowired
	private PaymentOrderService paymentOrderService;
	@Autowired
	private DemandSensitiveWordService demandSensitiveWordService;
	@Autowired
	private DogNoseService dogNoseService;
	@Autowired
	private DogDnaParentsCompareService dogDnaParentsCompareService;

	/**
	 * 合作机构登记会员
	 *
	 * @Author chaixueteng
	 * @2016年10月10日下午2:52:17
	 */
	@Transactional(readOnly = false)
	public void save(Member member) {
		// 校验用户提交的数据，如果不合法，抛出异常
		if (!member.getGender().equals("male") && !member.getGender().equals("female")) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "用户的性别格式不正确");
		}
		if (!ValidateUtil.Mobile(member.getMobile())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "手机号格式不正确");
		}
		if (StringUtils.isNotBlank(member.getEmail()) && !ValidateUtil.Email(member.getEmail())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "邮箱格式不正确");
		}
		member.setSafeMobile(member.getMobile());
		// 保存用户的基本信息
		if (member.getIsNewRecord()) {
			// 校验身份证黑名单
			memberService.checkCardNoBlackList(member);
			member.preInsert();
			member.setNameEn(PinYinUtil.getFullSpell(member.getName()));
			member.setPaymentState("1"); // 未付费
			member.setMemberEndDate(null);
			member.setKuFlag(null);
			member.setKuEndDate(null);
			member.setGroomerEndDate(null);
			member.setDgMemberType(null);
			member.setDgEndDate(null);
			String memberCode = SysCodeUtil.getMemberCode();
			if (!StringUtils.isBlank(member.getMemberSite()) && !member.getMemberSite().equals("0")) {
				LoginServer loginServer = loginServerService.getLoginServerByMemberSite(member.getMemberSite());
				memberCode = loginServer.getUserShortName().toUpperCase() + memberCode;
			}
			member.setMemberCode(memberCode);
			member.setAccountBalance("0");
			member.setReviewState("0");
			member.setPrintState("0");
			if (MemberCardTypeEnum.PLATINUM_CARD.code().equals(member.getMemberCardType())
					|| MemberCardTypeEnum.PURPLE_CARD.code().equals(member.getMemberCardType())) {
				this.saveKennel(member);
			}
			Org org = (Org) UserUtils.getSession().getAttribute("org");
			if (org != null) {
				member.setReferee(org.getMemberCode());
				if ("singleTypeClub".equals(org.getOrgType())) {
					// 单犬种俱乐部新增的会员，单犬种机构自动填写为该机构
					member.setSingleClubId(org.getId());
				}
			}
			memberDao.insert(member);
			// 会员是否使用抵扣券
			useCoupon(member);
		} else {
			member.preUpdate();
			memberDao.update(member);
			// member进行更新时同步user表里的邮箱和手机
			User user = member.getUser();
			if (user != null) {
				user.setEmail(member.getEmail());
				user.setMobile(member.getMobile());
				userDao.updateEmailAndMobile(user);
			}
			// 会员是否使用抵扣券
			useCoupon(member);
		}
	}

	private SysCoupon useCoupon(Member member) {
		SysCoupon sysCoupon = null;
		if (StringUtils.isNotBlank(member.getCouponFlag()) && "1".equals(member.getCouponFlag())) {
			Org org = (Org) UserUtils.getSession().getAttribute("org");
			List<SysCoupon> couponList = sysCouponDao.getCouponList(org.getMemberCode(), "0", "member");
			if (CollectionUtils.isNotEmpty(couponList) && couponList.size() > 0) {
				SysCoupon coupon = sysCouponDao.get(couponList.get(0).getId());
				coupon.setTargetId(member.getId() + "&" + member.getMemberCode());
				coupon.setUseState("1");
				sysCouponDao.update(coupon);
				sysCoupon = coupon;
			} else {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您没有可用的优惠券");
			}
		}
		return sysCoupon;
	}

	public void validateBusiness(Kennel kennel, Member member) {
		if (kennelDao.getKennelByMemberCode(member.getMemberCode()) != null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您已经注册过犬舍，不能重复注册");
		}
		if (!MemberCardTypeEnum.PLATINUM_CARD.code().equals(member.getMemberCardType())
				&& !MemberCardTypeEnum.PURPLE_CARD.code().equals(member.getMemberCardType())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "只有专业会员才能申请注册犬舍");
		}
		if (!kennelService.nameCnCheck(kennel.getName(), member.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬舍名称不正确");
		}
		if (!kennelService.nameEnCheck(kennel.getNameEn(), Boolean.TRUE, member.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬舍英名称不正确");
		}
		if (!kennelService.nameEnCheck(kennel.getFciName(), Boolean.TRUE, member.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬舍FCI英名称不正确");
		}
		if (!kennelService.nameEnCheck(kennel.getFciNameBackup(), Boolean.FALSE, member.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬舍FCI备用英名称不正确");
		}
	}

	/**
	 * @Description： 保存犬舍
	 *
	 * @author: yuanshuai
	 * @date: 2018/7/27 14:40
	 */
	@Transactional(readOnly = false)
	public void saveKennel(Member member) {
		// 判断会员类型
		if (!(MemberCardTypeEnum.PLATINUM_CARD.code().equals(member.getMemberCardType())
				|| MemberCardTypeEnum.PURPLE_CARD.code().equals(member.getMemberCardType()))) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请先升级为繁育专业会员");
		}
		if (member.getKennel() == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬舍信息为空，无法保存");
		}
		// 业务校验
		validateBusiness(member.getKennel(), member);
		Kennel k = new Kennel();
		k.setKennelCode(member.getMemberCode());
		k.setMemberCode(member.getMemberCode());
		String name = member.getKennel().getName();
		if (!name.contains("犬舍")) {
			k.setName(name + "犬舍");
		} else {
			k.setName(member.getKennel().getName());
		}
		k.setNameEn(member.getKennel().getNameEn());
		k.setFciName(member.getKennel().getFciName());
		k.setFciNameBackup(member.getKennel().getFciNameBackup());
		k.setType(MemberCardTypeEnum.PLATINUM_CARD.code().toString().equals(member.getMemberCardType())
				? KennelType.year.toString()
				: KennelType.permanent.toString());
		k.setReviewState("0");
		k.setPrintState("0");
		k.setFciPrintState("0");
		k.setFciReviewState("0");
		k.setCalculationFlag("0");// 参与年度核算
		k.setCalculationState("0");// 新注册的都是待核算的
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String loginName = org.getName();
		k.setCreateByName(loginName);
		kennelService.save(k);
	}

	/**
	 * 逻辑删除未缴费的会员
	 *
	 * @Author chaixueteng
	 * @2016年10月11日下午3:44:48
	 */
	@Transactional(readOnly = false)
	public void delete(Member member) {
		Member dbMember = memberDao.get(member.getId());
		if (Objects.nonNull(dbMember) && StringUtils.isNoneBlank(dbMember.getUserId())) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "该会员已绑定登录账户，请联系管理员解绑关系后在删除！");
		}
		if (Objects.nonNull(dbMember) && Objects.nonNull(dbMember.getMemberEndDate())) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "已缴费会员无法删除！");
		}
		member.setRemarks("俱乐部删除会员未缴费：" + "[" + UserUtils.getUser().getId() + ":" + DateUtils.getDate() + "]");
		List<SysCoupon> couponList = sysCouponDao.getByTargetId(member.getId() + "&" + member.getMemberCode());
		if (!Collections3.isEmpty(couponList)) {
			SysCoupon coupon = couponList.get(0);
			coupon.setUseState("0");
			coupon.setTargetId("");
			coupon.preUpdate();
			sysCouponDao.update(coupon);
		}
		memberDao.deleteEnd(member);
	}

	/**
	 * 出生纸编号和识别码 查找新生犬信息
	 *
	 * @Author chaixueteng
	 * @2016年10月12日上午10:11:52
	 */
	public Map<String, String> searchChipMessage(String birthCode, String snCode) throws ZAException {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String loginName = org.getUser().getLoginName();
		Map<String, String> map = new HashMap<String, String>();
		DogChip dogChip = dogChipService.getByBirthCode(birthCode);
		DogBirthCertificate birth = dogBirthCertificateService.getByBirthCodeAndSnCode(birthCode, snCode);
		if (birth == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登记卡编号和识别码不匹配");
		}
		if (dogChip != null) {
			String addUser = birth.getAddUser().trim();
			if (StringUtils.isNotBlank(dogChip.getIsCanceled()) && "1".equals(dogChip.getIsCanceled().trim())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只已撤销！！！！");
			}
			if ("1".equals(dogChip.getPaymentState())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该新生犬只未缴费！！！！");
			}
			if ("0".equals(dogChip.getReviewState())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该新生犬只未审核！！！！");
			}
			if (StringUtils.isNotBlank(addUser)) {
				if (!addUser.equals(loginName)) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该新生犬只已预约其他机构！！！！");
				}
			}
			map.put("callName", dogChip.getCallName());
		}
		validBirth(birth);
		// 验证近亲
		DogNewborn dogNewborn = dogNewbornService.getBybreedCertifiedCode(birth.getFmdogBreedCertifiedCode());
		if ("1".equals(dogNewborn.getKinGetDna())) {
			// throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
			// "该犬为近亲繁殖犬只，需至CKU赛场取DNA存档后办理芯片证书业务！");
			map.put("dna", "1");
		} else {
			map.put("dna", "0");
		}
		// 芯片需无登记记录
		String identificationFlag = birth.getIdentificationFlag();
		if (StringUtils.isNotBlank(identificationFlag)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只已办理!");
		}
		// 犬只需不满一岁
		Date dogBirthday = birth.getDogBirthday();
		Calendar ca = Calendar.getInstance();// 得到一个Calendar的实例
		ca.setTime(new Date()); // 设置时间为当前时间
		ca.add(Calendar.YEAR, -2); // 年份减1
		ca.add(Calendar.DATE, -1); // 日期加1
		Date lastMonth = ca.getTime();
		ca.setTime(new Date()); // 设置时间为当前时间
		ca.add(Calendar.YEAR, -1);
		ca.add(Calendar.DATE, -1); // 日期加1
		Date oneYear = ca.getTime();
		if (dogBirthday.getTime() < lastMonth.getTime()) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只年龄已超过2岁，请联系CKU繁殖部办理此业务！！！");
		}
		if (dogBirthday.getTime() > lastMonth.getTime() && dogBirthday.getTime() < oneYear.getTime()) {
			map.put("dna", "1");
		} else {
			map.put("dna", "0");
		}
		Dog dog = dogService.getByPedigreeCertifiedCode(birth.getFdogPedigreeCertified().trim());
		Dog dog2 = dogService.getByPedigreeCertifiedCode(birth.getMdogPedigreeCertified().trim());
		if (dog != null && dog2 != null) {
			if (restDogBirthCertificateService.isDnaParentsCompare(dog.getId(), dog2.getId(),
					birth.getFmdogBreedCertifiedCode())) {
				map.put("parent", "1");
			} else {
				map.put("parent", "0");
			}
		} else {
			map.put("parent", "0");
		}
		if (dog != null) {
			map.put("fDogNameEn", dog.getNameEn());
		}
		if (dog2 != null) {
			map.put("mDogNameEn", dog2.getNameEn());
		}
		map.put("breedCnName", birth.getBreeder());
		map.put("pedigreeCertified", birth.getPedigreeCertified());
		map.put("birthCerRegCode", birth.getBirthCerRegCode());
		map.put("dogEnName", birth.getDogEnName());
		map.put("identificationFlag", birth.getIdentificationFlag());
		String birthday = DateUtils.formatDate(birth.getDogBirthday(), "yyyy-MM-dd");
		map.put("dogBirthday", birthday);
		map.put("fdogPedigreeCertified", birth.getFdogPedigreeCertified());
		map.put("mdogPedigreeCertified", birth.getMdogPedigreeCertified());
		map.put("sameBatchNum", birth.getSameBatchNum());
		map.put("gender", birth.getDogGender());
		map.put("printType", dogNewborn.getPrintType());
		map.put("colorFlag", birth.getColorFlag());
		DogType dogType = dogTypeService.getByDogBreedCode(birth.getDogBreed());
		map.put("dogBreedCnName", dogType == null ? "" : dogType.getBreedCnName());// 品种
		return map;
	}

	/**
	 * 校验出生纸信息
	 *
	 * @param birth
	 */
	private void validBirth(DogBirthCertificate birth) {
		String paymentState = birth.getPaymentState();
		String reviewState = birth.getReviewState();
		// String printType = birth.getPrintType();
		// if (!"9".equals(printType)) {
		// throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该出生纸未打印!!!");
		// }
		if (!"2".equals(paymentState)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该出生纸未缴费!!!");
		}
		if (!"1".equals(reviewState)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该出生纸审核未通过! ");
		}
		// 藏獒不能办理
		String dogBreed = birth.getDogBreed();
		if ("230".equals(dogBreed.trim())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "藏獒不能办理该业务!");
		}

	}

	/**
	 * 校验出生纸犬龄
	 *
	 * @param birth
	 */
	private void validBirthDay(DogBirthCertificate birth) {
		// 犬只需不满一岁
		Date dogBirthday = birth.getDogBirthday();
		Calendar ca = Calendar.getInstance();// 得到一个Calendar的实例
		ca.setTime(new Date()); // 设置时间为当前时间
		ca.add(Calendar.YEAR, -2); // 年份减1
		ca.add(Calendar.DATE, -1); // 日期加1
		Date lastMonth = ca.getTime();
		ca.setTime(new Date()); // 设置时间为当前时间
		ca.add(Calendar.YEAR, -1);
		ca.add(Calendar.DATE, -1); // 日期加1
		Date oneYear = ca.getTime();
		if (dogBirthday.getTime() < lastMonth.getTime()) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只年龄已超过2岁，请联系CKU繁殖部办理此业务！！！");
		}
	}

	/**
	 * 校验输入的芯片
	 *
	 * @Author chaixueteng
	 * @2016年10月12日下午3:55:54
	 */
	public void checkChip(String identificationFlag) throws ZAException {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String orgId = org.getId();
		DogBirthCertificate birth = dogBirthCertificateService.getByIdentificationFlag(identificationFlag);
		DogChipChange chipChange = dogChipChangeService.getByIdentificationFlag(identificationFlag);
		ClubDog dogClub = clubDogService.getByIdentificationFlag(identificationFlag);
		DogPedigreeCertifiedChange dogPedigreeCertifiedChange = dogPedigreeCertifiedChangeDao
				.getByDogChipCode(identificationFlag);
		if (birth != null || chipChange != null || dogPedigreeCertifiedChange != null || dogClub != null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该芯片已经在CKU注册!!");
		}
		OrgChip orgChip = orgChipService.getByOrgAndIdflag(orgId, identificationFlag);
		if (orgChip == null) {
			String tuijiansren = org.getTuijiansren();
			if (StringUtils.isNotBlank(tuijiansren)) {
				OrgChip forgChip = orgChipService.getByOrgAndIdflag(tuijiansren, identificationFlag);
				if (forgChip == null) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该芯片未在CKU备案，请使用俱乐部专用芯片！");
				}
			} else {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该芯片未在CKU备案，请使用俱乐部专用芯片！");
			}
		} else {
			String invalid = orgChip.getInvalid();
			if ("1".equals(invalid)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该芯片已申请作废，如有疑问请与协会联系！");
			}
		}
	}

	/**
	 * 新生犬芯片录入
	 *
	 * @Author chaixueteng
	 * @2016年10月14日下午3:27:04
	 */
	@Transactional(readOnly = false)
	public void add(String birthCerRegCode, String identificationFlag, String memberCode, String dna, String parent,
			String callName, String chipInject, String stickerFlag) {
		// 血样留存标记为已采血
		dogChipService.setBloodSaveFlag(birthCerRegCode);
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String loginName = org.getUser().getLoginName();
		if (StringUtils.isBlank(memberCode)) {
			throw new ZAException(-1, "新犬主会员号为空!");
		}
		Member member = memberService.getByMemberCode(memberCode);
		if (member != null && !MemberUtil.isActiveMember(member)) {
			throw new ZAException(-1, "新犬主会员无效！");
		} else if (member == null) {
			throw new ZAException(-1, "找到不到该会员号！");
		}
		// 出生纸信息变更
		DogBirthCertificate birth = dogBirthCertificateService.getByBirthCerRegCode(birthCerRegCode);
		Member member2 = memberService.getByMemberCode(birth.getMemberCode());
		if (member2 == null) {
			throw new ZAException(-1, "出生纸犬主会员号找不到！");

		}
		if (!((StringUtils.isBlank(member.getMemberSite()) && StringUtils.isBlank(member2.getMemberSite()))
				|| (member.getMemberSite() == null ? "" : member.getMemberSite()).equals(member2.getMemberSite()))) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "新犬主与申请人会员站点不同，不能进行新生犬登记");
		}
		if (StringUtils.isBlank(identificationFlag)) {
			throw new ZAException(-1, "芯片为空!");
		}
		birth.setIdentificationFlag(identificationFlag);
		if (StringUtils.isBlank(loginName)) {
			throw new ZAException(-1, "登录信息为空,请刷新浏览器!");
		}
		birth.setAddUser(loginName);
		birth.setChipInjectDate(new Date());// 芯片录入时间
		birth.setTempMemberCode(memberCode);
		birth.setTempUserName(member.getName());
		dogBirthCertificateService.updateByBirth(birth);
		// 芯片变更记录
		DogChipChange dogChipChange = new DogChipChange();
		PaymentChargingItem paymentChargingItem = restDogChipService.getChipItem();// 芯片钱
		// 修改配种证明表
		dogChipChange.preInsert();
		dogChipChange.setBirthCode(birthCerRegCode);
		dogChipChange.setChipCodeNew(identificationFlag);
		dogChipChange.setPaymentMemberCode(memberCode);
		dogChipChange.setPrice(paymentChargingItem.getPrice());
		dogChipChange.setReviewState("0");
		dogChipChange.setReviewTime(new Date());
		dogChipChange.setPaymentState("1");
		dogChipChange.setProcessState("0");
		dogChipChange.setOrganizationUsername(loginName);
		dogChipChange.setOperator(loginName + ":" + DateUtils.formatDate(new Date(), "yyyy-M-d"));
		dogChipChangeDao.insert(dogChipChange);
		// 生成其他记录
		if (parent == null) {
			parent = "0";
		}
		restDogChipService.clubPost(birth, dna, parent, dogChipChange.getId(), callName, chipInject, stickerFlag, null);
	}

	/**
	 * 双亲比对
	 *
	 * @param birthCode
	 * @param snCode
	 * @return
	 */
	public Map<String, String> parent(String birthCode, String snCode) {
		Map<String, String> map = new HashMap<String, String>();
		DogBirthCertificate birth = dogBirthCertificateService.getByBirthCodeAndSnCode(birthCode, snCode);
		if (birth == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登记卡编号和识别码不匹配");
		} else {
			Dog dog = dogService.getByPedigreeCertifiedCode(birth.getFdogPedigreeCertified());
			Dog dog2 = dogService.getByPedigreeCertifiedCode(birth.getMdogPedigreeCertified());
			if (restDogBirthCertificateService.isDnaParentsCompare(dog.getId(), dog2.getId(),
					birth.getFmdogBreedCertifiedCode())) {
				map.put("parent", "1");
			} else {
				map.put("parent", "0");
			}
		}
		return map;
	}

	/**
	 * 双亲比对(新的判断)
	 *
	 * @param birthCode
	 * @param chipCode
	 * @return
	 */
	public Map<String, String> chipParent(String birthCode, String chipCode) {
		Map<String, String> map = new HashMap<String, String>();
		DogBirthCertificate birth = dogBirthCertificateService.getByBirthCodeAndChipCode(birthCode, chipCode);
		if (birth == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登记卡编号和芯片号不匹配");
		} else {
			// Dog dog =
			// dogService.getByPedigreeCertifiedCode(birth.getFdogPedigreeCertified());
			// Dog dog2 =
			// dogService.getByPedigreeCertifiedCode(birth.getMdogPedigreeCertified());
			// if (restDogBirthCertificateService.isDnaParentsCompare(dog.getId(),
			// dog2.getId(),
			// birth.getFmdogBreedCertifiedCode())) {
			// map.put("parent", "1");
			// } else {
			// map.put("parent", "0");
			// }
			// 亲子比对显示条件
			Dog fdog = dogService.getByPedigreeCertifiedCode(birth.getFdogPedigreeCertified(), true);
			Dog mdog = dogService.getByPedigreeCertifiedCode(birth.getMdogPedigreeCertified(), true);
			// 是否显示亲子对比，返回true表示可以
			if (restDogBirthCertificateService.isDnaParentsCompareNewCheck(fdog.getId(), mdog.getId(),
					birth.getFmdogBreedCertifiedCode())) {
				map.put("parent", "1");
			} else {
				map.put("parent", "0");
			}
		}
		return map;
	}

	public Map<String, String> searchMessage(String birthCode, String chipCode) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String loginName = org.getUser().getLoginName();
		Map<String, String> map = new HashMap<String, String>();
		DogChip dogChip = dogChipService.getByBirthCode(birthCode);
		DogBirthCertificate birth = dogBirthCertificateService.getByBirthCodeAndChipCode(birthCode.trim(),
				chipCode.trim());
		if (birth == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登记卡编号和芯片号不匹配");
		}
		// 判断犬种是否有效
		if ("singleTypeClub".equals(org.getOrgType())
				&& !orgDogTypeLimitService.checkSingleOrgDogTypeCode(org.getId(), birth.getDogBreed())) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "俱乐部不经营此犬种，如有疑问，请联系CKU。");
		}
		if (StringUtils.isBlank(birth.getAddUser())) {
			checkOrgSite(org, birth.getDogBreed());
		}
		DogNewborn dogNewborn = dogNewbornService.getBybreedCertifiedCode(birth.getFmdogBreedCertifiedCode());
		if (dogChip != null) {// 预约过来的
			String addUser = birth.getAddUser();
			if (StringUtils.isNotBlank(dogChip.getIsCanceled()) && "1".equals(dogChip.getIsCanceled().trim())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只已撤销！！！！");
			}
			if ("1".equals(dogChip.getPaymentState())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该新生犬只未缴费！！！！");
			}
			if (StringUtils.isNotBlank(addUser)) {
				if (!addUser.equals(loginName)) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该新生犬未预约到本机构！！！！");
				}
			}
			map.put("callName", dogChip.getCallName());
			map.put("dna", dogChip.getDnaSaveWay());
			map.put("parent", dogChip.getIsDnaParentsCompare());
			// DNA位点方式是否为口腔上皮细胞
			if ("1".equals(dogChip.getDnaSaveWay())) {
				// DNA留存方式:血样留存0；DNA位点分析1；暂不留存2
				DogDnaArchive dogDnaArchive = dogDnaArchiveService.getByBirthCode(birthCode);
				if (dogDnaArchive != null) {
					map.put("isOEC", dogDnaArchive.getIsOEC());
					map.put("samplingCode", dogDnaArchive.getSamplingCode());
				}
			}
		} else {
			// 验证近亲
			validBirth(birth);
			if ("1".equals(dogNewborn.getKinGetDna())) {
				// throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
				// "该犬为近亲繁殖犬只，需至CKU赛场取DNA存档后办理芯片证书业务！");
				map.put("dna", "1");
			} else {
				map.put("dna", "2");
			}
			// 犬只需不满一岁
			Date dogBirthday = birth.getDogBirthday();
			Calendar ca = Calendar.getInstance();// 得到一个Calendar的实例
			ca.setTime(new Date()); // 设置时间为当前时间
			ca.add(Calendar.YEAR, -2); // 年份减1
			ca.add(Calendar.DATE, -1); // 日期加1
			Date lastMonth = ca.getTime();
			ca.setTime(new Date()); // 设置时间为当前时间
			ca.add(Calendar.YEAR, -1);
			ca.add(Calendar.DATE, -1); // 日期加1
			Date oneYear = ca.getTime();
			if (dogBirthday.getTime() < lastMonth.getTime()) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只年龄已超过2岁，请联系CKU繁殖部办理此业务！！！");
			}
			if ("1".equals(map.get("dna"))
					|| (dogBirthday.getTime() > lastMonth.getTime() && dogBirthday.getTime() < oneYear.getTime())) {
				map.put("dna", "1");
			} else {
				map.put("dna", "0");
			}
			// 冷冻精提交的配种整明需强制位点分析
			if ("1".equals(map.get("dna"))
					|| restDogBirthCertificateService.isDnaParentsCheck(birth.getFmdogBreedCertifiedCode())) {
				map.put("dna", "1");
			} else {
				map.put("dna", "2");
			}
			// 亲子比对显示条件
			Dog fdog = dogService.getByPedigreeCertifiedCode(birth.getFdogPedigreeCertified(), true);
			Dog mdog = dogService.getByPedigreeCertifiedCode(birth.getMdogPedigreeCertified(), true);
			// 是否显示亲子对比，返回true表示可以
			if (restDogBirthCertificateService.isDnaParentsCompareNewCheck(fdog.getId(), mdog.getId(),
					birth.getFmdogBreedCertifiedCode())) {
				map.put("parent", "1");
			} else {
				map.put("parent", "0");
			}
		}
		DogNose nose = dogNoseService.getByDogIdODogBirthCertificateId(birth.getId(), null);
		map.put("dogBreed", birth.getDogBreed());
		map.put("nose", nose == null ? "0" : "1");
		map.put("breedCnName", birth.getBreeder());
		map.put("birthCerRegCode", birth.getBirthCerRegCode());
		map.put("dogEnName", birth.getDogEnName());
		String birthday = DateUtils.formatDate(birth.getDogBirthday(), "yyyy-MM-dd");
		map.put("dogBirthday", birthday);
		map.put("sameBatchNum", birth.getSameBatchNum());
		map.put("gender", birth.getDogGender());
		map.put("printType", dogNewborn.getPrintType());
		map.put("colorFlag", birth.getColorFlag());
		DogType dogType = dogTypeService.getByDogBreedCode(birth.getDogBreed());
		map.put("dogBreedCnName", dogType == null ? "" : dogType.getBreedCnName());// 品种
		return map;
	}

	public void checkOrgSite(Org org, String dogBreed) {
		String orgSite = org.getOrgSite();
		try {
			if (new Date().getTime() >= new SimpleDateFormat("yyyy-MM-dd").parse("2021-01-01").getTime()) {
				if (StringUtils.isNotBlank(orgSite) && orgSite.equals("1") && dogBreed.equals("15C")) {
					throw new ZAException(ZAErrorCode.ZA_ERROR, "该合作机构无法办理玛犬业务");
				}
				if (StringUtils.isNotBlank(orgSite) && orgSite.equals("2") && !dogBreed.equals("15C")) {
					throw new ZAException(ZAErrorCode.ZA_ERROR, "该合作机构无法办理非玛犬业务");
				}
			}
		} catch (ParseException e) {
			e.printStackTrace();
		}
	}

	public Map<String, String> searchAllNestMessage(String birthCode, String snCode) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String loginName = org.getUser().getLoginName();
		Map<String, String> map = new HashMap<String, String>();
		DogBirthCertificate birth = dogBirthCertificateService.getByBirthCodeAndSnCode(birthCode, snCode);
		if (birth == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登记卡编号和授权码码不匹配");
		}
		DogChip dogChip = dogChipService.getByBirthCode(birthCode);
		DogNewborn dogNewborn = dogNewbornService.getBybreedCertifiedCode(birth.getFmdogBreedCertifiedCode());
		if (dogChip != null) {// 预约过来的
			String addUser = birth.getAddUser().trim();
			if (StringUtils.isNotBlank(dogChip.getIsCanceled()) && "1".equals(dogChip.getIsCanceled().trim())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只已撤销！！！！");
			}
			if ("1".equals(dogChip.getPaymentState())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该新生犬缴费！！！！");
			}
			if (StringUtils.isNotBlank(addUser)) {
				if (!addUser.equals(loginName)) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该新生犬未预约到本机构！！！！");
				}
			}
			map.put("callName", dogChip.getCallName());
			map.put("dna", dogChip.getDnaSaveWay());
			map.put("parent", dogChip.getIsDnaParentsCompare());
		}
		map.put("identificationFlag", birth.getIdentificationFlag());
		map.put("dogBreed", birth.getDogBreed());
		map.put("breedCnName", birth.getBreeder());
		map.put("birthCerRegCode", birth.getBirthCerRegCode());
		map.put("dogEnName", birth.getDogEnName());
		String birthday = DateUtils.formatDate(birth.getDogBirthday(), "yyyy-MM-dd");
		map.put("dogBirthday", birthday);
		map.put("sameBatchNum", birth.getSameBatchNum());
		map.put("gender", birth.getDogGender());
		map.put("printType", dogNewborn.getPrintType());
		map.put("colorFlag", birth.getColorFlag());
		DogType dogType = dogTypeService.getByDogBreedCode(birth.getDogBreed());
		map.put("dogBreedCnName", dogType == null ? "" : dogType.getBreedCnName());// 品种
		return map;
	}

	/**
	 * 未预约的新出生纸信息
	 *
	 * @param birthCode
	 * @param chipCode
	 * @param dna
	 * @param parent
	 * @param memberCode
	 * @param chipInject
	 */
	@Transactional(readOnly = false)
	public void addNew(String birthCode, String chipCode, String dna, String parent, String memberCode, String callName,
			String chipInject, String stickerFlag, String samplingCode) {
		// 血样留存标记为已采血
		dogChipService.setBloodSaveFlag(birthCode);
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String loginName = org.getUser().getLoginName();
		Member member = memberService.getByMemberCode(memberCode);
		if (member != null && !MemberUtil.isActiveMember(member)) {
			throw new ZAException(-1, "新犬主会员无效！");
		} else if (member == null) {
			throw new ZAException(-1, "找到不到该会员号！");
		}
		// 出生纸信息变更
		DogBirthCertificate birth = dogBirthCertificateService.getByBirthCerRegCode(birthCode);
		// 判断犬种是否有效
		if ("singleTypeClub".equals(org.getOrgType())
				&& !orgDogTypeLimitService.checkSingleOrgDogTypeCode(org.getId(), birth.getDogBreed())) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "俱乐部不经营此犬种，如有疑问，请联系CKU。");
		}
		if ("singleTypeClub".equals(org.getOrgType())) {
			// 繁育人
			Member breederMember = memberService.singleMember(birth.getBreederMemberCode(),
					org.getUser().getLoginName());
			// 新犬主
			Member singleMember = memberService.singleMember(memberCode, org.getUser().getLoginName());
			if (!(breederMember != null
					|| (StringUtils.isBlank(birth.getBreederMemberCode()) ? "" : birth.getBreederMemberCode())
							.equals(org.getAdminCode())
					|| singleMember != null || memberCode.equals(org.getAdminCode()))) {
				throw new ZAException(ZAErrorCode.ZA_ERROR, "不是该单犬种俱乐部名下登记会员，无法在该机构办理业务");
			}

		}
		// if("singleTypeClub".equals(org.getOrgType()) &&
		// !(memberCode.equals(org.getAdminCode()))) {
		// Member sigleMember = memberService.singleMember(memberCode,
		// org.getUser().getLoginName());
		// if(sigleMember == null) {
		// throw new ZAException(ZAErrorCode.ZA_ERROR, "不是该单犬种俱乐部名下登记会员，无法在该机构办理业务");
		// }
		// }

		Member member2 = memberService.getByMemberCode(birth.getMemberCode());
		if (!((StringUtils.isBlank(member.getMemberSite()) && StringUtils.isBlank(member2.getMemberSite()))
				|| (member.getMemberSite() == null ? "" : member.getMemberSite()).equals(member2.getMemberSite()))) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "新犬主与申请人会员站点不同，不能进行新生犬登记");
		}
		birth.setAddUser(loginName);
		birth.setTempMemberCode(member.getMemberCode());
		birth.setTempUserName(member.getName());
		dogBirthCertificateService.updateByBirth(birth);
		// 生成其他记录
		if (parent == null) {
			parent = "0";
		}
		DogChipChange byIdentificationFlag = dogChipChangeService.getByIdentificationFlag(chipCode);
		restDogChipService.clubPost(birth, dna, parent, byIdentificationFlag.getId(), callName, chipInject, stickerFlag,
				samplingCode);
	}

	/**
	 * 会员中心预约过来的就出生纸 办理
	 *
	 * @param birthCerRegCode
	 * @param identificationFlag
	 * @param chipInject
	 * @param model
	 */
	@Transactional(readOnly = false)
	public void addOldMemberCenter(String birthCerRegCode, String identificationFlag, String callName,
			String chipInject, Model model, String stickerFlag) {
		// 血样留存标记为已采血
		dogChipService.setBloodSaveFlag(birthCerRegCode);
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String loginName = org.getUser().getLoginName();
		// 校验芯片
		checkChip(identificationFlag);
		// 查询出生纸详情
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateService.getByBirthCerRegCode(birthCerRegCode);
		dogBirthCertificate.setIdentificationFlag(identificationFlag);
		dogBirthCertificate.setChipInjectDate(new Date());
		dogBirthCertificateService.save(dogBirthCertificate);
		// 新生犬登记详情
		DogChip dogChip = dogChipService.getByBirthCode(birthCerRegCode);
		// build 芯片变更表记录
		PaymentChargingItem paymentChargingItem = restDogChipService.getChipItem();// 芯片钱
		// 添加芯片变更记录
		DogChipChange dogChipChange = new DogChipChange();
		dogChipChange.setBirthCode(birthCerRegCode);
		dogChipChange.setChipCodeNew(identificationFlag);
		dogChipChange.setPaymentMemberCode(dogChip.getPaymentMemberCode());
		dogChipChange.setRunningNumber(dogChip.getRunningNumber());
		dogChipChange.setPrice(paymentChargingItem.getPrice());
		dogChipChange.setReviewState("1");
		dogChipChange.setReviewTime(new Date());
		dogChipChange.setPaymentState("2");
		dogChipChange.setPaymentTime(new Date());
		dogChipChange.setProcessState(null);
		dogChipChange.setProcessTime(null);
		dogChipChange.setOrganizationUsername(loginName);
		dogChipChange.setOperator(loginName + ":" + DateUtils.formatDate(new Date(), "yyyy-M-d"));
		dogChipChangeService.save(dogChipChange);
		dogChip.setDogChipChangeId(dogChipChange.getId());
		dogChip.setCallName(callName);// 地方俱乐部代打芯片
		// update by zjw 2023-02-07 工单号：ID1005116 取消宠爱护照发放
		// dogChip.setStickerFlag(stickerFlag);
		dogChip.setStickerFlag("0");
		if (!StringUtils.isBlank(chipInject) && "1".equals(chipInject)) {
			// dogChip.setChipInjectFlag(chipInject);
			bulidChipINjectOrder(dogChip, model);

		}
		dogChipService.save(dogChip);
		// 生成狗信息
		dogChipService.changeProcessState(dogChip);
	}

	/**
	 * 会员中心预约过来的新出生纸 办理(有芯片记录)
	 *
	 * @param birthCerRegCode
	 * @param identificationFlag
	 * @param chipInject
	 * @param model
	 */
	@Transactional(readOnly = false)
	public void addMemberCenter(String birthCerRegCode, String identificationFlag, String callName, String chipInject,
			Model model, String stickerFlag, String samplingCode) {

		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String loginName = org.getUser().getLoginName();
		DogChip dogChip = dogChipService.getByBirthCode(birthCerRegCode);

		// 合作机构办理，金质证书不在生成证书号
		if (validGoldenPedigreeCertified(dogChip.getBirthCode(), dogChip.getHaddleWay())) {
			throw new ZAException(ZAErrorCode.ZA_ERC_PARAM_ERROR, "暂不支持金质证书办理，请前往DNA留存进行采样包绑定");
		}
		// 添加芯片变更记录
		DogChipChange dogChipChange = dogChipChangeService.getByIdentificationFlag(identificationFlag);
		dogChipChange.setReviewState("1");
		dogChipChange.setReviewTime(new Date());
		dogChipChange.setOrganizationUsername(loginName);
		dogChipChange.setOperator(loginName + ":" + DateUtils.formatDate(new Date(), "yyyy-M-d"));
		dogChipChangeService.save(dogChipChange);
		// 生成狗信息
		dogChip.setDogChipChangeId(dogChipChange.getId());
		dogChip.setOperator(loginName + ":" + DateUtils.formatDate(new Date(), "yyyy-M-d"));
		dogChip.setCallName(callName);
		// ID1005285 yuanshuai 2023年4月20日15:47:48
		// 如果是血样留存或位点分析则标记为已采血
		if ("0".equals(dogChip.getDnaSaveWay()) || "1".equals(dogChip.getDnaSaveWay())) {
			dogChip.setBloodSaveFlag("1");
		}
		// update by zjw 2023-02-07 工单号：ID1005116 取消宠爱护照发放
		// dogChip.setStickerFlag(stickerFlag);
		dogChip.setStickerFlag("0");
		// 地方俱乐部代打芯片
		if (!StringUtils.isBlank(chipInject) && "1".equals(chipInject)) {
			bulidChipINjectOrder(dogChip, model);
		}
		dogChipService.save(dogChip);
		dogChipService.changeProcessState(dogChip);
		// 绑定采样包
		if ("1".equals(dogChip.getDnaSaveWay())) {
			// 绑定采样包
			dogDnaArchiveService.bindSamplingFront(birthCerRegCode, SamplingDogSourceTypeEnum.BIRTH_CODE, samplingCode,
					org.getMemberCode());
		}
	}

	/**
	 * 判断是否为预约俱乐部办理金质证书申请
	 */
	public boolean validGoldenPedigreeCertified(String birthCode, String haddleWay) {
		// 合作机构办理，金质证书不在生成证书号
		if (StringUtils.isNotEmpty(haddleWay) && "1".equals(haddleWay)) {
			DogDnaParentsCompare dnaParentsCompare = dogDnaParentsCompareService.getByBirthCode(birthCode);
			if (Objects.nonNull(dnaParentsCompare)
					&& !DnaParentsCompareApplySourceEnum.COMPARE.code().equals(dnaParentsCompare.getApplySource())) {
				return Boolean.TRUE;
			}
		}
		return Boolean.FALSE;
	}

	@Transactional(readOnly = false)
	public void addAllNestChip(String birthCerRegCode, String identificationFlag, String callName, String chipInject,
			Model model, String stickerFlag, String dna, String memberCode) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String loginName = org.getUser().getLoginName();
		// 血样留存标记为已采血
		if (!StringUtils.isBlank(dna) && "0".equals(dna)) {
			dogChipService.setBloodSaveFlag(birthCerRegCode);
		}
		DogBloodSave dogBloodSave = dogBloodSaveService.getByBirthCode(birthCerRegCode);
		if (dogBloodSave != null) {
			dogBloodSave.setOrgId(org.getId());
			dogBloodSave.setTypeYes("2");
			dogBloodSaveService.save(dogBloodSave);
		}
		DogChip dogChip = dogChipService.getByBirthCode(birthCerRegCode);
		DogChipChange dogChipChange = dogChipChangeService.getByIdentificationFlag(identificationFlag);
		// 添加芯片变更记录
		dogChipChange.setReviewState("1");
		dogChipChange.setReviewTime(new Date());
		dogChipChange.setOrganizationUsername(loginName);
		dogChipChange.setOperator(loginName + ":" + DateUtils.formatDate(new Date(), "yyyy-M-d"));
		dogChipChangeService.save(dogChipChange);
		// 生成狗信息
		dogChip.setDogChipChangeId(dogChipChange.getId());
		dogChip.setOperator(loginName + ":" + DateUtils.formatDate(new Date(), "yyyy-M-d"));
		dogChip.setCallName(callName);
		// update by zjw 2023-02-07 工单号：ID1005116 取消宠爱护照发放
//		dogChip.setStickerFlag(stickerFlag);
		dogChip.setStickerFlag("0");
		dogChip.setHospitalCode(org.getId());
		dogChip.setHospitalName(org.getName());
		// 地方俱乐部代打芯片
		if (!StringUtils.isBlank(chipInject) && "1".equals(chipInject)) {
			bulidChipINjectOrder(dogChip, model);
		}
		DogBirthCertificate birth = dogBirthCertificateService.getByBirthCerRegCode(birthCerRegCode);
		birth.setAddUser(loginName);
		Member member = memberDao.getByMemberCode(memberCode);
		birth.setTempMemberCode(member.getMemberCode());
		birth.setTempUserName(member.getName());
		Member member2 = memberService.getByMemberCode(birth.getMemberCode());
		if (!((StringUtils.isBlank(member.getMemberSite()) && StringUtils.isBlank(member2.getMemberSite()))
				|| (member.getMemberSite() == null ? "" : member.getMemberSite()).equals(member2.getMemberSite()))) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "新犬主与申请人会员站点不同，不能进行新生犬登记");
		}
		dogBirthCertificateService.update(birth);
		dogChipService.save(dogChip);
		dogChipService.changeProcessState(dogChip);
	}

	/**
	 * 芯片代打订单
	 *
	 * @param dogChip
	 * @param model
	 */
	public void bulidChipINjectOrder(DogChip dogChip, Model model) {
		// 设置订单基本字段
		PaymentOrder order = new PaymentOrder();
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		Member member = org.getMember();
		order.setMemberCode(dogChip.getPaymentMemberCode());
		order.setMemberName(memberService.getByMemberCode(dogChip.getPaymentMemberCode()).getName());
		order.setAddTime(new Date());
		order.setSource(member.getLoginType());
		order.setRemarks("登记卡编号：" + dogChip.getBirthCode());
		// 构造订单详情列表
		List<PaymentOrderDetail> list = new ArrayList<PaymentOrderDetail>();
		PaymentChargingItem item = restDogChipService.getChipInjectItem();
		PaymentOrderDetail detail = new PaymentOrderDetail();
		detail.setAddTime(order.getAddTime());
		detail.setProccessState("0");
		detail.setTotalPrice(item.getPrice());
		detail.setNum("1");
		detail.setPrice(item.getPrice());
		detail.setBusinessIds(dogChip.getId());
		detail.setBusinessTable("dog_chip");
		detail.setChargingItemId(item.getId());
		detail.setMemberCode(order.getMemberCode());
		detail.setMemberName(order.getMemberName());
		detail.setChargingItemName(item.getName());
		detail.setTotalPrice(item.getPrice());
		detail.setRemarks("登记卡编号：" + dogChip.getBirthCode());
		restOrderService.saveOrder(order, Double.parseDouble(detail.getTotalPrice()), order.getAddTime());
		list.add(detail);
		for (PaymentOrderDetail d : list) {
			d.setOrderCode(order.getOrderCode());
			d.preInsert();
			paymentOrderDetailDao.insert(d);
		}
	}

	/**
	 * 删除未缴费埋置信息的时候删除未缴费订单
	 *
	 * @param runningNumber
	 */
	@Transactional(readOnly = false)
	public void deleteUnPayOrder(String runningNumber) {
		PaymentOrder order = paymentOrderDao.getOrderByRunningNum(runningNumber);
		String memberCode = order.getMemberCode();
		List<PaymentOrderDetail> orderDetail = paymentOrderDetailDao.getOrderByRunningNum(runningNumber, memberCode);
		if ("1".equals(order.getPaymentState())) {
			paymentOrderDao.delete(order);
			for (PaymentOrderDetail paymentOrderDetail : orderDetail) {
				paymentOrderDetailDao.delete(paymentOrderDetail);
			}
		}
	}

	private void validateRefundState(DogChip po) {
		if (po == null)
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "血统证书申请记录不存在，无法操作");
		String businessIds = null;
		if ("1".equals(po.getIsAll())) {
			businessIds = po.getFmdogBreedCertifiedCode();
		} else {
			businessIds = po.getId();
		}
		boolean canCanceled = paymentOrderService.getCanCanceledByBusinessIdAOrderCode(businessIds,
				po.getRunningNumber());
		if (!canCanceled)
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "已申请退费业务，无法操作");
	}

	@Transactional(readOnly = false)
	public void saveMemberIdentificationFlag(String birthCode, String identificationFlag, String memberCode,
			String snCode, String callName, String classSticker, Model model) {
		if (StringUtils.isBlank(birthCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登记卡编号为空");
		}
		if (StringUtils.isBlank(identificationFlag)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "芯片号为空");
		}
		if (StringUtils.isBlank(memberCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "新犬主会员号为空");
		}
		if (StringUtils.isBlank(snCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "授权码为空");
		}
		// 验证犬只呼名
		if (StringUtils.isNotBlank(callName)) {
			demandSensitiveWordService.validCallName(callName);
		}
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateService.getByBirthCodeAndSnCode(birthCode, snCode);
		if (dogBirthCertificate == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登记卡编号和授权码不匹配");
		}
		Member member = memberService.getByMemberCode(memberCode);
		if (member == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "新犬主会员号有误");
		}
		if (!MemberUtil.isActiveMember(member)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该新犬主会员为无效会员");
		}
		Org org = (Org) UserUtils.getSession().getAttribute("org");

		// 判断是否为单犬种会员
		if ("singleTypeClub".equals(org.getOrgType())) {
			// 繁育人
			Member breederMember = memberService.singleMember(dogBirthCertificate.getBreederMemberCode(),
					org.getUser().getLoginName());
			// 新犬主
			Member singleMember = memberService.singleMember(memberCode, org.getUser().getLoginName());
			if (!(breederMember != null
					|| (StringUtils.isBlank(dogBirthCertificate.getBreederMemberCode()) ? ""
							: dogBirthCertificate.getBreederMemberCode()).equals(org.getAdminCode())
					|| singleMember != null || memberCode.equals(org.getAdminCode()))) {
				throw new ZAException(ZAErrorCode.ZA_ERROR, "不是该单犬种俱乐部名下登记会员，无法在该机构办理业务");
			}
		}
		// 单犬种查询会员
		// if ("singleTypeClub".equals(org.getOrgType()) &&
		// !(memberCode.equals(org.getAdminCode()))) {
		// Member sigleMember = memberService.singleMember(memberCode,
		// org.getUser().getLoginName());
		// if (sigleMember == null) {
		// throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
		// "不是该单犬种俱乐部名下登记会员，无法在该机构办理业务");
		// }
		// }

		Member member2 = memberService.getByMemberCode(dogBirthCertificate.getMemberCode());
		if (!((StringUtils.isBlank(member.getMemberSite()) && StringUtils.isBlank(member2.getMemberSite()))
				|| (member.getMemberSite() == null ? "" : member.getMemberSite()).equals(member2.getMemberSite()))) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "新犬主与申请人会员站点不同，不能进行新生犬登记");
		}
		// 校验退费状态
		this.validateRefundState(dogChipService.getByBirthCode(birthCode));
		// 校验芯片
		if (!identificationFlag.equals(dogBirthCertificate.getIdentificationFlag())) {
			checkChip(identificationFlag);
		}
		boolean canInputIdentificationFlag = dogBirthCertificateService
				.isCanInputIdentificationFlag(dogBirthCertificate);
		if (canInputIdentificationFlag) {
			dogBirthCertificateService.insertDogChipChange(dogBirthCertificate, identificationFlag);
		}
		dogBirthCertificate.setIdentificationFlag(identificationFlag);
		dogBirthCertificate.setMemberCode(memberCode);
		dogBirthCertificate.setDogOwenr(member.getName());
		dogBirthCertificate.setTempMemberCode(memberCode);
		dogBirthCertificate.setTempUserName(member.getName());
		// 生成护照号
		Map<String, String> cabCode = cabCode = dogBirthCertificateService.createCabCode(dogBirthCertificate.getId(),
				identificationFlag);
		dogBirthCertificate.setCabPassport(cabCode.get("cabPassport"));
		dogBirthCertificate.setCabRegisterCode(cabCode.get("cabRegisterCode"));
		dogBirthCertificateService.validateIdentificationFlagAndCabPassport(dogBirthCertificate);
		// 保存信息
		dogBirthCertificate.preUpdate();
		dogBirthCertificateService.save(dogBirthCertificate);
		// 毛色、犬种
		DogType dogType = dogTypeService.getByDogBreedCode(dogBirthCertificate.getDogBreed());
		String dogBreedCnName = dogType == null ? "" : dogType.getBreedCnName();
		dogBirthCertificate.setDogBreedCnName(dogBreedCnName);
		DogColorMark dogColorMark = dogColorMarkService.getByDogColorMarkCode(dogBirthCertificate.getColorFlag());
		if (dogColorMark != null) {
			String colorFlag = dogColorMark.getDogColorMarkCn();
			if (colorFlag != null) {
				dogBirthCertificate.setColorFlag(colorFlag.substring(colorFlag.indexOf("-") + 1));
			}
		}
		// 生成血统证书
		DogChip dogChip = dogChipService.getByBirthCode(birthCode);
		// update by zjw 2023-02-07 工单号：ID1005116 取消宠爱护照发放
		dogChip.setStickerFlag("0");
		String stickerFlag = dogChip.getStickerFlag();
		// 整窝申请、俱乐部办理血统证书可以申请P级贴纸
//		if (StringUtils.isNotBlank(dogChip.getIsAll()) && "1".equals(dogChip.getIsAll())) {
//			stickerFlag = classSticker;
//		}
		addMemberCenter(birthCode, dogBirthCertificate.getIdentificationFlag(), callName, dogChip.getChipInjectFlag(),
				model, stickerFlag, null);

	}

	@Transactional(readOnly = false)
	public void saveAllNest(String frontPic, String sidePic, String backPic, String birthCode, Model model)
			throws Exception {
		if (StringUtils.isBlank(frontPic)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请上传犬只正面照!");
		}
		if (StringUtils.isBlank(sidePic)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请上传犬只侧面照!");
		}
		if (StringUtils.isBlank(backPic)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请上传犬只背面照!");
		}
		DogBirthCertificate birthCertificate = dogBirthCertificateService.getByBirthCerRegCode(birthCode.trim());
		if (birthCertificate == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "查询的登记卡编号有误!");
		}
		DogActivation dogActivation = dogActivationService.getByBirthCode(birthCode.trim());
		if (dogActivation != null && "0".equals(dogActivation.getDelFlag())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只已经办理过激活!");
		}
		// 保存激活数据
		dogActivation = clubDogActivitionService.buildDogActivation(frontPic, sidePic, backPic, birthCertificate);
		dogActivation.setPaymentState("2");
		dogActivation.setReviewState("1");
		dogActivationService.save(dogActivation);
		// 更新出生纸表的激活状态
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateService
				.getByBirthCerRegCode(dogActivation.getBirthCode());
		dogBirthCertificate.setActivitionState("1");
		dogBirthCertificateService.save(dogBirthCertificate);
		model.addAttribute("birthCode", birthCode);
		model.addAttribute("breederMemberCode", dogBirthCertificate.getBreederMemberCode());

	}

	public Map<String, String> getMemberMessage(String memberCodeMobile) {
		Map<String, String> map = new HashMap<String, String>();
		Member member = memberService.getByMobileOrMemberCode(memberCodeMobile);
		Org org = (Org) UserUtils.getSession().getAttribute("org");

		if (member == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员编号/手机号有误!");
		}
		if (StringUtils.isNotBlank(member.getMemberType()) && member.getMemberType().equals("foreign")) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "外籍会员不支持该业务!");
		}
//		if (member.getMemberEndDate() == null && StringUtils.isNotBlank(member.getRegistrant())
//				&& member.getRegistrant().equals(org.getUser().getLoginName())
//				&& new Date().getTime() <= DateUtils.parseDate(DateUtils.get1MonthLater(member.getMemberEndDate())).getTime()) {
//			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "俱乐部会员请直接续费!");
//		}
		// if (member.getMemberEndDate() != null && member.getMemberEndDate().getTime()
		// >= new Date().getTime()) {
		// throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员没有过期、请直接续费!");
		// }
		if (StringUtils.isNotBlank(member.getMemberSite())
				&& (member.getMemberSite().equals("4") || member.getMemberSite().equals("6"))) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "杜高/马犬会员不支持该业务!");
		}
		map.put("name", member.getName());
		map.put("id", member.getId());
		map.put("memberCode", member.getMemberCode());
		map.put("memberType", DictUtils.getDictLabel(member.getMemberType(), "user_member_type", ""));
		map.put("memberCardTypeLabel", DictUtils.getDictLabel(member.getMemberCardType(), "member_card_type", ""));
		map.put("memberEndDate",
				member.getMemberEndDate() == null ? null : DateUtils.formatDate(member.getMemberEndDate()));
		map.put("mobile", member.getMobile());
		map.put("address", member.getProvince() + member.getCity());
		map.put("safeMobile", member.getSafeMobile());
		return map;
	}

	@Transactional(readOnly = false)
	public String saveMemberCaptcha(Member member, Model model) {

		Org org = (Org) UserUtils.getSession().getAttribute("org");
		if ("1".equals(member.getCouponFlag())) {
			boolean flag = false;
			Date memberEndDate = member.getMemberEndDate();
			if ("singleTypeClub".equals(org.getOrgType())) {
				if (memberEndDate == null) {
					flag = true;
				}
				if (member.getRegistrant().equals(org.getUser().getLoginName())) {
					flag = true;
				} else {
					if (memberEndDate != null && new Date().getTime() > DateUtils
							.parseDate(DateUtils.get1MonthLater(memberEndDate)).getTime()) {
						flag = true;
					}
				}
			}
			if (!flag) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "此会员不能使用优惠券！");
			}
		}
		// 会员是否使用抵扣券
		SysCoupon sysCoupon = useCoupon(member);
		List<PaymentCart> carts = paymentService.toCart(member.getMemberCode(), org.getId(),
				sysCoupon != null ? sysCoupon.getId() : null);
		PaymentOrder paymentOrder = new PaymentOrder();
		paymentOrder.setMemberCode(carts.get(0).getMemberCode());
		paymentOrder.setMemberName(carts.get(0).getMemberName());
		List<PaymentOrderDetail> list = paymentService.cartToOrder(carts, paymentOrder);
		String orderCode = list.get(0).getOrderCode();
		PaymentOrder paymentOrder2 = paymentOrderDao.getOrderByRunningNum(orderCode);
		if (sysCoupon != null) {
			// 优惠券增加记录订单号，会员号，不然删除订单无法恢复优惠券
			sysCoupon.setRunningNumber(orderCode);
			sysCoupon.setTargetId(sysCoupon.getTargetId().split("&")[0] + "&" + orderCode);
			sysCouponDao.update(sysCoupon);
			List<PaymentOrderDetail> flist = list.stream().filter(a -> "sys_coupon".equals(a.getBusinessTable()))
					.collect(Collectors.toList());
			if (flist != null && flist.size() > 0) {
				flist.get(0).setBusinessIds(sysCoupon.getTargetId());
				paymentOrderDetailDao.update(flist.get(0));
			}
		}
		// 重新查找 session域固定不变 所以需要重新查询 余额
		String id = org.getId();
		Org org2 = orgService.get(id);
		model.addAttribute("order", list);
		model.addAttribute("org", org2);
		model.addAttribute("orderId", paymentOrder2.getId());
		return "partner/sys/paymentPage";
	}

	public Map<String, String> searchDogChipMessage(String birthCode, String snCode) {
		Map<String, String> map = new HashMap<String, String>();
		DogBirthCertificate birth = dogBirthCertificateService.findByBirthCodeAndSnCode(birthCode, snCode);
		if (birth == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登记卡编号和授权码/芯片号不匹配");
		}
		if (StringUtils.isNotBlank(birth.getIsAll()) && !"1".equals(birth.getIsAll())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只不是整窝办理，无法办理该业务");
		}
		if (StringUtils.isNotBlank(birth.getPedigreeCertified())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只已办理过血统证书");
		}
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		checkOrgSite(org, birth.getDogBreed());
		Long time = null;
		try {
			time = new SimpleDateFormat("yyyy-MM-dd").parse("2020-07-08").getTime();
		} catch (ParseException e) {
			System.out.println("整窝办理新旧业务记录格式化时间出错");
		}
		if (birth.getCreateDate().getTime() < time) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该申请功能仅限2020年7月8日以后申请的整窝办理犬只办理");
		}
		if (StringUtils.isBlank(birth.getIdentificationFlag())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只尚未绑定芯片信息，请等待协会绑定芯片后再次申请");
		}

		if (StringUtils.isNotBlank(birth.getReviewState()) && !"1".equals(birth.getReviewState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该登记卡尚未审核，无法办理该业务");
		}
		DogNose nose = dogNoseService.getByDogIdODogBirthCertificateId(birth.getId(), null);
		// if(nose == null){
		// throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只鼻纹未登记，请至APP完成鼻纹采集");
		// }
		DogChip dogChip = dogChipService.getByBirthCode(birthCode);
		if (dogChip != null) {// 预约过来的
			if (StringUtils.isNotBlank(dogChip.getIsCanceled()) && "1".equals(dogChip.getIsCanceled().trim())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只已撤销！！！！");
			}
			if ("1".equals(dogChip.getPaymentState())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该新生犬只未缴费！！！！");
			}
			map.put("dna", dogChip.getDnaSaveWay());
		} else {
			map.put("dna", "2");
		}
		map.put("dogBreed", birth.getDogBreed());
		map.put("nose", nose == null ? "0" : "1");
		map.put("breedCnName", birth.getBreeder());
		map.put("identificationFlag", birth.getIdentificationFlag());
		map.put("birthCerRegCode", birth.getBirthCerRegCode());
		map.put("dogEnName", birth.getDogEnName());
		String birthday = DateUtils.formatDate(birth.getDogBirthday(), "yyyy-MM-dd");
		map.put("dogBirthday", birthday);
		map.put("sameBatchNum", birth.getSameBatchNum());
		map.put("gender", birth.getDogGender());
		map.put("colorFlag", birth.getColorFlag());
		DogType dogType = dogTypeService.getByDogBreedCode(birth.getDogBreed());
		map.put("dogBreedCnName", dogType == null ? "" : dogType.getBreedCnName());// 品种
		return map;
	}
}
