package com.cku.oa.sys.zalog;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;

/**
 * Created with IntelliJ IDEA.
 * User: lyy
 * Date: 2016/7/6
 * Time: 14:50
 */
public class SysFailConfirmState implements SysState {

    @Override
    public void createOrder(SysContext ckuContext, String info,String memberCode,String tableName,String businessId,String runningNumber,  SysConsumer<String, ZAException> consumer) throws ZAException {
        throw new ZAException(ZAErrorCode.ZA_ERC_FAILCONFIRM_STATE,"当前处于审核不通过状态，无法进行此操作！");
    }
    @Override
    public void payment(SysContext ckuContext, String info,String memberCode,String tableName,String businessId,String runningNumber,  SysConsumer<String, ZAException> consumer) throws ZAException {
        throw new ZAException(ZAErrorCode.ZA_ERC_FAILCONFIRM_STATE,"当前处于审核不通过状态，无法进行此操作！");
    }

    @Override
    public void cancelApply(SysContext ckuContext, String info,String memberCode,String tableName,String businessId,String runningNumber,  SysConsumer<String, ZAException> consumer) throws ZAException {
        throw new ZAException(ZAErrorCode.ZA_ERC_FAILCONFIRM_STATE,"当前处于审核不通过状态，无法进行此操作！");
    }

    @Override
    public void confirmSuccess(SysContext ckuContext, String info,String memberCode,String tableName,String businessId,String runningNumber,  SysConsumer<String, ZAException> consumer) throws ZAException {
        throw new ZAException(ZAErrorCode.ZA_ERC_FAILCONFIRM_STATE,"当前处于审核不通过状态，无法进行此操作！");
    }

    @Override
    public void confirmFail(SysContext ckuContext, String info,String errorInfo,String memberCode,String tableName,String businessId,String runningNumber,  SysConsumer<String, ZAException> consumer) throws ZAException {
        throw new ZAException(ZAErrorCode.ZA_ERC_FAILCONFIRM_STATE,"当前处于审核不通过状态，无法进行此操作！");
    }

    @Override
    public void updateInfo(SysContext ckuContext, String info,String memberCode,String tableName,String businessId,String runningNumber,  SysConsumer<String, ZAException> consumer) throws ZAException {
        try {
            consumer.accept(info);
            ckuContext.setSysState(new SysFinishPayoutState());
            ckuContext.setNowState(SysNowState.FinishPayout);
            ckuContext.getSysZaLog().setSuccessInfo(info+"修改信息成功！");
            ckuContext.getSysZaLog().setMemberCode(memberCode);
            ckuContext.getSysZaLog().setTableName(tableName);
            ckuContext.getSysZaLog().setBusinessId(businessId);
            ckuContext.getSysZaLog().setRunningNumber(runningNumber);
            ckuContext.zaLogDao.insert(ckuContext.getSysZaLog());
        } catch (ZAException ze) {
            ckuContext.getSysZaLog().setErrorInfo(info+"修改信息失败："+"错误代码："+ze.get_code()+"。错误信息："+ze.getMessage());
            ckuContext.zaLogDao.insert(ckuContext.getSysZaLog());
            throw ze;
        }
    }

    @Override
    public void updateData(SysContext ckuContext, String info,String memberCode,String tableName,String businessId,String runningNumber,  SysConsumer<String, ZAException> consumer) throws ZAException {
        throw new ZAException(ZAErrorCode.ZA_ERC_FAILCONFIRM_STATE,"当前处于审核不通过状态，无法进行此操作！");
    }

    @Override
    public void offlineRefund(SysContext ckuContext, String info,String memberCode,String tableName,String businessId,String runningNumber,  SysConsumer<String, ZAException> consumer) throws ZAException {
        try {
            consumer.accept(info);
            ckuContext.setSysState(new SysEndState());
            ckuContext.setNowState(SysNowState.End);
            ckuContext.getSysZaLog().setSuccessInfo(info+"线下退款成功！");
            ckuContext.getSysZaLog().setMemberCode(memberCode);
            ckuContext.getSysZaLog().setTableName(tableName);
            ckuContext.getSysZaLog().setBusinessId(businessId);
            ckuContext.getSysZaLog().setRunningNumber(runningNumber);
            ckuContext.zaLogDao.insert(ckuContext.getSysZaLog());
        } catch (ZAException ze) {
            ckuContext.getSysZaLog().setErrorInfo(info+"线下退款失败："+"错误代码："+ze.get_code()+"。错误信息："+ze.getMessage());
            ckuContext.zaLogDao.insert(ckuContext.getSysZaLog());
            throw ze;
        }
    }
    @Override
    public void noStateExecute(SysContext ckuContext, String info,String memberCode,String tableName,String businessId,String runningNumber,  SysConsumer<String,ZAException> consumer) throws ZAException{
        throw new ZAException(ZAErrorCode.ZA_ERC_FAILCONFIRM_STATE,"当前处于审核不通过状态，无法进行此操作！");
    }
}
