package com.cku.oa.sys.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.sys.entity.NoseprintSwitchSettingLog;
import com.cku.oa.sys.service.NoseprintSwitchSettingLogService;

/**
 * 鼻纹开关设置记录表Controller
 * @author Sunny
 * @version 2021-06-02
 */
@Controller
@RequestMapping(value = "${adminPath}/sys/noseprintSwitchSettingLog")
public class NoseprintSwitchSettingLogController extends BaseController {

	@Autowired
	private NoseprintSwitchSettingLogService noseprintSwitchSettingLogService;
	
	@ModelAttribute
	public NoseprintSwitchSettingLog get(@RequestParam(required=false) String id) {
		NoseprintSwitchSettingLog entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = noseprintSwitchSettingLogService.get(id);
		}
		if (entity == null){
			entity = new NoseprintSwitchSettingLog();
		}
		return entity;
	}
	
	@RequiresPermissions("sys:noseprintSwitchSettingLog:view")
	@RequestMapping(value = {"list", ""})
	public String list(NoseprintSwitchSettingLog noseprintSwitchSettingLog, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<NoseprintSwitchSettingLog> page = noseprintSwitchSettingLogService.findPage(new Page<NoseprintSwitchSettingLog>(request, response), noseprintSwitchSettingLog); 
		model.addAttribute("page", page);
		return "oa/sys/noseprintSwitchSettingLogList";
	}

	@RequiresPermissions("sys:noseprintSwitchSettingLog:view")
	@RequestMapping(value = "form")
	public String form(NoseprintSwitchSettingLog noseprintSwitchSettingLog, Model model) {
		model.addAttribute("noseprintSwitchSettingLog", noseprintSwitchSettingLog);
		return "oa/sys/noseprintSwitchSettingLogForm";
	}

	@RequiresPermissions("sys:noseprintSwitchSettingLog:edit")
	@RequestMapping(value = "save")
	public String save(NoseprintSwitchSettingLog noseprintSwitchSettingLog, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, noseprintSwitchSettingLog)){
			return form(noseprintSwitchSettingLog, model);
		}
		noseprintSwitchSettingLogService.save(noseprintSwitchSettingLog);
		addMessage(redirectAttributes, "保存鼻纹开关设置记录表成功");
		return "redirect:"+Global.getAdminPath()+"/sys/noseprintSwitchSettingLog/?repage";
	}
	
	@RequiresPermissions("sys:noseprintSwitchSettingLog:edit")
	@RequestMapping(value = "delete")
	public String delete(NoseprintSwitchSettingLog noseprintSwitchSettingLog, RedirectAttributes redirectAttributes) {
		noseprintSwitchSettingLogService.delete(noseprintSwitchSettingLog);
		addMessage(redirectAttributes, "删除鼻纹开关设置记录表成功");
		return "redirect:"+Global.getAdminPath()+"/sys/noseprintSwitchSettingLog/?repage";
	}

}