package com.cku.oa.sys.web;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;

import org.apache.commons.collections.CollectionUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.alibaba.fastjson.JSONObject;
import com.cku.oa.dog.entity.DogDnaArchiveReissueSampling;
import com.cku.oa.dog.service.DogDnaArchiveReissueSamplingService;
import com.cku.oa.finance.service.PaymentOrderRefundService;
import com.cku.oa.sampling.entity.Sampling;
import com.cku.oa.sampling.service.SamplingService;
import com.cku.oa.sfexpress.entity.RouteResponse;
import com.cku.oa.sfexpress.entity.SfExpressState;
import com.cku.oa.sfexpress.entity.SfExpressStateVo;
import com.cku.oa.sfexpress.service.SfExpressStateService;
import com.cku.oa.sys.entity.ExpressQueue;
import com.cku.oa.sys.entity.ExpressSend;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.ExpressQueueCommonService;
import com.cku.oa.sys.service.ExpressQueueService;
import com.cku.oa.sys.service.ExpressSendService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.FnsUtils;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import edu.emory.mathcs.backport.java.util.Arrays;

/**
 * 邮寄发件Controller
 *
 * @author fanhuibin
 * @version 2016-09-01
 */
@Controller
@RequestMapping(value = "${adminPath}/sys/expressSend")
public class ExpressSendController extends BaseController {

	@Autowired
	private ExpressSendService expressSendService;
	@Autowired
	private ExpressQueueService expressQueueService;
	@Autowired
	private MemberService memberService;
	@Autowired
	private SfExpressStateService sfExpressStateService;
	@Autowired
	private SamplingService samplingService;
	@Autowired
	private DogDnaArchiveReissueSamplingService reissueSamplingService;
	@Autowired
	private PaymentOrderRefundService paymentOrderRefundService;
	@Autowired
	private ExpressQueueCommonService expressQueueCommonService;	

	/**
	 * 4625f60e8ac44d37b23ce2d972d1b532 DNA样本检测服务费（口腔上皮细胞）
	 * 56444644f3a64d1b96e53236a85e1948 纯种犬DNA样本检测服务费（口腔上皮细胞）
	 * 42486b62a04f40da8ae269c3efa142d2 纯种犬DNA样本重复检测服务费（口腔上皮细胞）
	 * 24fed019e8c64b7789cfa56a856f81c7 DNA检测采样包(补寄)
	 * 4df8d3ef339a4ea8b6f1167894567eea 纯种犬DNA样本检测服务费（口腔上皮细胞）优惠
	 */
	public final static List<String> SAMPLING_CHARGING_ITEM_IDS = Arrays
			.asList(new String[] { "56444644f3a64d1b96e53236a85e1948", "42486b62a04f40da8ae269c3efa142d2",
					"24fed019e8c64b7789cfa56a856f81c7","4df8d3ef339a4ea8b6f1167894567eea","4625f60e8ac44d37b23ce2d972d1b532" });

	@ModelAttribute
	public ExpressSend get(@RequestParam(required = false) String id) {
		ExpressSend entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = expressSendService.get(id);
		}
		if (entity == null) {
			entity = new ExpressSend();
		}
		return entity;
	}

	@RequiresPermissions("sys:expressSend:view")
	@RequestMapping(value = { "list", "" })
	public String list(ExpressSend expressSend, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<ExpressSend> page = expressSendService.findPage(new Page<ExpressSend>(request, response), expressSend);
		model.addAttribute("page", page);
		return "oa/sys/expressSendList";
	}

	@RequiresPermissions("sys:expressSend:view")
	@RequestMapping(value = "form")
	public String form(ExpressSend expressSend, Model model, HttpServletRequest request, HttpServletResponse response) {
		String ids = request.getParameter("queueIds");

		// 查询该用户所有的待邮寄物品
		List<ExpressQueue> list = new ArrayList<ExpressQueue>();
		if(StringUtils.isNotBlank(expressSend.getMemberCode())) {
			ExpressQueue queue = new ExpressQueue();
			queue.setMemberCode(expressSend.getMemberCode());
			list = expressQueueService.findList(queue);
		}
		/*
		 * 使用list.remove会导致list.size发生改变 极易导致数据判断不足 for(int i =0;i<list.size();i++){
		 * ExpressQueue eQ = list.get(i); if(ids!=null&&!ids.contains(eQ.getId())){
		 * list.remove(i); } }
		 */
		// start by 柴雪腾 使用迭代器循环排除不符合条件的
		for (Iterator<ExpressQueue> it = list.iterator(); it.hasNext();) {
			ExpressQueue eQ = it.next();
			if (ids != null && !ids.contains(eQ.getId())) {
				it.remove();
			}
		}
		// end by 柴雪腾 使用迭代器循环排除不符合条件的
		if (ids == null) {
			list = new ArrayList<ExpressQueue>();
		}
		// 采样包如果父母犬不同意不展示在邮寄页面
		list = expressQueueCommonService.filterList(list);

		List<String> delEQIdList = new ArrayList<>();
		if (list.size() > 0) {
			list.forEach(es -> {
				if (SAMPLING_CHARGING_ITEM_IDS.contains(es.getChargeItemId())
						&& paymentOrderRefundService.validOrderIsRefundingOrRefunded(es.getRunningNumber())) {
					delEQIdList.add(es.getId());
				}
			});
			if (CollectionUtils.isNotEmpty(delEQIdList)) {
				list = list.stream().filter(es -> !delEQIdList.contains(es.getId())).collect(Collectors.toList());
			}
		}

		if (list.size() > 0) {
			ExpressQueue eQ = list.get(0);
			expressSend.setMemberName(eQ.getMemberName());
			expressSend.setPostcode(eQ.getPostcode());

			// expressSend.setAddress(eQ.getProvince()+eQ.getCity()+eQ.getStreet());
			expressSend.setPhone(eQ.getPhone());
			expressSend.setReceiver(eQ.getReceiver());
			expressSend.setExpressType("2");

			if (list.stream().anyMatch(e -> SAMPLING_CHARGING_ITEM_IDS.contains(e.getChargeItemId()))) {
				model.addAttribute("showSampling", Boolean.TRUE);
				model.addAttribute("usableSamplingList", FnsUtils.getSamplingUnuseList());
			}

			list.forEach(e -> {
				e.setSamplingFlag(Boolean.FALSE);
				e.setReissueSamplingFlag(Boolean.FALSE);
				if (SAMPLING_CHARGING_ITEM_IDS.contains(e.getChargeItemId())) {
					if ("dog_dna_archive_reissue_sampling".equals(e.getBusinessTable())) {
						DogDnaArchiveReissueSampling reissueSampling = reissueSamplingService.get(e.getBusinessId());
						e.setReissueSamplingCode(reissueSampling.getSamplingCode());
						e.setReissueSamplingFlag(Boolean.TRUE);
					} else if (SAMPLING_CHARGING_ITEM_IDS.contains(e.getChargeItemId())) {
						e.setSamplingFlag(Boolean.TRUE);
					}
				}

			});
		}
		model.addAttribute("expressQueue", list);
		model.addAttribute("province", UserUtils.getProvince());

		// 查询用户的最近一次邮寄的方式与邮寄的时间
		if (expressSend.getMemberCode() != null) {
			ExpressSend ex = new ExpressSend();
			ex.setMemberCode(expressSend.getMemberCode());
			Page<ExpressSend> p = new Page<ExpressSend>(request, response);
			p.setPageSize(1);
			Page<ExpressSend> recent = expressSendService.findPage(p, ex);
			if (recent.getList().size() > 0) {
				ex = recent.getList().get(0);
				String recentSend = "最近一次的邮寄 <br/>方式：";
				if (ex.getExpressType() != null) {
					if ("1".equals(ex.getExpressType())) {
						recentSend += "到付快递";
					} else if ("2".equals(ex.getExpressType())) {
						recentSend += "月付快递-CKU付费";
					} else if ("3".equals(ex.getExpressType())) {
						recentSend += "挂号信";
					} else if ("4".equals(ex.getExpressType())) {
						recentSend += "自取";
					} else {
						recentSend += ex.getExpressType();
					}
				}
				if (ex.getExpressName() != null) {
					recentSend += " <br/>快递：" + DictUtils.getDictLabel(ex.getExpressName(), "express_name", "");
					;
				}
				if (ex.getPostDate() != null) {
					SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
					recentSend += " <br/>时间：" + format.format(ex.getPostDate());
				}
				model.addAttribute("recentSend", recentSend);
			} else {
				model.addAttribute("recentSend", "该会员没有邮寄记录");
			}

			Member member = memberService.getByMemberCode(expressSend.getMemberCode());
			if (!StringUtils.isEmpty(member.getDeliveryCertified())) {
				model.addAttribute("delivery", "证书默认邮寄方式:" + member.getDeliveryCertified());
			} else {
				model.addAttribute("delivery", "证书默认邮寄方式:" + "顺丰到付快递");
			}

			expressSend.setPhone(member.getMobile());
			expressSend.setAddress(member.getStreet());

			expressSend.setProvince(member.getProvince());
			expressSend.setCity(member.getCity());
			expressSend.setArea(member.getArea());
			model.addAttribute("city", UserUtils.getCityByProvince(expressSend.getProvince()));
		}
		// 会员的默认邮寄方式
		model.addAttribute("postType", "");
		if (StringUtils.isEmpty(expressSend.getSender())) {
			expressSend.setSender("1");
		}
		model.addAttribute("expressSend", expressSend);
		if (StringUtils.isNotEmpty(expressSend.getExpressNo())) {
			model.addAttribute("expressDetail", JSONObject.toJSONString(getExpressState(expressSend.getExpressNo())));
		}
		if (expressSend.getPostDate() == null) {
			expressSend.setPostDate(new Date());
		}
		return "oa/sys/expressSendForm";
	}

	private List<SfExpressStateVo> getExpressState(String expressNo) {
		SfExpressState sfExpressState = new SfExpressState();
		sfExpressState.setOrderNo(expressNo);
		List<SfExpressStateVo> stateList = sfExpressStateService.findStateList(sfExpressState);
		for (SfExpressStateVo vo : stateList) {
			vo.setNetcode(vo.getNetcode() == null ? "" : vo.getNetcode());
		}
		return stateList;
	}

	@RequiresPermissions("sys:expressSend:view")
	@RequestMapping(value = "editForm")
	public String editForm(ExpressSend expressSend, Model model, HttpServletRequest request,
			HttpServletResponse response) {
		// 查询该用户所有的待邮寄物品
		ExpressQueue queue = new ExpressQueue();
		queue.setMemberCode(expressSend.getMemberCode());
		List<ExpressQueue> list = expressQueueService.findList(queue);
		queue.setExpressSendId(expressSend.getId());
		List<ExpressQueue> selected = expressQueueService.findList(queue);

		selected.addAll(list);

		if (selected.stream().anyMatch(e -> SAMPLING_CHARGING_ITEM_IDS.contains(e.getChargeItemId()))) {
			model.addAttribute("showSampling", Boolean.TRUE);
			List<Sampling> samplingList = FnsUtils.getSamplingUnuseList();
			if (StringUtils.isNotBlank(expressSend.getContentValue())) {
				List<Sampling> bindSamplingList = samplingService
						.findListBySamplingCodeList(Arrays.asList(expressSend.getContentValue().split(",")));
				samplingList.addAll(0, bindSamplingList);
			}
			model.addAttribute("usableSamplingList", samplingList);
		}
		selected.forEach(e -> {
			e.setSamplingFlag(Boolean.FALSE);
			e.setReissueSamplingFlag(Boolean.FALSE);
			if ("dog_dna_archive_reissue_sampling".equals(e.getBusinessTable())) {
				DogDnaArchiveReissueSampling reissueSampling = reissueSamplingService.get(e.getBusinessId());
				e.setReissueSamplingCode(reissueSampling.getSamplingCode());
				e.setReissueSamplingFlag(Boolean.TRUE);
			} else if (SAMPLING_CHARGING_ITEM_IDS.contains(e.getChargeItemId())) {
				e.setSamplingFlag(Boolean.TRUE);
			}
		});

		if (StringUtils.isEmpty(expressSend.getProvince())) {
			Member member = memberService.getByMemberCode(expressSend.getMemberCode());
			model.addAttribute("mobile", member.getMobile());
			// model.addAttribute("address",
			// member.getProvince()+member.getCity()+member.getStreet());
			model.addAttribute("address", member.getStreet());
			expressSend.setProvince(member.getProvince());
			expressSend.setCity(member.getCity());
			expressSend.setArea(member.getArea());
		}

		model.addAttribute("province", UserUtils.getProvince());
		model.addAttribute("city", UserUtils.getCityByProvince(expressSend.getProvince()));
		model.addAttribute("expressQueue", selected);

		ExpressSend temp = expressSendService.get(expressSend.getId());
		if (StringUtils.isEmpty(temp.getSender())) {
			expressSend.setSender("1");
		} else {
			expressSend.setSender(temp.getSender());
		}

		model.addAttribute("expressSend", expressSend);

		if (StringUtils.isNotEmpty(expressSend.getExpressNo())) {
			model.addAttribute("expressDetail", JSONObject.toJSONString(getExpressState(expressSend.getExpressNo())));
		}
		if (expressSend.getPostDate() == null) {
			expressSend.setPostDate(new Date());
		}

		model.addAttribute("expressNo", temp.getExpressNo());

		return "oa/sys/expressEditForm";
	}

	@RequiresPermissions("sys:expressSend:view")
	@RequestMapping(value = "save")
	public String save(ExpressSend expressSend, Model model, RedirectAttributes redirectAttributes,
			HttpServletRequest request, HttpServletResponse response) throws Exception {
		boolean hasPermission = false;
		if (StringUtils.isEmpty(expressSend.getId())) {
			hasPermission = SecurityUtils.getSubject().isPermitted("sys:expressSend:add");
		} else {
			hasPermission = SecurityUtils.getSubject().isPermitted("sys:expressSend:edit");
		}
		if (!hasPermission) {
			throw new AuthorizationException("用户权限不足");
		}
		if (!beanValidator(model, expressSend)) {
			return form(expressSend, model, request, response);
		}

		if (expressSendService.saveExpress(expressSend, request)) {
			addMessage(redirectAttributes, "保存邮寄发件成功");
		} else {
			addMessage(redirectAttributes, "保存邮寄发件失败");
		}

		return "redirect:" + Global.getAdminPath() + "/sys/expressSend/list";
	}

	@RequiresPermissions("sys:expressSend:delete")
	@RequestMapping(value = "delete")
	public String delete(ExpressSend expressSend, RedirectAttributes redirectAttributes) throws JAXBException {
		expressSendService.delete(expressSend);
		addMessage(redirectAttributes, "删除邮寄发件成功");
		return "redirect:" + Global.getAdminPath() + "/sys/expressSend/?repage";
	}

	/**
	 * 顺丰到付快递-打印
	 *
	 * @Author chaixueteng
	 * @2016年9月2日下午4:08:57
	 */
	@RequiresPermissions("sys:expressSend:print")
	@RequestMapping(value = "expressSendPrint")
	public String expressSendPrint(ExpressSend expressSend, Model model) {
		expressSendService.print(expressSend);
		model.addAttribute("expressSend", expressSend);
		return "oa/sys/expressSendPrintSF";
	}

	@RequiresPermissions("sys:expressSend:print")
	@RequestMapping(value = "expressSendPrintNew")
	public String expressSendPrintNew(ExpressSend expressSend, Model model) {
		expressSendService.print(expressSend);
		model.addAttribute("expressSend", expressSend);
		return "oa/sys/expressSendPrintSFNew";
	}

	@RequiresPermissions("sys:expressSend:print")
	@RequestMapping(value = "expressSendPrintSf")
	public String expressSendPrintSf(ExpressSend expressSend, Model model, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		expressSendService.print(expressSend);
		String imgStr = expressSendService.printWaybillsNew(expressSend, request, response);
		model.addAttribute("imgStr", imgStr);
		return "oa/sys/sfPrintPage";
	}

	/**
	 * 申通到付快递-打印
	 *
	 * @Author chaixueteng
	 * @2016年9月2日下午4:08:57
	 */
	@RequiresPermissions("sys:expressSend:print")
	@RequestMapping(value = "expressPrint")
	public String expressPrint(ExpressSend expressSend, Model model) {
		expressSendService.print(expressSend);
		model.addAttribute("expressSend", expressSend);
		return "oa/sys/expressSendPrintST";
	}

	/**
	 * 重置打印
	 *
	 * @Author chaixueteng
	 * @2016年9月28日下午4:08:26
	 */
	@RequiresPermissions("sys:expressSend:print")
	@RequestMapping(value = "restPrint")
	public String restPrint(String id) {
		expressSendService.restPrint(id);
		return "redirect:" + Global.getAdminPath() + "/sys/expressSend/?repage";
	}

	@RequestMapping(value = { "searchSFRoute" })
	public String searchSFRoute(String orderId, HttpServletRequest request, HttpServletResponse response, Model model)
			throws Exception {
		RouteResponse routeResponse = expressSendService.searchSFRouteNew(orderId);
		model.addAttribute("route", routeResponse);
		return "oa/sys/sfRoute";
	}

	@RequestMapping(value = { "reviewSfBill" })
	public String reviewSfBill(String id, HttpServletRequest request, HttpServletResponse response, Model model)
			throws Exception {
		ExpressSend expressSend = this.get(id);
		String imgStr = expressSendService.printWaybillsNew(expressSend, request, response);
		model.addAttribute("imgStr", imgStr);
		return "oa/sys/reviewSfBill";
	}

	/**
	 * 重置打印
	 *
	 * @Author chaixueteng
	 * @2016年9月28日下午4:08:26
	 */
	@RequestMapping(value = "searchOne")
	@ResponseBody
	public Object searchOne(String memberCode, HttpServletRequest request, HttpServletResponse response) {
		Map<String, String> map = new HashMap<String, String>();
		ExpressSend ex = new ExpressSend();
		ex.setMemberCode(memberCode);
		Page<ExpressSend> p = new Page<ExpressSend>(request, response);
		p.setPageSize(1);
		Page<ExpressSend> recent = expressSendService.findPage(p, ex);
		if (recent.getList().size() > 0) {
			ex = recent.getList().get(0);
			String recentSend = "最近一次的邮寄 <br/>方式：";
			if (ex.getExpressType() != null) {
				if ("1".equals(ex.getExpressType())) {
					recentSend += "到付快递";
				} else if ("2".equals(ex.getExpressType())) {
					recentSend += "月付快递-CKU付费";
				} else if ("3".equals(ex.getExpressType())) {
					recentSend += "挂号信";
				} else if ("4".equals(ex.getExpressType())) {
					recentSend += "自取";
				} else {
					recentSend += ex.getExpressType();
				}
			}
			if (ex.getExpressName() != null) {
				recentSend += " <br/>快递：" + DictUtils.getDictLabel(ex.getExpressName(), "express_name", "");
				;
			}
			if (ex.getPostDate() != null) {
				SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				recentSend += " <br/>时间：" + format.format(ex.getPostDate());
			}
			map.put("recentSend", recentSend);
		} else {
			map.put("recentSend", "该会员没有邮寄记录");
		}

		Member member = memberService.getByMemberCode(memberCode);
		if (!StringUtils.isEmpty(member.getDeliveryCertified())) {
			map.put("delivery", "证书默认邮寄方式:" + member.getDeliveryCertified());
		} else {
		}
		return map;
	}
}