package com.cku.oa.sys.service;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.sys.entity.NoseprintSwitchSettingLog;
import com.cku.oa.sys.dao.NoseprintSwitchSettingLogDao;

/**
 * 鼻纹开关设置记录表Service
 * @author Sunny
 * @version 2021-06-02
 */
@Service
@Transactional(readOnly = true)
public class NoseprintSwitchSettingLogService extends CrudService<NoseprintSwitchSettingLogDao, NoseprintSwitchSettingLog> {

	public NoseprintSwitchSettingLog get(String id) {
		return super.get(id);
	}
	
	public List<NoseprintSwitchSettingLog> findList(NoseprintSwitchSettingLog noseprintSwitchSettingLog) {
		return super.findList(noseprintSwitchSettingLog);
	}
	
	public Page<NoseprintSwitchSettingLog> findPage(Page<NoseprintSwitchSettingLog> page, NoseprintSwitchSettingLog noseprintSwitchSettingLog) {
		return super.findPage(page, noseprintSwitchSettingLog);
	}
	
	@Transactional(readOnly = false)
	public void save(NoseprintSwitchSettingLog noseprintSwitchSettingLog) {
		super.save(noseprintSwitchSettingLog);
	}
	
	@Transactional(readOnly = false)
	public void delete(NoseprintSwitchSettingLog noseprintSwitchSettingLog) {
		super.delete(noseprintSwitchSettingLog);
	}
	
}