package com.cku.oa.sys.service;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.oa.dog.service.DogDnaParentsCompareAuditService;
import com.cku.oa.sys.dao.ExpressQueueDao;
import com.cku.oa.sys.entity.ExpressQueue;

@Service
@Transactional(readOnly = true)
public class ExpressQueueCommonService {

	@Autowired
	private DogDnaParentsCompareAuditService dogDnaParentsCompareAuditService;

	@Autowired
	private ExpressQueueDao expressQueueDao;

	/**
	 * 待邮寄物品过滤采样包父母未同意采样的部分
	 * 
	 * @param list
	 * @return
	 */
	public List<ExpressQueue> filterList(List<ExpressQueue> list) {
		List<String> orderCodes = list.stream().filter(a -> a.getItemName().contains("采样包"))
				.map(a -> a.getRunningNumber()).collect(Collectors.toList());

		Map<String, Boolean> map = dogDnaParentsCompareAuditService.cherkByOrderCodesToMap(orderCodes);
		list = list.stream().filter(a -> {
			return Objects.isNull(map.get(a.getRunningNumber())) ? true : map.get(a.getRunningNumber());
		}).collect(Collectors.toList());

		return list;
	}

	/**
	 * 待邮寄物品业务验证
	 * 
	 * @param ids
	 * @return
	 */
	public Boolean cherkBusinessByIds(List<String> ids) {
		List<ExpressQueue> list = expressQueueDao.getByIds(ids);
		// 待邮寄的采样包如果涉及双亲对比，需取得父母犬同意
		List<String> orderCodes = list.stream().filter(a -> a.getItemName().contains("采样包"))
				.map(a -> a.getRunningNumber()).collect(Collectors.toList());
		dogDnaParentsCompareAuditService.cherkByOrderCodes(orderCodes);
		return Boolean.TRUE;
	}

}