package com.cku.oa.sys.service;

import java.util.HashMap;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.utils.SendMailUtil;
import com.thinkgem.jeesite.modules.sys.entity.User;

/**
 * 邮件提醒服务
 * @author fanhuibin
 * @version 2016-08-11
 */
@Service
@Transactional(readOnly = true)
public class EmailRemindService  {

	@Autowired
	private LoginServerService loginServerService;

	/**
	 * 帐号激活邮件
	 * @param to 收件人邮箱号
	 * @param user 收件人的登录帐号
	 * @param key 帐号激活需要的token
	 */
	public void RegisteMail(User user){
		Map<String,Object> map = new HashMap<String,Object>();
		map.put("user", user);
		String url = Global.getConfig("email.regist.url") + "?loginName=" + user.getLoginName()
				+ "&type=" + user.getUserType() + "&ticket=" + user.getTicket();
		map.put("url", url);
		SendMailUtil.sendFtlMail(user.getEmail(), "CKU帐号激活", "mailtemplate/active.ftl", map);
	}

	/**
	 * 密码找回邮件
	 */
	public void ChangePasswordMail(User user,String ticket){
		Map<String,Object> map = new HashMap<>();
		map.put("user", user);
		String shortName = loginServerService.getShortNameByUserType(user.getUserType());
		String url = Global.getConfig("email.password.url").replace("uc", shortName)
				+ "?loginName=" + user.getLoginName() + "&type=" + user.getUserType() + "&ticket=" + ticket;
		map.put("url",url);
		SendMailUtil.sendFtlMail(user.getEmail(), "CKU帐号密码修改", "mailtemplate/changePassword.ftl", map);
	}

	public static void main(String args[]){
		//测试代码
		EmailRemindService r = new EmailRemindService();
		User user = new User();
		user.setName("张三");
		user.setLoginName("sdfsdf");
		user.setUserType("perfession");
		user.setTicket("sdf");
		user.setMailType("dc");
		user.setEmail("445461184@qq.com");
		r.ChangePasswordMail(user, "xxx");
		r.RegisteMail(user);
	}

}