package com.cku.oa.sys.interceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import com.cku.restful.v1.sys.utils.CkuInterfaceUtil;
import com.cku.util.MD5Generator;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import net.sf.json.JSONObject;

/**
 * 安全拦截器 1.用户是否登录，是否是会员的判断 2.用户
 *
 * @author fanhuibin
 */
public class LoginInterceptor implements HandlerInterceptor {
	private Logger logger = LoggerFactory.getLogger(LoginInterceptor.class);

	@Override
	public void afterCompletion(HttpServletRequest arg0, HttpServletResponse arg1, Object arg2, Exception arg3)
			throws Exception {

	}

	@Override
	public void postHandle(HttpServletRequest arg0, HttpServletResponse arg1, Object arg2, ModelAndView arg3)
			throws Exception {

	}

	/**
	 * cku的接口拦截器
	 */
	@Override
	public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object arg2) throws Exception {
		// 判断用户的url，登录接口不做访问限制。
		if (request.getRequestURI().startsWith(request.getContextPath() + "/api/v1/open/")) {
			// openURL下的接口为开放接口不做登录限制

			// String ip = IPLimitUtil.getIpAddr(request);
			// ipAddressService.addIpAddress(ip);
			return true;
		}
		
		// 审核员活动报名-列表
		if (request.getRequestURI().startsWith(request.getContextPath() + "/api/v1/handler/examiner/list")) {
			return true;
		}
		// 牵犬活动报名-列表
		else if (request.getRequestURI().startsWith(request.getContextPath() + "/api/v1/handler/handlerShow")) {
			return true;
		// 训犬活动报名列表
		}else if (request.getRequestURI().startsWith(request.getContextPath() + "/app/v1/handler/show/getHandlerShowList")) {
			return true;
		// 美容活动报名-列表
		}else if (request.getRequestURI().startsWith(request.getContextPath() + "/api/v1/open/groomer/groomerShow")) {
			return true;
		}else if (request.getRequestURI().startsWith(request.getContextPath() + "/api/v1/dog/dogcolormark/")) {
			return true;
		} else if (request.getRequestURI().startsWith( // TODO 暂时不拦截
				request.getContextPath() + "/api/v1/dog/dogtype/")) {
			return true;
		}else if (request.getRequestURI().startsWith( // TODO 暂时不拦截
				request.getContextPath() + "/api/v1/dog/dnablood/")) {
			return true;
		} else if (request.getRequestURI().startsWith(request.getContextPath() + "/api/v1/file/")) {
			return true;
		} else if (request.getRequestURI().startsWith(
				// 俱乐部查询订单详情
				request.getContextPath() + "/api/v1/finance/order")) {
			return true;
		} else if (request.getRequestURI().startsWith(
				// 俱乐部取消订单
				request.getContextPath() + "/api/v1/finance/order/cab")) {
			return true;
		} else if (request.getRequestURI().startsWith(
				// 俱乐部取消订单
				request.getContextPath() + "/api/v1/dict")) {
			return true;
		} else if (request.getRequestURI().startsWith(
				// 俱乐部取消订单
				request.getContextPath() + "/api/v1/person")) {
			return true;
		}else if (request.getRequestURI().startsWith(
				// 俱乐部取消订单
				request.getContextPath() + "/api/v1/export")) {
			return true;
		} else if (request.getRequestURI().startsWith(request.getContextPath() + "/api/v1/coupon")
				|| request.getRequestURI().startsWith(request.getContextPath() + "/api/v1/gift")) {
			return true;
		} else if (request.getRequestURI().startsWith(request.getContextPath() + "/cku/v1")) {
			// 查询犬只基本信息的接口开放
			if (request.getRequestURI().equals(request.getContextPath() + "/cku/v1/dog")) {
				return true;
			}
			// start by 柴雪腾 2017-03-15 查询赛事裁判的接口开放,提供给官网查询赛事裁判用
			if (request.getRequestURI().startsWith(request.getContextPath() + "/cku/v1/shows/showJudge")) {
				return true;
			}
			// start by 柴雪腾 2017-07-26 微信对接小能
			if (request.getRequestURI().startsWith(request.getContextPath() + "/cku/v1/customer")) {
				return true;
			}
			// end by 柴雪腾
			// start by 崔怀宇 2018-01-22 查询赛事积分的接口开放,提供给官网查询赛事积分用
			if (request.getRequestURI().startsWith(request.getContextPath() + "/cku/v1/shows/getShowScore")) {
				return true;
			}
			// end by 崔怀宇
			// start by 崔怀宇 2018-03-22 宠爱王国保险查询犬只信息
			if (request.getRequestURI().equals(request.getContextPath() + "/cku/v1/dog/getByInsIdentificationFlag")) {
				return true;
			}
			// end by 王洁
			// start by 王洁 2018-5-9 宠爱王国保险查询犬只信息
			if (request.getRequestURI()
					.equals(request.getContextPath() + "/cku/v1/dog/getByInsIdentificationFlagWhenInsert")) {
				return true;
			}

			if (request.getRequestURI().equals(request.getContextPath() + "/cku/v1/kennel/get")) {
				return true;
			}
			// start by liuyueyang 2018-12-18 宠爱王国保险查询Member信息
			if (request.getRequestURI().equals(request.getContextPath() + "/cku/v1/member/getInfoByCode")) {
				String token = request.getParameter("token");
				String memberCode = request.getParameter("memberCode");
				String newToken = MD5Generator.generate16("INSURANCE_" + memberCode);
				if (token.equals(newToken))
					return true;
			}
			// start by zhangxaing 2020-08-19 app人才页
			if (request.getRequestURI().equals(request.getContextPath() + "/cku/v1/personnel")) {
				return true;
			}

			// end by liuyueyang
			// cku下的接口为给cku提供，认证方式单独处理
			return CkuInterfaceUtil.handle(request, response);
		} else if (request.getRequestURI().startsWith(request.getContextPath() + "/cku/v2")) {
			// 查询犬只基本信息的接口开放
			if (request.getRequestURI().equals(request.getContextPath() + "/cku/v2/dog")) {
				return true;
			}
			// cku下的接口为给cku提供，认证方式单独处理
			return CkuInterfaceUtil.handleV2(request, response);
		} else if (request.getRequestURI().startsWith(request.getContextPath() + "/ckumc")) {
			// 对接www.ckumc.org.cn系统的信息查询接口
			return CkuInterfaceUtil.handleMC(request, response);
		}
		// 判断用户的登录信息
		String token = request.getParameter("token");
		// 判断是否存在token参数，若存在则放行请求
		if (StringUtils.isNotBlank(token)) {
			return true;
		}
		//token不为空即放行，这次不做改动，还是依赖于在代码中拿用户的时候做有效性判断。因为有持有俱乐部token的请求进入该拦截器，如APP俱乐部采鼻纹
		User user = UserUtils.getLoginUser();
		if (user == null || user.getId() == null) {
			response.setHeader("Content-type", "application/json;charset=UTF-8");
			response.setStatus(401);
			return false;
		}
		if (user.getUserType().equals("2") || user.getUserType().equals("3") || user.getUserType().equals("4")
				|| user.getUserType().equals("6")) {
			JSONObject object = new JSONObject();
			object.put("remoteAddr", StringUtils.getRemoteAddr(request));
			object.put("user-agent", request.getHeader("user-agent"));
			object.put("requestURI", request.getRequestURI());
			object.put("params", request.getParameterMap());
			object.put("method", request.getMethod());
			logger.debug(object.toString());// 打印登录日志
			// 会员中心登录判断，未绑定手机禁止进行其他操作 by yuanshuai 2017.12.20
			// 取消会员中心未绑定手机的强制更新操作 by yuanshuai 2018年1月19日10:06:31
			/*
			 * try { Member member = UserUtils.getLoginMember(); if (member != null &&
			 * StringUtils.isBlank(member.getSafeMobile()) &&
			 * !request.getRequestURI().contains("/safe/") &&
			 * (!(request.getRequestURI().contains("/userCenter/personalInfo") &&
			 * request.getMethod().equals("GET")) &&
			 * (StringUtils.isBlank(request.getParameter("home")) ||
			 * !request.getParameter("home").equals("1")))) { //增加android、ios端的判断，返回错误信息 by
			 * yuanshuai 2018年1月9日10:09:41 response.setHeader("Content-type",
			 * "application/json;charset=UTF-8"); if(user.getLoginType().equals("iOS") ||
			 * user.getLoginType().equals("Android")) {
			 * StreamUtils.writeStream(response.getOutputStream(), new
			 * RESTResponse(ZAErrorCode.ZA_ERROR, "请前往pc端绑定安全手机并下载最新版本")); return false; }
			 * response.setStatus(401); return false; } }catch (Exception e){
			 * //绑定流程有用户信息没有会员信息，不拦截 by yuanshuai 2018年1月4日10:28:33 if(e instanceof
			 * ZAException){ return true; } }
			 */
			return true;
		}
		return false;
	}

}
