package com.cku.oa.statistics.service;

import com.cku.oa.finance.cab.dao.CABFinanceStatisticsDao;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.dao.PaymentRecordDao;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.entity.PaymentRecord;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.kennel.service.KennelService;
import com.cku.oa.statistics.strategy.*;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.OrgService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.trainschool.dao.TrainingInstitutionDao;
import com.cku.oa.trainschool.entity.TrainingInstitution;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;

@Service
public class NewSplitFinanceService {
	@Autowired
	private PaymentOrderDetailDao paymentOrderDetailDao;
	@Autowired
	private PaymentRecordDao paymentRecordDao;
	@Autowired
	private CABFinanceStatisticsDao cabFinanceStatisticsDao;
	@Autowired
	private SaPaymentDetailService saPaymentDetailService;
	@Autowired
	private OrgService orgService;
	@Autowired
	private TrainingInstitutionDao trainingInstitutionDao;
	@Autowired
	private MemberService memberService;
	@Autowired
	private KennelService kennelService;
	//其他部门
	public static final String[] OTHERDEPT = {"71", "d410b11179f1479c843d337d876d6807"};

	//其他部门 拆分方法
	public void splitOtherDept(String startDate, String endDate, int year, HashMap<String, RelationShipEntity> relationShipMap, HashMap<String, BigDecimal> chargingPriceMap) {
		InitSplitStrategy noProcessOneToOneStrategy = new NoProcessOneToOneStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap);
		List<PaymentOrderDetail> orderDetailList = new ArrayList<PaymentOrderDetail>(20);
		List<PaymentRecord> recordList = new ArrayList<PaymentRecord>(20);
		for (int i = 0; i < OTHERDEPT.length; i++) {
			orderDetailList.clear();
			recordList.clear();
			orderDetailList = paymentOrderDetailDao.findDetailByChargeItem(OTHERDEPT[i], startDate, endDate);
			recordList = paymentRecordDao.findRecordByChargeItem(OTHERDEPT[i], startDate, endDate);

			if (orderDetailList != null && orderDetailList.size() > 0)
				noProcessOneToOneStrategy.initSplitOrderDetail(orderDetailList, OTHERDEPT[i]);
			if (recordList != null && recordList.size() > 0)
				noProcessOneToOneStrategy.initSplitRecord(recordList, OTHERDEPT[i]);
		}

	}

	//企业发展部
	public static final String[] FAZHANDEPT = {"118"};

	public void splitFaZhanDept(String startDate, String endDate, int year, HashMap<String, RelationShipEntity> relationShipMap, HashMap<String, BigDecimal> chargingPriceMap) {
		InitSplitStrategy noProcessOneToOneStrategy = new NoProcessOneToOneStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap);
		List<PaymentOrderDetail> orderDetailList = new ArrayList<PaymentOrderDetail>(20);
		List<PaymentRecord> recordList = new ArrayList<PaymentRecord>(20);
		for (int i = 0; i < FAZHANDEPT.length; i++) {
			orderDetailList.clear();
			recordList.clear();
			orderDetailList = paymentOrderDetailDao.findDetailByChargeItem(FAZHANDEPT[i], startDate, endDate);
			recordList = paymentRecordDao.findRecordByChargeItem(FAZHANDEPT[i], startDate, endDate);

			if (orderDetailList != null && orderDetailList.size() > 0)
				noProcessOneToOneStrategy.initSplitOrderDetail(orderDetailList, FAZHANDEPT[i]);
			if (recordList != null && recordList.size() > 0)
				noProcessOneToOneStrategy.initSplitRecord(recordList, FAZHANDEPT[i]);
		}
	}

	//繁育基数
	public static final String[] GENEDEPT = {
			"55a411fc9df04891b36d6b6a50203961",
			"a279c4dfd4dd4a28a6de083243ace888",
			"059b606e9bac456ea4abf4518125ee3c",
			"35e7c3ec85a349fd9126e98042e0a1f3",
			"b6f31fa5f4e84226b1c9567fe22b01d1",
			"bf7016542dc64e008613b5b350ced17e",
			"c2a14ef1c2fc44d6977c69073b4bc802",
			//2023.06.01
			"24fed019e8c64b7789cfa56a856f81c7", "c6a72dbf9f354d939f2292c5e35732f0",
			//2025.01.06
			"6943096af97d481c88d050855dcb30fd", "0c653b8b33bc42a78f91f2e5ae715054",
			//2025.08.01
			"950f5aec851047788611ad5bb57ff8a6", "c60cbd6e329d4848931cb78bb2ecf8d0",
			"53091d337a374be8ad2aece2f9e02ef7",
	};

	public void splitGENEDept(String startDate, String endDate, int year, HashMap<String, RelationShipEntity> relationShipMap, HashMap<String, BigDecimal> chargingPriceMap) {
		InitSplitStrategy noProcessOneToOneStrategy = new NoProcessOneToOneStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap);
		List<PaymentOrderDetail> orderDetailList = new ArrayList<PaymentOrderDetail>(20);
		List<PaymentRecord> recordList = new ArrayList<PaymentRecord>(20);
		for (int i = 0; i < GENEDEPT.length; i++) {
			orderDetailList.clear();
			recordList.clear();
			orderDetailList = paymentOrderDetailDao.findDetailByChargeItem(GENEDEPT[i], startDate, endDate);
			recordList = paymentRecordDao.findRecordByChargeItem(GENEDEPT[i], startDate, endDate);

			if (orderDetailList != null && orderDetailList.size() > 0)
				noProcessOneToOneStrategy.initSplitOrderDetail(orderDetailList, GENEDEPT[i]);
			if (recordList != null && recordList.size() > 0)
				noProcessOneToOneStrategy.initSplitRecord(recordList, GENEDEPT[i]);
		}
	}

	//重庆办事处
	public static final String[] CHOGNQINGDEPT = {
			"4b3a80da07fe40e28d3d5e683715ec02",
			"5809c0665c6c4bb39ed02c749fa1e134",
			"223",
			"261",
			"269",
			"219",
			"234",
			"367"
	};

	public void splitChongQingDept(String startDate, String endDate, int year, HashMap<String, RelationShipEntity> relationShipMap, HashMap<String, BigDecimal> chargingPriceMap) {
		InitSplitStrategy noProcessOneToOneStrategy = new NoProcessOneToOneStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap);
		List<PaymentOrderDetail> orderDetailList = new ArrayList<PaymentOrderDetail>(20);
		List<PaymentRecord> recordList = new ArrayList<PaymentRecord>(20);
		for (int i = 0; i < CHOGNQINGDEPT.length; i++) {
			orderDetailList.clear();
			recordList.clear();
			orderDetailList = paymentOrderDetailDao.findDetailByChargeItem(CHOGNQINGDEPT[i], startDate, endDate);
			recordList = paymentRecordDao.findRecordByChargeItem(CHOGNQINGDEPT[i], startDate, endDate);

			if (orderDetailList != null && orderDetailList.size() > 0)
				noProcessOneToOneStrategy.initSplitOrderDetail(orderDetailList, CHOGNQINGDEPT[i]);
			if (recordList != null && recordList.size() > 0)
				noProcessOneToOneStrategy.initSplitRecord(recordList, CHOGNQINGDEPT[i]);
		}
	}

	//长春办事处
	public static final String[] CHANGCHUNDEPT = {
			"281",
			"262",
			"270",
			"224",
			"221",
			"9925e1079fc44ed4a2ff096353f0a674",
			"f0eef5f34b864a9294e3d4e03561179a",
			"372"
	};

	public void splitChangchongDept(String startDate, String endDate, int year, HashMap<String, RelationShipEntity> relationShipMap, HashMap<String, BigDecimal> chargingPriceMap) {
		InitSplitStrategy noProcessOneToOneStrategy = new NoProcessOneToOneStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap);
		List<PaymentOrderDetail> orderDetailList = new ArrayList<PaymentOrderDetail>(20);
		List<PaymentRecord> recordList = new ArrayList<PaymentRecord>(20);
		for (int i = 0; i < CHANGCHUNDEPT.length; i++) {
			orderDetailList.clear();
			recordList.clear();
			orderDetailList = paymentOrderDetailDao.findDetailByChargeItem(CHANGCHUNDEPT[i], startDate, endDate);
			recordList = paymentRecordDao.findRecordByChargeItem(CHANGCHUNDEPT[i], startDate, endDate);

			if (orderDetailList != null && orderDetailList.size() > 0)
				noProcessOneToOneStrategy.initSplitOrderDetail(orderDetailList, CHANGCHUNDEPT[i]);
			if (recordList != null && recordList.size() > 0)
				noProcessOneToOneStrategy.initSplitRecord(recordList, CHANGCHUNDEPT[i]);
		}
	}

	//杭州办事处
	public static final String[] HANGZHOUEPT = {
			"195",
			"157",
			"141",
			"121",
			"148",
			"117",
			"189",
			"260",
			"268",
			"370",
			"73989b7f0c874729b76d5289b702064a"

	};

	public void splitHangZhouDept(String startDate, String endDate, int year, HashMap<String, RelationShipEntity> relationShipMap, HashMap<String, BigDecimal> chargingPriceMap) {
		InitSplitStrategy noProcessOneToOneStrategy = new NoProcessOneToOneStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap);
		List<PaymentOrderDetail> orderDetailList = new ArrayList<PaymentOrderDetail>(20);
		List<PaymentRecord> recordList = new ArrayList<PaymentRecord>(20);
		for (int i = 0; i < HANGZHOUEPT.length; i++) {
			orderDetailList.clear();
			recordList.clear();
			orderDetailList = paymentOrderDetailDao.findDetailByChargeItem(HANGZHOUEPT[i], startDate, endDate);
			recordList = paymentRecordDao.findRecordByChargeItem(HANGZHOUEPT[i], startDate, endDate);

			if (orderDetailList != null && orderDetailList.size() > 0)
				noProcessOneToOneStrategy.initSplitOrderDetail(orderDetailList, HANGZHOUEPT[i]);
			if (recordList != null && recordList.size() > 0)
				noProcessOneToOneStrategy.initSplitRecord(recordList, HANGZHOUEPT[i]);
		}
	}

	//长沙办事处
	public static final String[] CHANGSHAEPT = {
			"a995e065c4294b25b2ebbd6f56a31795",
			"371",
			"305",
			"299",
			"5dbe60c1ac8149b3a38e072d14032e8c",

	};

	public void splitChangShaDept(String startDate, String endDate, int year, HashMap<String, RelationShipEntity> relationShipMap, HashMap<String, BigDecimal> chargingPriceMap) {
		InitSplitStrategy noProcessOneToOneStrategy = new NoProcessOneToOneStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap);
		List<PaymentOrderDetail> orderDetailList = new ArrayList<PaymentOrderDetail>(20);
		List<PaymentRecord> recordList = new ArrayList<PaymentRecord>(20);
		for (int i = 0; i < CHANGSHAEPT.length; i++) {
			orderDetailList.clear();
			recordList.clear();
			orderDetailList = paymentOrderDetailDao.findDetailByChargeItem(CHANGSHAEPT[i], startDate, endDate);
			recordList = paymentRecordDao.findRecordByChargeItem(CHANGSHAEPT[i], startDate, endDate);
			if (orderDetailList != null && orderDetailList.size() > 0)
				noProcessOneToOneStrategy.initSplitOrderDetail(orderDetailList, CHANGSHAEPT[i]);
			if (recordList != null && recordList.size() > 0)
				noProcessOneToOneStrategy.initSplitRecord(recordList, CHANGSHAEPT[i]);
		}
	}

	//北京办事处
	public static final String[] BEIJING = {
			"d64061366fa245bc902c542807e2d998",
			"368",
			"155",
			"190",

	};

	public void splitBeingJingDept(String startDate, String endDate, int year, HashMap<String, RelationShipEntity> relationShipMap, HashMap<String, BigDecimal> chargingPriceMap) {
		InitSplitStrategy noProcessOneToOneStrategy = new NoProcessOneToOneStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap);
		List<PaymentOrderDetail> orderDetailList = new ArrayList<PaymentOrderDetail>(20);
		List<PaymentRecord> recordList = new ArrayList<PaymentRecord>(20);
		for (int i = 0; i < BEIJING.length; i++) {
			orderDetailList.clear();
			recordList.clear();
			orderDetailList = paymentOrderDetailDao.findDetailByChargeItem(BEIJING[i], startDate, endDate);
			recordList = paymentRecordDao.findRecordByChargeItem(BEIJING[i], startDate, endDate);
			if (orderDetailList != null && orderDetailList.size() > 0)
				noProcessOneToOneStrategy.initSplitOrderDetail(orderDetailList, BEIJING[i]);
			if (recordList != null && recordList.size() > 0)
				noProcessOneToOneStrategy.initSplitRecord(recordList, BEIJING[i]);
		}
	}

	//郑州办事处
	public static final String[] ZHENGZHOUEPT = {
			"25c04f060c1f4314bb7b7d18aeb7b915",
			"369",
			"305zz",
			"301zz",
			"299zz",

	};

	public void splitZhengZhouDept(String startDate, String endDate, int year, HashMap<String, RelationShipEntity> relationShipMap, HashMap<String, BigDecimal> chargingPriceMap) {
		InitSplitStrategy noProcessOneToOneStrategy = new NoProcessOneToOneStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap);
		List<PaymentOrderDetail> orderDetailList = new ArrayList<PaymentOrderDetail>(20);
		List<PaymentRecord> recordList = new ArrayList<PaymentRecord>(20);
		for (int i = 0; i < ZHENGZHOUEPT.length; i++) {
			orderDetailList.clear();
			recordList.clear();
			orderDetailList = paymentOrderDetailDao.findDetailByChargeItem(ZHENGZHOUEPT[i], startDate, endDate);
			recordList = paymentRecordDao.findRecordByChargeItem(ZHENGZHOUEPT[i], startDate, endDate);
			if (orderDetailList != null && orderDetailList.size() > 0)
				noProcessOneToOneStrategy.initSplitOrderDetail(orderDetailList, ZHENGZHOUEPT[i]);
			if (recordList != null && recordList.size() > 0)
				noProcessOneToOneStrategy.initSplitRecord(recordList, ZHENGZHOUEPT[i]);
		}
	}

	//合作单位
	public static final String[] HEZUODANWEIDEPT = {
			"272",
			"273",
			"274",
			"271",
			"263",
			"266",
			"265",
			"264",
			"140",
			"220",
			"142",
			"222",
			"156",
			"158",
			"257",
			"233",
			//新增
			"298",
			//2025.04.01
			"e70f60d0bcd04ac5b2bc1198542ba0ba", "a641edbdcf0e442bab94842c0c08b4a0",
			//2025.06.03
			"4bffbf17744f4ad4ab70d1f8f15e8295"
	};

	public void splitHeZuoDanWeiDept(String startDate, String endDate, int year, HashMap<String, RelationShipEntity> relationShipMap, HashMap<String, BigDecimal> chargingPriceMap) {
		InitSplitStrategy noProcessOneToOneStrategy = new NoProcessOneToOneStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap);
		InitSplitStrategy mathStrategy = new MathStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap);
		List<PaymentOrderDetail> orderDetailList = new ArrayList<PaymentOrderDetail>(20);
		List<PaymentRecord> recordList = new ArrayList<PaymentRecord>(20);
		for (int i = 0; i < HEZUODANWEIDEPT.length; i++) {
			orderDetailList.clear();
			recordList.clear();
			orderDetailList = paymentOrderDetailDao.findDetailByChargeItem(HEZUODANWEIDEPT[i], startDate, endDate);
			recordList = paymentRecordDao.findRecordByChargeItem(HEZUODANWEIDEPT[i], startDate, endDate);

//            if("140".equals(HEZUODANWEIDEPT[i]) || "220".equals(HEZUODANWEIDEPT[i]) || "142".equals(HEZUODANWEIDEPT[i]) || "222".equals(HEZUODANWEIDEPT[i])){
//                if(orderDetailList!=null && orderDetailList.size()>0)
//                    mathStrategy.initSplitOrderDetail(orderDetailList,HEZUODANWEIDEPT[i]);
//                if(recordList!=null && recordList.size()>0)
//                    mathStrategy.initSplitRecord(recordList,HEZUODANWEIDEPT[i]);
//            }else{
			if (orderDetailList != null && orderDetailList.size() > 0) {
				noProcessOneToOneStrategy.initSplitOrderDetail(orderDetailList, HEZUODANWEIDEPT[i]);
			}
			if (recordList != null && recordList.size() > 0) {
				noProcessOneToOneStrategy.initSplitRecord(recordList, HEZUODANWEIDEPT[i]);
			}

//            }

		}
	}

	//商品部
	public static final String[] SHANGPINDEPT = {
			"111",
			"112",
			"51",
			"67",
			"52",
			"68",
			"53",
			"227",
			"214",
			"54",
			"235",
			"215"
	};

	public void splitShangPinDept(String startDate, String endDate, int year, HashMap<String, RelationShipEntity> relationShipMap, HashMap<String, BigDecimal> chargingPriceMap) {
		InitSplitStrategy noProcessOneToOneStrategy = new NoProcessOneToOneStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap);
		List<PaymentOrderDetail> orderDetailList = new ArrayList<PaymentOrderDetail>(20);
		List<PaymentRecord> recordList = new ArrayList<PaymentRecord>(20);
		for (int i = 0; i < SHANGPINDEPT.length; i++) {
			orderDetailList.clear();
			recordList.clear();
			orderDetailList = paymentOrderDetailDao.findDetailByChargeItem(SHANGPINDEPT[i], startDate, endDate);
			recordList = paymentRecordDao.findRecordByChargeItem(SHANGPINDEPT[i], startDate, endDate);
			if (orderDetailList != null && orderDetailList.size() > 0)
				noProcessOneToOneStrategy.initSplitOrderDetail(orderDetailList, SHANGPINDEPT[i]);
			if (recordList != null && recordList.size() > 0)
				noProcessOneToOneStrategy.initSplitRecord(recordList, SHANGPINDEPT[i]);

		}
	}

	//招商部
	public static final String[] ZHAOSHANGDEPT = {
			"292",
			"287",
			"293",
			"1111",
			"288",
			"294",
			"289",
			"295",
			"290",
			"206",
			"291",
			"63",
			"286",
			//新增
			"296",
			"312",
			"3b51f5e483c348c7b465086060032324",
			"2c4e95dbc3ce4d5b898247f172594866",
			"de2d33b8bb014867968c31689dbc71bb",
			"e0bebb6702e4429a97ccb1e25140ed35",
			//2024.03.01
			"2b4dde7c558349378d375971feed4272"
	};

	public void splitZhaoShangdept(String startDate, String endDate, int year, HashMap<String, RelationShipEntity> relationShipMap, HashMap<String, BigDecimal> chargingPriceMap) {
		InitSplitStrategy noProcessOneToOneStrategy = new NoProcessOneToOneStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap);
		List<PaymentOrderDetail> orderDetailList = new ArrayList<PaymentOrderDetail>(20);
		List<PaymentRecord> recordList = new ArrayList<PaymentRecord>(20);
		for (int i = 0; i < ZHAOSHANGDEPT.length; i++) {
			orderDetailList.clear();
			recordList.clear();
			orderDetailList = paymentOrderDetailDao.findDetailByChargeItem(ZHAOSHANGDEPT[i], startDate, endDate);
			recordList = paymentRecordDao.findRecordByChargeItem(ZHAOSHANGDEPT[i], startDate, endDate);

			if (orderDetailList != null && orderDetailList.size() > 0)
				noProcessOneToOneStrategy.initSplitOrderDetail(orderDetailList, ZHAOSHANGDEPT[i]);
			if (recordList != null && recordList.size() > 0)
				noProcessOneToOneStrategy.initSplitRecord(recordList, ZHAOSHANGDEPT[i]);

		}
	}

	//财务部
	public static final String[] CAIWUDEPT = {
			"256",
			"167",
			"169",
			"84"
	};

	public void splitCaiWuDept(String startDate, String endDate, int year, HashMap<String, RelationShipEntity> relationShipMap, HashMap<String, BigDecimal> chargingPriceMap) {
		InitSplitStrategy noProcessOneToOneStrategy = new NoProcessOneToOneStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap);
		List<PaymentOrderDetail> orderDetailList = new ArrayList<PaymentOrderDetail>(20);
		List<PaymentRecord> recordList = new ArrayList<PaymentRecord>(20);
		for (int i = 0; i < CAIWUDEPT.length; i++) {
			orderDetailList.clear();
			recordList.clear();
			orderDetailList = paymentOrderDetailDao.findDetailByChargeItem(CAIWUDEPT[i], startDate, endDate);
			recordList = paymentRecordDao.findRecordByChargeItem(CAIWUDEPT[i], startDate, endDate);

			if (orderDetailList != null && orderDetailList.size() > 0)
				noProcessOneToOneStrategy.initSplitOrderDetail(orderDetailList, CAIWUDEPT[i]);
			if (recordList != null && recordList.size() > 0)
				noProcessOneToOneStrategy.initSplitRecord(recordList, CAIWUDEPT[i]);

		}
	}

	//地方俱乐部项目组
	public static final String[] JULEBUDEPT = {
			"601",
			"200",
			"602",
			"282",
			"f288b22d0f06402daa7df0024dd71aea",
			"280",
			//新增
			"308",
			"309",
			"1e8e703ca4ea429cb57f7db1d0a82774",
			//2023.06.01
			"9f742a03f73749e3a3d50c9f5941910c"
	};

	public void splitJuLeBuDept(String startDate, String endDate, int year, HashMap<String, RelationShipEntity> relationShipMap, HashMap<String, BigDecimal> chargingPriceMap) {
		InitSplitStrategy noProcessOneToOneStrategy = new NoProcessOneToOneStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap);
		InitSplitStrategy splitYearToMonthStrategy = new SplitYearToMonthStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap, 12);
		InitSplitStrategy splitYearToMonth3Strategy = new SplitYearToMonthStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap, 3);
		List<PaymentOrderDetail> orderDetailList = new ArrayList<PaymentOrderDetail>(20);
		List<PaymentRecord> recordList = new ArrayList<PaymentRecord>(20);
		for (int i = 0; i < JULEBUDEPT.length; i++) {
			orderDetailList.clear();
			recordList.clear();
			orderDetailList = paymentOrderDetailDao.findDetailByChargeItem(JULEBUDEPT[i], startDate, endDate);
			recordList = paymentRecordDao.findRecordByChargeItem(JULEBUDEPT[i], startDate, endDate);
			if ("308".equals(JULEBUDEPT[i]) || "309".equals(JULEBUDEPT[i])) {
				if (orderDetailList != null && orderDetailList.size() > 0) {
					//循环赋值 拆分开始时间
					for (PaymentOrderDetail orderDetail : orderDetailList) {
						orderDetail.setSplitBeginDate(orderDetail.getAddTime());
					}
					splitYearToMonth3Strategy.initSplitOrderDetail(orderDetailList, JULEBUDEPT[i]);
				}

				if (recordList != null && recordList.size() > 0) {
					//循环赋值 拆分开始时间
					for (PaymentRecord record : recordList) {
						record.setSplitBeginDate(record.getPaymentTime());
					}
					splitYearToMonth3Strategy.initSplitRecord(recordList, JULEBUDEPT[i]);
				}

			} else if ("200".equals(JULEBUDEPT[i])) {
				if (orderDetailList != null && orderDetailList.size() > 0) {
					//循环赋值 拆分开始时间
					for (PaymentOrderDetail orderDetail : orderDetailList) {
						String hzcode = orderDetail.getMemberCode();
						Org org = null;
						if (hzcode.indexOf("HZ") > -1) {
							org = orgService.getByMemberCode(hzcode);
							orderDetail.setSplitBeginDate(YearToMonthSplitUtils.getBeforeDate(org.getEndDate(), orderDetail.getAddTime()));
						} else {
							orderDetail.setSplitBeginDate(orderDetail.getAddTime());
						}
						;

					}
					splitYearToMonthStrategy.initSplitOrderDetail(orderDetailList, JULEBUDEPT[i]);
				}

				if (recordList != null && recordList.size() > 0) {
					//循环赋值 拆分开始时间
					for (PaymentRecord record : recordList) {
						String hzcode = record.getMemberCode();
						Org org = null;
						if (hzcode.indexOf("HZ") > -1) {
							org = orgService.getByMemberCode(hzcode);
							record.setSplitBeginDate(YearToMonthSplitUtils.getBeforeDate(org.getEndDate(), record.getPaymentTime()));
						} else {
							record.setSplitBeginDate(record.getPaymentTime());
						}
						;

					}
					splitYearToMonthStrategy.initSplitRecord(recordList, JULEBUDEPT[i]);
				}

			} else {
				if (orderDetailList != null && orderDetailList.size() > 0)
					noProcessOneToOneStrategy.initSplitOrderDetail(orderDetailList, JULEBUDEPT[i]);
				if (recordList != null && recordList.size() > 0)
					noProcessOneToOneStrategy.initSplitRecord(recordList, JULEBUDEPT[i]);
			}
		}
	}

	//会员部
	public static final String[] HUIYUANDEPT = {
			"208",
			"80",
			"237",
			"1",
			"104",
			"10",
			"2",
			"3",
			"6",
			"5",
			"8",
			"60",
			"7",
			"42715470bfad4b289b734354ba92a148",
			"57053cefa38149a8a04d4ae6d8a68741",
			"143",
			"99901",
			"99902",
			"99903",
			"2f34e1989ce0413a8cbe7bd36629794a",
			"fd275c2b041f4b7180647eeb7d64d4d1",
			"962c2f6e11e8412c8a000c1c8751dbb6",
			"7522347a3d3f4d2da83fdcb549296233",
			"c85cafb375cf43f5a6d44f85aa9596b1",
			"3d9431639cf14efc90531e95dc639d03",
			"024b7414f05d4052b12306a4e650aa19",
			"2267863ce07545b1856ed3fa31c6cd5c",
			"0d7f9e77b572400897406759dd563c31",
			"8b4a949131224404a81c3421a100bdde",
			"73aef57be260432d9f4dedca1c367486",
			"99904",
			"02ed5464fdaf414cb157d94e1f3cfa1c",
			"c4b4ef07cd9d4324b981d74f704ab399",
			"6d84b2d699f64431b1e9c6f887d7944f",
			"ac91fdf697fa4f9ea9afd081144947c7",
			"b00b4f7d018245ce9a24c0320ea22988",
			"a3025dcc3cb04f74a8084e372bf3a26f",
			"eb2a7ab2c36b49e986776ad40dac16e0",
			"6ec3d0ec24c1438b8b31e36af9927df7",
			//2024.10.08
			"07bdf5aacd0f4dc1a3d7370c2f8e2ede",
	};

	public void splitHuiYuanDept(String startDate, String endDate, int year, HashMap<String, RelationShipEntity> relationShipMap, HashMap<String, BigDecimal> chargingPriceMap) {
		InitSplitStrategy noProcessOneToOneStrategy = new NoProcessOneToOneStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap);
		InitSplitStrategy splitYearToMonthWithTowStrategy12 = new SplitYearToMonthWithTowStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap, 12, "cab");
		InitSplitStrategy splitYearToMonthWithTowStrategy120 = new SplitYearToMonthWithTowStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap, 120, "cab");
		InitSplitStrategy splitYearToMonthStrategy12 = new SplitYearToMonthStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap, 12);
		InitSplitStrategy splitOneToManyStrategy = new SplitOneToManyStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap);

		List<PaymentOrderDetail> orderDetailList = new ArrayList<PaymentOrderDetail>(20);
		List<PaymentRecord> recordList = new ArrayList<PaymentRecord>(20);
		for (int i = 0; i < HUIYUANDEPT.length; i++) {
			orderDetailList.clear();
			recordList.clear();
			orderDetailList = paymentOrderDetailDao.findDetailByChargeItem(HUIYUANDEPT[i], startDate, endDate);
			recordList = paymentRecordDao.findRecordByChargeItem(HUIYUANDEPT[i], startDate, endDate);


			if ("237".equals(HUIYUANDEPT[i]) || "2f34e1989ce0413a8cbe7bd36629794a".equals(HUIYUANDEPT[i])
					|| "962c2f6e11e8412c8a000c1c8751dbb6".equals(HUIYUANDEPT[i])) {
				//外籍会员年度登记费
				if (orderDetailList != null && orderDetailList.size() > 0) {
					for (PaymentOrderDetail orderDetail : orderDetailList) {
						orderDetail.setSplitBeginDate(orderDetail.getAddTime());
					}
					splitYearToMonthStrategy12.initSplitOrderDetail(orderDetailList, HUIYUANDEPT[i]);
				}
				if (recordList != null && recordList.size() > 0) {
					for (PaymentRecord record : recordList) {
						record.setSplitBeginDate(record.getPaymentTime());
					}
					splitYearToMonthStrategy12.initSplitRecord(recordList, HUIYUANDEPT[i]);
				}

			} else if ("1".equals(HUIYUANDEPT[i]) || "07bdf5aacd0f4dc1a3d7370c2f8e2ede".equals(HUIYUANDEPT[i])) {
				//基础会员年度登记费
				if (orderDetailList != null && orderDetailList.size() > 0) {
					for (PaymentOrderDetail orderDetail : orderDetailList) {
						String hrmember = orderDetail.getMemberCode();
						Member member = memberService.getByMemberCode(hrmember);
						if (member == null || member.getMemberType() == null || (!"basic".equals(member.getMemberType())) || member.getMemberEndDate() == null) {
							orderDetail.setSplitBeginDate(orderDetail.getAddTime());
						} else {
							if (hrmember.indexOf("HZ") > -1 && "sys_member".equals(orderDetail.getBusinessTable())) {
								//俱乐部帮会员办理
								Member forMember = memberService.get(orderDetail.getBusinessIds());
								orderDetail.setSplitBeginDate(YearToMonthSplitUtils.getBeforeDate(forMember.getMemberEndDate(), orderDetail.getAddTime()));
							} else {
								orderDetail.setSplitBeginDate(YearToMonthSplitUtils.getBeforeDate(member.getMemberEndDate(), orderDetail.getAddTime()));
							}
						}

					}
					splitYearToMonthStrategy12.initSplitOrderDetail(orderDetailList, HUIYUANDEPT[i]);
				}
				if (recordList != null && recordList.size() > 0) {
					for (PaymentRecord record : recordList) {
						String hrmember = record.getMemberCode();
						Member member = memberService.getByMemberCode(hrmember);
						if (member == null || member.getMemberType() == null || (!"basic".equals(member.getMemberType())) || member.getMemberEndDate() == null) {
							record.setSplitBeginDate(record.getPaymentTime());
						} else {
							record.setSplitBeginDate(YearToMonthSplitUtils.getBeforeDate(member.getMemberEndDate(), record.getPaymentTime()));
						}
					}
					splitYearToMonthStrategy12.initSplitRecord(recordList, HUIYUANDEPT[i]);
				}

			} else if ("3".equals(HUIYUANDEPT[i])) {
				// 专业会员年度登记费
				if (orderDetailList != null && orderDetailList.size() > 0) {
					for (PaymentOrderDetail orderDetail : orderDetailList) {
						String hrmember = orderDetail.getMemberCode();
						Member member = memberService.getByMemberCode(hrmember);
						if (member == null || member.getMemberType() == null || (!"professional".equals(member.getMemberType())) || member.getMemberEndDate() == null) {
							orderDetail.setSplitBeginDate(orderDetail.getAddTime());
						} else {

							if (hrmember.indexOf("HZ") > -1 && "sys_member".equals(orderDetail.getBusinessTable())) {
								//俱乐部帮会员办理
								Member forMember = memberService.get(orderDetail.getBusinessIds());
								orderDetail.setSplitBeginDate(YearToMonthSplitUtils.getBeforeDate(forMember.getMemberEndDate(), orderDetail.getAddTime()));
							} else {
								orderDetail.setSplitBeginDate(YearToMonthSplitUtils.getBeforeDate(member.getMemberEndDate(), orderDetail.getAddTime()));
							}
						}

					}
					splitYearToMonthWithTowStrategy12.initSplitOrderDetail(orderDetailList, HUIYUANDEPT[i]);
				}
				if (recordList != null && recordList.size() > 0) {
					for (PaymentRecord record : recordList) {
						String hrmember = record.getMemberCode();
						Member member = memberService.getByMemberCode(hrmember);
						if (member == null || member.getMemberType() == null || (!"professional".equals(member.getMemberType())) || member.getMemberEndDate() == null) {
							record.setSplitBeginDate(record.getPaymentTime());
						} else {
							record.setSplitBeginDate(YearToMonthSplitUtils.getBeforeDate(member.getMemberEndDate(), record.getPaymentTime()));
						}
					}
					splitYearToMonthWithTowStrategy12.initSplitRecord(recordList, HUIYUANDEPT[i]);
				}
			} else if ("6".equals(HUIYUANDEPT[i])) {
				// 犬舍年度登记费
				if (orderDetailList != null && orderDetailList.size() > 0) {
					for (PaymentOrderDetail orderDetail : orderDetailList) {
						String hrmember = orderDetail.getMemberCode();
						Kennel kennel = kennelService.getKennelByMemberCode(hrmember);
						if (kennel == null || (!"year".equals(kennel.getType())) || kennel.getEndTime() == null) {
							orderDetail.setSplitBeginDate(orderDetail.getAddTime());
						} else {
							orderDetail.setSplitBeginDate(YearToMonthSplitUtils.getBeforeDate(kennel.getEndTime(), orderDetail.getAddTime()));
						}

					}
					splitYearToMonthWithTowStrategy12.initSplitOrderDetail(orderDetailList, HUIYUANDEPT[i]);
				}
				if (recordList != null && recordList.size() > 0) {
					for (PaymentRecord record : recordList) {
						String hrmember = record.getMemberCode();
						Kennel kennel = kennelService.getKennelByMemberCode(hrmember);
						if (kennel == null || (!"year".equals(kennel.getType())) || kennel.getEndTime() == null) {
							record.setSplitBeginDate(record.getPaymentTime());
						} else {
							record.setSplitBeginDate(YearToMonthSplitUtils.getBeforeDate(kennel.getEndTime(), record.getPaymentTime()));
						}
					}
					splitYearToMonthWithTowStrategy12.initSplitRecord(recordList, HUIYUANDEPT[i]);
				}

			} else if ("7".equals(HUIYUANDEPT[i])) {
				// 永久犬舍名称登记费
				if (orderDetailList != null && orderDetailList.size() > 0) {
					for (PaymentOrderDetail orderDetail : orderDetailList) {
						orderDetail.setSplitBeginDate(orderDetail.getAddTime());
					}
					splitYearToMonthWithTowStrategy120.initSplitOrderDetail(orderDetailList, HUIYUANDEPT[i]);
				}
				if (recordList != null && recordList.size() > 0) {
					for (PaymentRecord record : recordList) {
						record.setSplitBeginDate(record.getPaymentTime());
					}
					splitYearToMonthWithTowStrategy120.initSplitRecord(recordList, HUIYUANDEPT[i]);
				}
			} else if ("99901".equals(HUIYUANDEPT[i])) {
				// 永久犬舍名称登记费
				if (orderDetailList != null && orderDetailList.size() > 0) {
					for (PaymentOrderDetail orderDetail : orderDetailList) {
						orderDetail.setSplitBeginDate(orderDetail.getAddTime());
					}
					splitYearToMonthWithTowStrategy12.initSplitOrderDetail(orderDetailList, HUIYUANDEPT[i]);
				}
				if (recordList != null && recordList.size() > 0) {
					for (PaymentRecord record : recordList) {
						record.setSplitBeginDate(record.getPaymentTime());
					}
					splitYearToMonthWithTowStrategy12.initSplitRecord(recordList, HUIYUANDEPT[i]);
				}
			} else if ("57053cefa38149a8a04d4ae6d8a68741".equals(HUIYUANDEPT[i]) || "a3025dcc3cb04f74a8084e372bf3a26f".equals(HUIYUANDEPT[i]) || "eb2a7ab2c36b49e986776ad40dac16e0".equals(HUIYUANDEPT[i])) {
				// 永久犬舍名称登记费
				if (orderDetailList != null && orderDetailList.size() > 0) {
					for (PaymentOrderDetail orderDetail : orderDetailList) {
						orderDetail.setSplitBeginDate(orderDetail.getAddTime());
					}
					splitOneToManyStrategy.initSplitOrderDetail(orderDetailList, HUIYUANDEPT[i]);
				}
				if (recordList != null && recordList.size() > 0) {
					for (PaymentRecord record : recordList) {
						record.setSplitBeginDate(record.getPaymentTime());
					}
					splitOneToManyStrategy.initSplitRecord(recordList, HUIYUANDEPT[i]);
				}
			} else {
				if (orderDetailList != null && orderDetailList.size() > 0)
					noProcessOneToOneStrategy.initSplitOrderDetail(orderDetailList, HUIYUANDEPT[i]);
				if (recordList != null && recordList.size() > 0)
					noProcessOneToOneStrategy.initSplitRecord(recordList, HUIYUANDEPT[i]);
			}


		}
	}

	//繁殖部
	public static final String[] FANZHIDEPT = {
			"278",
			"279",
			"26",
			"58",
			"242",
			"241",
			"240",
			"217",
			"64",
			"249",
			"56",
			"243",
			"14",
			"25",
			"12",
			"99",
			"238",
			"239",
			"15",
			"877",
			"76",
			"13",
			"244",
			"245",
			"816",
			"202",
			"225",
			"226",
			"258",
			"16",
			"251",
			"250",
			"24",
			"18",
			"19",
			"277",
			"276",
			"275",
			"285",
			"17",
			"20",
			"22",
			"246",
			"21",
			"247",
			"23",
			"248",
			"144",
			"313",
			"314",
			"315",
			"326",
			"328",
			"4c115d68975444548a82ca8bba9bcd04",
			"17855720b480431c81181bd082018d23",
			"c7351b6e4f6049cdbc6f1ff1b50382a0",
			"de20ce434cfc42f7b32b65b3953b886f",
			"dbdfb76d10c245b0a54c829ef4d31f03",
			"76f54bdd760c43d797a9b9c835ca20ee",
			"e9c37c8005c141b39cdfdee1f45b802d",
			"bfd0cbf4a1844cd5824c36efbf4c64f2",
			"fb9d498f2dc24ddfa5b50112f086c672",
			"238c11d98bcf484aa3929f480c71bd9f",
			"98a5e1027c054645bd5af654ca2ac736",
			"90a05d12fb784643a4ab919761f1449d",
			"4ba9605460a84b32b3a00ef71c924e7f",
			"3faf6501d752492791690fd24091e639",
			"fc1c9bc6e20f4ac3b61d2e7b3fec270a",
			"b2272f463e48444fb1abe810ec276b6a",
			"43a76668f7924f49aef7c7df33dcf5f6",
			"472d7c0affcc4e5ba1725b4729344346",
			"0d1d2749270443ecb20899ed200f92a7",
			"16e814e6409d4c759d909fcb52d30063",
			"bafe7753d9f343528bfad0bdd466ce44",
			"f5353f0d1e474d3dac4b9bca3d4c84a4",
			"bc35a8e93d54474c8b3b6252c1e3309b",
			"f5b0c97b819b4853a72cab5224e543ee",
			"f7676fbe0bdc4188a2a74ef475cbf694",
			"2644aff00fda43f5a269ed392ccc28d2",
			"f6876716d0c542e79610ac4b32f5bb0f",
			"31dfd9693ca44b69b3cd659b2795933c",
			"861e3ef534514375b3774b91cacf916d",
			"0e769cce9fdf4d4f88a72d0130cea779",
			"58e08a2616e645bd9ba66bcab8f129a2",
			//2023.06.01
			"e905032b77cf4a8b9bb3e53e693bdbac", "971e1864b6a54525ba3f66e56b3c10e5", "cf701ff5b169405bb4dab90623728042",
			"17bf072dcae74f7db3d489e06a3de3a4", "42486b62a04f40da8ae269c3efa142d2", "034db20398ee4bea828876e7e72a6f8c",
			"3f53d07d1006491189b0a0974fb2e443", "56444644f3a64d1b96e53236a85e1948", "272e0249fba64ff6b4e22e897ca37ec2",
			"a0db99c555d446eb8ea281704fcfb91a",
			//2023.12.01
			"ef6d1c5c10ed4df69f24aa740d40a0d2",
			//2024.02.01
			"ee1726c2d7594fb9858eb97cbcbde53f",
			//2024.06.03
			"4df8d3ef339a4ea8b6f1167894567eea",
			//2024.08.01
			"4625f60e8ac44d37b23ce2d972d1b532", "4f4f0654e9cc4b3fac8403532b2865b1",
			//2024.09.02
			"e8c03b7eb6174c99b5686e2171892182",
	};

	public void splitFanZhiDept(String startDate, String endDate, int year, HashMap<String, RelationShipEntity> relationShipMap, HashMap<String, BigDecimal> chargingPriceMap) {
		InitSplitStrategy noProcessOneToOneStrategy = new NoProcessOneToOneStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap);
		InitSplitStrategy splitOneToManyStrategy = new SplitOneToManyStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap);
		List<PaymentOrderDetail> orderDetailList = new ArrayList<PaymentOrderDetail>(5000);
		List<PaymentRecord> recordList = new ArrayList<PaymentRecord>(5000);
		for (int i = 0; i < FANZHIDEPT.length; i++) {
			orderDetailList.clear();
			recordList.clear();
			orderDetailList = paymentOrderDetailDao.findDetailByChargeItem(FANZHIDEPT[i], startDate, endDate);
			recordList = paymentRecordDao.findRecordByChargeItem(FANZHIDEPT[i], startDate, endDate);
			//拆分
			if ("278".equals(FANZHIDEPT[i]) || "279".equals(FANZHIDEPT[i]) || "26".equals(FANZHIDEPT[i])
					|| "14".equals(FANZHIDEPT[i]) || "239".equals(FANZHIDEPT[i]) || "15".equals(FANZHIDEPT[i])
					|| "877".equals(FANZHIDEPT[i]) || "76".equals(FANZHIDEPT[i]) || "13".equals(FANZHIDEPT[i])
					|| "816".equals(FANZHIDEPT[i]) || "16".equals(FANZHIDEPT[i]) || "19".equals(FANZHIDEPT[i])
					|| "277".equals(FANZHIDEPT[i]) || "17".equals(FANZHIDEPT[i]) || "58e08a2616e645bd9ba66bcab8f129a2".equals(FANZHIDEPT[i])
					|| "a0db99c555d446eb8ea281704fcfb91a".equals(FANZHIDEPT[i])) {
				if (orderDetailList != null && orderDetailList.size() > 0)
					splitOneToManyStrategy.initSplitOrderDetail(orderDetailList, FANZHIDEPT[i]);
				if (recordList != null && recordList.size() > 0)
					splitOneToManyStrategy.initSplitRecord(recordList, FANZHIDEPT[i]);
			} else {
				if (orderDetailList != null && orderDetailList.size() > 0)
					noProcessOneToOneStrategy.initSplitOrderDetail(orderDetailList, FANZHIDEPT[i]);
				if (recordList != null && recordList.size() > 0)
					noProcessOneToOneStrategy.initSplitRecord(recordList, FANZHIDEPT[i]);
			}


		}
	}

	//藏獒俱乐部
	public static final String[] ZANGAODEPT = {
			"131",
			"229",
			"181",
			"999",
			"132",
			"125",
			"185",
			"129",
			"230",
			"179",
			"134",
			"126",
			"151",
			"210",
			"133",
			"127",
			"128",
			"153",
			"135",
			"136",
			"130",
			"207",
			"137",
			"163"

	};

	public void splitZangaoDept(String startDate, String endDate, int year, HashMap<String, RelationShipEntity> relationShipMap, HashMap<String, BigDecimal> chargingPriceMap) {
		InitSplitStrategy noProcessOneToOneStrategy = new NoProcessOneToOneStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap);
		InitSplitStrategy splitOneToManyStrategy = new SplitOneToManyStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap);
		List<PaymentOrderDetail> orderDetailList = new ArrayList<PaymentOrderDetail>(5000);
		List<PaymentRecord> recordList = new ArrayList<PaymentRecord>(5000);
		for (int i = 0; i < ZANGAODEPT.length; i++) {
			orderDetailList.clear();
			recordList.clear();
			orderDetailList = paymentOrderDetailDao.findDetailByChargeItem(ZANGAODEPT[i], startDate, endDate);
			recordList = paymentRecordDao.findRecordByChargeItem(ZANGAODEPT[i], startDate, endDate);
			//拆分
			if ("131".equals(ZANGAODEPT[i]) || "129".equals(ZANGAODEPT[i]) || "230".equals(ZANGAODEPT[i]) ||
					"179".equals(ZANGAODEPT[i]) || "134".equals(ZANGAODEPT[i]) || "151".equals(ZANGAODEPT[i]) ||
					"210".equals(ZANGAODEPT[i]) || "153".equals(ZANGAODEPT[i]) || "135".equals(ZANGAODEPT[i]) ||
					"130".equals(ZANGAODEPT[i])) {
				if (orderDetailList != null && orderDetailList.size() > 0)
					splitOneToManyStrategy.initSplitOrderDetail(orderDetailList, ZANGAODEPT[i]);
				if (recordList != null && recordList.size() > 0)
					splitOneToManyStrategy.initSplitRecord(recordList, ZANGAODEPT[i]);
			} else {
				if (orderDetailList != null && orderDetailList.size() > 0)
					noProcessOneToOneStrategy.initSplitOrderDetail(orderDetailList, ZANGAODEPT[i]);
				if (recordList != null && recordList.size() > 0)
					noProcessOneToOneStrategy.initSplitRecord(recordList, ZANGAODEPT[i]);
			}


		}
	}

	//赛事部
	public static final String[] SAISHIDEPT = {
			"259",
			"267",
			"218",
			"191",
			"194",
			"50",
			"193",
			"192",
			"49",
			"45",
			"e53a5c2687e24bd4ae84e6ee84fa804d",
			"212",
			"177",
			"178",
			"145",
			"a5142d9719824e6a987fa090e0570b2c",
			"2f73bbd1890844cc86ae692c68e6cdfa",
			"24d78920df4e4c50bb8d03e1a4706bde",
			"9285afb4c0a147e380024edcab89399b",
			"e81a20bb6968434689cb4a42700112e3",
			"e1499d3b6b184238b668bbbe843cec94",
			"391c19bcccbe429590861a4669ace058",
			"c821501786ee4986bc079a0e58d0ed46",
			"8c77ea7c693c4765b96685db22843d8a",
			"c5e301de671549298e0e0388e47165a8",
			"ca8c0e71ec9b4efc906656bcd6d9d5a9",
			"b196aba404ce4ff2b331d32ba1e3152f",
			"bc2a3c91eac54db497e62e8b94ea8525",
			"98b615f2007c40dd999421bbb2916808",
			"14fc3fb75ea842829fc056d60e32f2c8",
			"3bf959b482aa459bbe5730fcb74ac24f",
			//2023.07.03
			"0d6afd1eef2d45ad8a2c406e597be910",
			"ac627bcf9f1c49bc8122b1028027b94c"
	};

	public void splitSaiShiDept(String startDate, String endDate, int year, HashMap<String, RelationShipEntity> relationShipMap, HashMap<String, BigDecimal> chargingPriceMap) {
		InitSplitStrategy noProcessOneToOneStrategy = new NoProcessOneToOneStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap);
		InitSplitStrategy splitOneToManyStrategy = new SplitOneToManyStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap);
		List<PaymentOrderDetail> orderDetailList = new ArrayList<PaymentOrderDetail>(20);
		List<PaymentRecord> recordList = new ArrayList<PaymentRecord>(20);
		for (int i = 0; i < SAISHIDEPT.length; i++) {
			orderDetailList.clear();
			recordList.clear();
			orderDetailList = paymentOrderDetailDao.findDetailByChargeItem(SAISHIDEPT[i], startDate, endDate);
			recordList = paymentRecordDao.findRecordByChargeItem(SAISHIDEPT[i], startDate, endDate);
			//拆分

			if ("218".equals(SAISHIDEPT[i]) || "191".equals(SAISHIDEPT[i]) || "194".equals(SAISHIDEPT[i])
					|| "50".equals(SAISHIDEPT[i]) || "193".equals(SAISHIDEPT[i]) || "192".equals(SAISHIDEPT[i]) || "49".equals(SAISHIDEPT[i])
					|| "0d6afd1eef2d45ad8a2c406e597be910".equals(SAISHIDEPT[i]) || "ac627bcf9f1c49bc8122b1028027b94c".equals(SAISHIDEPT[i])) {
				if (orderDetailList != null && orderDetailList.size() > 0)
					splitOneToManyStrategy.initSplitOrderDetail(orderDetailList, SAISHIDEPT[i]);
				if (recordList != null && recordList.size() > 0)
					splitOneToManyStrategy.initSplitRecord(recordList, SAISHIDEPT[i]);
			} else {
				if (orderDetailList != null && orderDetailList.size() > 0)
					noProcessOneToOneStrategy.initSplitOrderDetail(orderDetailList, SAISHIDEPT[i]);
				if (recordList != null && recordList.size() > 0)
					noProcessOneToOneStrategy.initSplitRecord(recordList, SAISHIDEPT[i]);
			}


		}
	}

	//美容部
	public static final String[] MEIRONGDEPT = {
			"32",
			"138b44dbd2c14394beb420799cb3d1c4",
			"33",
			"34",
			"35",
			"101",
			"39",
			"72",
			"40",
			"29",
			"27",
			"105",
			"106",
			"59523b7d19f54b82940f07ef6ac343a9",
			"41",
			"83",
			"30",
			"992c2008746f43c2be9c484d150008a4",
			"998",
			"31",
			"59",
			"146",
			"311",
			"33a073bd32b64c58b77744d887a5384e",
			"225d91b7b40d476ca6f7d7665dfaaf40",
			"5bb3495bc56c443a81aa3e74a8ae2e73",
			"20b96343190e4ba9b914b79b413f2f66",
			"381809578f254f33b08bed8d0059a1d2",
			"9b0957dc92af438eb0e9046fdc763962",
			"921cb8e18bb648a09e13a9e81bec8578",
			"49031d34292a40fab24c004b0ea1aa46",
			"46779ba4c36c4de399911e0c6ed75c68",
			"2654257cdfa1442c8f69df320b04de73",
			"4500c7fc381c47e094fd0d364ea65fe3",
			"2bdd35b2a0c7455aa14f7c3fe559e593",
			"166055e31e9649a39fb76c44ca13b058",
			"b57a51b31cad4fc8a3d1270e2546b997",
			"48724e0394824927bdfc8ddffaf197c4",
			"1a64f8a05672438b94bfb5c4c5ea87d3",
			"7ca3a44681494ed59a62c10b78a0536c",
			"86a430923fb944bc987e201e44c9913c",
			"a0e0550c59f74c0284508931ed53585c",
			"ce9342b829bf4ba0b916ee74f56f2ea9",
			"db6672386128489699a845f2174393a2",
			"f73187aed03f4955b6a72296b2e3b892",
			"d1ad21c0d8c5413380808014fb7bb03d",
			"bed7367a15b346918d1091705b2db556",
			//2024.02.01
			"97d6e885a6324ee89e370d50536c682b", "909c65809b4a41678752ce67231ca50c", "469cce7c03bd4856aad83adee6a457c2",
			"996f695d345446e2bf19b43f5126eaf2", "16d692b476584d2eb58c2853cb70f0a5", "3cccd62892f542b9a928a2485dda86da",
			"e39af5bea0b2497084d0aba8654dda65", "481063d4b6674dff815a38fef49cf160", "72cde4561c574548b287252bc5420c6c",
			"3ca9e19215284fb49f92b147f502535d", "28d74262c59f49d58198b9361f534b51",
			//2024.03.01
			"4329827604114c69bddfc8322d5ef016",
			//2024.05.06
			"0b9839845d0949ddbcbd0f391a887f77", "0743608d8f3545a9a833226077c4add0",
			//2024.08.01
			"b95300a5267642789b10212a9b74e1ff", "c70b9835ee7748a79420f331fdfb102e",
			//2024.09.02
			"7bb64fc1ef374a748dfedcb453fd9702",
			//2024.12.02
			"4dfd50872ca94491a182b98434585845", "af1f49c8c77b4a9e8011673670dd402e",
			//2025.01.06
			"ef98d59a4ded42ca9f3e6588e8716581", "c1fc52daecf946eca38e7d67b813dfda", "cbccf91be86843269ef9c4e6c7134286",
			"8a6c195ab66443b6b890c473a1f3d8bd", "def26f02ccb641a58751a84f58474e36", "ed5f46d4fa7844dd9ed3044e2fbfddca",
			"b598dc92b5bb4b9b96587f5dc36e2381",
			"0a1fba1486234c13ad8fec7c6ca8d70f", "1a6dd8c513234b15a068498ca9121b8e",
			"421cb05b25994be0abb197b87c45f178",
			//2025.07.01
			"e0928b89071d4f1499a716446329befb", "3df58af369db4d9d825bb018d1becb89",

	};

	public void splitMeiRongDept(String startDate, String endDate, int year, HashMap<String, RelationShipEntity> relationShipMap, HashMap<String, BigDecimal> chargingPriceMap) {
		InitSplitStrategy noProcessOneToOneStrategy = new NoProcessOneToOneStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap);
		InitSplitStrategy splitOneToManyStrategy = new SplitOneToManyStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap);
		InitSplitStrategy splitYearToMonthStrategy12 = new SplitYearToMonthStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap, 12);
		InitSplitStrategy splitYearToMonthStrategy36 = new SplitYearToMonthStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap, 36);
		List<PaymentOrderDetail> orderDetailList = new ArrayList<PaymentOrderDetail>(20);
		List<PaymentRecord> recordList = new ArrayList<PaymentRecord>(20);
		for (int i = 0; i < MEIRONGDEPT.length; i++) {
			orderDetailList.clear();
			recordList.clear();
			orderDetailList = paymentOrderDetailDao.findDetailByChargeItem(MEIRONGDEPT[i], startDate, endDate);
			recordList = paymentRecordDao.findRecordByChargeItem(MEIRONGDEPT[i], startDate, endDate);

			//拆分
			if ("33".equals(MEIRONGDEPT[i]) || "34".equals(MEIRONGDEPT[i]) || "35".equals(MEIRONGDEPT[i])
					|| "101".equals(MEIRONGDEPT[i]) || "29".equals(MEIRONGDEPT[i]) || "bed7367a15b346918d1091705b2db556".equals(MEIRONGDEPT[i])
					|| "97d6e885a6324ee89e370d50536c682b".equals(MEIRONGDEPT[i]) || "909c65809b4a41678752ce67231ca50c".equals(MEIRONGDEPT[i])
					|| "469cce7c03bd4856aad83adee6a457c2".equals(MEIRONGDEPT[i]) || "996f695d345446e2bf19b43f5126eaf2".equals(MEIRONGDEPT[i])
					|| "16d692b476584d2eb58c2853cb70f0a5".equals(MEIRONGDEPT[i]) || "3cccd62892f542b9a928a2485dda86da".equals(MEIRONGDEPT[i])
					|| "e39af5bea0b2497084d0aba8654dda65".equals(MEIRONGDEPT[i]) || "481063d4b6674dff815a38fef49cf160".equals(MEIRONGDEPT[i])
					|| "72cde4561c574548b287252bc5420c6c".equals(MEIRONGDEPT[i]) || "b95300a5267642789b10212a9b74e1ff".equals(MEIRONGDEPT[i])
					|| "4dfd50872ca94491a182b98434585845".equals(MEIRONGDEPT[i]) || "af1f49c8c77b4a9e8011673670dd402e".equals(MEIRONGDEPT[i])
					|| "ef98d59a4ded42ca9f3e6588e8716581".equals(MEIRONGDEPT[i]) || "c1fc52daecf946eca38e7d67b813dfda".equals(MEIRONGDEPT[i])
					|| "cbccf91be86843269ef9c4e6c7134286".equals(MEIRONGDEPT[i]) || "8a6c195ab66443b6b890c473a1f3d8bd".equals(MEIRONGDEPT[i])
					|| "def26f02ccb641a58751a84f58474e36".equals(MEIRONGDEPT[i]) || "ed5f46d4fa7844dd9ed3044e2fbfddca".equals(MEIRONGDEPT[i])
					|| "b598dc92b5bb4b9b96587f5dc36e2381".equals(MEIRONGDEPT[i])) {
				if (orderDetailList != null && orderDetailList.size() > 0)
					splitOneToManyStrategy.initSplitOrderDetail(orderDetailList, MEIRONGDEPT[i]);
				if (recordList != null && recordList.size() > 0)
					splitOneToManyStrategy.initSplitRecord(recordList, MEIRONGDEPT[i]);

				// 美容师预备会员费  reserve
			} else if ("105".equals(MEIRONGDEPT[i])
					|| "0b9839845d0949ddbcbd0f391a887f77".equals(MEIRONGDEPT[i])) {
				if (orderDetailList != null && orderDetailList.size() > 0) {
					for (PaymentOrderDetail orderDetail : orderDetailList) {
						String hrmember = orderDetail.getMemberCode();
						Member member = memberService.getByMemberCode(hrmember);
						if (member == null || member.getGroomerType() == null || (!"reserve".equals(member.getGroomerType())) || member.getGroomerEndDate() == null) {
							orderDetail.setSplitBeginDate(orderDetail.getAddTime());
						} else {
							orderDetail.setSplitBeginDate(YearToMonthSplitUtils.getBeforeDate(member.getGroomerEndDate(), orderDetail.getAddTime()));
						}

					}
					splitYearToMonthStrategy12.initSplitOrderDetail(orderDetailList, MEIRONGDEPT[i]);
				}
				if (recordList != null && recordList.size() > 0) {
					for (PaymentRecord record : recordList) {
						String hrmember = record.getMemberCode();
						Member member = memberService.getByMemberCode(hrmember);
						if (member == null || member.getGroomerType() == null || (!"reserve".equals(member.getGroomerType())) || member.getGroomerEndDate() == null) {
							record.setSplitBeginDate(record.getPaymentTime());
						} else {
							record.setSplitBeginDate(YearToMonthSplitUtils.getBeforeDate(member.getGroomerEndDate(), record.getPaymentTime()));
						}
					}
					splitYearToMonthStrategy12.initSplitRecord(recordList, MEIRONGDEPT[i]);
				}
				//美容师正式会员费 formal
			} else if ("106".equals(MEIRONGDEPT[i]) || "3ca9e19215284fb49f92b147f502535d".equals(MEIRONGDEPT[i])) {

				if (orderDetailList != null && orderDetailList.size() > 0) {
					for (PaymentOrderDetail orderDetail : orderDetailList) {
						String hrmember = orderDetail.getMemberCode();
						Member member = memberService.getByMemberCode(hrmember);
						if (member == null || member.getGroomerType() == null || (!"formal".equals(member.getGroomerType())) || member.getGroomerEndDate() == null) {
							orderDetail.setSplitBeginDate(orderDetail.getAddTime());
						} else {
							orderDetail.setSplitBeginDate(YearToMonthSplitUtils.getBeforeDate(member.getGroomerEndDate(), orderDetail.getAddTime()));
						}

					}
					splitYearToMonthStrategy12.initSplitOrderDetail(orderDetailList, MEIRONGDEPT[i]);
				}
				if (recordList != null && recordList.size() > 0) {
					for (PaymentRecord record : recordList) {
						String hrmember = record.getMemberCode();
						Member member = memberService.getByMemberCode(hrmember);
						if (member == null || member.getGroomerType() == null || (!"formal".equals(member.getGroomerType())) || member.getGroomerEndDate() == null) {
							record.setSplitBeginDate(record.getPaymentTime());
						} else {
							record.setSplitBeginDate(YearToMonthSplitUtils.getBeforeDate(member.getGroomerEndDate(), record.getPaymentTime()));
						}
					}
					splitYearToMonthStrategy12.initSplitRecord(recordList, MEIRONGDEPT[i]);
				}

			} else if ("d1ad21c0d8c5413380808014fb7bb03d".equals(MEIRONGDEPT[i])) {
				if (orderDetailList != null && orderDetailList.size() > 0) {
					for (PaymentOrderDetail orderDetail : orderDetailList) {
						orderDetail.setSplitBeginDate(orderDetail.getAddTime());
					}
					splitYearToMonthStrategy36.initSplitOrderDetail(orderDetailList, MEIRONGDEPT[i]);
				}
				if (recordList != null && recordList.size() > 0) {
					for (PaymentRecord record : recordList) {
						record.setSplitBeginDate(record.getPaymentTime());
					}
					splitYearToMonthStrategy36.initSplitRecord(recordList, MEIRONGDEPT[i]);
				}
			} else if ("27".equals(MEIRONGDEPT[i])) {
				if (orderDetailList != null && orderDetailList.size() > 0) {
					for (PaymentOrderDetail orderDetail : orderDetailList) {
						String yymember = orderDetail.getMemberCode();
						TrainingInstitution trainingInstitution = null;
						if (yymember.indexOf("MRHZ") > -1) {
							trainingInstitution = trainingInstitutionDao.getBySchoolMemberCode(yymember);
						} else {
							trainingInstitution = trainingInstitutionDao.getByMemberCode(yymember);
						}
						if (trainingInstitution == null || trainingInstitution.getEndDate() == null) {
							orderDetail.setSplitBeginDate(orderDetail.getAddTime());
						} else {
							orderDetail.setSplitBeginDate(YearToMonthSplitUtils.getBeforeDate(trainingInstitution.getEndDate(), orderDetail.getAddTime()));
						}

					}
					splitYearToMonthStrategy12.initSplitOrderDetail(orderDetailList, MEIRONGDEPT[i]);
				}

				if (recordList != null && recordList.size() > 0) {
					for (PaymentRecord record : recordList) {
						String yymember = record.getMemberCode();
						TrainingInstitution trainingInstitution = null;
						if (yymember.indexOf("MRHZ") > -1) {
							trainingInstitution = trainingInstitutionDao.getBySchoolMemberCode(yymember);
						} else {
							trainingInstitution = trainingInstitutionDao.getByMemberCode(yymember);
						}
						if (trainingInstitution == null || trainingInstitution.getEndDate() == null) {
							record.setSplitBeginDate(record.getPaymentTime());
						} else {
							record.setSplitBeginDate(YearToMonthSplitUtils.getBeforeDate(trainingInstitution.getEndDate(), record.getPaymentTime()));
						}
					}
					splitYearToMonthStrategy12.initSplitRecord(recordList, MEIRONGDEPT[i]);
				}
			} else {
				if (orderDetailList != null && orderDetailList.size() > 0)
					noProcessOneToOneStrategy.initSplitOrderDetail(orderDetailList, MEIRONGDEPT[i]);
				if (recordList != null && recordList.size() > 0)
					noProcessOneToOneStrategy.initSplitRecord(recordList, MEIRONGDEPT[i]);
			}


		}
	}

	//爱萌犬
	public static final String[] AIMENGDEPT = {
			"a064682336fd4443853a70d9362460be",
			"97e8411e1f2f40989bc41a5d092f8f98"
	};

	public void splitAiMengDept(String startDate, String endDate, int year, HashMap<String, RelationShipEntity> relationShipMap, HashMap<String, BigDecimal> chargingPriceMap) {
		InitSplitStrategy noProcessOneToOneStrategy = new NoProcessOneToOneStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap);
		List<PaymentOrderDetail> orderDetailList = new ArrayList<PaymentOrderDetail>(20);
		List<PaymentRecord> recordList = new ArrayList<PaymentRecord>(20);
		for (int i = 0; i < AIMENGDEPT.length; i++) {
			orderDetailList.clear();
			recordList.clear();
			orderDetailList = paymentOrderDetailDao.findDetailByChargeItem(AIMENGDEPT[i], startDate, endDate);
			recordList = paymentRecordDao.findRecordByChargeItem(AIMENGDEPT[i], startDate, endDate);

			if (orderDetailList != null && orderDetailList.size() > 0)
				noProcessOneToOneStrategy.initSplitOrderDetail(orderDetailList, AIMENGDEPT[i]);
			if (recordList != null && recordList.size() > 0)
				noProcessOneToOneStrategy.initSplitRecord(recordList, AIMENGDEPT[i]);

		}
	}

	//平面媒体
	public static final String[] PINGMIANMEITI = {
			"bc752bfeeaeb4038b264f0312495c80d",
			"aef73cbd37de41fc9a2677d32e625926",
			"5a3a51ede9e7420aa72ac70316676ada",
			"45a8f024c58f4c33b7992ea73c83c0a7",
			"0eaae963b5874417bd26cc880a2ba0cb",
			"0c41d24455fd4d01aaeaf228b5ad7796",
			"2d81d1b4a7a648748057060b10d43d76",
			"8661d886e3fd41f2a1626e66059942f5",
			"944143f6aa264e4482feb317fef19567",
			"a9ba4466d2d9472d907e34775976c157",
			"2d82a6f76824418aa5f00c0e6652b155",
	};

	public void splitPingmianmeiti(String startDate, String endDate, int year, HashMap<String, RelationShipEntity> relationShipMap, HashMap<String, BigDecimal> chargingPriceMap) {
		InitSplitStrategy noProcessOneToOneStrategy = new NoProcessOneToOneStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap);

		List<PaymentOrderDetail> orderDetailList = new ArrayList<PaymentOrderDetail>(20);
		List<PaymentRecord> recordList = new ArrayList<PaymentRecord>(20);
		for (int i = 0; i < PINGMIANMEITI.length; i++) {
			orderDetailList.clear();
			recordList.clear();
			orderDetailList = paymentOrderDetailDao.findDetailByChargeItem(PINGMIANMEITI[i], startDate, endDate);
			recordList = paymentRecordDao.findRecordByChargeItem(PINGMIANMEITI[i], startDate, endDate);

			if (orderDetailList != null && orderDetailList.size() > 0)
				noProcessOneToOneStrategy.initSplitOrderDetail(orderDetailList, PINGMIANMEITI[i]);
			if (recordList != null && recordList.size() > 0)
				noProcessOneToOneStrategy.initSplitRecord(recordList, PINGMIANMEITI[i]);
		}

	}

	//门店渠道部
	public static final String[] MENDIANQUDAOBU = {
			"e2e26a94169c41e588551ce9d9197fd6",
			"24987cf2e7cd44cb959bfc05b4f43fc4",
			"ff1651a694724ad6bdc66d74de44b256",
			"96b80592faeb41a18a7343c63490ffc0",
			"005bf368da2447d2bcdaf4a66a81ac33"
	};

	public void splitMendainqudaobu(String startDate, String endDate, int year, HashMap<String, RelationShipEntity> relationShipMap, HashMap<String, BigDecimal> chargingPriceMap) {
		InitSplitStrategy splitYearToMonthStrategy12 = new SplitYearToMonthStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap, 12);

		List<PaymentOrderDetail> orderDetailList = new ArrayList<PaymentOrderDetail>(20);
		List<PaymentRecord> recordList = new ArrayList<PaymentRecord>(20);
		for (int i = 0; i < MENDIANQUDAOBU.length; i++) {
			orderDetailList.clear();
			recordList.clear();
			orderDetailList = paymentOrderDetailDao.findDetailByChargeItem(MENDIANQUDAOBU[i], startDate, endDate);
			recordList = paymentRecordDao.findRecordByChargeItem(MENDIANQUDAOBU[i], startDate, endDate);

			if ("e2e26a94169c41e588551ce9d9197fd6".equals(MENDIANQUDAOBU[i])
					|| "96b80592faeb41a18a7343c63490ffc0".equals(MENDIANQUDAOBU[i])
					|| "005bf368da2447d2bcdaf4a66a81ac33".equals(MENDIANQUDAOBU[i])) {
				if (orderDetailList != null && orderDetailList.size() > 0) {
					for (PaymentOrderDetail orderDetail : orderDetailList) {
						orderDetail.setSplitBeginDate(orderDetail.getAddTime());
					}
					splitYearToMonthStrategy12.initSplitOrderDetail(orderDetailList, MENDIANQUDAOBU[i]);
				}
				if (recordList != null && recordList.size() > 0) {
					for (PaymentRecord record : recordList) {
						record.setSplitBeginDate(record.getPaymentTime());
					}
					splitYearToMonthStrategy12.initSplitRecord(recordList, MENDIANQUDAOBU[i]);
				}
			}

		}

	}

	//门店渠道部
	public static final String[] YINGXIAOBU = {
			"1303518712e54a3bb9f3339d479aa75d",
			"dc60531b20074952a44ce060ccd7430e",
	};

	public void splitYingxiao(String startDate, String endDate, int year, HashMap<String, RelationShipEntity> relationShipMap, HashMap<String, BigDecimal> chargingPriceMap) {
		InitSplitStrategy noProcessOneToOneStrategy = new NoProcessOneToOneStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap);

		List<PaymentOrderDetail> orderDetailList = new ArrayList<PaymentOrderDetail>(20);
		List<PaymentRecord> recordList = new ArrayList<PaymentRecord>(20);
		for (int i = 0; i < YINGXIAOBU.length; i++) {
			orderDetailList.clear();
			recordList.clear();
			orderDetailList = paymentOrderDetailDao.findDetailByChargeItem(YINGXIAOBU[i], startDate, endDate);
			recordList = paymentRecordDao.findRecordByChargeItem(YINGXIAOBU[i], startDate, endDate);

			if (orderDetailList != null && orderDetailList.size() > 0)
				noProcessOneToOneStrategy.initSplitOrderDetail(orderDetailList, YINGXIAOBU[i]);
			if (recordList != null && recordList.size() > 0)
				noProcessOneToOneStrategy.initSplitRecord(recordList, YINGXIAOBU[i]);
		}
	}

	//宠物店
	public static final String[] CHONGWUDIAN = {
			"9e3d51bf43754ea190f7f68da9aae817",
			"644132ab3e06413e8a01e46d59afa17a",
			"292a74d8249d44a88365fee44a2818b2"
	};

	public void splitChongwudian(String startDate, String endDate, int year, HashMap<String, RelationShipEntity> relationShipMap, HashMap<String, BigDecimal> chargingPriceMap) {
		InitSplitStrategy noProcessOneToOneStrategy = new NoProcessOneToOneStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap);
		InitSplitStrategy splitYearToMonthStrategy12 = new SplitYearToMonthStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap, 12);

		List<PaymentOrderDetail> orderDetailList = new ArrayList<PaymentOrderDetail>(20);
		List<PaymentRecord> recordList = new ArrayList<PaymentRecord>(20);
		for (int i = 0; i < CHONGWUDIAN.length; i++) {
			orderDetailList.clear();
			recordList.clear();
			orderDetailList = paymentOrderDetailDao.findDetailByChargeItem(CHONGWUDIAN[i], startDate, endDate);
			recordList = paymentRecordDao.findRecordByChargeItem(CHONGWUDIAN[i], startDate, endDate);

			if ("292a74d8249d44a88365fee44a2818b2".equals(CHONGWUDIAN[i]) || "644132ab3e06413e8a01e46d59afa17a".equals(CHONGWUDIAN[i])) {
				//外籍会员年度登记费
				if (orderDetailList != null && orderDetailList.size() > 0) {
					for (PaymentOrderDetail orderDetail : orderDetailList) {
						orderDetail.setSplitBeginDate(orderDetail.getAddTime());
					}
					splitYearToMonthStrategy12.initSplitOrderDetail(orderDetailList, CHONGWUDIAN[i]);
				}
				if (recordList != null && recordList.size() > 0) {
					for (PaymentRecord record : recordList) {
						record.setSplitBeginDate(record.getPaymentTime());
					}
					splitYearToMonthStrategy12.initSplitRecord(recordList, CHONGWUDIAN[i]);
				}

			} else {
				if (orderDetailList != null && orderDetailList.size() > 0)
					noProcessOneToOneStrategy.initSplitOrderDetail(orderDetailList, CHONGWUDIAN[i]);
				if (recordList != null && recordList.size() > 0)
					noProcessOneToOneStrategy.initSplitRecord(recordList, CHONGWUDIAN[i]);
			}
		}

	}

	//培训部
	public static final String[] PEIXUNDEPT = {
			"85",
			"36",
			"37",
			"38",
			"201",
			"254",
			"171",
			"170",
			"92",
			"186",
			"102",
			"103",
			"43",
			"86",
			"255",
			"172",
			"44",
			"98",
			"283",
			"198",
			"211",
			"159",
			"205",
			"456",
			"284",
			"252",
			"94",
			"366",
			"253",
			"95",
			"108",
			"109",
			"147",
			"e957c1373c744b26a5866b795a15bf48",
			"62818c904fed4d06bd215080bdd7e652",
			"b2ed91bbe772425ba6ecbcf3000d7e8d",
			"8f6e5ea2c4db4cfaa7e465435df06173",
			//新增
			"307",
			//Bh审查培训证书
			"310",
			"316",
			"317",
			"318",
			"319",
			"320",
			"321",
			"322",
			"323",
			"324",
			"325",
			"2bb9549794cc4757996b64574ea5fa4f",
			"d923d3ce76c24fa8bd6f695cb4885270",
			"0cbf012cf2cb4c59a1db0731a59cb575",
			"34d80b3bdbe44c5380b2e82dfd8a94ef",
			"c15785a93e224ef9ab9e3059ef652f45",
			"ba6b3b03a6af4a138dd3c3e03800ab1c",
			"fb84ccb10ced4a74a33dd5679b72cfb8",
			"61c851d0d3064676b51c2846a9d1e580",
			"6adc404e0ec8423891986d4c7fe0dd15",
			"861ae984947b4136989c34dbbe7d36c6",
			"af50807b2c5a4fbdb4ecb3d52a0ab536",
			"de747e854e0d4c559b4f31eb1878787c",
			"5fe44bed80dc478c95a0fe8f37498c7e",
			"4fb73289dd464530ad8657c9551e8fbe",
			"73b9ae46bc6b4aaf8026c16a1d3ed339",
			"fe25a3dedb2541a5a4a4ec34092a7f86",
			"64b70616c06746e595dfe29b5c388dae",
			"16f9033a3c7c400981d30253b637c4d0",
			"ad0a591e8d934b308acbd42eaa05c154",
			"fe535c0a0be546379351b9f50444da3a",
			"ab8245b66e9e436d8a5cfec5b465eb0c",
			"02cd9ffbbe6944fb99b7b7ceb53cc78a",
			"0bac5dfadd4444f8a69ed86391d21c8d",
			"26a2df03973e439ca04781e769b617ab",
			"299dde5e324548faa27d911d6bfd23e6",
			"36e6676f38364d30a3a88889936801f0",
			"3b5112bdc7ac48ba85b64b9a41755d4c",
			"4437f551fb8c4da386e38a48f355b4be",
			"54ee7bc98fbf424b8a41b438e61602c4",
			"66e8abc81cec4079bdd9cfcd6a8d4864",
			"88a72b0bdb684355bbcb2e58cbe8b8bb",
			"8b79c519ad0e4a97b88d62053b43e715",
			"8ea476cd6d1b42daa1a0e42f3c2fbdb9",
			"9393b0f613dc4bb38ff493c23c3cc371",
			"a2dfc4f22fe34a539f7636438b69669e",
			"a5c2e883d4c94ece8b356efdc48a0e1e",
			"b259f6c402144bf89bc0731323320c23",
			"d65aaea898b7447f8d5d8a6fcda6ed6c",
			"e2ff70b6c00244eabfa54c6e58d48423",
			"e8c26fce2f93416f8d3ce3f4152b199c",
			"f15f0cdb4ef5410caec4c0a4d281ffb6",
			"f5162ebc9cc2440a993a86aa50ee72a9",
			"f806c52b2b9e4ad6805de9f96ffdf89f",
			"ffb7a3efeda2487897a5e8ff1e2e481f",
			"89d66c56b2fa489e9ef9ce459cc42e49",
			"3a3d3551db0b4e1aab72579b99602865",
			"3e2661bc5bb84c5e93c78be42ce02104",
			"b1611c6f4eac4588b0c4419ef83b5144",
			"a2099580df654fd099b115f502dc8a77",
			"71c9017661ef41168bcdc03410128d2b",
			"17850f6f19c04c30904188575af6eb35",
			"da8f743b648c4f369fc19ebb31662ad1",
			"54882179cba04b988cbdab61b1d9a7e3",
			"265a2cbd74464dc58bda3b3a86cd8518",
			//2024.02.01
			"48f8b77c3ad94ac1bb17aa91ef199f27", "6a91b4bbe7e94d248c6e174c5bdef8d5", "1ee5686f97f6480c94e09d6332791cb5",
			//2024.07.01
			"35d3c83b9a17455090b2a1485e154372",
			//2025.02.06
			"acd9d8af9a2442eb8e25d94b95a9652f",
			//2025.07.01
			"0650a285501943369e561a1f05891349", "973b8836a2ed4884a895d5bcea9291a9", "ea51106dab0849bca544ff21f8da992b",
			"0513a5133406480aa17c7c41a470785f", "5b4f7bf7eec34f50a77184f329a08f87", "aa2866c302f645a29f2c227040210d65",
			//2025.08.01
			"9e82db321c7e45dc95ae36f9526442f7","4009f250481c44e19c560929be6f0660"
	};

	public void splitPeiXunDept(String startDate, String endDate, int year, HashMap<String, RelationShipEntity> relationShipMap, HashMap<String, BigDecimal> chargingPriceMap) {
		InitSplitStrategy noProcessOneToOneStrategy = new NoProcessOneToOneStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap);
		InitSplitStrategy splitOneToManyStrategy = new SplitOneToManyStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap);
		InitSplitStrategy splitYearToMonthStrategy12 = new SplitYearToMonthStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap, 12);
		InitSplitStrategy splitYearToMonthStrategy2 = new SplitYearToMonthStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap, 2);
		InitSplitStrategy splitYearToMonthStrategy60 = new SplitYearToMonthStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap, 60);
		InitSplitStrategy splitYearToMonthWithTowStrategy24 = new SplitYearToMonthWithTowStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap, 24, "cab");
		List<PaymentOrderDetail> orderDetailList = new ArrayList<PaymentOrderDetail>(20);
		List<PaymentRecord> recordList = new ArrayList<PaymentRecord>(20);
		for (int i = 0; i < PEIXUNDEPT.length; i++) {
			orderDetailList.clear();
			recordList.clear();
			orderDetailList = paymentOrderDetailDao.findDetailByChargeItem(PEIXUNDEPT[i], startDate, endDate);
			recordList = paymentRecordDao.findRecordByChargeItem(PEIXUNDEPT[i], startDate, endDate);

			//拆分
			if ("85".equals(PEIXUNDEPT[i]) || "36".equals(PEIXUNDEPT[i]) || "37".equals(PEIXUNDEPT[i]) || "38".equals(PEIXUNDEPT[i]) || "201".equals(PEIXUNDEPT[i])
					|| "98".equals(PEIXUNDEPT[i]) || "94".equals(PEIXUNDEPT[i]) || "62818c904fed4d06bd215080bdd7e652".equals(PEIXUNDEPT[i]) || "b2ed91bbe772425ba6ecbcf3000d7e8d".equals(PEIXUNDEPT[i])
					|| "e957c1373c744b26a5866b795a15bf48".equals(PEIXUNDEPT[i]) || "317".equals(PEIXUNDEPT[i]) || "319".equals(PEIXUNDEPT[i])
					|| "324".equals(PEIXUNDEPT[i]) || "325".equals(PEIXUNDEPT[i]) || "2bb9549794cc4757996b64574ea5fa4f".equals(PEIXUNDEPT[i])
					|| "da8f743b648c4f369fc19ebb31662ad1".equals(PEIXUNDEPT[i]) || "265a2cbd74464dc58bda3b3a86cd8518".equals(PEIXUNDEPT[i])
					|| "acd9d8af9a2442eb8e25d94b95a9652f".equals(PEIXUNDEPT[i])
					|| "0513a5133406480aa17c7c41a470785f".equals(PEIXUNDEPT[i]) || "5b4f7bf7eec34f50a77184f329a08f87".equals(PEIXUNDEPT[i])
					|| "aa2866c302f645a29f2c227040210d65".equals(PEIXUNDEPT[i])
					|| "4009f250481c44e19c560929be6f0660".equals(PEIXUNDEPT[i])) {
				if (orderDetailList != null && orderDetailList.size() > 0)
					splitOneToManyStrategy.initSplitOrderDetail(orderDetailList, PEIXUNDEPT[i]);
				if (recordList != null && recordList.size() > 0)
					splitOneToManyStrategy.initSplitRecord(recordList, PEIXUNDEPT[i]);
			} else if ("102".equals(PEIXUNDEPT[i]) || "103".equals(PEIXUNDEPT[i]) || "1ee5686f97f6480c94e09d6332791cb5".equals(PEIXUNDEPT[i])) {
				if (orderDetailList != null && orderDetailList.size() > 0) {
					for (PaymentOrderDetail orderDetail : orderDetailList) {
						String yymember = orderDetail.getMemberCode();
						TrainingInstitution trainingInstitution = trainingInstitutionDao.getByMemberCode(yymember);
						if (trainingInstitution == null || trainingInstitution.getEndDate() == null) {
							orderDetail.setSplitBeginDate(orderDetail.getAddTime());
						} else {
							orderDetail.setSplitBeginDate(YearToMonthSplitUtils.getBeforeDate(trainingInstitution.getEndDate(), orderDetail.getAddTime()));
						}

					}
					splitYearToMonthStrategy12.initSplitOrderDetail(orderDetailList, PEIXUNDEPT[i]);
				}

				if (recordList != null && recordList.size() > 0) {
					for (PaymentRecord record : recordList) {
						String yymember = record.getMemberCode();
						TrainingInstitution trainingInstitution = trainingInstitutionDao.getByMemberCode(yymember);
						if (trainingInstitution == null || trainingInstitution.getEndDate() == null) {
							record.setSplitBeginDate(record.getPaymentTime());
						} else {
							record.setSplitBeginDate(YearToMonthSplitUtils.getBeforeDate(trainingInstitution.getEndDate(), record.getPaymentTime()));
						}
					}
					splitYearToMonthStrategy12.initSplitRecord(recordList, PEIXUNDEPT[i]);
				}
			} else if ("102".equals(PEIXUNDEPT[i]) || "103".equals(PEIXUNDEPT[i])) {
				if (orderDetailList != null && orderDetailList.size() > 0) {
					for (PaymentOrderDetail orderDetail : orderDetailList) {
						String yymember = orderDetail.getMemberCode();
						TrainingInstitution trainingInstitution = trainingInstitutionDao.getByMemberCode(yymember);
						if (trainingInstitution == null || trainingInstitution.getEndDate() == null) {
							orderDetail.setSplitBeginDate(orderDetail.getAddTime());
						} else {
							orderDetail.setSplitBeginDate(YearToMonthSplitUtils.getBeforeDate(trainingInstitution.getEndDate(), orderDetail.getAddTime()));
						}

					}
					splitYearToMonthStrategy12.initSplitOrderDetail(orderDetailList, PEIXUNDEPT[i]);
				}

				if (recordList != null && recordList.size() > 0) {
					for (PaymentRecord record : recordList) {
						String yymember = record.getMemberCode();
						TrainingInstitution trainingInstitution = trainingInstitutionDao.getByMemberCode(yymember);
						if (trainingInstitution == null || trainingInstitution.getEndDate() == null) {
							record.setSplitBeginDate(record.getPaymentTime());
						} else {
							record.setSplitBeginDate(YearToMonthSplitUtils.getBeforeDate(trainingInstitution.getEndDate(), record.getPaymentTime()));
						}
					}
					splitYearToMonthStrategy12.initSplitRecord(recordList, PEIXUNDEPT[i]);
				}
			} else if ("95".equals(PEIXUNDEPT[i]) || "16f9033a3c7c400981d30253b637c4d0".equals(PEIXUNDEPT[i]) || "ad0a591e8d934b308acbd42eaa05c154".equals(PEIXUNDEPT[i])) {
				if (orderDetailList != null && orderDetailList.size() > 0) {
					for (PaymentOrderDetail orderDetail : orderDetailList) {
						orderDetail.setSplitBeginDate(orderDetail.getAddTime());
					}
					splitYearToMonthStrategy60.initSplitOrderDetail(orderDetailList, PEIXUNDEPT[i]);
				}

				if (recordList != null && recordList.size() > 0) {
					for (PaymentRecord record : recordList) {
						record.setSplitBeginDate(record.getPaymentTime());
					}
					splitYearToMonthStrategy60.initSplitRecord(recordList, PEIXUNDEPT[i]);
				}
			} else if ("320".equals(PEIXUNDEPT[i])) {
				if (orderDetailList != null && orderDetailList.size() > 0) {
					for (PaymentOrderDetail orderDetail : orderDetailList) {
						orderDetail.setSplitBeginDate(orderDetail.getAddTime());
					}
					splitYearToMonthStrategy2.initSplitOrderDetail(orderDetailList, "95");
				}

				if (recordList != null && recordList.size() > 0) {
					for (PaymentRecord record : recordList) {
						record.setSplitBeginDate(record.getPaymentTime());
					}
					splitYearToMonthStrategy2.initSplitRecord(recordList, "95");
				}
			} else if ("64b70616c06746e595dfe29b5c388dae".equals(PEIXUNDEPT[i])) {//CKU牵犬师合作学校年费拆分
				if (orderDetailList != null && orderDetailList.size() > 0) {
					for (PaymentOrderDetail orderDetail : orderDetailList) {
						orderDetail.setSplitBeginDate(orderDetail.getAddTime());
					}
					splitYearToMonthStrategy12.initSplitOrderDetail(orderDetailList, PEIXUNDEPT[i]);
				}
				if (recordList != null && recordList.size() > 0) {
					for (PaymentRecord record : recordList) {
						record.setSplitBeginDate(record.getPaymentTime());
					}
					splitYearToMonthStrategy12.initSplitRecord(recordList, PEIXUNDEPT[i]);
				}

			} else {
				if (orderDetailList != null && orderDetailList.size() > 0)
					noProcessOneToOneStrategy.initSplitOrderDetail(orderDetailList, PEIXUNDEPT[i]);
				if (recordList != null && recordList.size() > 0)
					noProcessOneToOneStrategy.initSplitRecord(recordList, PEIXUNDEPT[i]);
			}


		}
	}

	//企管中心
	public static final String[] QIGUANDEPT = {"5349519101be4fc9b2ee81677019f21b", "790a4f21f33f4ac5903a452c92cfa15d", "8af3b7250f974929921b89756c0622c6"};

	//企管中心 拆分方法
	public void splitQiGuan(String startDate, String endDate, int year, HashMap<String, RelationShipEntity> relationShipMap, HashMap<String, BigDecimal> chargingPriceMap) {
		InitSplitStrategy noProcessOneToOneStrategy = new NoProcessOneToOneStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap);
		List<PaymentOrderDetail> orderDetailList = new ArrayList<>(20);
		List<PaymentRecord> recordList = new ArrayList<>(20);
		for (int i = 0; i < QIGUANDEPT.length; i++) {
			orderDetailList.clear();
			recordList.clear();
			orderDetailList = paymentOrderDetailDao.findDetailByChargeItem(QIGUANDEPT[i], startDate, endDate);
			recordList = paymentRecordDao.findRecordByChargeItem(QIGUANDEPT[i], startDate, endDate);

			if (orderDetailList != null && orderDetailList.size() > 0)
				noProcessOneToOneStrategy.initSplitOrderDetail(orderDetailList, QIGUANDEPT[i]);
			if (recordList != null && recordList.size() > 0)
				noProcessOneToOneStrategy.initSplitRecord(recordList, QIGUANDEPT[i]);
		}
	}

	//事务部
	public static final String[] SHIWUDEPT = {"ad9ca2f0141f415385cced5c1a0f6ee0"};

	//事务部 拆分方法
	public void splitShiWu(String startDate, String endDate, int year, HashMap<String, RelationShipEntity> relationShipMap, HashMap<String, BigDecimal> chargingPriceMap) {
		InitSplitStrategy noProcessOneToOneStrategy = new NoProcessOneToOneStrategy(saPaymentDetailService, relationShipMap, chargingPriceMap);
		List<PaymentOrderDetail> orderDetailList = new ArrayList<>(20);
		List<PaymentRecord> recordList = new ArrayList<>(20);
		for (int i = 0; i < QIGUANDEPT.length; i++) {
			orderDetailList.clear();
			recordList.clear();
			orderDetailList = paymentOrderDetailDao.findDetailByChargeItem(QIGUANDEPT[i], startDate, endDate);
			recordList = paymentRecordDao.findRecordByChargeItem(QIGUANDEPT[i], startDate, endDate);

			if (orderDetailList != null && orderDetailList.size() > 0)
				noProcessOneToOneStrategy.initSplitOrderDetail(orderDetailList, QIGUANDEPT[i]);
			if (recordList != null && recordList.size() > 0)
				noProcessOneToOneStrategy.initSplitRecord(recordList, QIGUANDEPT[i]);
		}
	}

	//    @Transactional(readOnly = false)
	public void initSplit(String startDate, String endDate, int year) {
		//查询所有拆分后价格 id 封装
		HashMap<String, BigDecimal> chargingPriceMap = new HashMap<String, BigDecimal>(2 << 8);
		List<Map> cablist = cabFinanceStatisticsDao.cabChargeItem();
		List<Map> ckulist = cabFinanceStatisticsDao.ckuChargeItem();
		for (Map cabm : cablist) {
			chargingPriceMap.put((String) cabm.get("id"), (BigDecimal) cabm.get("price"));
		}
		for (Map ckum : ckulist) {
			chargingPriceMap.put((String) ckum.get("id"), (BigDecimal) ckum.get("price"));
		}

		HashMap<String, RelationShipEntity> relationShipMap = new HashMap<String, RelationShipEntity>(2 << 8);
		List<Map> relist = cabFinanceStatisticsDao.relationShip();
		for (Map re : relist) {
			relationShipMap.put((String) re.get("id"), new RelationShipEntity((String) re.get("id"), re.get("CAB") != null ? (String) re.get("CAB") : null, re.get("CKU") != null ? (String) re.get("CKU") : null, (String) re.get("dept")));
		}

		Date start = new Date();
		splitOtherDept(startDate, endDate, year, relationShipMap, chargingPriceMap);
		System.out.println("其他--------------------------------------------");
		splitGENEDept(startDate, endDate, year, relationShipMap, chargingPriceMap);
		System.out.println("繁育基数项目--------------------------------------------");
		splitFaZhanDept(startDate, endDate, year, relationShipMap, chargingPriceMap);
		System.out.println("企业发展部--------------------------------------------");
		splitChongQingDept(startDate, endDate, year, relationShipMap, chargingPriceMap);
		System.out.println("重庆办事处--------------------------------------------");
		splitChangchongDept(startDate, endDate, year, relationShipMap, chargingPriceMap);
		System.out.println("长春办事处--------------------------------------------");
		splitHangZhouDept(startDate, endDate, year, relationShipMap, chargingPriceMap);
		System.out.println("杭州办事处--------------------------------------------");
		splitChangShaDept(startDate, endDate, year, relationShipMap, chargingPriceMap);
		System.out.println("长沙办事处--------------------------------------------");
		splitBeingJingDept(startDate, endDate, year, relationShipMap, chargingPriceMap);
		System.out.println("北京办事处--------------------------------------------");
		splitZhengZhouDept(startDate, endDate, year, relationShipMap, chargingPriceMap);
		System.out.println("郑州办事处--------------------------------------------");
		splitHeZuoDanWeiDept(startDate, endDate, year, relationShipMap, chargingPriceMap);
		System.out.println("合作单位--------------------------------------------");
		splitShangPinDept(startDate, endDate, year, relationShipMap, chargingPriceMap);
		System.out.println("商品部--------------------------------------------");
		splitZhaoShangdept(startDate, endDate, year, relationShipMap, chargingPriceMap);
		System.out.println("招商部--------------------------------------------");
		splitCaiWuDept(startDate, endDate, year, relationShipMap, chargingPriceMap);
		System.out.println("财务部--------------------------------------------");
		splitAiMengDept(startDate, endDate, year, relationShipMap, chargingPriceMap);
		System.out.println("爱萌犬--------------------------------------------");
		splitJuLeBuDept(startDate, endDate, year, relationShipMap, chargingPriceMap);
		System.out.println("地方俱乐部项目组--------------------------------------------");
		splitPeiXunDept(startDate, endDate, year, relationShipMap, chargingPriceMap);
		System.out.println("培训部--------------------------------------------");
		splitMeiRongDept(startDate, endDate, year, relationShipMap, chargingPriceMap);
		System.out.println("美容部--------------------------------------------");
		splitSaiShiDept(startDate, endDate, year, relationShipMap, chargingPriceMap);
		System.out.println("赛事部--------------------------------------------");
		splitHuiYuanDept(startDate, endDate, year, relationShipMap, chargingPriceMap);
		System.out.println("会员部--------------------------------------------");
		splitFanZhiDept(startDate, endDate, year, relationShipMap, chargingPriceMap);
		System.out.println("繁殖部--------------------------------------------");
		splitZangaoDept(startDate, endDate, year, relationShipMap, chargingPriceMap);
		System.out.println("藏獒部--------------------------------------------");
		splitChongwudian(startDate, endDate, year, relationShipMap, chargingPriceMap);
		System.out.println("宠物店--------------------------------------------");
		splitPingmianmeiti(startDate, endDate, year, relationShipMap, chargingPriceMap);
		System.out.println("平面媒体--------------------------------------------");
		splitMendainqudaobu(startDate, endDate, year, relationShipMap, chargingPriceMap);
		System.out.println("门店渠道部--------------------------------------------");
		splitYingxiao(startDate, endDate, year, relationShipMap, chargingPriceMap);
		System.out.println("营销部--------------------------------------------");
		splitQiGuan(startDate, endDate, year, relationShipMap, chargingPriceMap);
		System.out.println("企管中心--------------------------------------------");
		splitShiWu(startDate, endDate, year, relationShipMap, chargingPriceMap);
		System.out.println("事务部-------------------------------------------");
		//最后提交数据
		saPaymentDetailService.lastSave();
		Date end = new Date();
		long cha = end.getTime() - start.getTime();
		System.out.println(cha);
		System.out.println(cha / (60 * 1000));
	}


}
