/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.statistics.entity;

import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;

import javax.validation.constraints.NotNull;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 大客户数据统计Entity
 *
 * @author yuanshuai
 * @version 2020-06-29
 */
public class MemberVip extends DataEntity<MemberVip> {

	private static final long serialVersionUID = 1L;
	/**
	 * 会员号
	 */
	@ExcelField(title="会员号", align=2, sort=2)
	private String memberCode;
	/**
	 * 合同类型见字典contract_type
	 */
	@ExcelField(title="客户类型", align=2, sort=3)
	private String contractType;
	/**
	 * 合同签约数量
	 */
	@ExcelField(title="签约数量（血统证书）", align=2, sort=21)
	private Integer contractNum;
	/**
	 * 合同开始日期
	 */
	@ExcelField(title="签约日期", align=2, sort=11)
	private Date startDate;
	/**
	 * 负责人
	 */
	@ExcelField(title="客户经理", align=2, sort=4)
	private String manInCharge;
	/**
	 * 血统证书数量
 	 */
	@ExcelField(title="完成数量（血统证书）", align=2, sort=22)
	private Integer pedigreeCertifiedCompleteNum;
	/**
	 * 血统证书完成比例
	 */
	@ExcelField(title="完成比例（血统证书）", align=2, sort=23)
	private String pedigreeCertifiedCompleteRatio;
	/**
	 * 会员姓名
	 */
	@ExcelField(title="会员姓名", align=2, sort=1)
	private String memberName;
	/**
	 * 截止日期
	 */
	@ExcelField(title="截止日期", align=2, sort=12)
	private Date endDate;
	/**
	 * 新会员数量
	 */
	@ExcelField(title="新会员数量", align=2, sort=25)
	private Integer memberCount;

	public MemberVip() {
		super();
	}

	public MemberVip(String id) {
		super(id);
	}

	@Length(min = 1, max = 16, message = "会员号长度必须介于 1 和 16 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	@Length(min = 1, max = 4, message = "合同类型见字典contract_type长度必须介于 1 和 4 之间")
	public String getContractType() {
		return contractType;
	}

	public void setContractType(String contractType) {
		this.contractType = contractType;
	}

	public Integer getContractNum() {
		return contractNum;
	}

	public void setContractNum(Integer contractNum) {
		this.contractNum = contractNum;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@NotNull(message = "合同开始日期不能为空")
	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	@Length(min = 1, max = 16, message = "负责人长度必须介于 1 和 16 之间")
	public String getManInCharge() {
		return manInCharge;
	}

	public void setManInCharge(String manInCharge) {
		this.manInCharge = manInCharge;
	}

	public Integer getPedigreeCertifiedCompleteNum() {
		return pedigreeCertifiedCompleteNum;
	}

	public void setPedigreeCertifiedCompleteNum(Integer pedigreeCertifiedCompleteNum) {
		this.pedigreeCertifiedCompleteNum = pedigreeCertifiedCompleteNum;
	}

	public String getPedigreeCertifiedCompleteRatio() {
		return pedigreeCertifiedCompleteRatio;
	}

	public void setPedigreeCertifiedCompleteRatio(String pedigreeCertifiedCompleteRatio) {
		this.pedigreeCertifiedCompleteRatio = pedigreeCertifiedCompleteRatio;
	}

	public Integer getMemberCount() {
		return memberCount;
	}

	public void setMemberCount(Integer memberCount) {
		this.memberCount = memberCount;
	}

	public String getMemberName() {
		return memberName;
	}

	public void setMemberName(String memberName) {
		this.memberName = memberName;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}
}