package com.cku.oa.statistics.dao;
import com.cku.oa.dog.entity.Dog;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 活动报名信息统计的数据库查询
 * @author xuzhenxing
 *
 */
@MyBatisDao
public interface ActivityRegisterDao {

	/**
	 * 赛事报名统计
	 */
	/**
	 * 合计查询符合条件的主赛事总数、子赛事总数、纯血统犬总数、报名人数
	 */
	Map<String,Object> countTotal(@Param("showCode") String showCode,@Param("startDate") String startDate,@Param("endDate") String endDate,@Param("orgnizeType") String orgnizeType);
	/**
	 * 合计查询符合条件的子赛事的报名总数、订单总收入
	 */
	Map<String,Object> countTotalFee(@Param("showCode") String showCode,@Param("startDate") String startDate,@Param("endDate") String endDate,@Param("orgnizeType") String orgnizeType);
	/**
	 * 查询符合条件的主赛事、子赛事的详细信息
	 */
	/**
	 * 查询主赛事ID
	 */
	List<Map> showMainID(@Param("showCode") String showCode,@Param("startDate") String startDate,@Param("endDate") String endDate,@Param("orgnizeType") String orgnizeType,@Param("pageNo") int pageNo,@Param("pageSize") int pageSize) ;
	/**
	 * 根据主赛事ID查询子赛事，页面显示项
	 */
	List<Map<String,Object>> showChild(@Param("showMainID") String showMainID) ;
	/**
	 * 根据子赛事的show_code统计show_apply报名表中的统计信息：报名人数、犬只、犬次等
	 */
	Map<String,Object> showChildTotal (@Param("showMainID") String showMainID);
	/**
	 * 根据子赛事show_code查询同一场主赛事的鉴定犬数量及鉴定费
	 *
	 */
	Map<String,Object> showAppraisal(@Param("showCode") String showCode);

	/**
	 * 根据主赛事查询退费手续费金额及数量
	 * @param showMainID 主赛事id
	 * @author: yuanshuai
	 * @date: 2020/6/11 10:44
	 */
	Map<String,BigDecimal> showRefundHandlingFee(@Param("showMainID") String showMainID);
	/**
	 * 根据子赛事show_code查询比赛成绩
	 *
	 */
	public List<Map> showResult(@Param("showCode") String showCode);
	public Dog showDog(@Param("pedigreeCertified") String pedigreeCertified);

	/**
	 * 美容活动报名
	 *
	 */
	/**
	 * 美容合计，查询符合条件的活动总数、报名人数
	 */
	public Map groomCountTotal(@Param("startDate") String startDate,@Param("endDate") String endDate,@Param("showCode") String showCode);

	/**
	 * 符合条件的所有美容活动的编号，活动赛事编号取左边9位
	 */

	public int countGroom(@Param("startDate") String startDate,@Param("endDate") String endDate,@Param("showCode") String showCode);

	/**
	 * 查询美容主活动赛事编号取左边9位，相同则认为是隶属于一场活动
	 */
	public List groomMainID(@Param("startDate") String startDate,@Param("endDate") String endDate,@Param("showCode") String showCode,@Param("pageNo") int pageNo,@Param("pageSize") int pageSize);

	/**
	 * 根据主活动赛事编号取左边9位统计groom_register报名表中的详细信息，时间，地点，实际参赛人数等
	 */
	public List<Map> groomChild(@Param("groomMainID") String groomMainID);

	/**
	 * 根据主活动赛事编号取左边9位统计groom_register报名表中的总计信息，报名订单数、应收款数等
	 */
	public Map groomChildTotal (@Param("groomMainID") String groomMainID);

	/**
	 * 相关赛事美容师总数
	 */
	public int countGroomer (@Param("showCode") String showCode);

	/**
	 * 相关赛事美容师列表
	 */
	public List<Map> groomerView (@Param("showCode") String showCode,@Param("pageNo") int pageNo,@Param("pageSize") int pageSize);

	/**
	 * 活动赛事订单总计查询(合作、会员中心、业务订单)
	 */
	public Map showOrderListCount(@Param("absence") String absence,@Param("refund") String refunde,@Param("orderType") String orderType,@Param("showChargeItemID") String showChargeItemID,@Param("paymentState") String paymentState,@Param("orderCode") String orderCode,@Param("memberCode") String memberCode,@Param("showCode") String showCode,@Param("orderPrice") String orderPrice,@Param("startDate") String startDate,@Param("endDate") String endDate);
	/**
	 * 活动赛事订单明细查询(合作、会员中心、业务订单)
	 */
	public List<Map> showOrderList(@Param("absence") String absence,@Param("refund") String refunde,@Param("orderType") String orderType,@Param("showChargeItemID") String showChargeItemID,@Param("paymentState") String paymentState,@Param("orderCode") String orderCode,@Param("memberCode") String memberCode,@Param("showCode") String showCode,@Param("orderPrice") String orderPrice,@Param("startDate") String startDate,@Param("endDate") String endDate,@Param("pageNo") int pageNo,@Param("pageSize") int pageSize);

	public List<Map> showOrderCouponList(@Param("absence") String absence,@Param("refund") String refunde,@Param("orderType") String orderType,@Param("showChargeItemID") String showChargeItemID,@Param("paymentState") String paymentState,@Param("orderCode") String orderCode,@Param("memberCode") String memberCode,@Param("showCode") String showCode,@Param("orderPrice") String orderPrice,@Param("startDate") String startDate,@Param("endDate") String endDate,@Param("pageNo") int pageNo,@Param("pageSize") int pageSize);

	/**
	 * 活动赛事订单总计查询(OA)
	 */
	public Map oashowOrderListCount(@Param("showChargeItemID") String showChargeItemID,@Param("paymentState") String paymentState,@Param("orderCode") String orderCode,@Param("memberCode") String memberCode,@Param("showCode") String showCode,@Param("orderPrice") String orderPrice,@Param("startDate") String startDate,@Param("endDate") String endDate);
	/**
	 * 活动赛事订单明细查询(OA)
	 */
	public List<Map> oashowOrderList(@Param("showChargeItemID") String showChargeItemID,@Param("paymentState") String paymentState,@Param("orderCode") String orderCode,@Param("memberCode") String memberCode,@Param("showCode") String showCode,@Param("orderPrice") String orderPrice,@Param("startDate") String startDate,@Param("endDate") String endDate,@Param("pageNo") int pageNo,@Param("pageSize") int pageSize);


	/**
	 * 活动赛事收费项目
	 */
	public List<Map> showChargeItem();

    /**
     * 活动统计
     * @param startDate
     * @param endDate
     * @param showCode
     * @return
     */
    int countHandle(@Param("startDate") String startDate,@Param("endDate") String endDate,@Param("showCode") String showCode);

    Map handleCountTotal(@Param("startDate") String startDate,@Param("endDate") String endDate,@Param("showCode") String showCode);

    List<String> handleMainID(@Param("startDate") String startDate,@Param("endDate") String endDate,@Param("showCode") String showCode,@Param("pageNo") int pageNo,@Param("pageSize") int pageSize);

    List<Map> handleChild(@Param("handleMainID") String handleMainID);

    Map handleChildTotal(@Param("handleMainID") String handleMainID);

	int countHandleMember(@Param("showCode") String showCode);

	List<Map> handleMemberView(@Param("showCode") String showCode,@Param("pageNo") int pageNo,@Param("pageSize") int pageSize);
}
