package com.cku.oa.showRefereeDelegate.comparator;


import com.cku.oa.showRefereeDelegate.entity.Referee;
import org.apache.commons.lang3.StringUtils;

import java.util.Comparator;

/**
 * @author yuanshuai
 * @date 2021/2/4 15:56
 */
public class RefereeLevelThreeComparator implements Comparator<Referee> {
	@Override
	public int compare(Referee o1, Referee o2) {
		//优先判断是否已经委派完毕
		int o1Diff = o1.getJoinCount() - o1.getDelegateCount();
		int o2Diff = o2.getJoinCount() - o2.getDelegateCount();
		if (o1Diff != 0 && o2Diff == 0) {
			return -1;
		} else if (o1Diff == 0 && o2Diff != 0) {
			return 1;
		}
		//优先分配新进审查
		int compare = 0;
//		if ("N".equals(o1.getNewFlag()) && StringUtils.isBlank(o2.getNewFlag())) {
//			compare = 1;
//		} else if ("N".equals(o2.getNewFlag()) && StringUtils.isBlank(o1.getNewFlag())) {
//			compare = -1;
//		}
		//1.级别
		if (compare == 0) {
			compare = Integer.compare(o1.getLevel().getCode(), o2.getLevel().getCode());
		}
		//2.待分配场次
		if (compare == 0) {
			compare = Integer.compare(o2Diff, o1Diff);
		}
		//3.权重
		if (compare == 0) {
			compare = Integer.compare(o2.getWeight(), o1.getWeight());
		}
		//4.随机值
		if (compare == 0) {
			compare = Integer.compare(o2.getSort(), o1.getSort());
		}
		return compare;
	}
}
