package com.cku.oa.show.web;

import com.cku.oa.constant.Constants;
import com.cku.oa.show.dao.ShowJudgeCertificateDogGroupDao;
import com.cku.oa.show.entity.ShowJudgeCertificate;
import com.cku.oa.show.entity.ShowJudgeCertificateDogGroup;
import com.cku.oa.show.service.ShowJudgeCertificateService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 赛事裁判证书Controller
 *
 * @author lgl
 * @version 2018-09-20
 */
@Controller
@RequestMapping(value = "${adminPath}/judgecertificate/showJudgeCertificate")
public class ShowJudgeCertificateController extends BaseController {

	@Autowired
	private ShowJudgeCertificateService showJudgeCertificateService;
	@Autowired
	private ShowJudgeCertificateDogGroupDao showJudgeCertificateDogGroupDao;

	@ModelAttribute
	public ShowJudgeCertificate get(@RequestParam(required = false) String id) {
		ShowJudgeCertificate entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = showJudgeCertificateService.get(id);
		}
		if (entity == null) {
			entity = new ShowJudgeCertificate();
		}
		return entity;
	}

	@RequiresPermissions("judgecertificate:showJudgeCertificate:view")
	@RequestMapping(value = {"list", ""})
	public String list(ShowJudgeCertificate showJudgeCertificate, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<ShowJudgeCertificate> page = showJudgeCertificateService.findPage(new Page<ShowJudgeCertificate>(request, response), showJudgeCertificate);
		model.addAttribute("page", page);
		return "oa/show/judgecertificate/showJudgeCertificateList";
	}

	@RequiresPermissions("judgecertificate:showJudgeCertificate:view")
	@RequestMapping(value = "view")
	public String view(ShowJudgeCertificate showJudgeCertificate, Model model) {
		if (null != showJudgeCertificate && StringUtils.isNotBlank(showJudgeCertificate.getId())
				&& showJudgeCertificate.getCertificateType().equals("3")) {
			List<ShowJudgeCertificateDogGroup> showJudgeCertificateDogGroupList = showJudgeCertificateDogGroupDao.getByJudgeCertificateMian(showJudgeCertificate.getJudgeCertificate());
			for (ShowJudgeCertificateDogGroup showJudgeCertificateDogGroup : showJudgeCertificateDogGroupList) {
				ShowJudgeCertificateDogGroup fciShowGroup = showJudgeCertificateDogGroupDao.getFciShowGroupByGroupNo(showJudgeCertificateDogGroup.getGroupNo());
				showJudgeCertificateDogGroup.setGroupNo(fciShowGroup.getJudgeCertificateMian() + "  " + fciShowGroup.getJudgeCertificate());
			}
			showJudgeCertificate.setShowJudgeCertificateDogGroupList(showJudgeCertificateDogGroupList);
		}
		model.addAttribute("showJudgeCertificate", showJudgeCertificate);
		return "oa/show/judgecertificate/showJudgeCertificateView";
	}

	@RequiresPermissions("judgecertificate:showJudgeCertificate:edit")
	@RequestMapping(value = "edit")
	public String editForm(ShowJudgeCertificate showJudgeCertificate, Model model) {
		List<ShowJudgeCertificateDogGroup> fciShowGroupList = showJudgeCertificateDogGroupDao.getFciShowGroupList();
		model.addAttribute("fciShowGroupList", fciShowGroupList);
		if (null != showJudgeCertificate
				&& StringUtils.isNotBlank(showJudgeCertificate.getId())
				&& "3".equals(showJudgeCertificate.getCertificateType())) {
			List<ShowJudgeCertificateDogGroup> showJudgeCertificateDogGroupList = showJudgeCertificateDogGroupDao.getByJudgeCertificateMian(showJudgeCertificate.getJudgeCertificate());
			showJudgeCertificate.setShowJudgeCertificateDogGroupList(showJudgeCertificateDogGroupList);
		}
		model.addAttribute("showJudgeCertificate", showJudgeCertificate);
		return "oa/show/judgecertificate/showJudgeCertificateEditForm";
	}

	@RequiresPermissions("judgecertificate:showJudgeCertificate:edit")
	@RequestMapping(value = "save")
	public String save(ShowJudgeCertificate showJudgeCertificate, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, showJudgeCertificate)) {
			return editForm(showJudgeCertificate, model);
		}
		showJudgeCertificateService.save(showJudgeCertificate);
		addMessage(redirectAttributes, "保存CKU审查员成功");
		return "redirect:" + Global.getAdminPath() + "/judgecertificate/showJudgeCertificate/?repage";
	}

	@RequiresPermissions("judgecertificate:showJudgeCertificate:del")
	@RequestMapping(value = "delete")
	public String delete(ShowJudgeCertificate showJudgeCertificate, RedirectAttributes redirectAttributes) {
		showJudgeCertificateService.delete(showJudgeCertificate);
		addMessage(redirectAttributes, "删除CKU审查员成功");
		return "redirect:" + Global.getAdminPath() + "/judgecertificate/showJudgeCertificate/?repage";
	}

}