package com.cku.oa.shop.service;

import java.util.List;

import com.cku.oa.sys.entity.user.Member;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.shop.entity.ShopUserAddress;
import com.cku.oa.shop.dao.ShopUserAddressDao;

/**
 * 商城用户地址Service
 * @author lyy
 * @version 2016-08-24
 */
@Service
@Transactional(readOnly = true)
public class ShopUserAddressService extends CrudService<ShopUserAddressDao, ShopUserAddress> {

	public ShopUserAddress get(String id) {
		return super.get(id);
	}
	
	public List<ShopUserAddress> findList(ShopUserAddress shopUserAddress) {
		return super.findList(shopUserAddress);
	}
	
	public Page<ShopUserAddress> findPage(Page<ShopUserAddress> page, ShopUserAddress shopUserAddress) {
		return super.findPage(page, shopUserAddress);
	}
	public List<ShopUserAddress> findListByMemberCode(String memberCode){
		return dao.findListByMemberCode(memberCode);
	}
	@Transactional(readOnly = false)
	public void noAddressAddMemberAddress(ShopUserAddress shopUserAddress){
		super.save(shopUserAddress);
	}
	@Transactional(readOnly = false)
	public void save(ShopUserAddress shopUserAddress) {
		super.save(shopUserAddress);
	}
	@Transactional(readOnly = false)
	public void updateAddress(ShopUserAddress shopUserAddress){
		shopUserAddress = get(shopUserAddress.getId());
		shopUserAddress.setIsDefault("1");
		List<ShopUserAddress> shopUserAddressList = findList(shopUserAddress);
		if(shopUserAddressList!=null && shopUserAddressList.size()>0){
			for(ShopUserAddress pre : shopUserAddressList){
				pre.setIsDefault("0");
				save(pre);
			}
		}
		save(shopUserAddress);
	}

	@Transactional(readOnly = false)
	public void delete(ShopUserAddress shopUserAddress) {
		super.delete(shopUserAddress);
	}
	
}