
package com.cku.oa.report.vo;

import java.util.Date;
import java.util.List;

import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;

import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(callSuper = false)
public class ReportMemberVO extends DataEntity<ReportMemberVO> {

	private static final long serialVersionUID = 1900790328196914427L;
	
	@ExcelField(title = "会员号", align = 2, sort = 3)
	private String memberCode; // 会员号
	
	@ExcelField(title = "会员电话", align = 2, sort = 11)
	private String mobile; // 手机
	
	@ExcelField(title = "会员姓名", align = 2, sort = 4)
	private String name; // 姓名

	@ExcelField(title = "会员类型", align = 2, sort = 5)
	private String memberCardType; // 会员卡片类型

	private String isExpires; // 0 已到期 1 未到期

	private Date memberEndDateStart; // 会员截止时间-开始

	private Date memberEndDateEnd; // 会员截止时间-开始

	@ExcelField(title = "注册地址-省", align = 2, sort = 1)
	private String registerProvince;

	@ExcelField(title = "注册地址-市", align = 2, sort = 2)
	private String registerCity;

	private String isAdded;// 是否新增 0是1不是

	private String isLoss;// 是否流失 0是1不是

	private List<String> provinces;// 可查省份
	
	@ExcelField(title = "美容会员类型", align = 2, sort = 13)
	private String groomerType;
	
	@ExcelField(title = "会员截止日期", align = 2, sort = 6)
	private Date memberEndDate;

	@ExcelField(title = "首次缴费时间", align = 2, sort = 7)
	private Date firstPaymentTime;
	
	@ExcelField(title = "美容会员截止日期", align = 2, sort = 14)
	private Date groomerEndDate;

	private String key; // 查询关键字

	private Date groomerEndDateStart; // 美容会员截止时间-开始

	private Date groomerEndDateEnd; // 美容会员截止时间-开始

	private String officeName;

	private String region;
	
	@ExcelField(title = "犬舍名称", align = 2, sort = 8)
	private String kennelName;

	@ExcelField(title = "犬舍创建时间", align = 2, sort = 9)
	private Date kennelCreateDate;

	@ExcelField(title = "犬舍截止日期", align = 2, sort = 10)
	private Date endTime;
	
	@ExcelField(title = "完整地址", align = 2, sort = 12)
	private String completeAddress;
	
	private String registerStreet;
	
	private String registerArea;

	@ExcelField(title = "有效状态", align = 2, sort = 15)
	private String expires; // 0 已到期 1 未到期
	
}