package com.cku.oa.order.service;

import com.cku.oa.order.vo.ChargingItemVo;
import com.cku.oa.order.vo.OrderBusinessVo;
import com.cku.oa.order.vo.OrderSkuVo;
import com.cku.restful.v2.order.vo.request.OrderApplyRequest;

import java.util.List;

/**
 * 商品服务
 *
 * @author yuanshuai
 * @date 2023/6/18 15:04
 */
public interface ISkuBusinessService<T extends OrderBusinessVo> {

    /**
     * 根据业务和商品更新收费项金额
     *
     * @param orderRequest 下单相关参数
     * @param businessList 业务具体参数
     * @param itemList     收费项List
     * @author yuanshuai
     * @date 2023/6/19 14:01
     */
    void processChargingItemPrice(OrderApplyRequest orderRequest, List<T> businessList, List<ChargingItemVo> itemList);


    /**
     * 根据业务和商品处理付款前业务逻辑
     *
     * @param orderRequest 下单相关参数
     * @param businessData 业务具体参数
     * @author yuanshuai
     * @date 2023/6/18 16:26
     */
    void processBusinessPrePay(OrderApplyRequest orderRequest, T businessData, OrderSkuVo skuVo);


    /**
     * 根据业务和商品更新收费项业务表信息
     *
     * @param orderRequest 下单相关参数
     * @param skuVo        sku参数
     * @param itemList     收费项List
     * @author yuanshuai
     * @date 2023/6/19 14:01
     */
    void findChargingItemBusinessTableId(OrderApplyRequest orderRequest, OrderSkuVo skuVo, List<ChargingItemVo> itemList);
}
