/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.notice.entity;

import java.util.Date;

import javax.validation.constraints.NotNull;

import org.hibernate.validator.constraints.Length;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 通知Entity
 * 
 * @author xx
 * @version 2021-01-18
 */
public class SysNode extends DataEntity<SysNode> {

	private static final long serialVersionUID = 1L;
	private String channelId; // 频道ID
	private String sortId; // 分类ID
	private String typeId; // 类型ID
	private String title; // 标题
	private String title2; // 副标题
	private String titlecolor; // 标题颜色
	private String cover1; // 小图
	private String cover2; // 中图
	private String cover3; // 大图
	private String author; // 作者
	private String origin; // 来源
	private String url; // 连接
	private String keyword; // 关键字
	private String region; // 地域
	private String extend1; // 保留字段1
	private String extend2; // 保留字段2
	private String extend3; // 保留字段3
	private String extend4; // 保留字段4
	private String extend5; // 保留字段5
	private String summary; // 摘要
	private String content; // 正文
	private String explain; // 说明
	private String atlas; // 图集
	private String atlascount; // 图集数量
	private String tags; // 标签
	private String hits; // 点击
	private String recommend; // 推荐
	private String verify; // 审核状态
	private String status; // 状态
	private String location; // 位置
	private String addUser; // 添加人
	private Date addTime; // 添加时间
	private Long addIp; // 添加人IP
	private String editUser; // 修改人
	private Long editTime; // 修改时间
	private Long editIp; // 修改人IP
	private Long sDateline; // 发布时间
	private Long eDateline; // 结束时间

	private String nickname;// 添加人中文

	public Long getsDateline() {
		return sDateline;
	}

	public void setsDateline(Long sDateline) {
		this.sDateline = sDateline;
	}

	public Long geteDateline() {
		return eDateline;
	}

	public void seteDateline(Long eDateline) {
		this.eDateline = eDateline;
	}

	public String getNickname() {
		return nickname;
	}

	public void setNickname(String nickname) {
		this.nickname = nickname;
	}

	public SysNode() {
		super();
	}

	public SysNode(String id) {
		super(id);
	}

	@Length(min = 1, max = 11, message = "频道ID长度必须介于 1 和 11 之间")
	public String getChannelId() {
		return channelId;
	}

	public void setChannelId(String channelId) {
		this.channelId = channelId;
	}

	@Length(min = 1, max = 11, message = "分类ID长度必须介于 1 和 11 之间")
	public String getSortId() {
		return sortId;
	}

	public void setSortId(String sortId) {
		this.sortId = sortId;
	}

	@Length(min = 0, max = 11, message = "类型ID长度必须介于 0 和 11 之间")
	public String getTypeId() {
		return typeId;
	}

	public void setTypeId(String typeId) {
		this.typeId = typeId;
	}

	@Length(min = 1, max = 255, message = "标题长度必须介于 1 和 255 之间")
	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	@Length(min = 0, max = 255, message = "副标题长度必须介于 0 和 255 之间")
	public String getTitle2() {
		return title2;
	}

	public void setTitle2(String title2) {
		this.title2 = title2;
	}

	@Length(min = 1, max = 8, message = "标题颜色长度必须介于 1 和 8 之间")
	public String getTitlecolor() {
		return titlecolor;
	}

	public void setTitlecolor(String titlecolor) {
		this.titlecolor = titlecolor;
	}

	@Length(min = 0, max = 255, message = "小图长度必须介于 0 和 255 之间")
	public String getCover1() {
		return cover1;
	}

	public void setCover1(String cover1) {
		this.cover1 = cover1;
	}

	@Length(min = 0, max = 255, message = "中图长度必须介于 0 和 255 之间")
	public String getCover2() {
		return cover2;
	}

	public void setCover2(String cover2) {
		this.cover2 = cover2;
	}

	@Length(min = 0, max = 255, message = "大图长度必须介于 0 和 255 之间")
	public String getCover3() {
		return cover3;
	}

	public void setCover3(String cover3) {
		this.cover3 = cover3;
	}

	@Length(min = 0, max = 32, message = "作者长度必须介于 0 和 32 之间")
	public String getAuthor() {
		return author;
	}

	public void setAuthor(String author) {
		this.author = author;
	}

	@Length(min = 0, max = 64, message = "来源长度必须介于 0 和 64 之间")
	public String getOrigin() {
		return origin;
	}

	public void setOrigin(String origin) {
		this.origin = origin;
	}

	@Length(min = 0, max = 255, message = "连接长度必须介于 0 和 255 之间")
	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	@Length(min = 0, max = 255, message = "关键字长度必须介于 0 和 255 之间")
	public String getKeyword() {
		return keyword;
	}

	public void setKeyword(String keyword) {
		this.keyword = keyword;
	}

	@Length(min = 1, max = 11, message = "地域长度必须介于 1 和 11 之间")
	public String getRegion() {
		return region;
	}

	public void setRegion(String region) {
		this.region = region;
	}

	@Length(min = 0, max = 255, message = "保留字段1长度必须介于 0 和 255 之间")
	public String getExtend1() {
		return extend1;
	}

	public void setExtend1(String extend1) {
		this.extend1 = extend1;
	}

	@Length(min = 0, max = 255, message = "保留字段2长度必须介于 0 和 255 之间")
	public String getExtend2() {
		return extend2;
	}

	public void setExtend2(String extend2) {
		this.extend2 = extend2;
	}

	@Length(min = 0, max = 255, message = "保留字段3长度必须介于 0 和 255 之间")
	public String getExtend3() {
		return extend3;
	}

	public void setExtend3(String extend3) {
		this.extend3 = extend3;
	}

	@Length(min = 0, max = 255, message = "保留字段4长度必须介于 0 和 255 之间")
	public String getExtend4() {
		return extend4;
	}

	public void setExtend4(String extend4) {
		this.extend4 = extend4;
	}

	@Length(min = 0, max = 255, message = "保留字段5长度必须介于 0 和 255 之间")
	public String getExtend5() {
		return extend5;
	}

	public void setExtend5(String extend5) {
		this.extend5 = extend5;
	}

	public String getSummary() {
		return summary;
	}

	public void setSummary(String summary) {
		this.summary = summary;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public String getExplain() {
		return explain;
	}

	public void setExplain(String explain) {
		this.explain = explain;
	}

	public String getAtlas() {
		return atlas;
	}

	public void setAtlas(String atlas) {
		this.atlas = atlas;
	}

	@Length(min = 1, max = 11, message = "图集数量长度必须介于 1 和 11 之间")
	public String getAtlascount() {
		return atlascount;
	}

	public void setAtlascount(String atlascount) {
		this.atlascount = atlascount;
	}

	public String getTags() {
		return tags;
	}

	public void setTags(String tags) {
		this.tags = tags;
	}

	@Length(min = 0, max = 11, message = "点击长度必须介于 0 和 11 之间")
	public String getHits() {
		return hits;
	}

	public void setHits(String hits) {
		this.hits = hits;
	}

	@Length(min = 0, max = 3, message = "推荐长度必须介于 0 和 3 之间")
	public String getRecommend() {
		return recommend;
	}

	public void setRecommend(String recommend) {
		this.recommend = recommend;
	}

	@Length(min = 1, max = 11, message = "审核状态长度必须介于 1 和 11 之间")
	public String getVerify() {
		return verify;
	}

	public void setVerify(String verify) {
		this.verify = verify;
	}

	@Length(min = 1, max = 3, message = "状态长度必须介于 1 和 3 之间")
	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	@Length(min = 1, max = 11, message = "位置长度必须介于 1 和 11 之间")
	public String getLocation() {
		return location;
	}

	public void setLocation(String location) {
		this.location = location;
	}

	@Length(min = 1, max = 11, message = "添加人长度必须介于 1 和 11 之间")
	public String getAddUser() {
		return addUser;
	}

	public void setAddUser(String addUser) {
		this.addUser = addUser;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@NotNull(message = "添加时间不能为空")
	public Date getAddTime() {
		return addTime;
	}

	public void setAddTime(Date addTime) {
		this.addTime = addTime;
	}

	@NotNull(message = "添加人IP不能为空")
	public Long getAddIp() {
		return addIp;
	}

	public void setAddIp(Long addIp) {
		this.addIp = addIp;
	}

	@Length(min = 0, max = 11, message = "修改人长度必须介于 0 和 11 之间")
	public String getEditUser() {
		return editUser;
	}

	public void setEditUser(String editUser) {
		this.editUser = editUser;
	}

	public Long getEditTime() {
		return editTime;
	}

	public void setEditTime(Long editTime) {
		this.editTime = editTime;
	}

	public Long getEditIp() {
		return editIp;
	}

	public void setEditIp(Long editIp) {
		this.editIp = editIp;
	}

	@NotNull(message = "发布时间不能为空")
	public Long getSDateline() {
		return sDateline;
	}

	public void setSDateline(Long sDateline) {
		this.sDateline = sDateline;
	}

	@NotNull(message = "结束时间不能为空")
	public Long getEDateline() {
		return eDateline;
	}

	public void setEDateline(Long eDateline) {
		this.eDateline = eDateline;
	}

}