package com.cku.oa.nativedog.service;

import java.util.List;

import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.nativedog.entity.NativeDogInfo;
import com.cku.oa.nativedog.dao.NativeDogInfoDao;

/**
 * 原生犬介绍Service
 * @author lyy
 * @version 2018-12-11
 */
@Service
@Transactional(readOnly = true)
public class NativeDogInfoService extends CrudService<NativeDogInfoDao, NativeDogInfo> {

	public NativeDogInfo get(String id) {
		return super.get(id);
	}
	
	public List<NativeDogInfo> findList(NativeDogInfo nativeDogInfo) {
		return super.findList(nativeDogInfo);
	}
	
	public Page<NativeDogInfo> findPage(Page<NativeDogInfo> page, NativeDogInfo nativeDogInfo) {
		return super.findPage(page, nativeDogInfo);
	}
	
	@Transactional(readOnly = false)
	public void save(NativeDogInfo nativeDogInfo) {
		if (StringUtils.isNotBlank(nativeDogInfo.getInfoDetail())) {
			nativeDogInfo.setInfoDetail(StringEscapeUtils.unescapeHtml4(nativeDogInfo.getInfoDetail()));
		}
		super.save(nativeDogInfo);
	}
	
	@Transactional(readOnly = false)
	public void delete(NativeDogInfo nativeDogInfo) {
		super.delete(nativeDogInfo);
	}
	
}