/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.handler.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 积分榜牵犬师Entity
 * @author xx
 * @version 2022-06-08
 */
public class ShowHandler extends DataEntity<ShowHandler> {
	
	private static final long serialVersionUID = 1L;
	private String name;		// 牵犬师姓名
	private String memberCode;		// 会员号
	private String photo;		// 照片
	private String introduce;		// 简介
	
	public ShowHandler() {
		super();
	}

	public ShowHandler(String id){
		super(id);
	}

	@Length(min=0, max=64, message="牵犬师姓名长度必须介于 0 和 64 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	@Length(min=0, max=100, message="会员号长度必须介于 0 和 100 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}
	
	@Length(min=0, max=255, message="照片长度必须介于 0 和 255 之间")
	public String getPhoto() {
		return photo;
	}

	public void setPhoto(String photo) {
		this.photo = photo;
	}
	
	public String getIntroduce() {
		return introduce;
	}

	public void setIntroduce(String introduce) {
		this.introduce = introduce;
	}
	
}