package com.cku.oa.groomerRefereeDelegate.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.oa.groomerRefereeDelegate.entity.GroomerRefereeDelegateLog;
import com.cku.oa.groomerRefereeDelegate.service.GroomerRefereeDelegateLogService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;

/**
 * 美容裁判委派记录Controller
 *
 * @author 袁帅
 * @version 2021-03-16
 */
@Controller
@RequestMapping(value = "${adminPath}/groomerShow/delegateLog")
public class GroomerRefereeDelegateLogController extends BaseController {

	@Autowired
	private GroomerRefereeDelegateLogService groomerRefereeDelegateLogService;

	@ModelAttribute
	public GroomerRefereeDelegateLog get(@RequestParam(required = false) String id) {
		GroomerRefereeDelegateLog entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = groomerRefereeDelegateLogService.get(id);
		}
		if (entity == null) {
			entity = new GroomerRefereeDelegateLog();
		}
		return entity;
	}

	@RequiresPermissions("groomerShow:delegateLog:view")
	@RequestMapping(value = {"list", ""})
	public String list(GroomerRefereeDelegateLog groomerRefereeDelegateLog, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<GroomerRefereeDelegateLog> page = groomerRefereeDelegateLogService.findPage(new Page<GroomerRefereeDelegateLog>(request, response), groomerRefereeDelegateLog);
		model.addAttribute("page", page);
		return "oa/groomerRefereeDelegate/groomerRefereeDelegateLogList";
	}

	@RequiresPermissions("groomerShow:delegateLog:view")
	@RequestMapping(value = "form")
	public String form(GroomerRefereeDelegateLog groomerRefereeDelegateLog, Model model) {
		model.addAttribute("groomerRefereeDelegateLog", groomerRefereeDelegateLog);
		return "oa/groomerRefereeDelegate/groomerRefereeDelegateLogForm";
	}

	@RequiresPermissions("groomerShow:delegateLog:edit")
	@RequestMapping(value = "save")
	public String save(GroomerRefereeDelegateLog groomerRefereeDelegateLog, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, groomerRefereeDelegateLog)) {
			return form(groomerRefereeDelegateLog, model);
		}
		groomerRefereeDelegateLogService.save(groomerRefereeDelegateLog);
		addMessage(redirectAttributes, "保存美容活动委派记录成功");
		return "redirect:" + Global.getAdminPath() + "/groomerShow/delegateLog/?repage";
	}

	@RequiresPermissions("groomerShow:delegateLog:del")
	@RequestMapping(value = "delete")
	public String delete(GroomerRefereeDelegateLog groomerRefereeDelegateLog, RedirectAttributes redirectAttributes) {
		groomerRefereeDelegateLogService.delete(groomerRefereeDelegateLog);
		addMessage(redirectAttributes, "删除美容活动委派记录成功");
		return "redirect:" + Global.getAdminPath() + "/groomerShow/delegateLog/?repage";
	}


	/**
	 * 导入模板
	 * @author yuanshuai
	 * @date 2021/3/17 10:19
	 */
	@RequiresPermissions("groomerShow:delegateLog:import")
	@RequestMapping(value = "import/template")
	public String importFileTemplate(HttpServletResponse response, RedirectAttributes redirectAttributes) {
		try {
			groomerRefereeDelegateLogService.importFileTemplate(response);
			return null;
		} catch (Exception e) {
			addMessage(redirectAttributes, "导入模板下载失败！失败信息：" + e.getMessage());
		}
		return "redirect:" + Global.getAdminPath() + "/groomerShow/delegateLog/?repage";
	}

	/**
	 * 导入委派记录
	 * @author yuanshuai
	 * @date 2021/3/17 10:19
	 */
	@RequiresPermissions("groomerShow:delegateLog:import")
	@RequestMapping(value = "import", method = RequestMethod.POST)
	public String importFile(MultipartFile file, Model model, RedirectAttributes redirectAttributes) {
		try {
			groomerRefereeDelegateLogService.importGroomerReferee(file);
			addMessage(redirectAttributes,"导入美容活动委派记录成功。");
		} catch (Exception e) {
			addMessage(redirectAttributes,"导入美容活动委派记录失败！失败信息：" + e.getMessage());
		}
		return "redirect:" + Global.getAdminPath() + "/groomerShow/delegateLog/?repage";
	}
}