package com.cku.oa.groomer.web;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.cku.oa.groomer.dao.FciGroomerQualificationCertificateDao;
import com.cku.oa.groomer.entity.*;
import com.cku.oa.groomer.service.FciGroomerQualificationCertificateService;
import com.cku.oa.groomer.vo.FciGroomerCertificatesH5VO;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.common.ResultVo;
import com.cku.oa.common.ResultVoUtil;
import com.cku.oa.groomer.dao.GroomerQualificationCertificateDao;
import com.cku.oa.groomer.utils.GroomerUtil;
import com.cku.oa.groomer.vo.GroomerCertificatesH5VO;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.util.PinYinUtil;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.utils.Collections3;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 美容师资格证书Controller
 *
 * @author cxt
 * @version 2016-07-22
 */
@Controller
@RequestMapping(value = "/groomer")
public class GroomerQualificationPubCertificateController extends BaseController {

	@Autowired
	private GroomerQualificationCertificateDao groomerQualificationCertificateDao;
	@Autowired
	private MemberDao memberDao;
	@Autowired
	private FciGroomerQualificationCertificateDao fciGroomerQualificationCertificateDao;
	@Autowired
	private FciGroomerQualificationCertificateService fciGroomerQualificationCertificateService;

	/**
	 * 资格证书列表1
	 *
	 * @Author chaixueteng
	 * @2016年7月25日上午10:27:56
	 */
	@RequestMapping(value = "get")
	@ResponseBody
	public ResultVo<Map<String, Object>> get(String id, String certificateCode) {
		if (StringUtils.isBlank(id) && StringUtils.isBlank(certificateCode)) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "会员号或证书编号为空，请重试");
		}
		Map<String, Object> map = new HashMap<>(Collections.emptyMap());
		// 获得国际表的信息
		InternationalGroomerCertificate internationalGroomerCertificate = null;
		List<InternationalGroomerCertificate> internationalGroomerCertificateList = groomerQualificationCertificateDao
				.getByMemcode(id);
		if (!Collections3.isEmpty(internationalGroomerCertificateList)) {
			internationalGroomerCertificate = internationalGroomerCertificateList.stream()
					.filter(certificate -> StringUtils.isNotBlank(certificate.getCertificateCode())
							&& certificate.getCertificateCode().equals(certificateCode))
					.findFirst().orElse(null);
		}
		if (internationalGroomerCertificate == null || StringUtils.isBlank(internationalGroomerCertificate.getId())) {
			internationalGroomerCertificate = internationalGroomerCertificateList.stream()
					.filter(certificate -> "2".equals(certificate.getCertificateType())).findFirst().orElse(null);
		}

		// 通过会员id，找到会员头像
		Member member = memberDao.getByMemberCode(id);
		if (null != member) {
			String url = Global.getConfig("touxiangUrl");
			String imgPath = url + "api/v1/open/groomerImage/" + member.getAvatar();
			member.setAvatar(imgPath);
			internationalGroomerCertificate.setEndDate(member.getGroomerEndDate());
		}

		// 获得所有资格证书信息
		GroomerQualificationCertificate search = new GroomerQualificationCertificate();
		search.setMemberCode(id);
		List<GroomerQualificationCertificate> list = groomerQualificationCertificateDao.findListBycku(search);

		map.put("internationalGroomerCertificate", internationalGroomerCertificate);
		map.put("GroomerQualificationCertificateList", list);
		map.put("member", member);
		return ResultVoUtil.success(map);
	}

	/**
	 * 资格证书列表1
	 * 
	 * @throws Exception
	 *
	 * @Author chaixueteng
	 * @2016年7月25日上午10:27:56
	 */
	@RequestMapping(value = "groomerCertificates")
	@ResponseBody
	public ResultDto<GroomerCertificatesH5VO> groomerCertificates(
			@RequestParam(name = "id", required = false) String id,
			@RequestParam(name = "token", required = false) String token) throws Exception {
		GroomerCertificatesH5VO map = new GroomerCertificatesH5VO();
		List<GroomerQualificationCertificateVo> list = new ArrayList<>();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

		Member member = null;
		if (StringUtils.isNotBlank(token)) {
			member = UserUtils.getLoginMember();
		} else if (StringUtils.isNotBlank(id)) {
			// 获取当前证书信息
			InternationalGroomerCertificate internationalGroomerCertificate = groomerQualificationCertificateDao
					.getById(id);
			if (internationalGroomerCertificate != null) {
				member = memberDao.getByMemberCode(internationalGroomerCertificate.getMemberCode());
			}
		}

		if (member != null) {
			map.setAvatar(GroomerUtil.getUrl(member.getAvatar()));
			map.setMemberName(member.getName());
			map.setMemberCode(member.getMemberCode());
			map.setGroomerType("formal".equals(member.getGroomerType()) ? "正式会员"
					: ("reserve".equals(member.getGroomerType()) ? "预备会员" : "无"));
			map.setOverdue(!((member.getMemberEndDate() != null && member.getMemberEndDate().after(new Date()))
					|| (member.getGroomerEndDate() != null && member.getGroomerEndDate().after(new Date()))));
			Date date = new Date();
			if (member.getGroomerEndDate() != null) {
				if (member.getGroomerEndDate().getTime() > date.getTime()) {
					map.setGrommerEndTime(sdf.format(member.getGroomerEndDate()));
				} else {
					map.setGrommerEndTime("已失效");
				}
			} else {
				map.setGrommerEndTime("无");
			}

			GroomerQualificationCertificate certificate = new GroomerQualificationCertificate();
			certificate.setMemberCode(member.getMemberCode());
			List<GroomerQualificationCertificate> lists = groomerQualificationCertificateDao
					.findListByCertificate(certificate);
			for (GroomerQualificationCertificate certificate1 : lists) {
				GroomerQualificationCertificateVo vo = new GroomerQualificationCertificateVo();
				BeanUtils.copyProperties(certificate1, vo);
				if (certificate1.getIssueDate() != null) {
					vo.setIssueDate(sdf.format(certificate1.getIssueDate()));
				}
				//如果是派多格资格证书则前端另走逻辑
				if ("6".equals(certificate1.getCertificateType())) {
					vo.setLevelCn("PDG-" + vo.getLevelEn() + "级");
				} else if ("8".equals(certificate1.getCertificateType())) {
					vo.setLevelCn(GroomerUtil.getCatNurseLevelCn(vo.getLevelEn()));
				} else {
					vo.setLevelCn(GroomerUtil.getLevelCn(vo.getLevelEn()));
				}
				list.add(vo);
			}
		}
		map.setList(list);
		return ResultDto.success(map);
	}

	@RequestMapping(value = "groomerCertificates/{certificateCode}")
	@ResponseBody
	public ResultDto<GroomerQualificationCertificateVo> getGroomerCertificate(
			@PathVariable("certificateCode") String certificateCode) throws Exception {
		GroomerQualificationCertificate groomerQualificationCertificate = groomerQualificationCertificateDao
				.getGroomerCertificateByCode(certificateCode);
		Member member = memberDao.getByMemberCode(groomerQualificationCertificate.getMemberCode());
		if (!((member.getMemberEndDate() != null && member.getMemberEndDate().after(new Date()))
				|| (member.getGroomerEndDate() != null && member.getGroomerEndDate().after(new Date())))) {
			return ResultDto.error(ZAErrorCode.ZA_ERROR, "会员过期，暂不支持查询");
		}
		GroomerQualificationCertificateVo vo = new GroomerQualificationCertificateVo();
		BeanUtil.copyProperties(vo, groomerQualificationCertificate, "yyyy-MM-dd");
		if ("6".equals(groomerQualificationCertificate.getCertificateType())) {
			vo.setLevelCn("PDG-" + vo.getLevelEn() + "级");
			vo.setLevelEn(vo.getLevelEn());
		} else if ("8".equals(groomerQualificationCertificate.getCertificateType())) {
			vo.setLevelCn(GroomerUtil.getCatNurseLevelCn(vo.getLevelEn()));
			vo.setLevelEn(vo.getLevelEn());
		} else {
			vo.setLevelCn(GroomerUtil.getLevelCn(groomerQualificationCertificate.getLevelEn()));
			vo.setLevelEn(GroomerUtil.getLevelEn(vo.getLevelEn()));
		}
		vo.setAvatar(GroomerUtil.getUrl(groomerQualificationCertificate.getMember().getAvatar()));
		vo.setNamePinyin(StringUtils.isNotEmpty(vo.getNamePinyin()) ? vo.getNamePinyin() : PinYinUtil.getFullSpell(vo.getName()));
		vo.setQrCode("http://www.chongaibao.com/internationalGroomerCertificateH5/index.html?memberCode="
				+ groomerQualificationCertificate.getMemberCode());
		return ResultDto.success(vo);
	}

	/**
	 * 资格证书列表 -【FCI证书】
	 *
	 * @throws Exception
	 *
	 * @Author hjx
	 * @Date 2025-01-09 14:38:55
	 */
	@RequestMapping(value = "groomerFciCertificates")
	@ResponseBody
	public ResultDto<FciGroomerCertificatesH5VO> groomerFciCertificates(
			@RequestParam(name = "id", required = false) String id,
			@RequestParam(name = "token", required = false) String token) throws Exception {
		FciGroomerCertificatesH5VO map = new FciGroomerCertificatesH5VO();
		List<FciGroomerQualificationCertificateVo> list = new ArrayList<>();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

		Member member = null;
		if (StringUtils.isNotBlank(token)) {
			member = UserUtils.getLoginMember();
		}
		if (member != null) {
			map.setAvatar(GroomerUtil.getUrl(member.getAvatar()));
			map.setMemberName(member.getName());
			map.setMemberCode(member.getMemberCode());
			map.setGroomerType("formal".equals(member.getGroomerType()) ? "正式会员"
					: ("reserve".equals(member.getGroomerType()) ? "预备会员" : "无"));
			map.setOverdue(!((member.getMemberEndDate() != null && member.getMemberEndDate().after(new Date()))
					|| (member.getGroomerEndDate() != null && member.getGroomerEndDate().after(new Date()))));
			Date date = new Date();
			if (member.getGroomerEndDate() != null) {
				if (member.getGroomerEndDate().getTime() > date.getTime()) {
					map.setGrommerEndTime(sdf.format(member.getGroomerEndDate()));
				} else {
					map.setGrommerEndTime("已失效");
				}
			} else {
				map.setGrommerEndTime("无");
			}

			FciGroomerQualificationCertificate fciGroomerQualificationCertificate = new FciGroomerQualificationCertificate();
			fciGroomerQualificationCertificate.setMemberCode(member.getMemberCode());
			List<FciGroomerQualificationCertificate> lists = fciGroomerQualificationCertificateDao
					.findListByCertificate(fciGroomerQualificationCertificate);
			for (FciGroomerQualificationCertificate certificate1 : lists) {
				FciGroomerQualificationCertificateVo vo = new FciGroomerQualificationCertificateVo();
				BeanUtils.copyProperties(certificate1, vo);
				if (certificate1.getIssueDate() != null) {
					vo.setIssueDate(sdf.format(certificate1.getIssueDate()));
				}

				/*if (certificate1.getCertificateType().equals("7")) {
					vo.setLevelCn("FCI-" + vo.getLevelEn() + "级");
				} else {*/
				vo.setLevelCn(GroomerUtil.getLevelCn(vo.getLevelEn()));

				list.add(vo);
			}
		}
		map.setList(list);
		return ResultDto.success(map);
	}

	@RequestMapping(value = "groomerFciCertificates/{id}")
	@ResponseBody
	public ResultDto<FciGroomerQualificationCertificateVo> groomerFciCertificates(
			@PathVariable("id") String id) throws Exception {
		FciGroomerQualificationCertificate fciGroomerQualificationCertificate = fciGroomerQualificationCertificateDao
				.get(id);
		Member member = memberDao.getByMemberCode(fciGroomerQualificationCertificate.getMemberCode());
		if (!((member.getMemberEndDate() != null && member.getMemberEndDate().after(new Date()))
				|| (member.getGroomerEndDate() != null && member.getGroomerEndDate().after(new Date())))) {
			return ResultDto.error(ZAErrorCode.ZA_ERROR, "会员过期，暂不支持查询");
		}
		FciGroomerQualificationCertificateVo fciGroomerQualificationCertificateVo = fciGroomerQualificationCertificateService.mobileFciCertificateDetailInfo(fciGroomerQualificationCertificate);

		fciGroomerQualificationCertificateVo.setLevelCn("FCI-" + fciGroomerQualificationCertificate.getLevelEn() + "级");
		fciGroomerQualificationCertificateVo.setLevelEn(fciGroomerQualificationCertificate.getLevelEn());
		fciGroomerQualificationCertificateVo.setCountry("CHINA");
		fciGroomerQualificationCertificateVo.setQrCode("http://www.chongaibao.com/internationalGroomerCertificateH5/index.html?memberCode="
				+ fciGroomerQualificationCertificate.getMemberCode());
		return ResultDto.success(fciGroomerQualificationCertificateVo);
	}

	@RequestMapping(value = "groomerCertificatesById")
	@ResponseBody
	public ResultDto<GroomerQualificationCertificateVo> getGroomerCertificateById(
			@RequestParam(name = "id") String id) throws Exception {
		GroomerQualificationCertificate groomerQualificationCertificate = groomerQualificationCertificateDao
				.getGroomerCertificateById(id);
		Member member = memberDao.getByMemberCode(groomerQualificationCertificate.getMemberCode());
		if (!((member.getMemberEndDate() != null && member.getMemberEndDate().after(new Date()))
				|| (member.getGroomerEndDate() != null && member.getGroomerEndDate().after(new Date())))) {
			return ResultDto.error(ZAErrorCode.ZA_ERROR, "会员过期，暂不支持查询");
		}
		GroomerQualificationCertificateVo vo = new GroomerQualificationCertificateVo();
		BeanUtil.copyProperties(vo, groomerQualificationCertificate, "yyyy-MM-dd");
		if ("6".equals(groomerQualificationCertificate.getCertificateType())) {
			vo.setLevelCn("PDG-" + vo.getLevelEn() + "级");
			vo.setLevelEn(vo.getLevelEn());
		} else if ("8".equals(groomerQualificationCertificate.getCertificateType())) {
			vo.setLevelCn(GroomerUtil.getCatNurseLevelCn(vo.getLevelEn()));
			vo.setLevelEn(vo.getLevelEn());
		} else {
			vo.setLevelCn(GroomerUtil.getLevelCn(groomerQualificationCertificate.getLevelEn()));
			vo.setLevelEn(GroomerUtil.getLevelEn(vo.getLevelEn()));
		}
		vo.setAvatar(GroomerUtil.getUrl(groomerQualificationCertificate.getMember().getAvatar()));
		vo.setNamePinyin(StringUtils.isNotEmpty(vo.getNamePinyin()) ? vo.getNamePinyin() : PinYinUtil.getFullSpell(vo.getName()));
		vo.setQrCode("http://www.chongaibao.com/internationalGroomerCertificateH5/index.html?memberCode="
				+ groomerQualificationCertificate.getMemberCode());
		return ResultDto.success(vo);
	}

}