package com.cku.oa.groomer.service;

import java.io.IOException;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import com.cku.oa.groomer.dao.GroomerForeignRegisterDao;
import com.cku.oa.groomer.entity.GroomerForeignRegister;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.excel.ExportExcel;
import com.thinkgem.jeesite.common.utils.excel.ImportExcel;

/**
 * 国外美容考试结果Service
 * 
 * @author Sunny
 * @version 2024-01-11
 */
@Service
@Transactional(readOnly = true)
public class GroomerForeignRegisterService extends CrudService<GroomerForeignRegisterDao, GroomerForeignRegister> {

	public GroomerForeignRegister get(String id) {
		return super.get(id);
	}

	public List<GroomerForeignRegister> findList(GroomerForeignRegister groomerForeignRegister) {
		return super.findList(groomerForeignRegister);
	}

	public Page<GroomerForeignRegister> findPage(Page<GroomerForeignRegister> page,
			GroomerForeignRegister groomerForeignRegister) {
		return super.findPage(page, groomerForeignRegister);
	}

	@Transactional(readOnly = false)
	public void save(GroomerForeignRegister groomerForeignRegister) {
		super.save(groomerForeignRegister);
	}

	@Transactional(readOnly = false)
	public void delete(GroomerForeignRegister groomerForeignRegister) {
		super.delete(groomerForeignRegister);
	}

	public String importTemplate(HttpServletResponse response) throws IOException {
		String fileName = "考试结果导入模板.xlsx";
		List<GroomerForeignRegister> list = Lists.newArrayList();
		GroomerForeignRegister register = new GroomerForeignRegister();
		register.setRegisterNo("A1-R-001");
		register.setName("Gerati Sastaphat");
		register.setBreed("Wire Fox Terrier");
		register.setResult("Pass");
		register.setLevel("A");
		register.setCategory("1");
		register.setCertifiedNo("FG2023-VN-DEC-A1-001");
		register.setCountry("印度");
		register.setSpecificDate(new Date());
		list.add(register);
		new ExportExcel("考试结果信息", GroomerForeignRegister.class, 2).setDataList(list).write(response, fileName)
				.dispose();
		return null;
	}

	@Transactional(readOnly = false)
	public void importFile(GroomerForeignRegister param, MultipartFile file) throws Exception {
		ImportExcel ei = new ImportExcel(file, 1, 0);
		List<GroomerForeignRegister> list = ei.getDataList(GroomerForeignRegister.class);
		boolean error = false;
		for (GroomerForeignRegister gfr : list) {
			if (StringUtils.isBlank(gfr.getRegisterNo()) || StringUtils.isBlank(gfr.getResult())) {
				continue;
			}
			gfr.setCountry(param.getCountry());
			gfr.setSpecificDate(param.getSpecificDate());
			if (!error) {
				gfr.preInsert();
				this.dao.insert(gfr);
			}
		}
	}

}