package com.cku.oa.groomer.service;

import com.cku.oa.groomer.dao.GroomerCourseApplicationDao;
import com.cku.oa.groomer.dao.GroomerDiplomaDao;
import com.cku.oa.groomer.entity.GroomerCourse;
import com.cku.oa.groomer.entity.GroomerCourseApplication;
import com.cku.oa.groomer.entity.GroomerDiploma;
import com.cku.oa.groomer.vo.GroomerCourseApplicationVo;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.user.Member;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.excel.ExportExcel;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * 美容课程报名表Service
 *
 * @author xx
 * @version 2020-09-21
 */
@Service
@Transactional(readOnly = true)
public class GroomerCourseApplicationService
		extends CrudService<GroomerCourseApplicationDao, GroomerCourseApplication> {

	@Autowired
	private GroomerCourseService groomerCourseService;
	@Autowired
	private GroomerDiplomaDao groomerDiplomaDao;
	@Autowired
	private MemberDao memberDao;

	public GroomerCourseApplication get(String id) {
		return super.get(id);
	}

	public List<GroomerCourseApplication> findList(GroomerCourseApplication groomerCourseApplication) {
		return super.findList(groomerCourseApplication);
	}

	public Page<GroomerCourseApplication> findPage(Page<GroomerCourseApplication> page,
			GroomerCourseApplication groomerCourseApplication) {
		return super.findPage(page, groomerCourseApplication);
	}

	@Transactional(readOnly = false)
	public void save(GroomerCourseApplication groomerCourseApplication) {
		super.save(groomerCourseApplication);
	}

	@Transactional(readOnly = false)
	public void delete(GroomerCourseApplication groomerCourseApplication) {
		super.delete(groomerCourseApplication);
	}

	@Transactional(readOnly = false)
	public GroomerCourseApplication getOneByMemberCodeACourseId(String memberCode, String courseId) {
		return dao.getOneByMemberCodeACourseId(memberCode, courseId);
	}
	public void exportApply(GroomerCourseApplication groomerCourseApplication, HttpServletResponse response) throws IOException {
		List<GroomerCourseApplication> groomerCourseApplicationList=dao.findList(groomerCourseApplication);
		List<GroomerCourseApplicationVo> list = new ArrayList<>();
		for (GroomerCourseApplication gd : groomerCourseApplicationList) {
			GroomerCourseApplicationVo vo = new GroomerCourseApplicationVo();
			vo.setPaymentTime(gd.getPaymentTime());
			vo.setSchoolNameCn(gd.getTrainingInstitution().getSchoolNameCn());
			vo.setMemberCode(gd.getMemberCode());
			vo.setName(gd.getName());
			vo.setPaymentState(DictUtils.getDictLabel(gd.getPaymentState(), "user_payment_state",""));
			GroomerCourse groomerCourse = groomerCourseService.get(gd.getCourseId());
			vo.setCourseLevel(DictUtils.getDictLabel(groomerCourse.getDiplomaLevel(), "course_level",""));
			vo.setType(DictUtils.getDictLabel(groomerCourse.getType(), "course_type",""));
			vo.setCode(groomerCourse.getCode());
			vo.setCourseName(groomerCourse.getCourseName());
			vo.setPrice(groomerCourse.getPrice());
			vo.setGroomerType((DictUtils.getDictLabel(gd.getMember().getGroomerType(), "user_groomer_type","")));
			list.add(vo);
		}
		new ExportExcel("", GroomerCourseApplicationVo.class, 2)
				.setDataList(list).write(response, "美容课程报名信息.xlsx").dispose();
	}
//		保存课程报名信息
	@Transactional(readOnly = false)
    public void afterPay(String id) {
		GroomerDiploma groomerDiploma = groomerDiplomaDao.get(id);
		GroomerCourse groomerCourse = groomerCourseService.get(groomerDiploma.getGroomerCourseId());
		GroomerCourseApplication po = new GroomerCourseApplication();
		po.setCourseCode(groomerCourse.getCode());
		po.setCourseId(groomerCourse.getId());
		po.setCoursePrice(groomerCourse.getPrice());
		Member member = memberDao.getByMemberCode(groomerDiploma.getMemberCode());
		po.setMemberCode(member.getMemberCode());
		po.setName(member.getName());
		po.setMobile(member.getMobile());
		po.setProvince(member.getProvince());
		po.setCity(member.getCity());
		po.setArea(member.getArea());
		po.setStreet(member.getStreet());
		po.setAddress(member.getAddress());
		po.setPaymentState("2");
		po.setPaymentTime(groomerDiploma.getPaymentTime());
		po.setRunningNumber(groomerDiploma.getRunningNumber());
		po.preInsert();
		dao.insert(po);
	}
}