package com.cku.oa.groomer.enums;

import com.cku.oa.sys.entity.user.IEnum;

import java.util.Objects;

/**
 * 美容活动新旧UI枚举
 * @author hjx
 */
public enum GroomerExamUIEnum implements IEnum<Integer> {

	OLD_UI(0, "旧UI"),

	NEW_UI(1, "新UI"),


	;

	private Integer code;

	private String message;

	GroomerExamUIEnum(Integer code, String message) {
		this.code = code;
		this.message = message;
	}

	public static GroomerExamUIEnum codeOf(Integer code) {
		for (GroomerExamUIEnum operationExamStatusEnum : GroomerExamUIEnum.values()) {
			if (Objects.equals(operationExamStatusEnum.getCode(), code)) {
				return operationExamStatusEnum;
			}
		}
		return null;
	}

	public Integer getCode() {
		return code;
	}

	public void setCode(Integer code) {
		this.code = code;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	@Override
	public Integer code() {
		return this.code;
	}

	@Override
	public String message() {
		return this.message;
	}

}
