package com.cku.oa.groomer.entity;

import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 美容资格证书换发规则Entity
 * @author yuanshuai
 * @version 2024-02-18
 */
public class GroomerCertificateChangeRule extends DataEntity<GroomerCertificateChangeRule> {
	
	private static final long serialVersionUID = 1L;
	private Integer certificateCate;		// 证书类型（1资格证书）
	private Integer certificateSource;		// 证书来源（1CKU、2FCI、3香港）
	private String certificateLevel;		// 证书级别
	private String ckuCertificateLevel;		// CKU证书级别
	
	public GroomerCertificateChangeRule() {
		super();
	}

	public GroomerCertificateChangeRule(String id){
		super(id);
	}

	@NotNull(message="证书类型（1资格证书）不能为空")
	public Integer getCertificateCate() {
		return certificateCate;
	}

	public void setCertificateCate(Integer certificateCate) {
		this.certificateCate = certificateCate;
	}
	
	@NotNull(message="证书来源（1CKU、2FCI、3香港）不能为空")
	public Integer getCertificateSource() {
		return certificateSource;
	}

	public void setCertificateSource(Integer certificateSource) {
		this.certificateSource = certificateSource;
	}
	
	@Length(min=1, max=32, message="证书级别长度必须介于 1 和 32 之间")
	public String getCertificateLevel() {
		return certificateLevel;
	}

	public void setCertificateLevel(String certificateLevel) {
		this.certificateLevel = certificateLevel;
	}
	
	@Length(min=1, max=32, message="CKU证书级别长度必须介于 1 和 32 之间")
	public String getCkuCertificateLevel() {
		return ckuCertificateLevel;
	}

	public void setCkuCertificateLevel(String ckuCertificateLevel) {
		this.ckuCertificateLevel = ckuCertificateLevel;
	}
	
}