/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dogsporting.entity;

import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;

import javax.validation.constraints.NotNull;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 犬运动犬只Entity
 *
 * @author yuanshuai
 * @version 2021-06-15
 */
public class DogSportingDogs extends DataEntity<DogSportingDogs> {

	private static final long serialVersionUID = 1L;
	private String certificateCode;        // 证书号
	private String dogImage;        // 犬只图片
	@ExcelField(title = "犬主会员号*", align = 2, sort = 2)
	private String memberCode;        // 会员号
	@ExcelField(title = "犬名*", align = 2, sort = 1)
	private String dogName;        // 犬名
	@ExcelField(title = "性别*", align = 2, sort = 3)
	private String dogGender;        // 犬只性别（dog_gender）
	@ExcelField(title = "犬种编号*", align = 2, sort = 4)
	private String dogType;        // 犬只品种
	@ExcelField(title = "体型*", align = 2, sort = 5)
	private String somatotype;        // 犬只体型（dog_somatotype）
	@ExcelField(title = "出生日期*", align = 2, sort = 6)
	private Date birthday;        // 犬只出生日期
	@ExcelField(title = "毛色", align = 2, sort = 7)
	private String colorFlag;        // 犬只毛色
	@ExcelField(title = "芯片号", align = 2, sort = 8)
	private String identificationFlag;        // 芯片号
	@ExcelField(title = "鼻纹编号", align = 2, sort = 9)
	private String noseCode;        // 鼻纹编号
	private String printState;        // 打印状态（print_state）
	private String memberName;
	private String dogTypeCn;

	@ExcelField(title = "备注", align = 2, sort = 11)
	private String remarks;

	//查询用
	private String code;

	public DogSportingDogs() {
		super();
	}

	public DogSportingDogs(String id) {
		super(id);
	}

	public String getCertificateCode() {
		return certificateCode;
	}

	public void setCertificateCode(String certificateCode) {
		this.certificateCode = certificateCode;
	}

	@Length(min = 0, max = 32, message = "犬只图片长度必须介于 0 和 32 之间")
	public String getDogImage() {
		return dogImage;
	}

	public void setDogImage(String dogImage) {
		this.dogImage = dogImage;
	}

	@Length(min = 1, max = 32, message = "会员号长度必须介于 1 和 32 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	public String getDogName() {
		return dogName;
	}

	public void setDogName(String dogName) {
		this.dogName = dogName;
	}

	@Length(min = 1, max = 1, message = "犬只性别（dog_gender）长度必须介于 1 和 1 之间")
	public String getDogGender() {
		return dogGender;
	}

	public void setDogGender(String dogGender) {
		this.dogGender = dogGender;
	}

	@Length(min = 1, max = 32, message = "犬只品种长度必须介于 1 和 32 之间")
	public String getDogType() {
		return dogType;
	}

	public void setDogType(String dogType) {
		this.dogType = dogType;
	}

	@Length(min = 1, max = 1, message = "犬只体型（dog_somatotype）长度必须介于 1 和 1 之间")
	public String getSomatotype() {
		return somatotype;
	}

	public void setSomatotype(String somatotype) {
		this.somatotype = somatotype;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@NotNull(message = "犬只出生日期不能为空")
	public Date getBirthday() {
		return birthday;
	}

	public void setBirthday(Date birthday) {
		this.birthday = birthday;
	}

	@Length(min = 0, max = 20, message = "犬只毛色长度必须介于 0 和 20 之间")
	public String getColorFlag() {
		return colorFlag;
	}

	public void setColorFlag(String colorFlag) {
		this.colorFlag = colorFlag;
	}

	@Length(min = 0, max = 20, message = "芯片号长度必须介于 1 和 20 之间")
	public String getIdentificationFlag() {
		return identificationFlag;
	}

	public void setIdentificationFlag(String identificationFlag) {
		this.identificationFlag = identificationFlag;
	}

	@Length(min = 0, max = 20, message = "鼻纹编号长度必须介于 0 和 20 之间")
	public String getNoseCode() {
		return noseCode;
	}

	public void setNoseCode(String noseCode) {
		this.noseCode = noseCode;
	}

	@Length(min = 1, max = 1, message = "打印状态（print_state）长度必须介于 1 和 1 之间")
	public String getPrintState() {
		return printState;
	}

	public void setPrintState(String printState) {
		this.printState = printState;
	}

	public String getMemberName() {
		return memberName;
	}

	public void setMemberName(String memberName) {
		this.memberName = memberName;
	}

	public String getDogTypeCn() {
		return dogTypeCn;
	}

	public void setDogTypeCn(String dogTypeCn) {
		this.dogTypeCn = dogTypeCn;
	}

	@Override
	@Length(min=0, max=500, message="备注长度必须介于 0 和 500 之间")
	public String getRemarks() {
		return remarks;
	}

	@Override
	public void setRemarks(String remarks) {
		this.remarks = remarks;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}
}