package com.cku.oa.dog.web;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogColorMark;
import com.cku.oa.dog.entity.DogDnaArchive;
import com.cku.oa.dog.entity.DogDnaArchiveReissueSampling;
import com.cku.oa.dog.entity.DogPedigreeCertifiedChange;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.dog.service.DogColorMarkService;
import com.cku.oa.dog.service.DogDnaArchiveReissueSamplingService;
import com.cku.oa.dog.service.DogDnaArchiveService;
import com.cku.oa.dog.service.DogPedigreeCertifiedChangeService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.sampling.entity.Sampling;
import com.cku.oa.sampling.service.SamplingService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberService;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 犬只DNA存档采样包补寄Controller
 * 
 * @author Sunny
 * @version 2023-06-29
 */
@Controller
@RequestMapping(value = "${adminPath}/dogDnaArchive/dogDnaArchiveReissueSampling")
public class DogDnaArchiveReissueSamplingController extends BaseController {

	@Autowired
	private DogDnaArchiveReissueSamplingService dogDnaArchiveReissueSamplingService;

	@Autowired
	private DogPedigreeCertifiedChangeService dogPedigreeCertifiedChangeService;

	@Autowired
	private DogDnaArchiveService dogDnaArchiveService;

	@Autowired
	private DogBirthCertificateService dogBirthCertificateService;

	@Autowired
	private SamplingService samplingService;

	@Autowired
	private MemberService memberService;

	@Autowired
	private PaymentOrderDetailDao paymentOrderDetailDao;

	@Autowired
	private DogColorMarkService dogColorMarkService;

	@Autowired
	private DogTypeService dogTypeService;

	@ModelAttribute
	public DogDnaArchiveReissueSampling get(@RequestParam(required = false) String id) {
		DogDnaArchiveReissueSampling entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = dogDnaArchiveReissueSamplingService.get(id);
		}
		if (entity == null) {
			entity = new DogDnaArchiveReissueSampling();
		}
		return entity;
	}

	/**
	 * 根据国外证书号/出生纸编号/血统证书号查询存档记录
	 * 
	 * @param keywords
	 * @return
	 */
	@ResponseBody
	@RequestMapping(value = "findDnaArchive")
	public ResultDto<DogDnaArchive> findDnaArchive(@RequestParam String keyword) {
		DogDnaArchive dogDnaArchive = dogDnaArchiveService.getByOverseasPedigreeCertifiedOrBirthCode(keyword);
		if (Objects.nonNull(dogDnaArchive)) {
			if (StringUtils.isBlank(dogDnaArchive.getSamplingCode())) {
				return ResultDto.error(ZAErrorCode.ZA_ERROR, "该存档未绑定采样包，不允许补寄");
			}
			if (StringUtils.isNotBlank(dogDnaArchive.getDnaCode())) {
				return ResultDto.error(ZAErrorCode.ZA_ERROR, "该存档已存在DNA信息，不允许补寄");
			}
			Sampling sampling = samplingService.findBySamplingCode(dogDnaArchive.getSamplingCode());
			if (Objects.isNull(sampling)) {
				return ResultDto.error(ZAErrorCode.ZA_ERROR, "该存档记录绑定的采样包记录有误");
			}
			// 补充犬只信息
			this.initDogInfo(dogDnaArchive);
			dogDnaArchive.getOverseasPedigreeCertified();
			Member member = memberService.getByMemberCode(dogDnaArchive.getPaymentMemberCode());
			dogDnaArchive.setMemberName(member.getName());
			DogColorMark dogColorMark = dogColorMarkService.getByDogColorMarkCode(dogDnaArchive.getDogColorFlag());
			if (Objects.nonNull(dogColorMark)) {
				dogDnaArchive.setDogColorName(dogColorMark.getDogColorMarkCn());
			}
			DogType dogType = dogTypeService.getByDogBreedCode(dogDnaArchive.getDogBreed());
			if (Objects.nonNull(dogType)) {
				dogDnaArchive.setBreedCnName(dogType.getBreedCnName());
			}
			// 查询采样包绑定记录
			List<Sampling> bindSamplingRecord = dogDnaArchiveReissueSamplingService.findBindSamplingList(dogDnaArchive);
			dogDnaArchive.setBindSamplingRecord(bindSamplingRecord);
			return ResultDto.success(dogDnaArchive);
		}
		return ResultDto.error(ZAErrorCode.ZA_ERROR, "未查询到该编号对应的存档记录");
	}

	private void initDogInfo(DogDnaArchive dogDnaArchive) {
		if (StringUtils.isEmpty(dogDnaArchive.getDogId()) && StringUtils.isNotEmpty(dogDnaArchive.getBirthCode())) {
			DogBirthCertificate dogBirthCertificate = dogBirthCertificateService
					.getByBirthCerRegCode(dogDnaArchive.getBirthCode());
			if (Objects.nonNull(dogBirthCertificate)) {
				dogDnaArchive.setDogName(dogBirthCertificate.getDogEnName());
				dogDnaArchive.setDogBirthday(dogBirthCertificate.getDogBirthday());
				dogDnaArchive.setDogGender(dogBirthCertificate.getDogGender());
				dogDnaArchive.setDogColorFlag(dogBirthCertificate.getColorFlag());
				dogDnaArchive.setChipCode(dogBirthCertificate.getIdentificationFlag());
				dogDnaArchive.setDogBreed(dogBirthCertificate.getDogBreed());
			}
		} else if (StringUtils.isEmpty(dogDnaArchive.getDogId())
				&& StringUtils.isNotEmpty(dogDnaArchive.getOverseasPedigreeCertified())) {
			DogPedigreeCertifiedChange dogPedigreeCertifiedChange = dogPedigreeCertifiedChangeService
					.getByOverseasPedigreeCertified(dogDnaArchive.getOverseasPedigreeCertified());
			if (Objects.nonNull(dogPedigreeCertifiedChange)) {
				dogDnaArchive.setDogName(dogPedigreeCertifiedChange.getDogName());
				dogDnaArchive.setDogBirthday(dogPedigreeCertifiedChange.getDogBirthday());
				dogDnaArchive.setDogGender(dogPedigreeCertifiedChange.getDogGender());
				dogDnaArchive.setDogColorFlag(dogPedigreeCertifiedChange.getDogFurColor());
				dogDnaArchive.setChipCode(dogPedigreeCertifiedChange.getDogChip());
				dogDnaArchive.setDogBreed(dogPedigreeCertifiedChange.getDogBreed());
			}
		}
	}

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = { "orderList" })
	public String orderList(DogDnaArchiveReissueSampling dogDnaArchiveReissueSampling, HttpServletRequest request,
			HttpServletResponse response, Model model) {
		// 查询订单所有明细
		List<PaymentOrderDetail> detailList = paymentOrderDetailDao
				.findAllByOrderCode(dogDnaArchiveReissueSampling.getRunningNumber());
//		 查询已经补寄的记录
//		List<DogDnaArchiveReissueSampling> reissueSamplingList = dogDnaArchiveReissueSamplingService
//				.findByRunningNumber(dogDnaArchiveReissueSampling.getRunningNumber());
//		Map<String, DogDnaArchiveReissueSampling> reissueSamplingMap = new HashMap<>();
//		if (!CollectionUtils.isEmpty(reissueSamplingList)) {
//			reissueSamplingMap.putAll(reissueSamplingList.stream()
//					.collect(Collectors.toMap(DogDnaArchiveReissueSampling::getDnaArchiveId, Function.identity())));
//		}
		if (!CollectionUtils.isEmpty(detailList)) {
			// 根据业务参数，过滤出对应的业务数据
			List<PaymentOrderDetail> filterDetailList = detailList.stream()
					.filter(d -> StringUtils.isNotEmpty(d.getBusinessIds())
							&& d.getBusinessIds().equals(dogDnaArchiveReissueSampling.getBusinessIds()))
					.collect(Collectors.toList());
			// 如过滤数据存在，则证明已录入过业务数据
			if (!CollectionUtils.isEmpty(filterDetailList)) {
				List<DogDnaArchiveReissueSampling> reissueSamplingList = new ArrayList<>();
				filterDetailList.forEach(detail -> {
					DogDnaArchiveReissueSampling reissueSampling = dogDnaArchiveReissueSamplingService
							.get(detail.getBusinessIds());
					if (Objects.nonNull(reissueSampling)) {
						DogDnaArchive dogDnaArchive = dogDnaArchiveService.get(reissueSampling.getDnaArchiveId());
						reissueSampling.setDogDnaArchive(dogDnaArchive);
					}
					reissueSamplingList.add(reissueSampling);
				});

				model.addAttribute("reissueSamplingList", reissueSamplingList);
			}
		}
		return "oa/dog/dnaarchive/dogDnaArchiveReissueOrderList";
	}

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderAdd")
	public String orderAdd(Model model, @RequestParam(required = true) String id,
			@RequestParam(required = true) String runningNumber, @RequestParam(required = true) String chargingItemId,
			@RequestParam(required = true) String memberCode) {
		model.addAttribute("orderDetailId", id);
		model.addAttribute("runningNumber", runningNumber);
		model.addAttribute("paymentChargingItemId", chargingItemId);
		model.addAttribute("paymentMemberCode", memberCode);
		return "oa/dog/dnaarchive/dogDnaArchiveReissueOrderAdd";
	}

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderSave")
	@ResponseBody
	public ResultDto<String> orderSave(DogDnaArchive dogDnaArchive, Model model, HttpServletRequest request) {
		try {
			dogDnaArchiveReissueSamplingService.orderSave(dogDnaArchive);
		} catch (ZAException e) {
			e.printStackTrace();
			return ResultDto.error(ZAErrorCode.ZA_VALID_FAILED, "补寄采样包失败：" + e.getMessage());
		}
		return ResultDto.success("补寄采样包成功");
	}

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderView")
	public String orderView(DogDnaArchiveReissueSampling dogDnaArchiveReissueSampling, Model model) {
		dogDnaArchiveReissueSampling = dogDnaArchiveReissueSamplingService.get(dogDnaArchiveReissueSampling.getId());
		DogDnaArchive dogDnaArchive = dogDnaArchiveService.get(dogDnaArchiveReissueSampling.getDnaArchiveId());
		if(Objects.nonNull(dogDnaArchive)) {
			// 补充犬只信息
			this.initDogInfo(dogDnaArchive);	
		}
		DogColorMark dogColorMark = dogColorMarkService.getByDogColorMarkCode(dogDnaArchive.getDogColorFlag());
		if (Objects.nonNull(dogColorMark)) {
			dogDnaArchive.setDogColorName(dogColorMark.getDogColorMarkCn());
		}
		DogType dogType = dogTypeService.getByDogBreedCode(dogDnaArchive.getDogBreed());
		if (Objects.nonNull(dogType)) {
			dogDnaArchive.setBreedCnName(dogType.getBreedCnName());
		}
		// 查询采样包绑定记录
		List<Sampling> bindSamplingRecord = dogDnaArchiveReissueSamplingService.findBindSamplingList(dogDnaArchive);
		model.addAttribute("dogDnaArchive", dogDnaArchive);
		model.addAttribute("dogDnaArchiveReissueSampling", dogDnaArchiveReissueSampling);
		model.addAttribute("bindSamplingRecord", bindSamplingRecord);
		return "oa/dog/dnaarchive/dogDnaArchiveReissueOrderView";
	}

}