/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.web;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.ibatis.exceptions.TooManyResultsException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.mybatis.spring.MyBatisSystemException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogChip;
import com.cku.oa.dog.entity.DogNose;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.dog.service.DogChipService;
import com.cku.oa.dog.service.DogNoseService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.dog.vo.DogChipVO;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.finance.vo.PaymentOrderDetailQueryVO;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.service.OrgService;
import com.cku.oa.sys.util.RequestUtil;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.service.AreaService;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;



/**
 * 新生犬登记Controller
 *
 * @author zhuoHeng
 * @version 2016-08-04
 */
@Controller
@RequestMapping(value = "${adminPath}/newdogchip/dogChip")
public class DogChipController extends BaseController {

	private final static String REPAGE = "redirect:" + Global.getAdminPath() + "/newdogchip/dogChip/?repage";

	private final static String AUTHORITY_PRDFIX = "newdogchip:dogChip:";

	@Autowired
	private DogChipService dogChipService;
	@Autowired
	private DogBirthCertificateService dogBirthCertificateService;
	@Autowired
	private DogService dogService;
	@Autowired
	private DogNoseService dogNoseService;
	@Autowired
	private AreaService areaService;
	@Autowired
	private OrgService orgService;

	@ModelAttribute
	public DogChip get(@RequestParam(required = false) String id) {
		DogChip entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = dogChipService.get(id);
		}
		if (entity == null) {
			entity = new DogChip();
		}
		return entity;
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "view")
	@RequestMapping(value = { "list", "" })
	public String list(DogChip dogChip, HttpServletRequest request, HttpServletResponse response, Model model) {
		if (!RequestUtil.hasParameter(request)) {
			// 没有参数的查询，默认只查询最近的三个月
			Calendar calendar = Calendar.getInstance();// 日历对象
			Date date = new Date();
			date.setHours(0);
			date.setMinutes(0);
			date.setSeconds(0);
			calendar.setTime(date);// 设置当前日期
			calendar.add(Calendar.MONTH, -3);// 年份+1
			dogChip.setCreateDate(calendar.getTime());
		}
		Page<DogChip> page = dogChipService.findPage(new Page<DogChip>(request, response), dogChip);
		for (DogChip po : page.getList()) {
			try {
				po.setBusinessState(dogChipService.getBusinessState(po));
			}catch (MyBatisSystemException e) {
				if(e.getCause() instanceof TooManyResultsException) {
					Dog dog = new Dog();
					dog.setBirthCertificateLevelCode(po.getBirthCode());
					List<Dog> dogList = dogService.findList(dog);
					model.addAttribute("repeatDogList",dogList);
					model.addAttribute("repeatBirthCode",po.getBirthCode());
					Date minDate = dogList.stream().map(Dog::getCreateDate).min(Date::compareTo).get();
					model.addAttribute("minDate",minDate);
					return "oa/dog/newdogchip/dogChipRepeat";
				}
			}
		}
		// 查询有没有退款或退款中
		// 血统证书特殊处理 整窝businessIds为fmdogBreedCertifiedCode 单只businessIds为ID
		Map<String, String> map = paymentOrderService.getRefundStateByBusinessId(page.getList().stream()
				.filter(a -> !"1".equals(a.getIsAll())).map(a -> a.getId()).collect(Collectors.toSet()));
		Map<String, String> map2 = paymentOrderService
				.getRefundStateByBusinessIdAOrderCode(page.getList().stream().filter(a -> "1".equals(a.getIsAll()))
						.map(a -> new PaymentOrderDetailQueryVO(a.getFmdogBreedCertifiedCode(), a.getRunningNumber()))
						.collect(Collectors.toList()));
		List<DogChip> list = page.getList().stream().map(a -> {
			DogChipVO b = new DogChipVO();
			BeanUtils.copyProperties(a, b);
			b.setBusinessRefundState(map.keySet().contains(a.getId())
					|| map2.keySet().contains(a.getFmdogBreedCertifiedCode() + a.getRunningNumber()));
			DogNose dogNose = dogNoseService.getByDogIdODogBirthCertificateId(Objects.nonNull(a.getDogBirthCertificate())?a.getDogBirthCertificate().getId():null, a.getId());
			if(dogNose != null ){
				b.setNoseId(dogNose.getId());
			}else{
				b.setNoseId("");
			}
			return b;
		}).collect(Collectors.toList());
		page.setList(list);
		model.addAttribute("page", page);
		if (!RequestUtil.hasParameter(request)) {
			dogChip.setCreateDate(null);
		}
		return "oa/dog/newdogchip/dogChipList";
	}

	
	@ResponseBody
	@RequiresPermissions(AUTHORITY_PRDFIX + "edit")
	@RequestMapping(value = "removeRepeatRecord/{birthCode}")
	public ResultDto<Boolean> removeRepeatRecord(@PathVariable("birthCode")String birthCode,@RequestBody List<String> repeatDogIds, Model model, RedirectAttributes redirectAttributes) {
		try {
			dogChipService.removeRepeatRecord(birthCode, repeatDogIds);
		}catch (ZAException e) {
			return ResultDto.error(e.get_code(),e.getMessage());
		}catch (Exception e) {
			return ResultDto.error(ZAErrorCode.ZA_ERC_UNKNOWN, e.getMessage());
		}
		//返回处理结果
		return ResultDto.success(Boolean.TRUE);
	}
	
	@RequiresPermissions(AUTHORITY_PRDFIX + "view")
	@RequestMapping(value = "form")
	public String form(DogChip dogChip, Model model) {
		model.addAttribute("dogChip", dogChip);
		return "oa/dog/newdogchip/dogChipForm";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "edit")
	@RequestMapping(value = "save")
	public String save(DogChip dogChip, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, dogChip)) {
			return form(dogChip, model);
		}
		dogChipService.save(dogChip);
		addMessage(redirectAttributes, "保存新生犬登记成功");
		return REPAGE;
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "delete")
	@RequestMapping(value = "delete")
	public String delete(DogChip dogChip, RedirectAttributes redirectAttributes) {
		if ("2".equals(dogChip.getPaymentState())) {
			addMessage(redirectAttributes, "该订单已缴费，不允许删除");
		} else {
			dogChipService.delete(dogChip);
			addMessage(redirectAttributes, "删除新生犬登记成功");
		}
		return REPAGE;
	}

	/**
	 *
	 * @Description：打开新生犬登记审核界面
	 * @author: zhuoHeng
	 * @version: 2016年8月9日 上午10:31:08
	 */
	@RequiresPermissions(AUTHORITY_PRDFIX + "audit")
	@RequestMapping(value = "review")
	public String toEditPage(DogChip dogChip, Model model) {
		model.addAttribute("dogChip", dogChip);
		return "oa/dog/newdogchip/dogChipReview";
	}

	/**
	 *
	 * @Description：更改新生犬登记审核状态
	 * @author: zhuoHeng
	 * @version: 2016年8月9日 下午2:01:25
	 */
	@RequiresPermissions(AUTHORITY_PRDFIX + "audit")
	@RequestMapping(value = "changeStatus")
	@ResponseBody
	public String changeStatus(DogChip dogChip, Model model) {
		if (!beanValidator(model, dogChip)) {
			return "{\"rc\":-1,\"msg\":\"error\"}";
		}
		try {
			dogChipService.changeReviewStatus(dogChip);
		} catch (ZAException e) {
			return "{\"rc\":" + e.get_code() + ",\"msg\":\"" + e.getMessage() + "\"}";
		}
		return "{\"rc\":0,\"msg\":\"success\"}";
	}

	/**
	 *
	 * @Description：更改新生犬登记处理状态并生成血统证书号
	 * @author: zhuoHeng
	 * @version: 2016年8月9日 下午4:45:04
	 */
	@RequiresPermissions(AUTHORITY_PRDFIX + "process")
	@RequestMapping(value = "process")
	@ResponseBody
	public String processState(DogChip dogChip, Model model) {
		if (!beanValidator(model, dogChip)) {
			return "{\"rc\":-1,\"msg\":\"error\"}";
		}
		try {
			dogChipService.changeProcessState(dogChip);
		} catch (ZAException e) {
			return "{\"rc\":" + e.get_code() + ",\"msg\":\"" + e.getMessage() + "\"}";
		}
		return "{\"rc\":0,\"msg\":\"success\"}";
	}

	/**
	 *
	 * @Description：新生犬登记查看页
	 * @author: zhuoHeng
	 * @version: 2016年8月27日 下午4:20:36
	 */
	@RequiresPermissions(AUTHORITY_PRDFIX + "view")
	@RequestMapping(value = "view")
	public String view(DogChip dogChip, Model model) {
		model.addAttribute("dogChip", dogChip);
		return "oa/dog/newdogchip/dogChipView";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "print")
	@RequestMapping(value = "print")
	public String print(DogChip print, Model model,HttpServletRequest request) {
		DogChip dogChip = dogChipService.get(print.getId());
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateService
				.getByBirthCerRegCode(dogChip.getBirthCode());
		Dog dog = dogService.getByPedigreeCertifiedCode(dogBirthCertificate.getPedigreeCertified());
		return dogService.processPrintBusiness(dog, model, Boolean.TRUE);
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "resetPrint")
	@RequestMapping(value = "resetPrint")
	@ResponseBody
	public ResultDto<Boolean> resetPrint(DogChip resetPrint, RedirectAttributes redirectAttributes) {
		DogChip dogChip = dogChipService.get(resetPrint.getId());
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateService
				.getByBirthCerRegCode(dogChip.getBirthCode());
		Dog dog = dogService.getByPedigreeCertifiedCode(dogBirthCertificate.getPedigreeCertified());
		dogService.resetPrint(dog.getId());
		return ResultDto.success("重置证书出口打印成功", Boolean.TRUE);
	}

	@Autowired
	private PaymentOrderService paymentOrderService;

	/**
	 *
	 * @Description：新生犬登记订单录入列表
	 * @author: zhuoHeng
	 * @version: 2016年10月17日 下午5:22:57
	 */
	@RequiresPermissions("dogownerchange:dogOwnerChange:view")
	@RequestMapping(value = { "orderList" })
	public String orderList(DogChip dogChip, HttpServletRequest request, HttpServletResponse response, Model model) {
		List<DogChip> list = dogChipService.findList(dogChip);

		// 查询有没有退款或退款中
		// 血统证书特殊处理 整窝businessIds为fmdogBreedCertifiedCode 单只businessIds为ID
		Map<String, String> map = paymentOrderService.getRefundStateByBusinessId(
				list.stream().filter(a -> !"1".equals(a.getIsAll())).map(a -> a.getId()).collect(Collectors.toSet()));
		Map<String, String> map2 = paymentOrderService
				.getRefundStateByBusinessIdAOrderCode(list.stream().filter(a -> "1".equals(a.getIsAll()))
						.map(a -> new PaymentOrderDetailQueryVO(a.getFmdogBreedCertifiedCode(), a.getRunningNumber()))
						.collect(Collectors.toList()));
		List<DogChipVO> list2 = list.stream().map(a -> {
			DogChipVO b = new DogChipVO();
			BeanUtils.copyProperties(a, b);
			b.setBusinessRefundState(map.keySet().contains(a.getId())
					|| map2.keySet().contains(a.getFmdogBreedCertifiedCode() + a.getRunningNumber()));
			return b;
		}).collect(Collectors.toList());
		model.addAttribute("list", list2);

		return "oa/dog/newdogchip/dogChipOrderList";
	}

	/**
	 *
	 * @Description：新生犬登记订单业务添加页
	 * @author: zhuoHeng
	 * @version: 2016年10月17日 下午5:23:16
	 */
	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderAdd")
	public String orderAdd(DogChip dogChip, Model model, @RequestParam(required = true) String chargingItemId,
			@RequestParam(required = true) String memberCode) {
		dogChip.setPaymentMemberCode(memberCode);
		model.addAttribute("dogChip", dogChip);
		model.addAttribute("province", UserUtils.getProvince());
		// TODO 验证是否存在流水号
		return "oa/dog/newdogchip/dogChipOrderAdd";
	}

	/**
	 *
	 * @Description：新生犬登记业务信息保存
	 * @author: zhuoHeng
	 * @version: 2016年10月17日 下午5:23:40
	 */
	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderSave")
	@ResponseBody
	public Object orderSave(DogChip dogChip, Model model, HttpServletRequest request) {
		HashMap<String, String> map = new HashMap<String, String>();
		map.put("rc", "0");
		try {
			String hidDogOwenrName = request.getParameter("hidDogOwenrName");
			dogChipService.orderSave(dogChip, hidDogOwenrName);
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	/**
	 *
	 * @Description：订单列表删除订单数据
	 * @author: zhuoHeng
	 * @version: 2016年10月29日 下午4:09:45
	 */
	@RequiresPermissions("dogownerchange:dogOwnerChange:delete")
	@RequestMapping(value = "orderDelete")
	public String orderDelete(DogChip dogChip, RedirectAttributes redirectAttributes) {
		String runningNumber = dogChip.getRunningNumber();
		dogChipService.delete(dogChip);
		addMessage(redirectAttributes, "删除新生犬登记成功");
		return "redirect:" + Global.getAdminPath() + "/newdogchip/dogChip/orderList?runningNumber=" + runningNumber
				+ "&repage";
	}

	/**
	 *
	 * @Description：撤销新生犬登记记录
	 * @author: zhuoHeng
	 * @version: 2016年10月29日 下午4:10:00
	 */
	@RequiresPermissions(AUTHORITY_PRDFIX + "canceled")
	@RequestMapping(value = "canceled")
	public String canceled(DogChip dogChip, RedirectAttributes redirectAttributes) {
		if (dogChip == null) {
			addMessage(redirectAttributes, "id有误");
		}
		dogChipService.canceled(dogChip);
		addMessage(redirectAttributes, "撤销新生犬登记成功");
		return REPAGE;
	}
	
	
	@RequiresPermissions(AUTHORITY_PRDFIX + "audit")
	@RequestMapping(value = "changeOrg")
	public String changeOrg(String id, Model model) {
		DogChip dogChip = dogChipService.get(id);
		if(StringUtils.isEmpty(dogChip.getHospitalCode()) ) {
			dogChip.setHaddleWay("0");
		}
		Org org = null;
		if(!StringUtils.isEmpty(dogChip.getHospitalCode())) {
			org = orgService.get(dogChip.getHospitalCode());
		}
		if(org != null) {
			dogChip.setProvince(org.getProvince());
		}
		dogChip.setOldHaddleWay(dogChip.getHaddleWay());
		model.addAttribute("dogChip", dogChip);
		model.addAttribute("provinceList", areaService.getProvince());
		return "oa/dog/newdogchip/changeOrg";
	}
	
	@RequiresPermissions(AUTHORITY_PRDFIX + "audit")
	@RequestMapping(value = "saveOrg")
	@ResponseBody
	public Object saveOrg(DogChip dogChip) {
		HashMap<String, String> map = new HashMap<String, String>();
		map.put("rc", "0");
		try {
			return dogChipService.saveOrg(dogChip , map);
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
			return map;
		}
		
	}
	
	
}