package com.cku.oa.contest.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.oa.contest.entity.Language;
import com.cku.oa.contest.service.LanguageService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.contest.entity.ContestGrade;
import com.cku.oa.contest.service.ContestGradeService;

/**
 * 犬展活动区域评价Controller
 * @author yuanshuai
 * @version 2020-10-12
 */
@Controller
@RequestMapping(value = "${adminPath}/contest/contestGrade")
public class ContestGradeController extends BaseController {

	@Autowired
	private ContestGradeService contestGradeService;
	@Autowired
	private LanguageService languageService;
	
	@ModelAttribute
	public ContestGrade get(@RequestParam(required=false) String id) {
		ContestGrade entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = contestGradeService.get(id);
		}
		if (entity == null){
			entity = new ContestGrade();
		}
		return entity;
	}
	
	@RequiresPermissions("contest:contestGrade:view")
	@RequestMapping(value = {"list", ""})
	public String list(ContestGrade contestGrade, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<ContestGrade> page = contestGradeService.findPage(new Page<>(request, response), contestGrade);
		model.addAttribute("page", page);
		model.addAttribute("languageList", languageService.findList(new Language()));
		return "oa/contest/contestGradeList";
	}

	@RequiresPermissions("contest:contestGrade:view")
	@RequestMapping(value = "form")
	public String form(ContestGrade contestGrade, Model model) {
		model.addAttribute("contestGrade", contestGrade);
		model.addAttribute("languageList", languageService.findList(new Language()));
		return "oa/contest/contestGradeForm";
	}

	@RequiresPermissions("contest:contestGrade:edit")
	@RequestMapping(value = "save")
	public String save(ContestGrade contestGrade, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, contestGrade)){
			return form(contestGrade, model);
		}
		contestGradeService.save(contestGrade);
		addMessage(redirectAttributes, "保存犬展活动区域评价成功");
		return "redirect:"+Global.getAdminPath()+"/contest/contestGrade/?repage";
	}
	
	@RequiresPermissions("contest:contestGrade:del")
	@RequestMapping(value = "delete")
	public String delete(ContestGrade contestGrade, RedirectAttributes redirectAttributes) {
		contestGradeService.delete(contestGrade);
		addMessage(redirectAttributes, "删除犬展活动区域评价成功");
		return "redirect:"+Global.getAdminPath()+"/contest/contestGrade/?repage";
	}

}