/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.contest.entity;

import com.cku.restful.v1.contest.model.RestContestExhibit;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;
import org.hibernate.validator.constraints.Length;

/**
 * 赛场犬只Entity
 * @author yuanshuai
 * @version 2020-10-12
 */
public class ContestExhibit extends DataEntity<ContestExhibit> {
	
	private static final long serialVersionUID = 1L;

	@ExcelField(title="赛圈", align=2, sort=3)
	private String raceLap;
	@ExcelField(title="秩序号", align=2, sort=4)
	private String exhibitNo;
	private String grade;
	@ExcelField(title="血统证书", align=2, sort=10)
	private String pedigreeCode;
	@ExcelField(title="FCI代码", align=2, sort=12)
	private String breedNo;
	@ExcelField(title="年龄组别", align=2, sort=6)
	private String classNo;
	@ExcelField(title="BOH组", align=2, sort=8)
	private String boh;
	@ExcelField(title="犬展编号", align=2, sort=2)
	private String contestNo;
	private String contestEventNo;

	public ContestExhibit() {
		super();
	}

	public ContestExhibit(String id){
		super(id);
	}

	public ContestExhibit(RestContestExhibit rest) {
		exhibitNo = rest.getExhibit_no();
		grade = rest.getGrade();
		contestNo = rest.getContest_no();
	}

	@Length(min=1, max=8, message="赛圈必须介于 1 和 8 之间")
	public String getRaceLap() {
		return raceLap;
	}

	public void setRaceLap(String raceLap) {
		this.raceLap = raceLap;
	}

	@Length(min=1, max=11, message="秩序号长度必须介于 1 和 11 之间")
	public String getExhibitNo() {
		return exhibitNo;
	}

	public void setExhibitNo(String exhibitNo) {
		this.exhibitNo = exhibitNo;
	}
	
	@Length(min=1, max=4, message="赛场评价长度必须介于 1 和 4 之间")
	public String getGrade() {
		return grade;
	}

	public void setGrade(String grade) {
		this.grade = grade;
	}
	
	@Length(min=1, max=32, message="血统证书长度必须介于 1 和 32 之间")
	public String getPedigreeCode() {
		return pedigreeCode;
	}

	public void setPedigreeCode(String pedigreeCode) {
		this.pedigreeCode = pedigreeCode;
	}
	
	@Length(min=1, max=32, message="犬种代码长度必须介于 1 和 32 之间")
	public String getBreedNo() {
		return breedNo;
	}

	public void setBreedNo(String breedNo) {
		this.breedNo = breedNo;
	}
	
	@Length(min=1, max=11, message="年龄组别编号长度必须介于 1 和 11 之间")
	public String getClassNo() {
		return classNo;
	}

	public void setClassNo(String classNo) {
		this.classNo = classNo;
	}

	public String getBoh() {
		return boh;
	}

	public void setBoh(String boh) {
		this.boh = boh;
	}

	@Length(min=1, max=64, message="子赛事编号长度必须介于 1 和 64 之间")
	public String getContestNo() {
		return contestNo;
	}

	public void setContestNo(String contestNo) {
		this.contestNo = contestNo;
	}

	public String getContestEventNo() {
		return contestEventNo;
	}

	public void setContestEventNo(String contestEventNo) {
		this.contestEventNo = contestEventNo;
	}
}