/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.breeder.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 黑名单表Entity
 *
 * @author lgl
 * @version 2018-01-16
 */
public class Blacklist extends DataEntity<Blacklist> {

    private static final long serialVersionUID = 1L;
    private String memberCode;        // 会员号
    private String module;        // 模块
    private Date startTime;        // 禁用开始时间
    private Date endTime;        // 禁用结束时间

    public Blacklist() {
        super();
    }

    public Blacklist(String id) {
        super(id);
    }

    @Length(min = 1, max = 60, message = "会员号长度必须介于 1 和 60 之间")
    public String getMemberCode() {
        return memberCode;
    }

    public void setMemberCode(String memberCode) {
        this.memberCode = memberCode;
    }

    @Length(min = 1, max = 50, message = "模块长度必须介于 1 和 50 之间")
    public String getModule() {
        return module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @NotNull(message = "禁用开始时间不能为空")
    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @NotNull(message = "禁用结束时间不能为空")
    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

}