package com.cku.oa.appreciation.web;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.appreciation.entity.AppreciationApply;
import com.cku.oa.appreciation.entity.AppreciationCourses;
import com.cku.oa.appreciation.service.AppreciationApplyService;
import com.cku.oa.appreciation.service.AppreciationCoursesService;
import com.cku.oa.sys.entity.user.Member;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 鉴赏课报名Controller
 * 
 * @author zxy
 * @version 2022-02-15
 */
@Controller
@RequestMapping(value = "${adminPath}/appreciation/appreciationApply")
public class AppreciationApplyController extends BaseController {

	@Autowired
	private AppreciationApplyService appreciationApplyService;

	@Autowired
	private AppreciationCoursesService appreciationCoursesService;

	@ModelAttribute
	public AppreciationApply get(@RequestParam(required = false) String id) {
		AppreciationApply entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = appreciationApplyService.get(id);
		}
		if (entity == null) {
			entity = new AppreciationApply();
		}
		return entity;
	}

	@RequiresPermissions("appreciation:appreciationApply:view")
	@RequestMapping(value = { "list", "" })
	public String list(AppreciationApply appreciationApply, HttpServletRequest request, HttpServletResponse response,
			Model model) throws UnsupportedEncodingException {
		if(!StringUtils.isEmpty(appreciationApply.getMemberKeyword())) {
			String memberKeyword = java.net.URLDecoder.decode(appreciationApply.getMemberKeyword() , "UTF-8");
			appreciationApply.setMemberKeyword(memberKeyword);
		}
		Page<AppreciationApply> pagePar = new Page<AppreciationApply>(request, response);
		pagePar.setOrderBy("apply_code desc");
		Page<AppreciationApply> page = appreciationApplyService.findPage(pagePar, appreciationApply);
		// 课程ids
		Set<String> cIds = page.getList().stream().filter(obj -> StringUtils.isNotEmpty(obj.getCourseId()))
				.map(obj -> obj.getCourseId()).collect(Collectors.toSet());
		// 查询课程报名数量
		List<AppreciationApply> applyNumList = new ArrayList<>();
		if (!CollectionUtils.isEmpty(cIds)) {
			applyNumList = appreciationApplyService.getCoursesApplyNum(cIds);
		}
		for (AppreciationApply apply : page.getList()) {
			// 会员类型
			if (!StringUtils.isEmpty(apply.getMemberCode())) {
				Member member = new Member();
				member.setMemberCardType(apply.getMemberCardType());
				member.setMemberCode(apply.getMemberCode());
				member.setMemberEndDate(apply.getMemberEndDate());
				if(StringUtils.isNotBlank(member.getMemberCardType())) {
					apply.setMemberCardType(UserUtils.getMemberCardTypeDesc(member));
				}
			}
			// 支付状态
			if (StringUtils.isNotEmpty(apply.getApplyType())) {
				apply.setApplyTypeDesc(apply.getApplyType().equals("0") ? "正常" : "试听");
			}

			if (StringUtils.isEmpty(apply.getCourseId())) {
				apply.setCourseState("");
			} else {
				apply.setCourseState(StringUtils.isEmpty(apply.getCourseState()) ? "0" : apply.getCourseState());
			}
			// 课程状态
			for (AppreciationApply applyNum : applyNumList) {
				if (StringUtils.isNotEmpty(apply.getCourseId()) && apply.getCourseId().equals(applyNum.getCourseId())) {
					if (apply.getMaxNum() <= applyNum.getApplyNum() && !apply.getCourseState().equals("2")) {
						apply.setCourseState("1");
					}
				}
			}

		}
		model.addAttribute("page", page);
		model.addAttribute("appreciationApply", appreciationApply);
		return "oa/appreciation/appreciationApplyList";
	}

	@RequiresPermissions("appreciation:appreciationApply:view")
	@RequestMapping(value = "form")
	public String form(AppreciationApply appreciationApply, Model model) {
		model.addAttribute("appreciationApply", appreciationApply);
		return "oa/appreciation/appreciationApplyForm";
	}

	@RequiresPermissions("appreciation:appreciationApply:edit")
	@RequestMapping(value = "formArrange")
	public String formArrange(AppreciationApply appreciationApply, Model model) {
		int num = appreciationApply.getArrangeType().equals("1") ? 1 : appreciationApply.getId().split(",").length;
		appreciationApply.setNum(String.valueOf(num));

		model.addAttribute("appreciationApply", appreciationApply);

		AppreciationCourses appreciationCourses = new AppreciationCourses();
		appreciationCourses.setStates("0");
		List<AppreciationCourses> courseList = appreciationCoursesService.findList(appreciationCourses);
		courseList = courseList.stream()
				.filter(c -> c.getMaxNum() > appreciationApplyService.getCoursesApplyNum(c.getId()).getApplyNum())
				.collect(Collectors.toList());

		model.addAttribute("courseList", courseList);
		return "oa/appreciation/formArrange";
	}

	@RequiresPermissions("appreciation:appreciationApply:edit")
	@RequestMapping(value = "formAddress")
	public String formAddress(AppreciationApply appreciationApply, Model model) {
		model.addAttribute("appreciationApply", appreciationApply);
		return "oa/appreciation/formAddress";
	}

	@RequiresPermissions("appreciation:appreciationApply:edit")
	@PostMapping(value = "arrange")
	@ResponseBody
	public String arrange(AppreciationApply appreciationApply, Model model) {
		try {
			if (appreciationApply.getArrangeType().equals("1")) {
				appreciationApplyService.updateCourseId(appreciationApply);
			} else {
//				for (String id : appreciationApply.getId().split(",")) {
//					appreciationApply.setId(id);
				appreciationApplyService.updateCourseIds(appreciationApply);
//				}
			}
			return "OK";
		} catch (Exception e) {
			return e.getMessage();
		}
	}
	
	@RequiresPermissions("appreciation:appreciationApply:edit")
	@PostMapping(value = "editAddress")
	@ResponseBody
	public String editAddress(AppreciationApply appreciationApply, Model model) throws UnsupportedEncodingException {
		String memberName = java.net.URLDecoder.decode(appreciationApply.getMemberName() , "UTF-8");
		appreciationApply.setMemberName(memberName);
		appreciationApplyService.save(appreciationApply);
		return "OK";
	}

	@RequiresPermissions("appreciation:appreciationApply:edit")
	@RequestMapping(value = "save")
	public String save(AppreciationApply appreciationApply, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, appreciationApply)) {
			return form(appreciationApply, model);
		}
		appreciationApplyService.save(appreciationApply);
		addMessage(redirectAttributes, "保存鉴赏课报名成功");
		return "redirect:" + Global.getAdminPath() + "/appreciation/appreciationApply/?repage";
	}

	@RequiresPermissions("appreciation:appreciationApply:edit")
	@RequestMapping(value = "delete")
	public String delete(AppreciationApply appreciationApply, RedirectAttributes redirectAttributes) {
		appreciationApplyService.delete(appreciationApply);
		addMessage(redirectAttributes, "删除鉴赏课报名成功");
		return "redirect:" + Global.getAdminPath() + "/appreciation/appreciationApply/?repage";
	}
	
	@RequiresPermissions("appreciation:appreciationApply:edit")
	@RequestMapping(value = "clean")
	public String clean(AppreciationApply appreciationApply, RedirectAttributes redirectAttributes) {
		appreciationApplyService.clean(appreciationApply);
		addMessage(redirectAttributes, "解绑课程成功");
		return "redirect:" + Global.getAdminPath() + "/appreciation/appreciationApply/?repage";
	}
	
	

	/**
	 * 导入报名信息
	 *
	 * @author: yuanshuai
	 * @date: 2019年5月30日10:49:41
	 */
	@RequiresPermissions("appreciation:appreciationApply:export")
	@RequestMapping(value = "import", method = RequestMethod.POST)
	public String importFile(MultipartFile file, RedirectAttributes redirectAttributes) {
		try {
			appreciationApplyService.importMember(file);
			addMessage(redirectAttributes, "导入报名信息成功！");
		} catch (Exception e) {
			redirectAttributes.addFlashAttribute("importError", "导入报名信息失败！失败信息：##" + e.getMessage());
		}
		return "redirect:" + Global.getAdminPath() + "/appreciation/appreciationApply/?repage";
	}

	@RequiresPermissions("appreciation:appreciationApply:export")
	@RequestMapping(value = "export")
	public String export(AppreciationApply appreciationApply, HttpServletResponse response,
			RedirectAttributes redirectAttributes) {
		try {
			appreciationApplyService.export(appreciationApply, response);
		} catch (Exception e) {
			addMessage(redirectAttributes, "导出报名信息失败！失败信息：" + e.getMessage());
		}
		return null;
	}

}